/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.system;

import java.io.File;
import java.io.Serializable;
import java.lang.management.ManagementFactory;
import java.net.URL;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.DateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TimeZone;
import javax.annotation.Resource;
import javax.ejb.EJB;
import javax.ejb.Stateless;
import javax.ejb.Timeout;
import javax.ejb.Timer;
import javax.ejb.TimerService;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import javax.management.MBeanServer;
import javax.management.MBeanServerInvocationHandler;
import javax.management.ObjectName;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.annotation.IgnoreDependency;
import org.jboss.deployment.MainDeployerMBean;
import org.jboss.mx.util.MBeanServerLocator;
import org.rhq.core.db.DatabaseType;
import org.rhq.core.db.DatabaseTypeFactory;
import org.rhq.core.domain.auth.Subject;
import org.rhq.core.domain.authz.Permission;
import org.rhq.core.domain.common.ProductInfo;
import org.rhq.core.domain.common.ServerDetails;
import org.rhq.core.domain.common.SystemConfiguration;
import org.rhq.core.domain.common.composite.SystemSetting;
import org.rhq.core.domain.common.composite.SystemSettings;
import org.rhq.core.domain.configuration.definition.PropertySimpleType;
import org.rhq.core.domain.server.PersistenceUtility;
import org.rhq.core.util.ObjectNameFactory;
import org.rhq.core.util.StopWatch;
import org.rhq.enterprise.server.auth.SubjectManagerLocal;
import org.rhq.enterprise.server.authz.RequiredPermission;
import org.rhq.enterprise.server.core.CoreServerMBean;
import org.rhq.enterprise.server.core.CustomJaasDeploymentServiceMBean;
import org.rhq.enterprise.server.plugin.pc.MasterServerPluginContainer;
import org.rhq.enterprise.server.plugin.pc.ServerPluginEnvironment;
import org.rhq.enterprise.server.plugin.pc.drift.DriftServerPluginContainer;
import org.rhq.enterprise.server.plugin.pc.drift.DriftServerPluginManager;
import org.rhq.enterprise.server.system.InvalidSystemConfigurationException;
import org.rhq.enterprise.server.system.SystemInfoManagerLocal;
import org.rhq.enterprise.server.system.SystemManagerLocal;
import org.rhq.enterprise.server.system.SystemManagerRemote;
import org.rhq.enterprise.server.util.LookupUtil;
import org.rhq.enterprise.server.util.SystemDatabaseInformation;

@Stateless
public class SystemManagerBean
implements SystemManagerLocal,
SystemManagerRemote {
    private final String SQL_VACUUM = "VACUUM ANALYZE {0}";
    private final String SQL_ANALYZE = "ANALYZE";
    private final String SQL_REINDEX = "REINDEX TABLE {0}";
    private final String SQL_REBUILD = "ALTER INDEX {0} REBUILD UNRECOVERABLE";
    private final String[] TABLES_TO_VACUUM = new String[]{"RHQ_RESOURCE", "RHQ_CONFIG", "RHQ_CONFIG_PROPERTY", "RHQ_AGENT"};
    private final String[] TABLES_TO_REINDEX = new String[]{"RHQ_MEASUREMENT_DATA_NUM_1D", "RHQ_MEASUREMENT_DATA_NUM_6H", "RHQ_MEASUREMENT_DATA_NUM_1H", "RHQ_MEASUREMENT_DATA_TRAIT", "RHQ_CALLTIME_DATA_KEY", "RHQ_CALLTIME_DATA_VALUE", "RHQ_AVAILABILITY"};
    private final String[] ORA_INDEXES_TO_REBUILD = new String[]{"RHQ_MEAS_DATA_1H_ID_TIME_PK", "RHQ_MEAS_DATA_6H_ID_TIME_PK", "RHQ_MEAS_DATA_1D_ID_TIME_PK", "RHQ_MEAS_BASELINE_CTIME_IDX", "RHQ_MEAS_DATA_TRAIT_ID_TIME_PK"};
    private Log log = LogFactory.getLog(SystemManagerBean.class);
    @PersistenceContext(unitName="rhqpu")
    private EntityManager entityManager;
    @Resource(name="RHQ_DS", mappedName="java:/RHQDS")
    private DataSource dataSource;
    @Resource
    private TimerService timerService;
    @EJB
    private SystemManagerLocal systemManager;
    @EJB
    @IgnoreDependency
    private SubjectManagerLocal subjectManager;
    @EJB
    @IgnoreDependency
    private SystemInfoManagerLocal systemInfoManager;
    private static SystemSettings cachedSystemSettings = null;
    private final String TIMER_DATA = "SystemManagerBean.reloadConfigCache";

    @Override
    public void scheduleConfigCacheReloader() {
        Collection timers = this.timerService.getTimers();
        for (Timer existingTimer : timers) {
            this.log.debug((Object)("Found timer - attempting to cancel: " + existingTimer.toString()));
            try {
                existingTimer.cancel();
            }
            catch (Exception e) {
                this.log.warn((Object)("Failed in attempting to cancel timer: " + existingTimer.toString()));
            }
        }
        this.timerService.createTimer(60000L, (Serializable)((Object)"SystemManagerBean.reloadConfigCache"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Timeout
    public void reloadConfigCache(Timer timer) {
        try {
            this.systemManager.loadSystemConfigurationCacheInNewTx();
        }
        catch (Throwable t) {
            this.log.error((Object)("Failed to reload the system config cache - will try again later. Cause: " + t));
        }
        finally {
            try {
                this.timerService.createTimer(60000L, (Serializable)((Object)"SystemManagerBean.reloadConfigCache"));
            }
            catch (Throwable t) {
                this.log.error((Object)("Failed to reschedule system config cache reload timer! System config cache reload handling will not work from this point. A server restart may be needed after issue is resolved:" + t));
            }
        }
    }

    @Override
    @TransactionAttribute(value=TransactionAttributeType.NOT_SUPPORTED)
    public DatabaseType getDatabaseType() {
        Connection conn = null;
        DatabaseType dbtype = null;
        try {
            conn = this.dataSource.getConnection();
            DatabaseType databaseType = dbtype = DatabaseTypeFactory.getDatabaseType((Connection)conn);
            return databaseType;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (SQLException e) {
                    this.log.warn((Object)"Failed to close temporary connection", (Throwable)e);
                }
            }
        }
    }

    @Override
    @RequiredPermission(value=Permission.MANAGE_SETTINGS)
    @Deprecated
    public Properties getSystemConfiguration(Subject subject) {
        Properties copy = new Properties();
        SystemSettings settings = this.getSystemSettings(subject);
        for (Map.Entry e : settings.entrySet()) {
            String value = this.transformSystemConfigurationProperty((SystemSetting)e.getKey(), (String)e.getValue(), false);
            copy.put(((SystemSetting)e.getKey()).getInternalName(), value);
        }
        return copy;
    }

    @Override
    @RequiredPermission(value=Permission.MANAGE_SETTINGS)
    public SystemSettings getSystemSettings(Subject subject) {
        if (cachedSystemSettings == null) {
            this.loadSystemConfigurationCache();
        }
        return new SystemSettings(cachedSystemSettings);
    }

    @Override
    @RequiredPermission(value=Permission.MANAGE_SETTINGS)
    public void setSystemSettings(Subject subject, SystemSettings settings) {
        this.setSystemSettings(settings, false);
    }

    private void setSystemSettings(SystemSettings settings, boolean skipValidation) {
        List configs = this.entityManager.createNamedQuery("SystemConfiguration.findAll").getResultList();
        HashMap<String, SystemConfiguration> existingConfigMap = new HashMap<String, SystemConfiguration>();
        for (SystemConfiguration config : configs) {
            existingConfigMap.put(config.getPropertyKey(), config);
        }
        for (Map.Entry e : settings.entrySet()) {
            SystemConfiguration existingConfig;
            SystemSetting prop = (SystemSetting)e.getKey();
            String value = (String)e.getValue();
            if (!skipValidation) {
                this.verifyNewSystemConfigurationProperty(prop, value, settings);
            }
            if ((existingConfig = (SystemConfiguration)existingConfigMap.get(prop.getInternalName())) == null) {
                value = this.transformSystemConfigurationProperty(prop, value, false);
                existingConfig = new SystemConfiguration(prop.getInternalName(), value);
                this.entityManager.persist((Object)existingConfig);
                continue;
            }
            String existingValue = this.transformSystemConfigurationProperty(prop, existingConfig.getPropertyValue(), true);
            if ((existingValue != null || value == null) && existingValue.equals(value)) continue;
            if (prop.isReadOnly() || existingConfig.getFreadOnly() != null && existingConfig.getFreadOnly().booleanValue()) {
                throw new IllegalArgumentException("The setting [" + prop.getInternalName() + "] is read-only - you cannot change its current value! Current value is [" + existingConfig.getPropertyValue() + "] while the new value was [" + value + "].");
            }
            value = this.transformSystemConfigurationProperty(prop, value, false);
            existingConfig.setPropertyValue(value);
            this.entityManager.merge((Object)existingConfig);
        }
        cachedSystemSettings = null;
    }

    private Map<String, String> toMap(Properties props) {
        HashMap<String, String> map = new HashMap<String, String>(props.size());
        for (Map.Entry<Object, Object> entry : props.entrySet()) {
            map.put(String.valueOf(entry.getKey()), String.valueOf(entry.getValue()));
        }
        return map;
    }

    private void transformToSystemSettingsFormat(Map<String, String> map) {
        for (Map.Entry<String, String> e : map.entrySet()) {
            SystemSetting prop = SystemSetting.getByInternalName((String)e.getKey());
            if (prop == null) continue;
            String value = this.transformSystemConfigurationProperty(prop, e.getValue(), true);
            e.setValue(value);
        }
    }

    private Map<String, String> getDriftServerPlugins() {
        DriftServerPluginManager pluginMgr = this.getDriftServerPluginManager();
        HashMap<String, String> plugins = new HashMap<String, String>();
        for (ServerPluginEnvironment env : pluginMgr.getPluginEnvironments()) {
            plugins.put(env.getPluginKey().getPluginName(), env.getPluginDescriptor().getDisplayName());
        }
        return plugins;
    }

    private DriftServerPluginManager getDriftServerPluginManager() {
        MasterServerPluginContainer masterPC = LookupUtil.getServerPluginService().getMasterPluginContainer();
        if (masterPC == null) {
            this.log.warn((Object)(MasterServerPluginContainer.class.getSimpleName() + " is not started yet"));
            return null;
        }
        DriftServerPluginContainer pc = masterPC.getPluginContainerByClass(DriftServerPluginContainer.class);
        if (pc == null) {
            this.log.warn((Object)(DriftServerPluginContainer.class + " has not been loaded by the " + masterPC.getClass() + " yet"));
            return null;
        }
        return (DriftServerPluginManager)pc.getPluginManager();
    }

    @Override
    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    public void loadSystemConfigurationCacheInNewTx() {
        this.loadSystemConfigurationCache();
    }

    @Override
    public void loadSystemConfigurationCache() {
        List configs = this.entityManager.createNamedQuery("SystemConfiguration.findAll").getResultList();
        SystemSettings settings = new SystemSettings();
        for (SystemConfiguration config : configs) {
            SystemSetting prop = SystemSetting.getByInternalName((String)config.getPropertyKey());
            if (prop == null) {
                this.log.warn((Object)("The database contains unknown system configuration setting [" + config.getPropertyKey() + "]."));
                continue;
            }
            if (config.getPropertyValue() == null) {
                String defaultValue = config.getDefaultPropertyValue();
                settings.put(prop, (defaultValue = this.transformSystemConfigurationProperty(prop, defaultValue, true)) != null ? defaultValue : "");
                continue;
            }
            String value = config.getPropertyValue();
            value = this.transformSystemConfigurationProperty(prop, value, true);
            settings.put(prop, value);
        }
        settings.setDriftPlugins(this.getDriftServerPlugins());
        cachedSystemSettings = settings;
    }

    @Override
    @RequiredPermission(value=Permission.MANAGE_SETTINGS)
    @Deprecated
    public void setSystemConfiguration(Subject subject, Properties properties, boolean skipValidation) throws Exception {
        Map<String, String> map = this.toMap(properties);
        this.transformToSystemSettingsFormat(map);
        SystemSettings settings = SystemSettings.fromMap(map);
        this.setSystemSettings(settings, skipValidation);
    }

    @Override
    @RequiredPermission(value=Permission.MANAGE_SETTINGS)
    public void validateSystemConfiguration(Subject subject, Properties properties) throws InvalidSystemConfigurationException {
        Map<String, String> map = this.toMap(properties);
        this.transformToSystemSettingsFormat(map);
        SystemSettings settings = SystemSettings.fromMap(map);
        for (Map.Entry e : settings.entrySet()) {
            SystemSetting prop = (SystemSetting)e.getKey();
            String value = (String)e.getValue();
            this.verifyNewSystemConfigurationProperty(prop, value, settings);
        }
    }

    private String transformSystemConfigurationProperty(SystemSetting prop, String value, boolean fromDb) {
        block17: {
            block16: {
                if (!fromDb) break block16;
                switch (prop) {
                    case LDAP_BASED_JAAS_PROVIDER: {
                        if ("JDBC".equals(value)) {
                            return Boolean.toString(false);
                        }
                        if ("LDAP".equals(value)) {
                            return Boolean.toString(true);
                        }
                        break block17;
                    }
                    case USE_SSL_FOR_LDAP: {
                        if ("ssl".equals(value)) {
                            return Boolean.toString(true);
                        }
                        return Boolean.toString(false);
                    }
                    default: {
                        if (prop.getType() == PropertySimpleType.BOOLEAN) {
                            if ("0".equals(value)) {
                                return Boolean.FALSE.toString();
                            }
                            if ("1".equals(value)) {
                                return Boolean.TRUE.toString();
                            }
                        }
                        break block17;
                    }
                }
            }
            switch (prop) {
                case LDAP_BASED_JAAS_PROVIDER: {
                    if (Boolean.parseBoolean(value)) {
                        return "LDAP";
                    }
                    return "JDBC";
                }
                case USE_SSL_FOR_LDAP: {
                    if (Boolean.parseBoolean(value)) {
                        return "ssl";
                    }
                    return "";
                }
            }
        }
        return value;
    }

    private void verifyNewSystemConfigurationProperty(SystemSetting property, String value, SystemSettings settings) {
        long time;
        if (property == SystemSetting.BASE_LINE_DATASET) {
            long baselineDataSet = Long.parseLong(value);
            if (baselineDataSet > 1209600000L) {
                throw new InvalidSystemConfigurationException("Baseline dataset must be less than 14 days");
            }
        } else if (property == SystemSetting.BASE_LINE_FREQUENCY) {
            long baselineDataSet;
            long baselineFrequency = Long.parseLong(value);
            if (baselineFrequency > (baselineDataSet = Long.parseLong((String)settings.get((Object)SystemSetting.BASE_LINE_DATASET)))) {
                throw new InvalidSystemConfigurationException("baseline computation frequency must not be larger than baseline data set");
            }
        } else if (property == SystemSetting.AGENT_MAX_QUIET_TIME_ALLOWED && (time = Long.parseLong(value)) < 180000L) {
            throw new InvalidSystemConfigurationException("Agent Max Quiet Time Allowed must be at least 3 minutes");
        }
    }

    @Override
    public void enableHibernateStatistics() {
        PersistenceUtility.enableHibernateStatistics((EntityManager)this.entityManager, (MBeanServer)ManagementFactory.getPlatformMBeanServer());
    }

    @Override
    @RequiredPermission(value=Permission.MANAGE_SETTINGS)
    public void reconfigureSystem(Subject whoami) {
        try {
            CustomJaasDeploymentServiceMBean mbean = MBeanServerInvocationHandler.newProxyInstance(MBeanServerLocator.locateJBoss(), CustomJaasDeploymentServiceMBean.OBJECT_NAME, CustomJaasDeploymentServiceMBean.class, false);
            mbean.installJaasModules();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    @RequiredPermission(value=Permission.MANAGE_SETTINGS)
    @TransactionAttribute(value=TransactionAttributeType.NOT_SUPPORTED)
    public long analyze(Subject whoami) {
        Connection conn = null;
        DatabaseType dbtype = null;
        try {
            long duration;
            conn = this.dataSource.getConnection();
            dbtype = DatabaseTypeFactory.getDatabaseType((Connection)conn);
            if (!DatabaseTypeFactory.isPostgres((DatabaseType)dbtype)) {
                long l = -1L;
                return l;
            }
            long l = duration = this.doCommand(dbtype, conn, "ANALYZE", null);
            return l;
        }
        catch (Exception e) {
            this.log.error((Object)"Error analyzing database", (Throwable)e);
            throw new RuntimeException("Error analyzing database", e);
        }
        finally {
            if (dbtype != null) {
                dbtype.closeConnection(conn);
            }
        }
    }

    @Override
    @RequiredPermission(value=Permission.MANAGE_SETTINGS)
    @TransactionAttribute(value=TransactionAttributeType.NOT_SUPPORTED)
    public long reindex(Subject whoami) {
        Connection conn = null;
        DatabaseType dbtype = null;
        try {
            conn = this.dataSource.getConnection();
            dbtype = DatabaseTypeFactory.getDatabaseType((Connection)conn);
            long duration = 0L;
            if (DatabaseTypeFactory.isPostgres((DatabaseType)dbtype)) {
                for (String table : this.TABLES_TO_REINDEX) {
                    duration += this.doCommand(dbtype, conn, "REINDEX TABLE {0}", table);
                }
            } else if (DatabaseTypeFactory.isOracle((DatabaseType)dbtype)) {
                for (String index : this.ORA_INDEXES_TO_REBUILD) {
                    duration += this.doCommand(dbtype, conn, "ALTER INDEX {0} REBUILD UNRECOVERABLE", index);
                }
            } else {
                long l = -1L;
                return l;
            }
            long l = duration;
            return l;
        }
        catch (Exception e) {
            this.log.error((Object)"Error reindexing database", (Throwable)e);
            throw new RuntimeException("Error reindexing database", e);
        }
        finally {
            if (dbtype != null) {
                dbtype.closeConnection(conn);
            }
        }
    }

    @Override
    @RequiredPermission(value=Permission.MANAGE_SETTINGS)
    @TransactionAttribute(value=TransactionAttributeType.NOT_SUPPORTED)
    public long vacuum(Subject whoami) {
        return this.vacuum(whoami, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @RequiredPermission(value=Permission.MANAGE_SETTINGS)
    @TransactionAttribute(value=TransactionAttributeType.NOT_SUPPORTED)
    public long vacuum(Subject whoami, String[] tableNames) {
        long duration = 0L;
        Connection conn = null;
        DatabaseType dbtype = null;
        try {
            conn = this.dataSource.getConnection();
            dbtype = DatabaseTypeFactory.getDatabaseType((Connection)conn);
            if (!DatabaseTypeFactory.isPostgres((DatabaseType)dbtype)) {
                long l = -1L;
                return l;
            }
            if (tableNames == null) {
                tableNames = new String[]{null};
            }
            for (String tableName : tableNames) {
                duration += this.doCommand(dbtype, conn, "VACUUM ANALYZE {0}", tableName);
            }
            long arr$ = duration;
            return arr$;
        }
        catch (Exception e) {
            this.log.error((Object)("Error vacuuming database: " + e.getMessage()), (Throwable)e);
            long l = duration;
            return l;
        }
        finally {
            if (dbtype != null) {
                dbtype.closeConnection(conn);
            }
        }
    }

    @Override
    @RequiredPermission(value=Permission.MANAGE_SETTINGS)
    @TransactionAttribute(value=TransactionAttributeType.NOT_SUPPORTED)
    public long vacuumAppdef(Subject whoami) {
        return this.vacuum(whoami, this.TABLES_TO_VACUUM);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long doCommand(DatabaseType dbtype, Connection conn, String command, String table) {
        Statement stmt = null;
        StopWatch watch = new StopWatch();
        if (table == null) {
            table = "";
        }
        command = command.replace("{0}", table);
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Execute command: " + command));
        }
        try {
            stmt = conn.createStatement();
            stmt.execute(command);
            long l = watch.getElapsed();
            return l;
        }
        catch (SQLException e) {
            this.log.error((Object)("Error in command: " + command + ": " + e), (Throwable)e);
            long l = watch.getElapsed();
            return l;
        }
        finally {
            dbtype.closeStatement(stmt);
        }
    }

    @Override
    public void undeployInstaller() {
        block17: {
            try {
                File serverHomeDir = LookupUtil.getCoreServer().getJBossServerHomeDir();
                File deployDirectory = new File(serverHomeDir, "deploy");
                if (deployDirectory.exists()) {
                    File deployedInstallWar = new File(deployDirectory.getAbsolutePath(), "rhq-installer.war");
                    File undeployedInstallWar = new File(deployDirectory.getAbsolutePath(), "rhq-installer.war.rej");
                    if (deployedInstallWar.exists()) {
                        ObjectName name = ObjectNameFactory.create((String)"jboss.system:service=MainDeployer");
                        MBeanServer mbs = MBeanServerLocator.locateJBoss();
                        MainDeployerMBean mbean = MBeanServerInvocationHandler.newProxyInstance(mbs, name, MainDeployerMBean.class, false);
                        URL url = deployedInstallWar.toURI().toURL();
                        String urlString = url.toString().replace("%20", " ");
                        mbean.undeploy(urlString);
                        if (!mbean.isDeployed(urlString)) {
                            this.log.info((Object)"Installer war has been hot-undeployed from memory");
                        } else {
                            this.log.warn((Object)"Installer hot-undeploy failed - full installer undeploy may not work...");
                        }
                        if (!deployedInstallWar.renameTo(undeployedInstallWar)) {
                            throw new RuntimeException("Cannot undeploy the installer war: " + deployedInstallWar);
                        }
                        if (deployedInstallWar.exists()) {
                            throw new RuntimeException("Failed to undeploy the installer war: " + deployedInstallWar);
                        }
                        File deployedPostInstallWar = new File(deployDirectory.getAbsolutePath(), "rhq-postinstaller.war");
                        File undeployedPostInstallWar = new File(deployDirectory.getAbsolutePath(), "rhq-postinstaller.war.rej");
                        if (!deployedPostInstallWar.exists()) {
                            if (undeployedPostInstallWar.exists()) {
                                if (undeployedPostInstallWar.renameTo(deployedPostInstallWar)) {
                                    this.log.debug((Object)"Post-install notification war has been deployed");
                                } else {
                                    this.log.info((Object)"Post-install notification war failed to deploy - this can be ignored");
                                }
                            } else {
                                this.log.info((Object)"Post-install notification war not found and not deployed - this can be ignored");
                            }
                        } else {
                            this.log.info((Object)"Post-install notification war already deployed");
                        }
                    } else if (undeployedInstallWar.exists()) {
                        this.log.debug((Object)("Installer looks to be undeployed already, this is good: " + undeployedInstallWar));
                    } else {
                        this.log.debug((Object)("Installer can't be found - assume it has been completely purged: " + deployedInstallWar));
                    }
                    break block17;
                }
                throw new RuntimeException("Your deployment seems corrupted - missing deploy dir: " + deployDirectory);
            }
            catch (Exception e) {
                this.log.warn((Object)("Please manually remove installer war to secure your deployment: " + e));
                return;
            }
        }
        this.log.info((Object)"Confirmed that the installer has been undeployed");
    }

    @Override
    public boolean isDebugModeEnabled() {
        try {
            Subject su = this.subjectManager.getOverlord();
            String setting = (String)this.getSystemSettings(su).get((Object)SystemSetting.DEBUG_MODE_ENABLED);
            if (setting == null) {
                setting = "false";
            }
            return Boolean.valueOf(setting);
        }
        catch (Throwable t) {
            return false;
        }
    }

    @Override
    public boolean isExperimentalFeaturesEnabled() {
        try {
            Subject su = this.subjectManager.getOverlord();
            String setting = (String)this.getSystemSettings(su).get((Object)SystemSetting.EXPERIMENTAL_FEATURES_ENABLED);
            if (setting == null) {
                setting = "false";
            }
            return Boolean.valueOf(setting);
        }
        catch (Throwable t) {
            return false;
        }
    }

    @Override
    public boolean isLdapAuthorizationEnabled() {
        Subject su = this.subjectManager.getOverlord();
        SystemSettings settings = this.getSystemSettings(su);
        String ldapAuthValue = (String)settings.get((Object)SystemSetting.LDAP_BASED_JAAS_PROVIDER);
        boolean ldapAuth = ldapAuthValue == null ? false : Boolean.valueOf(ldapAuthValue);
        String groupFilter = (String)settings.get((Object)SystemSetting.LDAP_GROUP_FILTER);
        String groupMember = (String)settings.get((Object)SystemSetting.LDAP_GROUP_MEMBER);
        return ldapAuth && (groupFilter != null && groupFilter.trim().length() > 0 || groupMember != null && groupMember.trim().length() > 0);
    }

    @Override
    @RequiredPermission(value=Permission.MANAGE_SETTINGS)
    public ServerDetails getServerDetails(Subject subject) {
        CoreServerMBean coreServerMBean = LookupUtil.getCoreServer();
        ServerDetails serverDetails = new ServerDetails();
        serverDetails.setProductInfo(this.getProductInfo(subject));
        HashMap details = serverDetails.getDetails();
        DateFormat localTimeFormatter = DateFormat.getDateTimeInstance(1, 0);
        details.put(ServerDetails.Detail.SERVER_LOCAL_TIME, localTimeFormatter.format(new Date()));
        details.put(ServerDetails.Detail.SERVER_TIMEZONE, TimeZone.getDefault().getDisplayName());
        details.put(ServerDetails.Detail.SERVER_HOME_DIR, coreServerMBean.getJBossServerHomeDir().getAbsolutePath());
        details.put(ServerDetails.Detail.SERVER_INSTALL_DIR, coreServerMBean.getInstallDir().getAbsolutePath());
        SystemDatabaseInformation dbInfo = SystemDatabaseInformation.getInstance();
        details.put(ServerDetails.Detail.DATABASE_CONNECTION_URL, dbInfo.getDatabaseConnectionURL());
        details.put(ServerDetails.Detail.DATABASE_DRIVER_NAME, dbInfo.getDatabaseDriverName());
        details.put(ServerDetails.Detail.DATABASE_DRIVER_VERSION, dbInfo.getDatabaseDriverVersion());
        details.put(ServerDetails.Detail.DATABASE_PRODUCT_NAME, dbInfo.getDatabaseProductName());
        details.put(ServerDetails.Detail.DATABASE_PRODUCT_VERSION, dbInfo.getDatabaseProductVersion());
        details.put(ServerDetails.Detail.CURRENT_MEASUREMENT_TABLE, dbInfo.getCurrentMeasurementTable());
        details.put(ServerDetails.Detail.NEXT_MEASUREMENT_TABLE_ROTATION, dbInfo.getNextMeasurementTableRotation());
        return serverDetails;
    }

    @Override
    public ProductInfo getProductInfo(Subject subject) {
        CoreServerMBean coreServer = LookupUtil.getCoreServer();
        ProductInfo productInfo = coreServer.getProductInfo();
        return productInfo;
    }

    @Override
    public void dumpSystemInfo(Subject subject) {
        this.systemInfoManager.dumpToLog(subject);
    }
}

