/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.test;

import javax.ejb.EJB;
import javax.ejb.Stateless;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.rhq.core.domain.alert.AlertDefinition;
import org.rhq.core.domain.auth.Subject;
import org.rhq.enterprise.server.alert.AlertTemplateManagerLocal;
import org.rhq.enterprise.server.alert.InvalidAlertDefinitionException;
import org.rhq.enterprise.server.auth.SubjectManagerLocal;
import org.rhq.enterprise.server.resource.ResourceTypeNotFoundException;
import org.rhq.enterprise.server.test.AlertTemplateTestLocal;

@Stateless
public class AlertTemplateTestBean
implements AlertTemplateTestLocal {
    @PersistenceContext(unitName="rhqpu")
    private EntityManager entityManager;
    @EJB
    private AlertTemplateManagerLocal alertTemplateManager;
    @EJB
    private SubjectManagerLocal subjectManager;

    @Override
    public void cloneAlertTemplate(int alertTemplateId, int numberOfClones) throws ResourceTypeNotFoundException, InvalidAlertDefinitionException {
        Subject overlord = this.subjectManager.getOverlord();
        long currentMillis = System.currentTimeMillis();
        for (int i = 1; i <= numberOfClones; ++i) {
            AlertDefinition template = (AlertDefinition)this.entityManager.find(AlertDefinition.class, (Object)alertTemplateId);
            AlertDefinition newTemplate = new AlertDefinition(template);
            String oldName = template.getName();
            int resourceTypeId = template.getResourceType().getId();
            String newName = oldName + " (clone " + i + " at " + currentMillis + ")";
            newTemplate.setName(newName);
            this.alertTemplateManager.createAlertTemplate(overlord, newTemplate, resourceTypeId);
            this.entityManager.flush();
            this.entityManager.clear();
        }
    }
}

