/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.alert;

import java.util.Collection;
import java.util.List;
import javax.ejb.EJB;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.domain.alert.AlertCondition;
import org.rhq.core.domain.alert.AlertConditionCategory;
import org.rhq.core.domain.alert.composite.AbstractAlertConditionCategoryComposite;
import org.rhq.core.domain.auth.Subject;
import org.rhq.core.domain.resource.InventoryStatus;
import org.rhq.core.domain.server.PersistenceUtility;
import org.rhq.core.domain.util.PageControl;
import org.rhq.core.domain.util.PageList;
import org.rhq.enterprise.server.alert.AlertConditionManagerLocal;
import org.rhq.enterprise.server.authz.AuthorizationManagerLocal;
import org.rhq.enterprise.server.authz.PermissionException;

@Stateless
public class AlertConditionManagerBean
implements AlertConditionManagerLocal {
    private static final Log LOG = LogFactory.getLog(AlertConditionManagerBean.class);
    @PersistenceContext(unitName="rhqpu")
    private EntityManager entityManager;
    @EJB
    private AuthorizationManagerLocal authorizationManager;

    @Override
    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    public Integer getAlertDefinitionByConditionIdInNewTransaction(int alertConditionId) {
        try {
            Query query = this.entityManager.createNamedQuery("AlertDefinition.findDefinitionIdByConditionId");
            query.setParameter("alertConditionId", (Object)alertConditionId);
            Integer alertDefinitionId = (Integer)query.getSingleResult();
            return alertDefinitionId;
        }
        catch (NoResultException nre) {
            return null;
        }
    }

    @Override
    public AlertCondition getAlertConditionById(int alertConditionId) {
        return (AlertCondition)this.entityManager.find(AlertCondition.class, (Object)alertConditionId);
    }

    @Override
    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    public PageList<? extends AbstractAlertConditionCategoryComposite> getAlertConditionComposites(Subject user, Integer agentId, AlertConditionCategory category, PageControl pageControl) {
        if (!this.authorizationManager.isOverlord(user)) {
            throw new PermissionException("User [" + user.getName() + "] does not have permission to call " + "getAlertConditionComposites; only the overlord has that right");
        }
        String queryName = null;
        String countQueryName = "AlertCondition.byCategoryCountParameterized";
        if (category == AlertConditionCategory.BASELINE) {
            queryName = "AlertCondition.byCategoryBaseline";
            countQueryName = "AlertCondition.byCategoryCountBaseline";
        } else if (category == AlertConditionCategory.CHANGE) {
            queryName = "AlertCondition.byCategoryChange";
        } else if (category == AlertConditionCategory.TRAIT) {
            queryName = "AlertCondition.byCategoryTrait";
        } else if (category == AlertConditionCategory.AVAILABILITY) {
            queryName = "AlertCondition.byCategoryAvailability";
        } else if (category == AlertConditionCategory.AVAIL_DURATION) {
            queryName = "AlertCondition.byCategoryAvailability";
        } else if (category == AlertConditionCategory.CONTROL) {
            queryName = "AlertCondition.byCategoryControl";
        } else if (category == AlertConditionCategory.THRESHOLD) {
            queryName = "AlertCondition.byCategoryThreshold";
        } else if (category == AlertConditionCategory.EVENT) {
            queryName = "AlertCondition.byCategoryEvent";
        } else if (category == AlertConditionCategory.RESOURCE_CONFIG) {
            queryName = "AlertCondition.byCategoryResourceConfig";
        } else if (category == AlertConditionCategory.DRIFT) {
            queryName = "AlertCondition.byCategoryDrift";
        } else if (category == AlertConditionCategory.RANGE) {
            queryName = "AlertCondition.byCategoryRange";
        } else {
            throw new IllegalArgumentException("getAlertConditionComposites does not support category '" + category + "'");
        }
        Query query = this.entityManager.createNamedQuery(queryName);
        PersistenceUtility.setDataPage((Query)query, (PageControl)pageControl);
        Query queryCount = this.entityManager.createNamedQuery(countQueryName);
        if (queryName == "AlertCondition.byCategoryAvailability") {
            query.setParameter("category", (Object)category);
        }
        if (countQueryName == "AlertCondition.byCategoryCountParameterized") {
            queryCount.setParameter("category", (Object)category);
        }
        query.setParameter("agentId", (Object)agentId);
        queryCount.setParameter("agentId", (Object)agentId);
        long totalCount = (Long)queryCount.getSingleResult();
        List list = query.getResultList();
        LOG.debug((Object)("Found " + totalCount + " elements of type '" + category + "', list was size " + list.size()));
        return new PageList((Collection)list, (int)totalCount, pageControl);
    }

    @Override
    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    public InventoryStatus getResourceStatusByConditionId(int alertConditionId) {
        try {
            Query query = this.entityManager.createNamedQuery("AlertCondition.findResourceStatus");
            query.setParameter("alertConditionId", (Object)alertConditionId);
            InventoryStatus status = (InventoryStatus)query.getSingleResult();
            return status;
        }
        catch (NoResultException nre) {
            return InventoryStatus.UNINVENTORIED;
        }
    }

    @Override
    public int purgeOrphanedAlertConditions() {
        Query purgeQuery = this.entityManager.createNamedQuery("AlertCondition.deleteOrphaned");
        return purgeQuery.executeUpdate();
    }
}

