/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.alert.engine.jms;

import javax.ejb.ActivationConfigProperty;
import javax.ejb.EJB;
import javax.ejb.MessageDriven;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.ObjectMessage;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.domain.resource.InventoryStatus;
import org.rhq.enterprise.server.alert.AlertConditionManagerLocal;
import org.rhq.enterprise.server.alert.CachedConditionManagerLocal;
import org.rhq.enterprise.server.alert.engine.jms.model.AbstractAlertConditionMessage;
import org.rhq.enterprise.server.util.concurrent.AlertSerializer;

@MessageDriven(activationConfig={@ActivationConfigProperty(propertyName="destinationType", propertyValue="javax.jms.Queue"), @ActivationConfigProperty(propertyName="destination", propertyValue="java:/queue/AlertConditionQueue"), @ActivationConfigProperty(propertyName="acknowledgeMode", propertyValue="Auto-acknowledge"), @ActivationConfigProperty(propertyName="subscriptionDurability", propertyValue="NonDurable")})
public class AlertConditionConsumerBean
implements MessageListener {
    private final Log log = LogFactory.getLog(AlertConditionConsumerBean.class);
    @EJB
    private AlertConditionManagerLocal alertConditionManager;
    @EJB
    private CachedConditionManagerLocal cachedConditionManager;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void onMessage(Message message) {
        AbstractAlertConditionMessage conditionMessage = null;
        try {
            ObjectMessage objectMessage = (ObjectMessage)message;
            conditionMessage = (AbstractAlertConditionMessage)objectMessage.getObject();
        }
        catch (Throwable t) {
            this.log.error((Object)"Error getting content of jms message", t);
            return;
        }
        Integer definitionId = null;
        try {
            int alertConditionId;
            InventoryStatus status;
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Received message: " + conditionMessage));
            }
            if ((status = this.alertConditionManager.getResourceStatusByConditionId(alertConditionId = conditionMessage.getAlertConditionId())) != InventoryStatus.COMMITTED) {
                this.log.debug((Object)("Resource for AlertCondition[id=" + alertConditionId + "] is no longer COMMITTED, status was '" + status + "'; this message will be discarded"));
                return;
            }
            definitionId = this.alertConditionManager.getAlertDefinitionByConditionIdInNewTransaction(alertConditionId);
            if (definitionId == null) {
                this.log.info((Object)("AlertCondition[id=" + alertConditionId + "] has been removed after it was triggered; this message will be discarded"));
                return;
            }
            AlertSerializer.getSingleton().lock(definitionId);
            this.cachedConditionManager.processCachedConditionMessage(conditionMessage, definitionId);
            return;
        }
        catch (Throwable t) {
            this.log.error((Object)("Error handling " + conditionMessage + " - " + t.toString()));
            return;
        }
        finally {
            try {
                if (definitionId != null) {
                    AlertSerializer.getSingleton().unlock(definitionId);
                }
            }
            catch (Throwable t) {}
        }
    }
}

