/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.alert.engine.model;

import java.util.regex.Pattern;
import org.rhq.core.domain.alert.AlertConditionOperator;
import org.rhq.enterprise.server.alert.engine.model.AbstractCacheElement;
import org.rhq.enterprise.server.alert.engine.model.UnsupportedAlertConditionOperatorException;

public abstract class StringCacheElement
extends AbstractCacheElement<String> {
    final Pattern pattern;

    public StringCacheElement(AlertConditionOperator operator, String value, int conditionTriggerId) {
        super(operator, value, conditionTriggerId);
        if (operator.equals((Object)AlertConditionOperator.REGEX)) {
            if (!value.startsWith("^")) {
                value = ".*" + value;
            }
            if (!value.endsWith("$")) {
                value = value + ".*";
            }
            this.pattern = Pattern.compile(value, 42);
        } else {
            this.pattern = null;
        }
    }

    @Override
    public boolean matches(String providedValue, Object ... extraParams) {
        if (providedValue == null) {
            return false;
        }
        if (this.alertConditionOperator == AlertConditionOperator.CHANGES) {
            Boolean results = null;
            if (results == null && !((String)this.alertConditionValue).equals(providedValue)) {
                results = Boolean.TRUE;
            }
            if (results == null) {
                results = Boolean.FALSE;
            }
            this.alertConditionValue = providedValue;
            return results;
        }
        int result = ((String)this.alertConditionValue).compareTo(providedValue);
        if (this.alertConditionOperator == AlertConditionOperator.GREATER_THAN) {
            return result > 0;
        }
        if (this.alertConditionOperator == AlertConditionOperator.LESS_THAN) {
            return result < 0;
        }
        if (this.alertConditionOperator == AlertConditionOperator.EQUALS) {
            return result == 0;
        }
        if (this.alertConditionOperator == AlertConditionOperator.REGEX) {
            return this.pattern.matcher(providedValue).matches();
        }
        throw new UnsupportedAlertConditionOperatorException(this.getClass().getSimpleName() + " does not yet support " + this.alertConditionOperator);
    }

    @Override
    public AlertConditionOperator.Type getOperatorSupportsType(AlertConditionOperator operator) {
        if (operator == AlertConditionOperator.GREATER_THAN || operator == AlertConditionOperator.EQUALS || operator == AlertConditionOperator.LESS_THAN || operator == AlertConditionOperator.CHANGES || operator == AlertConditionOperator.REGEX) {
            return operator.getDefaultType();
        }
        return AlertConditionOperator.Type.NONE;
    }
}

