/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.auth.prefs;

import java.util.HashMap;
import java.util.Map;
import javax.ejb.ConcurrencyManagement;
import javax.ejb.ConcurrencyManagementType;
import javax.ejb.EJB;
import javax.ejb.Lock;
import javax.ejb.LockType;
import javax.ejb.Singleton;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.domain.auth.Subject;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.Property;
import org.rhq.core.domain.configuration.PropertySimple;
import org.rhq.enterprise.server.auth.SubjectManagerLocal;
import org.rhq.enterprise.server.auth.prefs.SubjectPreferencesCacheLocal;
import org.rhq.enterprise.server.common.EntityManagerFacadeLocal;
import org.rhq.enterprise.server.configuration.ConfigurationManagerLocal;

@ConcurrencyManagement(value=ConcurrencyManagementType.CONTAINER)
@Singleton
@TransactionAttribute(value=TransactionAttributeType.SUPPORTS)
public class SubjectPreferencesCacheBean
implements SubjectPreferencesCacheLocal {
    protected final Log log = LogFactory.getLog(SubjectPreferencesCacheBean.class);
    private Map<Integer, Configuration> subjectPreferences = new HashMap<Integer, Configuration>();
    @EJB
    private SubjectManagerLocal subjectManager;
    @EJB
    private EntityManagerFacadeLocal entityManagerFacade;
    @EJB
    private ConfigurationManagerLocal configurationManager;

    private SubjectPreferencesCacheBean() {
    }

    private void load(int subjectId) {
        if (subjectId != 0 && !this.subjectPreferences.containsKey(subjectId)) {
            try {
                Subject subject = this.subjectManager.loadUserConfiguration(subjectId);
                Configuration configuration = subject.getUserConfiguration();
                this.subjectPreferences.put(subjectId, configuration);
            }
            catch (Throwable t) {
                this.log.warn((Object)("Can not get preferences for subject[id=" + subjectId + "], subject does not exist yet"));
            }
        }
    }

    @Override
    @Lock(value=LockType.READ)
    public PropertySimple getUserProperty(int subjectId, String propertyName) {
        this.load(subjectId);
        Configuration config = this.subjectPreferences.get(subjectId);
        if (config == null) {
            return null;
        }
        PropertySimple prop = config.getSimple(propertyName);
        if (prop == null) {
            return null;
        }
        return new PropertySimple(propertyName, (Object)prop.getStringValue());
    }

    @Override
    @Lock(value=LockType.WRITE)
    public void setUserProperty(int subjectId, String propertyName, String value) {
        this.load(subjectId);
        Configuration config = this.subjectPreferences.get(subjectId);
        if (config == null) {
            return;
        }
        PropertySimple prop = config.getSimple(propertyName);
        if (prop == null) {
            prop = new PropertySimple(propertyName, (Object)value);
            config.put((Property)prop);
            this.mergeProperty(prop);
        } else if (prop.getStringValue() == null || !prop.getStringValue().equals(value)) {
            prop.setStringValue(value);
            this.mergeProperty(prop);
        }
    }

    private void mergeProperty(PropertySimple prop) {
        PropertySimple mergedProperty = this.entityManagerFacade.merge(prop);
        if (prop.getId() == 0) {
            prop.setId(mergedProperty.getId());
        }
    }

    @Override
    @Lock(value=LockType.WRITE)
    public void unsetUserProperty(int subjectId, String propertyName) {
        this.load(subjectId);
        Configuration config = this.subjectPreferences.get(subjectId);
        if (config == null) {
            return;
        }
        Property property = config.remove(propertyName);
        if (property != null && property.getId() != 0) {
            try {
                this.configurationManager.deleteProperties(new int[]{property.getId()});
            }
            catch (Throwable t) {
                this.log.error((Object)("Could not remove " + property), t);
            }
        }
    }

    @Override
    @Lock(value=LockType.READ)
    public Configuration getPreferences(int subjectId) {
        this.load(subjectId);
        Configuration config = this.subjectPreferences.get(subjectId);
        if (config == null) {
            return new Configuration();
        }
        return config.deepCopy();
    }

    @Override
    @Lock(value=LockType.WRITE)
    public void clearConfiguration(int subjectId) {
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("Removing PreferencesCache For " + subjectId));
        }
        this.subjectPreferences.remove(subjectId);
    }
}

