/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.core;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import javax.ejb.EJB;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import javax.interceptor.ExcludeDefaultInterceptors;
import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.maven.artifact.versioning.ComparableVersion;
import org.rhq.core.clientapi.server.core.AgentVersion;
import org.rhq.core.clientapi.server.core.PingRequest;
import org.rhq.core.domain.auth.Subject;
import org.rhq.core.domain.authz.Permission;
import org.rhq.core.domain.common.composite.SystemSetting;
import org.rhq.core.domain.criteria.AgentCriteria;
import org.rhq.core.domain.criteria.Criteria;
import org.rhq.core.domain.measurement.AvailabilityType;
import org.rhq.core.domain.resource.Agent;
import org.rhq.core.domain.resource.composite.AgentLastAvailabilityPingComposite;
import org.rhq.core.domain.server.PersistenceUtility;
import org.rhq.core.domain.util.PageControl;
import org.rhq.core.domain.util.PageList;
import org.rhq.core.util.MessageDigestGenerator;
import org.rhq.core.util.exception.ThrowableUtil;
import org.rhq.core.util.stream.StreamUtil;
import org.rhq.enterprise.server.agentclient.AgentClient;
import org.rhq.enterprise.server.auth.SubjectManagerLocal;
import org.rhq.enterprise.server.authz.AuthorizationManagerLocal;
import org.rhq.enterprise.server.authz.PermissionException;
import org.rhq.enterprise.server.authz.RequiredPermission;
import org.rhq.enterprise.server.cloud.FailoverListManagerLocal;
import org.rhq.enterprise.server.core.AgentManagerLocal;
import org.rhq.enterprise.server.core.CoreServerMBean;
import org.rhq.enterprise.server.core.comm.ServerCommunicationsServiceMBean;
import org.rhq.enterprise.server.core.comm.ServerCommunicationsServiceUtil;
import org.rhq.enterprise.server.measurement.AvailabilityManagerLocal;
import org.rhq.enterprise.server.system.SystemManagerLocal;
import org.rhq.enterprise.server.util.CriteriaQueryGenerator;
import org.rhq.enterprise.server.util.CriteriaQueryRunner;
import org.rhq.enterprise.server.util.LookupUtil;
import org.rhq.enterprise.server.util.concurrent.AvailabilityReportSerializer;

@Stateless
public class AgentManagerBean
implements AgentManagerLocal {
    private final Log log = LogFactory.getLog(AgentManagerBean.class);
    @PersistenceContext(unitName="rhqpu")
    private EntityManager entityManager;
    @EJB
    private FailoverListManagerLocal failoverListManager;
    @EJB
    private AvailabilityManagerLocal availabilityManager;
    @EJB
    private AgentManagerLocal agentManager;
    @EJB
    private SystemManagerLocal systemManager;
    @EJB
    private SubjectManagerLocal subjectManager;
    @EJB
    private AuthorizationManagerLocal authorizationManager;
    private static final String RHQ_SERVER_VERSION = "rhq-server.version";
    private static final String RHQ_SERVER_BUILD_NUMBER = "rhq-server.build-number";
    private static final String RHQ_AGENT_LATEST_VERSION = "rhq-agent.latest.version";
    private static final String RHQ_AGENT_LATEST_BUILD_NUMBER = "rhq-agent.latest.build-number";
    private static final String RHQ_AGENT_LATEST_MD5 = "rhq-agent.latest.md5";

    @Override
    @ExcludeDefaultInterceptors
    public void createAgent(Agent agent) {
        this.entityManager.persist((Object)agent);
        this.log.debug((Object)("Persisted new agent: " + agent));
    }

    @Override
    @ExcludeDefaultInterceptors
    public void deleteAgent(Agent agent) {
        agent = (Agent)this.entityManager.find(Agent.class, (Object)agent.getId());
        this.failoverListManager.deleteServerListsForAgent(agent);
        this.entityManager.remove((Object)agent);
        this.destroyAgentClient(agent);
        this.log.info((Object)("Removed agent: " + agent));
    }

    @Override
    @ExcludeDefaultInterceptors
    public void destroyAgentClient(Agent agent) {
        ServerCommunicationsServiceMBean bootstrap = ServerCommunicationsServiceUtil.getService();
        try {
            bootstrap.destroyKnownAgentClient(agent);
            this.log.debug((Object)("agent client destroyed for agent: " + agent));
        }
        catch (Exception e) {
            this.log.warn((Object)("Could not destroy agent client for agent [" + agent + "]: " + ThrowableUtil.getAllMessages((Throwable)e)));
        }
    }

    @Override
    @ExcludeDefaultInterceptors
    public Agent updateAgent(Agent agent) {
        agent = (Agent)this.entityManager.merge((Object)agent);
        this.log.debug((Object)("Updated agent: " + agent));
        return agent;
    }

    @Override
    @ExcludeDefaultInterceptors
    public AgentClient getAgentClient(Agent agent) {
        AgentClient client = null;
        try {
            ServerCommunicationsServiceMBean bootstrap = ServerCommunicationsServiceUtil.getService();
            client = bootstrap.getKnownAgentClient(agent);
            client.startSending();
        }
        catch (Throwable t) {
            this.log.debug((Object)("Could not get agent client for " + agent));
        }
        return client;
    }

    @Override
    public AgentClient getAgentClient(Subject subject, int resourceId) {
        Agent agent = this.getAgentByResourceId(subject, resourceId);
        if (agent == null) {
            this.log.debug((Object)("Resource [" + resourceId + "] does not exist or has no agent assigned"));
            return null;
        }
        return this.getAgentClient(agent);
    }

    @Override
    @ExcludeDefaultInterceptors
    public void agentIsShuttingDown(String agentName) {
        Agent downedAgent = this.getAgentByName(agentName);
        ServerCommunicationsServiceMBean server_bootstrap = ServerCommunicationsServiceUtil.getService();
        server_bootstrap.removeDownedAgent(downedAgent.getRemoteEndpoint());
        this.log.info((Object)("Agent with name [" + agentName + "] just went down"));
        this.agentManager.backfillAgentInNewTransaction(this.subjectManager.getOverlord(), agentName, downedAgent.getId());
    }

    @Override
    @ExcludeDefaultInterceptors
    public void agentIsAlive(Agent agent) {
        try {
            ServerCommunicationsServiceMBean server_comm = ServerCommunicationsServiceUtil.getService();
            server_comm.addStartedAgent(agent);
        }
        catch (Exception e) {
            this.log.info((Object)"Cannot flag the agent as started for some reason", (Throwable)e);
        }
    }

    @Override
    @ExcludeDefaultInterceptors
    public void checkForSuspectAgents() {
        this.log.debug((Object)"Checking to see if there are agents that we suspect are down...");
        long maximumQuietTimeAllowed = 300000L;
        try {
            String prop = (String)this.systemManager.getSystemSettings(this.subjectManager.getOverlord()).get((Object)SystemSetting.AGENT_MAX_QUIET_TIME_ALLOWED);
            if (prop != null) {
                maximumQuietTimeAllowed = Long.parseLong(prop);
            }
        }
        catch (Exception e) {
            this.log.warn((Object)("Agent quiet time config is invalid in DB, defaulting to: " + maximumQuietTimeAllowed), (Throwable)e);
        }
        long nowEpoch = System.currentTimeMillis();
        Query q = this.entityManager.createNamedQuery("Agent.findAllSuspectAgents");
        q.setParameter("dateThreshold", (Object)(nowEpoch - maximumQuietTimeAllowed));
        List records = q.getResultList();
        ServerCommunicationsServiceMBean serverComm = null;
        for (AgentLastAvailabilityPingComposite record : records) {
            long lastReport = record.getLastAvailabilityPing();
            long timeSinceLastReport = nowEpoch - lastReport;
            if (timeSinceLastReport % 21600000L < maximumQuietTimeAllowed * 2L) {
                if (serverComm == null) {
                    serverComm = ServerCommunicationsServiceUtil.getService();
                }
                serverComm.removeDownedAgent(record.getRemoteEndpoint());
            }
            if (record.isBackFilled()) continue;
            this.log.info((Object)("Have not heard from agent [" + record.getAgentName() + "] since [" + new Date(record.getLastAvailabilityPing()) + "]. Will be backfilled since we suspect it is down"));
            this.agentManager.backfillAgentInNewTransaction(this.subjectManager.getOverlord(), record.getAgentName(), record.getAgentId());
        }
        this.log.debug((Object)"Finished checking for suspected agents");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    public void backfillAgentInNewTransaction(Subject subject, String agentName, int agentId) {
        AvailabilityReportSerializer.getSingleton().lock(agentName);
        try {
            this.agentManager.setAgentBackfilled(agentId, true);
            this.availabilityManager.updateAgentResourceAvailabilities(agentId, AvailabilityType.DOWN, AvailabilityType.UNKNOWN);
        }
        finally {
            AvailabilityReportSerializer.getSingleton().unlock(agentName);
        }
    }

    @Override
    public void setAgentBackfilled(int agentId, boolean backfilled) {
        Query query = this.entityManager.createNamedQuery("Agent.setAgentBackfilled");
        query.setParameter("agentId", (Object)agentId);
        query.setParameter("backfilled", (Object)backfilled);
        query.executeUpdate();
    }

    @Override
    public boolean isAgentBackfilled(int agentId) {
        Query query = this.entityManager.createNamedQuery("Agent.isAgentBackfilled");
        query.setParameter("agentId", (Object)agentId);
        Long backfilledCount = (Long)query.getSingleResult();
        return backfilledCount != 0L;
    }

    @Override
    @ExcludeDefaultInterceptors
    public List<Agent> getAllAgents() {
        return this.entityManager.createNamedQuery("Agent.findAll").getResultList();
    }

    @Override
    @RequiredPermission(value=Permission.MANAGE_INVENTORY)
    public PageList<Agent> getAgentsByServer(Subject subject, Integer serverId, PageControl pageControl) {
        pageControl.initDefaultOrderingField("a.name");
        Query query = PersistenceUtility.createQueryWithOrderBy((EntityManager)this.entityManager, (String)"Agent.findByServer", (PageControl)pageControl);
        Query countQuery = PersistenceUtility.createCountQuery((EntityManager)this.entityManager, (String)"Agent.findByServer");
        query.setParameter("serverId", (Object)serverId);
        countQuery.setParameter("serverId", (Object)serverId);
        long count = (Long)countQuery.getSingleResult();
        List results = query.getResultList();
        return new PageList((Collection)results, (int)count, pageControl);
    }

    @Override
    @ExcludeDefaultInterceptors
    public int getAgentCount() {
        return ((Number)this.entityManager.createNamedQuery("Agent.countAll").getSingleResult()).intValue();
    }

    @Override
    @ExcludeDefaultInterceptors
    public Agent getAgentByAgentToken(String token) {
        Agent agent;
        try {
            Query query = this.entityManager.createNamedQuery("Agent.findByAgentToken");
            query.setParameter("agentToken", (Object)token);
            agent = (Agent)query.getSingleResult();
        }
        catch (NoResultException e) {
            this.log.debug((Object)("Failed to lookup agent - none exist with token [" + token + "] : " + (Object)((Object)e)));
            agent = null;
        }
        return agent;
    }

    @Override
    @ExcludeDefaultInterceptors
    public Agent getAgentByName(String agentName) {
        Agent agent;
        try {
            Query query = this.entityManager.createNamedQuery("Agent.findByName");
            query.setParameter("name", (Object)agentName);
            agent = (Agent)query.getSingleResult();
        }
        catch (NoResultException e) {
            this.log.debug((Object)("Failed to lookup agent - none exist with name [" + agentName + "] : " + (Object)((Object)e)));
            agent = null;
        }
        return agent;
    }

    @Override
    @ExcludeDefaultInterceptors
    public Agent getAgentByID(int agentId) {
        Agent agent = (Agent)this.entityManager.find(Agent.class, (Object)agentId);
        return agent;
    }

    @Override
    @ExcludeDefaultInterceptors
    public Agent getAgentByAddressAndPort(String address, int port) {
        Agent agent;
        try {
            Query query = this.entityManager.createNamedQuery("Agent.findByAddressAndPort");
            query.setParameter("address", (Object)address);
            query.setParameter("port", (Object)port);
            agent = (Agent)query.getSingleResult();
        }
        catch (NoResultException e) {
            this.log.debug((Object)("Agent not found with address/port: " + address + "/" + port));
            agent = null;
        }
        return agent;
    }

    @Override
    public Agent getAgentByResourceId(Subject subject, int resourceId) {
        Agent agent;
        try {
            if (subject != null && !this.authorizationManager.hasGlobalPermission(subject, Permission.MANAGE_SETTINGS)) {
                throw new PermissionException("Can not get agent details - " + subject + " lacks " + Permission.MANAGE_SETTINGS + " for resource[id=" + resourceId + "]");
            }
            Query query = this.entityManager.createNamedQuery("Agent.findByResourceId");
            query.setParameter("resourceId", (Object)resourceId);
            agent = (Agent)query.getSingleResult();
        }
        catch (NoResultException e) {
            this.log.debug((Object)("Failed to lookup agent for resource with ID of [" + resourceId + "] : " + (Object)((Object)e)));
            agent = null;
        }
        return agent;
    }

    @Override
    @ExcludeDefaultInterceptors
    public Integer getAgentIdByResourceId(int resourceId) {
        Integer agentId;
        try {
            Query query = this.entityManager.createNamedQuery("Agent.findAgentIdByResourceId");
            query.setParameter("resourceId", (Object)resourceId);
            agentId = (Integer)query.getSingleResult();
        }
        catch (NoResultException e) {
            this.log.debug((Object)("Failed to lookup agent for resource with ID of [" + resourceId + "] : " + (Object)((Object)e)));
            agentId = null;
        }
        return agentId;
    }

    @Override
    @ExcludeDefaultInterceptors
    public Integer getAgentIdByName(String agentName) {
        Integer agentId;
        try {
            Query query = this.entityManager.createNamedQuery("Agent.findAgentIdByName");
            query.setParameter("name", (Object)agentName);
            agentId = (Integer)query.getSingleResult();
        }
        catch (NoResultException e) {
            this.log.debug((Object)("Failed to lookup agent for name of [" + agentName + "] : " + (Object)((Object)e)));
            agentId = null;
        }
        return agentId;
    }

    @Override
    @ExcludeDefaultInterceptors
    public Integer getAgentIdByScheduleId(int scheduleId) {
        Integer agentId;
        try {
            Query query = this.entityManager.createNamedQuery("Agent.findAgentIdByScheduleId");
            query.setParameter("scheduleId", (Object)scheduleId);
            agentId = (Integer)query.getSingleResult();
        }
        catch (NoResultException e) {
            this.log.debug((Object)("Failed to lookup agent for resource with ID of [" + scheduleId + "] : " + (Object)((Object)e)));
            agentId = null;
        }
        return agentId;
    }

    @Override
    @ExcludeDefaultInterceptors
    public boolean isAgentVersionSupported(AgentVersion agentVersionInfo) {
        try {
            Properties properties = this.getAgentUpdateVersionFileContent();
            String supportedAgentVersion = properties.getProperty(RHQ_AGENT_LATEST_VERSION);
            if (supportedAgentVersion == null) {
                throw new NullPointerException("no agent version in file");
            }
            ComparableVersion agent = new ComparableVersion(agentVersionInfo.getVersion());
            ComparableVersion server = new ComparableVersion(supportedAgentVersion);
            if (Boolean.getBoolean("rhq.server.agent-update.nonstrict-version-check")) {
                return agent.equals((Object)server);
            }
            String supportedAgentBuild = properties.getProperty(RHQ_AGENT_LATEST_BUILD_NUMBER);
            return agent.equals((Object)server) && agentVersionInfo.getBuild().equals(supportedAgentBuild);
        }
        catch (Exception e) {
            this.log.warn((Object)("Cannot determine if agent version [" + agentVersionInfo + "] is supported. Cause: " + e));
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ExcludeDefaultInterceptors
    public File getAgentUpdateVersionFile() throws Exception {
        File agentDownloadDir = this.getAgentDataDownloadDir();
        File versionFile = new File(agentDownloadDir, "rhq-server-agent-versions.properties");
        if (!versionFile.exists()) {
            StringBuilder serverVersionInfo = new StringBuilder();
            CoreServerMBean coreServer = LookupUtil.getCoreServer();
            serverVersionInfo.append("rhq-server.version=").append(coreServer.getVersion()).append('\n');
            serverVersionInfo.append("rhq-server.build-number=").append(coreServer.getBuildNumber()).append('\n');
            File binaryFile = this.getAgentUpdateBinaryFile();
            String md5Property = "rhq-agent.latest.md5=" + MessageDigestGenerator.getDigestString((File)binaryFile) + '\n';
            JarFile binaryJarFile = new JarFile(binaryFile);
            try {
                JarEntry binaryJarFileEntry = binaryJarFile.getJarEntry("rhq-agent-update-version.properties");
                InputStream binaryJarFileEntryStream = binaryJarFile.getInputStream(binaryJarFileEntry);
                FileOutputStream versionFileOutputStream = new FileOutputStream(versionFile);
                try {
                    versionFileOutputStream.write(serverVersionInfo.toString().getBytes());
                    versionFileOutputStream.write(md5Property.getBytes());
                    StreamUtil.copy((InputStream)binaryJarFileEntryStream, (OutputStream)versionFileOutputStream, (boolean)false);
                }
                finally {
                    try {
                        versionFileOutputStream.close();
                    }
                    catch (Exception e) {}
                    try {
                        binaryJarFileEntryStream.close();
                    }
                    catch (Exception e) {}
                }
            }
            finally {
                binaryJarFile.close();
            }
        }
        return versionFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ExcludeDefaultInterceptors
    public Properties getAgentUpdateVersionFileContent() throws Exception {
        FileInputStream stream = new FileInputStream(this.getAgentUpdateVersionFile());
        try {
            Properties props = new Properties();
            props.load(stream);
            Properties properties = props;
            return properties;
        }
        finally {
            try {
                stream.close();
            }
            catch (Exception e) {}
        }
    }

    @Override
    @ExcludeDefaultInterceptors
    public File getAgentUpdateBinaryFile() throws Exception {
        File agentDownloadDir = this.getAgentDownloadDir();
        for (File file : agentDownloadDir.listFiles()) {
            if (!file.getName().endsWith(".jar")) continue;
            return file;
        }
        throw new FileNotFoundException("Missing agent update binary in [" + agentDownloadDir + "]");
    }

    @Override
    public File getAgentDownloadDir() throws Exception {
        File earDir = LookupUtil.getCoreServer().getEarDeploymentDir();
        File agentDownloadDir = new File(earDir, "rhq-downloads/rhq-agent");
        if (!agentDownloadDir.exists()) {
            throw new FileNotFoundException("Missing agent downloads directory at [" + agentDownloadDir + "]");
        }
        return agentDownloadDir;
    }

    private File getAgentDataDownloadDir() throws Exception {
        File earDir = LookupUtil.getCoreServer().getJBossServerDataDir();
        File agentDownloadDir = new File(earDir, "rhq-downloads/rhq-agent");
        if (!agentDownloadDir.exists()) {
            agentDownloadDir.mkdirs();
            if (!agentDownloadDir.exists()) {
                throw new FileNotFoundException("Missing agent data downloads directory at [" + agentDownloadDir + "]");
            }
        }
        return agentDownloadDir;
    }

    @Override
    public PingRequest handlePingRequest(PingRequest request) {
        long now = System.currentTimeMillis();
        if (request.isRequestUpdateAvailability()) {
            this.updateLastAvailabilityPing(request.getAgentName(), now);
            request.setReplyUpdateAvailability(true);
        }
        if (request.isRequestServerTimestamp()) {
            request.setReplyServerTimestamp(Long.valueOf(now));
        }
        return request;
    }

    private void updateLastAvailabilityPing(String agentName, long now) {
        String updateStatement = "UPDATE Agent    SET lastAvailabilityPing = :now, backFilled = FALSE  WHERE name = :agentName ";
        Query query = this.entityManager.createQuery(updateStatement);
        query.setParameter("now", (Object)now);
        query.setParameter("agentName", (Object)agentName);
        query.executeUpdate();
    }

    @Override
    @ExcludeDefaultInterceptors
    public Boolean pingAgentByResourceId(Subject subject, int resourceId) {
        Boolean pingResults = Boolean.FALSE;
        try {
            Agent agent = this.getAgentByResourceId(subject, resourceId);
            AgentClient client = this.getAgentClient(agent);
            pingResults = client.ping(5000L);
        }
        catch (NoResultException e) {
            this.log.debug((Object)("Failed to lookup agent for resource with ID of [" + resourceId + "] : " + (Object)((Object)e)));
            Object agent = null;
        }
        return pingResults;
    }

    @Override
    @RequiredPermission(value=Permission.MANAGE_SETTINGS)
    public PageList<Agent> findAgentsByCriteria(Subject subject, AgentCriteria criteria) {
        CriteriaQueryGenerator generator = new CriteriaQueryGenerator(subject, (Criteria)criteria);
        CriteriaQueryRunner runner = new CriteriaQueryRunner((Criteria)criteria, generator, this.entityManager);
        return runner.execute();
    }
}

