/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.drift;

import difflib.DiffUtils;
import difflib.Patch;
import java.io.File;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import javax.annotation.Resource;
import javax.ejb.EJB;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.Message;
import javax.jms.MessageProducer;
import javax.jms.ObjectMessage;
import javax.jms.Queue;
import javax.jms.Session;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.Hibernate;
import org.jboss.remoting.CannotConnectException;
import org.rhq.core.clientapi.agent.drift.DriftAgentService;
import org.rhq.core.domain.auth.Subject;
import org.rhq.core.domain.authz.Permission;
import org.rhq.core.domain.common.EntityContext;
import org.rhq.core.domain.criteria.Criteria;
import org.rhq.core.domain.criteria.DriftChangeSetCriteria;
import org.rhq.core.domain.criteria.DriftCriteria;
import org.rhq.core.domain.criteria.DriftDefinitionCriteria;
import org.rhq.core.domain.criteria.GenericDriftChangeSetCriteria;
import org.rhq.core.domain.criteria.GenericDriftCriteria;
import org.rhq.core.domain.drift.Drift;
import org.rhq.core.domain.drift.DriftCategory;
import org.rhq.core.domain.drift.DriftChangeSet;
import org.rhq.core.domain.drift.DriftChangeSetCategory;
import org.rhq.core.domain.drift.DriftComplianceStatus;
import org.rhq.core.domain.drift.DriftComposite;
import org.rhq.core.domain.drift.DriftConfigurationDefinition;
import org.rhq.core.domain.drift.DriftDefinition;
import org.rhq.core.domain.drift.DriftDefinitionComparator;
import org.rhq.core.domain.drift.DriftDefinitionComposite;
import org.rhq.core.domain.drift.DriftDefinitionTemplate;
import org.rhq.core.domain.drift.DriftDetails;
import org.rhq.core.domain.drift.DriftFile;
import org.rhq.core.domain.drift.DriftSnapshot;
import org.rhq.core.domain.drift.DriftSnapshotRequest;
import org.rhq.core.domain.drift.FileDiffReport;
import org.rhq.core.domain.drift.Filter;
import org.rhq.core.domain.drift.dto.DriftChangeSetDTO;
import org.rhq.core.domain.drift.dto.DriftDTO;
import org.rhq.core.domain.drift.dto.DriftFileDTO;
import org.rhq.core.domain.resource.ResourceType;
import org.rhq.core.domain.util.PageControl;
import org.rhq.core.domain.util.PageList;
import org.rhq.core.domain.util.PageOrdering;
import org.rhq.enterprise.server.agentclient.AgentClient;
import org.rhq.enterprise.server.alert.engine.AlertConditionCacheManagerLocal;
import org.rhq.enterprise.server.alert.engine.AlertConditionCacheStats;
import org.rhq.enterprise.server.auth.SubjectManagerLocal;
import org.rhq.enterprise.server.authz.AuthorizationManagerLocal;
import org.rhq.enterprise.server.authz.PermissionException;
import org.rhq.enterprise.server.core.AgentManagerLocal;
import org.rhq.enterprise.server.drift.DriftManagerLocal;
import org.rhq.enterprise.server.drift.DriftManagerRemote;
import org.rhq.enterprise.server.drift.DriftUploadRequest;
import org.rhq.enterprise.server.drift.DriftUtil;
import org.rhq.enterprise.server.plugin.pc.MasterServerPluginContainer;
import org.rhq.enterprise.server.plugin.pc.drift.DriftChangeSetSummary;
import org.rhq.enterprise.server.plugin.pc.drift.DriftServerPluginContainer;
import org.rhq.enterprise.server.plugin.pc.drift.DriftServerPluginFacet;
import org.rhq.enterprise.server.plugin.pc.drift.DriftServerPluginManager;
import org.rhq.enterprise.server.util.CriteriaQueryGenerator;
import org.rhq.enterprise.server.util.CriteriaQueryRunner;
import org.rhq.enterprise.server.util.LookupUtil;

@Stateless
public class DriftManagerBean
implements DriftManagerLocal,
DriftManagerRemote {
    private Log log = LogFactory.getLog(DriftManagerBean.class);
    @Resource(mappedName="java:/JmsXA")
    private ConnectionFactory factory;
    @Resource(mappedName="java:/queue/DriftChangesetQueue")
    private Queue changesetQueue;
    @Resource(mappedName="java:/queue/DriftFileQueue")
    private Queue fileQueue;
    @PersistenceContext(unitName="rhqpu")
    private EntityManager entityManager;
    @EJB
    private AgentManagerLocal agentManager;
    @EJB
    private DriftManagerLocal driftManager;
    @EJB
    private SubjectManagerLocal subjectManager;
    @EJB
    private AlertConditionCacheManagerLocal alertConditionCacheManager;
    @EJB
    private AuthorizationManagerLocal authorizationManager;

    @Override
    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    public void addChangeSet(Subject subject, int resourceId, long zipSize, InputStream zipStream) throws Exception {
        this.authorizeOrFail(subject, resourceId, "Can not update drifts");
        Connection connection = this.factory.createConnection();
        Session session = connection.createSession(false, 1);
        MessageProducer producer = session.createProducer((Destination)this.changesetQueue);
        ObjectMessage msg = session.createObjectMessage((Serializable)new DriftUploadRequest(resourceId, zipSize, zipStream));
        producer.send((Message)msg);
        connection.close();
    }

    @Override
    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    public void addFiles(Subject subject, int resourceId, String driftDefName, String token, long zipSize, InputStream zipStream) throws Exception {
        this.authorizeOrFail(subject, resourceId, "Can not update drifts");
        Connection connection = this.factory.createConnection();
        Session session = connection.createSession(false, 1);
        MessageProducer producer = session.createProducer((Destination)this.fileQueue);
        ObjectMessage msg = session.createObjectMessage((Serializable)new DriftUploadRequest(resourceId, driftDefName, token, zipSize, zipStream));
        producer.send((Message)msg);
        connection.close();
    }

    @Override
    @TransactionAttribute(value=TransactionAttributeType.NOT_SUPPORTED)
    public void saveChangeSetContent(Subject subject, int resourceId, String driftDefName, String token, File changeSetFilesZip) throws Exception {
        this.authorizeOrFail(subject, resourceId, "Can not update drifts");
        this.saveChangeSetFiles(subject, changeSetFilesZip);
        AgentClient agent = this.agentManager.getAgentClient(this.subjectManager.getOverlord(), resourceId);
        DriftAgentService driftService = agent.getDriftAgentService();
        driftService.ackChangeSetContent(resourceId, driftDefName, token);
    }

    @Override
    public void processRepeatChangeSet(int resourceId, String driftDefName, int version) {
        Subject overlord = this.subjectManager.getOverlord();
        DriftDefinitionCriteria driftDefCriteria = new DriftDefinitionCriteria();
        driftDefCriteria.setStrict(true);
        driftDefCriteria.addFilterResourceIds(new Integer[]{resourceId});
        driftDefCriteria.addFilterName(driftDefName);
        PageList<DriftDefinition> defs = this.findDriftDefinitionsByCriteria(overlord, driftDefCriteria);
        if (defs.isEmpty()) {
            this.log.warn((Object)("Cannot process repeat change set. No drift definition found for [resourceId: " + resourceId + ", driftDefinitionName: " + driftDefName + "]"));
        }
        DriftDefinition driftDef = (DriftDefinition)defs.get(0);
        DriftServerPluginFacet driftServerPlugin = this.getServerPlugin();
        GenericDriftChangeSetCriteria criteria = new GenericDriftChangeSetCriteria();
        criteria.addFilterResourceId(Integer.valueOf(resourceId));
        criteria.addFilterDriftDefinitionId(Integer.valueOf(driftDef.getId()));
        criteria.addFilterVersion(Integer.toString(version));
        criteria.fetchDrifts(true);
        PageList<? extends DriftChangeSet<?>> changeSets = driftServerPlugin.findDriftChangeSetsByCriteria(overlord, (DriftChangeSetCriteria)criteria);
        if (changeSets.isEmpty()) {
            this.log.warn((Object)("Cannot process repeat change set. No change set found for [driftDefinitionId: " + driftDef.getId() + ", version: " + version + "]"));
            return;
        }
        DriftChangeSet changeSet = (DriftChangeSet)changeSets.get(0);
        DriftChangeSetSummary summary = new DriftChangeSetSummary();
        summary.setCategory(changeSet.getCategory());
        summary.setCreatedTime(System.currentTimeMillis());
        summary.setResourceId(changeSet.getResourceId());
        summary.setDriftDefinitionName(driftDef.getName());
        summary.setDriftHandlingMode(driftDef.getDriftHandlingMode());
        for (Drift drift : changeSet.getDrifts()) {
            summary.addDriftPathname(drift.getPath());
        }
        this.notifyAlertConditionCacheManager("processRepeatChangeSet", summary);
    }

    @Override
    @TransactionAttribute(value=TransactionAttributeType.NOT_SUPPORTED)
    public DriftSnapshot getSnapshot(Subject subject, DriftSnapshotRequest request) {
        DriftSnapshot result = new DriftSnapshot(request);
        int startVersion = request.getStartVersion();
        if (0 == startVersion) {
            DriftChangeSet<? extends Drift<?, ?>> initialChangeset = this.loadInitialChangeSet(subject, request);
            if (null == initialChangeset) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("Cannot create snapshot, no initial changeset for: " + request));
                }
                return result;
            }
            result.addChangeSet(initialChangeset);
            if (Integer.valueOf(0).equals(request.getVersion())) {
                return result;
            }
            ++startVersion;
        }
        GenericDriftChangeSetCriteria criteria = new GenericDriftChangeSetCriteria();
        criteria.addFilterCategory(DriftChangeSetCategory.DRIFT);
        criteria.addFilterStartVersion(String.valueOf(startVersion));
        if (null != request.getVersion()) {
            criteria.addFilterEndVersion(Integer.toString(request.getVersion()));
        }
        criteria.addFilterDriftDefinitionId(request.getDriftDefinitionId());
        criteria.addFilterDriftDirectory(request.getDirectory());
        criteria.setStrict(true);
        criteria.fetchDrifts(true);
        criteria.addSortVersion(PageOrdering.ASC);
        PageList<? extends DriftChangeSet<?>> changeSets = this.findDriftChangeSetsByCriteria(subject, (DriftChangeSetCriteria)criteria);
        for (DriftChangeSet changeSet : changeSets) {
            result.addChangeSet(changeSet);
        }
        return result;
    }

    private DriftChangeSet<? extends Drift<?, ?>> loadInitialChangeSet(Subject subject, DriftSnapshotRequest request) {
        GenericDriftChangeSetCriteria criteria = new GenericDriftChangeSetCriteria();
        criteria.addFilterCategory(DriftChangeSetCategory.COVERAGE);
        criteria.addFilterVersion("0");
        criteria.addFilterDriftDefinitionId(request.getDriftDefinitionId());
        criteria.addFilterId(request.getTemplateChangeSetId());
        criteria.fetchDrifts(true);
        PageList<? extends DriftChangeSet<?>> changeSets = this.findDriftChangeSetsByCriteria(subject, (DriftChangeSetCriteria)criteria);
        if (changeSets.isEmpty()) {
            return null;
        }
        return (DriftChangeSet)changeSets.get(0);
    }

    @Override
    public void detectDrift(Subject subject, EntityContext context, DriftDefinition driftDef) {
        switch (context.getType()) {
            case Resource: {
                this.authorizeOrFail(subject, context, "Can not update drifts");
                int resourceId = context.getResourceId();
                org.rhq.core.domain.resource.Resource resource = (org.rhq.core.domain.resource.Resource)this.entityManager.find(org.rhq.core.domain.resource.Resource.class, (Object)resourceId);
                if (null == resource) {
                    throw new IllegalArgumentException("Resource not found [" + resourceId + "]");
                }
                AgentClient agentClient = this.agentManager.getAgentClient(this.subjectManager.getOverlord(), resourceId);
                DriftAgentService service = agentClient.getDriftAgentService();
                try {
                    service.detectDrift(resourceId, driftDef);
                    break;
                }
                catch (CannotConnectException e) {
                    throw new IllegalStateException("Agent could not be reached and may be down (see server logs for more). Could not perform drift detection request [" + driftDef + "]");
                }
            }
            default: {
                throw new IllegalArgumentException("Entity Context Type not supported [" + context + "]");
            }
        }
    }

    @Override
    @TransactionAttribute(value=TransactionAttributeType.NOT_SUPPORTED)
    public void deleteDriftDefinition(Subject subject, EntityContext entityContext, String driftDefName) {
        switch (entityContext.getType()) {
            case Resource: {
                this.authorizeOrFail(subject, entityContext, "Can not delete drifts");
                int resourceId = entityContext.getResourceId();
                DriftDefinitionCriteria criteria = new DriftDefinitionCriteria();
                criteria.addFilterName(driftDefName);
                criteria.addFilterResourceIds(new Integer[]{resourceId});
                criteria.setStrict(true);
                PageList<DriftDefinition> results = this.driftManager.findDriftDefinitionsByCriteria(subject, criteria);
                DriftDefinition doomedDriftDef = null;
                if (results != null && results.size() == 1) {
                    doomedDriftDef = (DriftDefinition)results.get(0);
                }
                if (doomedDriftDef != null) {
                    boolean unscheduledOnAgent = false;
                    try {
                        AgentClient agentClient = this.agentManager.getAgentClient(this.subjectManager.getOverlord(), resourceId);
                        DriftAgentService service = agentClient.getDriftAgentService();
                        service.unscheduleDriftDetection(resourceId, doomedDriftDef);
                        unscheduledOnAgent = true;
                    }
                    catch (Exception e) {
                        this.log.warn((Object)(" Unable to inform agent of unscheduled drift detection  [" + doomedDriftDef + "]"), (Throwable)e);
                    }
                    try {
                        this.driftManager.purgeByDriftDefinitionName(subject, resourceId, doomedDriftDef.getName());
                    }
                    catch (Exception e) {
                        String warnMessage = "Failed to purge data for drift definition [" + driftDefName + "] for resource [" + resourceId + "].";
                        if (unscheduledOnAgent) {
                            warnMessage = warnMessage + " The agent was told to stop detecting drift for that definition.";
                        }
                        this.log.warn((Object)warnMessage, (Throwable)e);
                    }
                    this.driftManager.deleteResourceDriftDefinition(subject, resourceId, doomedDriftDef.getId());
                    break;
                }
                throw new IllegalArgumentException("Resource does not have drift definition named [" + driftDefName + "]");
            }
            default: {
                throw new IllegalArgumentException("Entity Context Type not supported [" + entityContext + "]");
            }
        }
    }

    @Override
    public void deleteResourceDriftDefinition(Subject subject, int resourceId, int driftDefId) {
        this.authorizeOrFail(subject, resourceId, "Can not delete drifts");
        DriftDefinition doomed = (DriftDefinition)this.entityManager.getReference(DriftDefinition.class, (Object)driftDefId);
        doomed.getResource().setAgentSynchronizationNeeded();
        this.entityManager.remove((Object)doomed);
    }

    @Override
    @TransactionAttribute(value=TransactionAttributeType.NOT_SUPPORTED)
    public PageList<? extends DriftChangeSet<?>> findDriftChangeSetsByCriteria(Subject subject, DriftChangeSetCriteria criteria) {
        DriftServerPluginFacet driftServerPlugin = this.getServerPlugin();
        return driftServerPlugin.findDriftChangeSetsByCriteria(subject, criteria);
    }

    @Override
    @TransactionAttribute(value=TransactionAttributeType.NOT_SUPPORTED)
    public PageList<DriftComposite> findDriftCompositesByCriteria(Subject subject, DriftCriteria criteria) {
        DriftServerPluginFacet driftServerPlugin = this.getServerPlugin();
        return driftServerPlugin.findDriftCompositesByCriteria(subject, criteria);
    }

    @Override
    public PageList<DriftDefinition> findDriftDefinitionsByCriteria(Subject subject, DriftDefinitionCriteria criteria) {
        CriteriaQueryGenerator generator = new CriteriaQueryGenerator(subject, (Criteria)criteria);
        CriteriaQueryRunner queryRunner = new CriteriaQueryRunner((Criteria)criteria, generator, this.entityManager);
        PageList result = queryRunner.execute();
        return result;
    }

    @Override
    public PageList<DriftDefinitionComposite> findDriftDefinitionCompositesByCriteria(Subject subject, DriftDefinitionCriteria criteria) {
        PageList<DriftDefinition> defs = this.findDriftDefinitionsByCriteria(subject, criteria);
        PageList result = new PageList(defs.getPageControl());
        ArrayList<DriftDefinitionComposite> composites = new ArrayList<DriftDefinitionComposite>(defs.size());
        GenericDriftChangeSetCriteria csCriteria = new GenericDriftChangeSetCriteria();
        for (DriftDefinition def : defs) {
            DriftDefinitionComposite composite = new DriftDefinitionComposite(def, null);
            csCriteria.addFilterDriftDefinitionId(Integer.valueOf(def.getId()));
            csCriteria.addSortVersion(PageOrdering.DESC);
            csCriteria.setPageControl(PageControl.getSingleRowInstance());
            PageList<? extends DriftChangeSet<?>> changeSets = this.findDriftChangeSetsByCriteria(subject, (DriftChangeSetCriteria)csCriteria);
            if (!changeSets.isEmpty()) {
                composite.setMostRecentChangeset((DriftChangeSet)changeSets.get(0));
            }
            composites.add(composite);
        }
        result.addAll(composites);
        return result;
    }

    @Override
    @TransactionAttribute(value=TransactionAttributeType.NOT_SUPPORTED)
    public PageList<? extends Drift<?, ?>> findDriftsByCriteria(Subject subject, DriftCriteria criteria) {
        DriftServerPluginFacet driftServerPlugin = this.getServerPlugin();
        return driftServerPlugin.findDriftsByCriteria(subject, criteria);
    }

    @Override
    public DriftDefinition getDriftDefinition(Subject subject, int driftDefId) {
        DriftDefinition result = (DriftDefinition)this.entityManager.find(DriftDefinition.class, (Object)driftDefId);
        if (null == result) {
            throw new IllegalArgumentException("Drift Definition Id [" + driftDefId + "] not found.");
        }
        result.getConfiguration().getProperties();
        Hibernate.initialize((Object)result.getResource());
        Hibernate.initialize((Object)result.getTemplate());
        return result;
    }

    @Override
    @TransactionAttribute(value=TransactionAttributeType.NOT_SUPPORTED)
    public DriftFile getDriftFile(Subject subject, String hashId) throws Exception {
        DriftServerPluginFacet driftServerPlugin = this.getServerPlugin();
        return driftServerPlugin.getDriftFile(subject, hashId);
    }

    @Override
    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    public DriftChangeSetSummary saveChangeSet(Subject subject, int resourceId, File changeSetZip) throws Exception {
        this.authorizeOrFail(subject, resourceId, "Can not update/create drifts");
        DriftServerPluginFacet driftServerPlugin = this.getServerPlugin();
        DriftChangeSetSummary summary = driftServerPlugin.saveChangeSet(subject, resourceId, changeSetZip);
        if (DriftConfigurationDefinition.DriftHandlingMode.plannedChanges != summary.getDriftHandlingMode()) {
            this.notifyAlertConditionCacheManager("saveChangeSet", summary);
        }
        DriftDefinitionCriteria criteria = new DriftDefinitionCriteria();
        criteria.setStrict(true);
        criteria.addFilterName(summary.getDriftDefinitionName());
        criteria.addFilterResourceIds(new Integer[]{resourceId});
        PageList<DriftDefinition> definitions = this.findDriftDefinitionsByCriteria(subject, criteria);
        if (definitions.isEmpty()) {
            this.log.warn((Object)("Could not find drift definition for [resourceId: " + resourceId + ", driftDefinitionName: " + summary.getDriftDefinitionName() + "]. Will not be able check compliance for thiis drift definition"));
        } else {
            this.updateCompliance(subject, (DriftDefinition)definitions.get(0), summary);
        }
        return summary;
    }

    private void updateCompliance(Subject subject, DriftDefinition definition, DriftChangeSetSummary changeSetSummary) {
        this.authorizeOrFail(subject, definition.getResource().getId(), "Can not update drifts");
        boolean updateNeeded = false;
        if (changeSetSummary.isInitialChangeSet()) {
            updateNeeded = definition.getComplianceStatus() != DriftComplianceStatus.IN_COMPLIANCE;
            definition.setComplianceStatus(DriftComplianceStatus.IN_COMPLIANCE);
        }
        if (definition.isPinned()) {
            if (changeSetSummary.getDriftPathnames().isEmpty()) {
                updateNeeded = definition.getComplianceStatus() != DriftComplianceStatus.IN_COMPLIANCE;
                definition.setComplianceStatus(DriftComplianceStatus.IN_COMPLIANCE);
            } else {
                updateNeeded = definition.getComplianceStatus() == DriftComplianceStatus.IN_COMPLIANCE;
                definition.setComplianceStatus(DriftComplianceStatus.OUT_OF_COMPLIANCE_DRIFT);
            }
        }
        if (updateNeeded) {
            this.updateDriftDefinition(subject, definition);
        }
    }

    @Override
    @TransactionAttribute(value=TransactionAttributeType.NOT_SUPPORTED)
    public void saveChangeSetFiles(Subject subject, File changeSetFilesZip) throws Exception {
        DriftServerPluginFacet driftServerPlugin = this.getServerPlugin();
        driftServerPlugin.saveChangeSetFiles(subject, changeSetFilesZip);
    }

    @Override
    @TransactionAttribute(value=TransactionAttributeType.NOT_SUPPORTED)
    public void purgeByDriftDefinitionName(Subject subject, int resourceId, String driftDefName) throws Exception {
        this.authorizeOrFail(subject, resourceId, "Can not delete drifts");
        DriftServerPluginFacet driftServerPlugin = this.getServerPlugin();
        driftServerPlugin.purgeByDriftDefinitionName(subject, resourceId, driftDefName);
    }

    @Override
    @TransactionAttribute(value=TransactionAttributeType.NOT_SUPPORTED)
    public int purgeOrphanedDriftFiles(Subject subject, long purgeMillis) {
        DriftServerPluginFacet driftServerPlugin = this.getServerPlugin();
        return driftServerPlugin.purgeOrphanedDriftFiles(subject, purgeMillis);
    }

    @Override
    @TransactionAttribute(value=TransactionAttributeType.NOT_SUPPORTED)
    public void pinSnapshot(Subject subject, int driftDefId, int snapshotVersion) {
        DriftDefinition driftDef = this.driftManager.getDriftDefinition(subject, driftDefId);
        this.authorizeOrFail(subject, driftDef.getResource().getId(), "Can not update drifts");
        if (driftDef.getTemplate() != null && driftDef.getTemplate().isPinned()) {
            throw new IllegalArgumentException("Cannot repin a definition that has been created from a pinned template.");
        }
        driftDef.setPinned(true);
        this.driftManager.updateDriftDefinition(subject, driftDef);
        driftDef.getResource().setAgentSynchronizationNeeded();
        DriftSnapshotRequest snapshotRequest = new DriftSnapshotRequest(driftDefId, Integer.valueOf(snapshotVersion));
        DriftSnapshot snapshot = this.getSnapshot(subject, snapshotRequest);
        DriftChangeSetDTO changeSet = new DriftChangeSetDTO();
        changeSet.setCategory(DriftChangeSetCategory.COVERAGE);
        changeSet.setVersion(0);
        changeSet.setDriftDefinitionId(driftDefId);
        changeSet.setDriftHandlingMode(DriftConfigurationDefinition.DriftHandlingMode.normal);
        changeSet.setResourceId(driftDef.getResource().getId());
        DriftServerPluginFacet driftServerPlugin = this.getServerPlugin();
        try {
            driftServerPlugin.purgeByDriftDefinitionName(subject, driftDef.getResource().getId(), driftDef.getName());
            this.persistSnapshot(subject, snapshot, (DriftChangeSet<? extends Drift<?, ?>>)changeSet);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to pin snapshot", e);
        }
        try {
            AgentClient agent = this.agentManager.getAgentClient(this.subjectManager.getOverlord(), driftDef.getResource().getId());
            DriftAgentService driftService = agent.getDriftAgentService();
            driftService.pinSnapshot(driftDef.getResource().getId(), driftDef.getName(), snapshot);
        }
        catch (Exception e) {
            this.log.warn((Object)("Unable to notify agent that DriftDefinition[driftDefinitionId: " + driftDefId + ", driftDefinitionName: " + driftDef.getName() + "] has been pinned. The agent may be down."), (Throwable)e);
        }
    }

    @Override
    @TransactionAttribute(value=TransactionAttributeType.NOT_SUPPORTED)
    public String persistSnapshot(Subject subject, DriftSnapshot snapshot, DriftChangeSet<? extends Drift<?, ?>> changeSet) {
        this.authorizeOrFail(subject, changeSet.getResourceId(), "Can not update/create drifts");
        DriftChangeSetDTO changeSetDTO = new DriftChangeSetDTO();
        changeSetDTO.setCategory(changeSet.getCategory());
        changeSetDTO.setDriftHandlingMode(changeSet.getDriftHandlingMode());
        changeSetDTO.setVersion(changeSet.getVersion());
        changeSetDTO.setDriftDefinitionId(changeSet.getDriftDefinitionId());
        changeSetDTO.setResourceId(changeSet.getResourceId());
        HashSet<DriftDTO> drifts = new HashSet<DriftDTO>();
        for (Drift drift : snapshot.getDriftInstances()) {
            DriftDTO driftDTO = new DriftDTO();
            driftDTO.setCategory(DriftCategory.FILE_ADDED);
            driftDTO.setChangeSet(changeSetDTO);
            driftDTO.setCtime(drift.getCtime());
            driftDTO.setNewDriftFile(this.toDTO(drift.getNewDriftFile()));
            driftDTO.setPath(drift.getPath());
            driftDTO.setDirectory(drift.getDirectory());
            drifts.add(driftDTO);
        }
        changeSetDTO.setDrifts(drifts);
        DriftServerPluginFacet driftServerPlugin = this.getServerPlugin();
        try {
            return driftServerPlugin.persistChangeSet(subject, (DriftChangeSet<?>)changeSetDTO);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to pin snapshot", e);
        }
    }

    private DriftFileDTO toDTO(DriftFile file) {
        DriftFileDTO dto = new DriftFileDTO();
        dto.setHashId(file.getHashId());
        dto.setStatus(file.getStatus());
        dto.setDataSize(file.getDataSize());
        return dto;
    }

    @Override
    @TransactionAttribute(value=TransactionAttributeType.NOT_SUPPORTED)
    public String getDriftFileBits(Subject subject, String hash) {
        this.log.debug((Object)("Retrieving drift file content for " + hash));
        DriftServerPluginFacet driftServerPlugin = this.getServerPlugin();
        return driftServerPlugin.getDriftFileBits(subject, hash);
    }

    @Override
    public byte[] getDriftFileAsByteArray(Subject subject, String hash) {
        this.log.debug((Object)("Retrieving drift file content for " + hash));
        DriftServerPluginFacet driftServerPlugin = this.getServerPlugin();
        return driftServerPlugin.getDriftFileAsByteArray(subject, hash);
    }

    @Override
    public FileDiffReport generateUnifiedDiff(Subject subject, Drift<?, ?> drift) {
        this.log.debug((Object)("Generating diff for " + drift));
        String oldContent = this.getDriftFileBits(subject, drift.getOldDriftFile().getHashId());
        List<String> oldList = Arrays.asList(oldContent.split("\\n"));
        String newContent = this.getDriftFileBits(subject, drift.getNewDriftFile().getHashId());
        List<String> newList = Arrays.asList(newContent.split("\\n"));
        Patch patch = DiffUtils.diff(oldList, newList);
        List deltas = DiffUtils.generateUnifiedDiff((String)drift.getPath(), (String)drift.getPath(), oldList, (Patch)patch, (int)10);
        return new FileDiffReport(patch.getDeltas().size(), deltas);
    }

    @Override
    public FileDiffReport generateUnifiedDiffByIds(Subject subject, String driftId1, String driftId2) {
        DriftServerPluginFacet driftServerPlugin = this.getServerPlugin();
        GenericDriftCriteria criteria = new GenericDriftCriteria();
        criteria.addFilterId(driftId1);
        PageList<Drift<?, ?>> result = driftServerPlugin.findDriftsByCriteria(subject, (DriftCriteria)criteria);
        if (result.size() != 1) {
            throw new IllegalArgumentException("Drift record not found: " + driftId1);
        }
        Drift drift1 = (Drift)result.get(0);
        criteria.addFilterId(driftId2);
        result = driftServerPlugin.findDriftsByCriteria(subject, (DriftCriteria)criteria);
        if (result.size() != 1) {
            throw new IllegalArgumentException("Drift record not found: " + driftId2);
        }
        Drift drift2 = (Drift)result.get(0);
        return this.generateUnifiedDiff(subject, drift1, drift2);
    }

    @Override
    public FileDiffReport generateUnifiedDiff(Subject subject, Drift<?, ?> drift1, Drift<?, ?> drift2) {
        DriftFile drift1File = drift1.getNewDriftFile();
        String content1 = null == drift1File ? "" : this.getDriftFileBits(subject, drift1File.getHashId());
        List<String> content1List = Arrays.asList(content1.split("\\n"));
        DriftFile drift2File = drift2.getNewDriftFile();
        String content2 = null == drift2File ? "" : this.getDriftFileBits(subject, drift2File.getHashId());
        List<String> content2List = Arrays.asList(content2.split("\\n"));
        Patch patch = DiffUtils.diff(content1List, content2List);
        List deltas = DiffUtils.generateUnifiedDiff((String)drift1.getPath(), (String)drift2.getPath(), content1List, (Patch)patch, (int)10);
        return new FileDiffReport(patch.getDeltas().size(), deltas);
    }

    @Override
    public void updateDriftDefinition(Subject subject, DriftDefinition driftDefinition) {
        this.authorizeOrFail(subject, driftDefinition.getResource().getId(), "Can not update drifts");
        this.entityManager.merge((Object)driftDefinition);
    }

    @Override
    public void updateDriftDefinition(Subject subject, EntityContext entityContext, DriftDefinition driftDef) {
        this.authorizeOrFail(subject, entityContext.getResourceId(), "Can not update drifts");
        DriftManagerBean.validateDriftDefinition(driftDef);
        switch (entityContext.getType()) {
            case Resource: {
                int resourceId = entityContext.getResourceId();
                org.rhq.core.domain.resource.Resource resource = (org.rhq.core.domain.resource.Resource)this.entityManager.find(org.rhq.core.domain.resource.Resource.class, (Object)resourceId);
                if (null == resource) {
                    throw new IllegalArgumentException("Entity not found [" + entityContext + "]");
                }
                if (!this.isDriftMgmtSupported(resource)) {
                    throw new IllegalArgumentException("Cannot create drift definition. The resource type " + resource.getResourceType() + " does not support drift management");
                }
                DriftDefinitionComparator comparator = new DriftDefinitionComparator(DriftDefinitionComparator.CompareMode.ONLY_DIRECTORY_SPECIFICATIONS);
                boolean isUpdated = false;
                for (DriftDefinition dc : resource.getDriftDefinitions()) {
                    if (!dc.getName().equals(driftDef.getName())) continue;
                    if (comparator.compare(driftDef, dc) == 0) {
                        if (dc.isPinned() && !driftDef.isPinned()) {
                            dc.setComplianceStatus(DriftComplianceStatus.IN_COMPLIANCE);
                        }
                        dc.setConfiguration(driftDef.getConfiguration().deepCopyWithoutProxies());
                        isUpdated = true;
                        break;
                    }
                    throw new IllegalArgumentException("A new definition must have a unique name. An existing definition cannot update it's base directory or includes/excludes filters.");
                }
                if (!isUpdated) {
                    this.validateTemplateForNewDef(driftDef, resource);
                    resource.addDriftDefinition(driftDef);
                    this.entityManager.persist((Object)driftDef);
                    DriftDefinitionTemplate template = driftDef.getTemplate();
                    if (template != null && template.isPinned()) {
                        DriftServerPluginFacet driftServerPlugin = this.getServerPlugin();
                        driftServerPlugin.copyChangeSet(subject, template.getChangeSetId(), driftDef.getId(), resourceId);
                    }
                }
                resource.setAgentSynchronizationNeeded();
                AgentClient agentClient = this.agentManager.getAgentClient(this.subjectManager.getOverlord(), resourceId);
                DriftAgentService service = agentClient.getDriftAgentService();
                try {
                    DriftSnapshot snapshot = null;
                    if (driftDef.getTemplate() != null && driftDef.getTemplate().isPinned()) {
                        snapshot = this.getSnapshot(subject, new DriftSnapshotRequest(driftDef.getId()));
                    }
                    this.entityManager.flush();
                    this.entityManager.clear();
                    if (snapshot != null) {
                        service.updateDriftDetection(resourceId, driftDef, snapshot);
                        break;
                    }
                    service.updateDriftDetection(resourceId, driftDef);
                }
                catch (Exception e) {
                    this.log.warn((Object)(" Unable to inform agent of unscheduled drift detection  [" + driftDef + "]"), (Throwable)e);
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("Entity Context Type not supported [" + entityContext + "]");
            }
        }
    }

    public static void validateDriftDefinition(DriftDefinition driftDef) {
        if (!driftDef.getName().matches("[ \\.\\-\\w]+")) {
            throw new IllegalArgumentException("Drift definition name contains invalid characters: " + driftDef.getName());
        }
        DriftDefinition.BaseDirectory baseDir = driftDef.getBasedir();
        if (null == baseDir || !baseDir.getValueName().matches("[ \\.\\-\\(\\)\\w/\\:\\\\]+")) {
            throw new IllegalArgumentException("Drift definition base directory is null or contains invalid characters: " + baseDir);
        }
        ArrayList<List> filtersList = new ArrayList<List>(2);
        filtersList.add(driftDef.getIncludes());
        filtersList.add(driftDef.getExcludes());
        for (List filterList : filtersList) {
            for (Filter filter : filterList) {
                String path;
                String string = path = null == filter.getPath() ? null : filter.getPath().trim();
                if (null != path && !path.isEmpty() && !path.matches("[ \\.\\-\\(\\)\\w/\\\\]+")) {
                    throw new IllegalArgumentException("Drift definition filter path contains invalid characters: " + path);
                }
                String pattern = null == filter.getPattern() ? null : filter.getPattern().trim();
                if (null == pattern || pattern.isEmpty() || pattern.matches("[ \\.\\-\\(\\)\\w/\\\\\\?\\*]+")) continue;
                throw new IllegalArgumentException("Drift definition filter pattern contains invalid characters: " + pattern);
            }
        }
    }

    private boolean isDriftMgmtSupported(org.rhq.core.domain.resource.Resource resource) {
        ResourceType type = resource.getResourceType();
        return type.getDriftDefinitionTemplates() != null && !type.getDriftDefinitionTemplates().isEmpty();
    }

    private void validateTemplateForNewDef(DriftDefinition driftDef, org.rhq.core.domain.resource.Resource resource) {
        if (driftDef.getTemplate() == null) {
            return;
        }
        DriftDefinitionTemplate template = (DriftDefinitionTemplate)this.entityManager.find(DriftDefinitionTemplate.class, (Object)driftDef.getTemplate().getId());
        if (template == null) {
            throw new IllegalArgumentException("Cannot create drift definition with template " + DriftDefinitionTemplate.class.getSimpleName() + "[" + driftDef.getTemplate().getName() + "] that has not been saved");
        }
        if (!template.getResourceType().equals((Object)resource.getResourceType())) {
            throw new IllegalArgumentException("Cannot create drift definition with template " + DriftDefinitionTemplate.class.getSimpleName() + "[" + driftDef.getTemplate().getName() + "] that is from a different resource type, " + template.getResourceType());
        }
    }

    @Override
    public boolean isBinaryFile(Subject subject, Drift<?, ?> drift) {
        return DriftUtil.isBinaryFile(drift);
    }

    @Override
    @TransactionAttribute(value=TransactionAttributeType.NOT_SUPPORTED)
    public DriftDetails getDriftDetails(Subject subject, String driftId) {
        this.log.debug((Object)("Loading drift details for drift id: " + driftId));
        GenericDriftCriteria criteria = new GenericDriftCriteria();
        criteria.addFilterId(driftId);
        criteria.fetchChangeSet(true);
        DriftDetails driftDetails = new DriftDetails();
        DriftServerPluginFacet driftServerPlugin = this.getServerPlugin();
        DriftFile newFile = null;
        DriftFile oldFile = null;
        PageList<? extends Drift<?, ?>> results = driftServerPlugin.findDriftsByCriteria(subject, (DriftCriteria)criteria);
        if (results.size() == 0) {
            this.log.warn((Object)("Unable to get the drift details for drift id " + driftId + ". No drift object found with that id."));
            return null;
        }
        Drift drift = (Drift)results.get(0);
        driftDetails.setDrift(drift);
        try {
            switch (drift.getCategory()) {
                case FILE_ADDED: {
                    newFile = driftServerPlugin.getDriftFile(subject, drift.getNewDriftFile().getHashId());
                    driftDetails.setNewFileStatus(newFile.getStatus());
                    break;
                }
                case FILE_CHANGED: {
                    newFile = driftServerPlugin.getDriftFile(subject, drift.getNewDriftFile().getHashId());
                    oldFile = driftServerPlugin.getDriftFile(subject, drift.getOldDriftFile().getHashId());
                    driftDetails.setNewFileStatus(newFile.getStatus());
                    driftDetails.setOldFileStatus(oldFile.getStatus());
                    driftDetails.setPreviousChangeSet(this.loadPreviousChangeSet(subject, drift));
                    break;
                }
                case FILE_REMOVED: {
                    oldFile = driftServerPlugin.getDriftFile(subject, drift.getOldDriftFile().getHashId());
                    driftDetails.setOldFileStatus(oldFile.getStatus());
                }
            }
        }
        catch (Exception e) {
            this.log.error((Object)("An error occurred while loading the drift details for drift id " + driftId + ": " + e.getMessage()));
            throw new RuntimeException("An error occurred while loading th drift details for drift id " + driftId, e);
        }
        driftDetails.setBinaryFile(this.isBinaryFile(subject, drift));
        return driftDetails;
    }

    private void notifyAlertConditionCacheManager(String callingMethod, DriftChangeSetSummary summary) {
        AlertConditionCacheStats stats = this.alertConditionCacheManager.checkConditions(summary);
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)(callingMethod + ": " + stats.toString()));
        }
    }

    private DriftChangeSet<?> loadPreviousChangeSet(Subject subject, Drift<?, ?> drift) {
        GenericDriftChangeSetCriteria criteria = new GenericDriftChangeSetCriteria();
        criteria.addFilterResourceId(Integer.valueOf(drift.getChangeSet().getResourceId()));
        criteria.addFilterDriftDefinitionId(Integer.valueOf(drift.getChangeSet().getDriftDefinitionId()));
        criteria.addFilterVersion(Integer.toString(drift.getChangeSet().getVersion() - 1));
        PageList<? extends DriftChangeSet<?>> results = this.findDriftChangeSetsByCriteria(subject, (DriftChangeSetCriteria)criteria);
        return (DriftChangeSet)results.get(0);
    }

    private DriftServerPluginFacet getServerPlugin() {
        MasterServerPluginContainer masterPC = LookupUtil.getServerPluginService().getMasterPluginContainer();
        if (masterPC == null) {
            this.log.warn((Object)(MasterServerPluginContainer.class.getSimpleName() + " is not started yet"));
            return null;
        }
        DriftServerPluginContainer pc = masterPC.getPluginContainerByClass(DriftServerPluginContainer.class);
        if (pc == null) {
            this.log.warn((Object)(DriftServerPluginContainer.class + " has not been loaded by the " + masterPC.getClass() + " yet"));
            return null;
        }
        DriftServerPluginManager pluginMgr = (DriftServerPluginManager)pc.getPluginManager();
        return pluginMgr.getDriftServerPluginComponent();
    }

    private void authorizeOrFail(Subject subject, int resourceId, String message) {
        if (!this.authorizationManager.hasResourcePermission(subject, Permission.MANAGE_DRIFT, resourceId)) {
            throw new PermissionException(message + " - " + subject + " lacks " + Permission.MANAGE_DRIFT + " for resource[id=" + resourceId + "]");
        }
    }

    private void authorizeOrFail(Subject subject, EntityContext context, String message) {
        this.authorizeOrFail(subject, context.getResourceId(), message);
    }
}

