/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.measurement;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Resource;
import javax.ejb.EJB;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import javax.interceptor.Interceptors;
import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.SimpleTrigger;
import org.quartz.Trigger;
import org.rhq.core.db.DatabaseType;
import org.rhq.core.db.DatabaseTypeFactory;
import org.rhq.core.db.H2DatabaseType;
import org.rhq.core.db.OracleDatabaseType;
import org.rhq.core.db.PostgresqlDatabaseType;
import org.rhq.core.db.SQLServerDatabaseType;
import org.rhq.core.domain.auth.Subject;
import org.rhq.core.domain.authz.Permission;
import org.rhq.core.domain.common.EntityContext;
import org.rhq.core.domain.criteria.Criteria;
import org.rhq.core.domain.criteria.MeasurementDefinitionCriteria;
import org.rhq.core.domain.criteria.MeasurementScheduleCriteria;
import org.rhq.core.domain.criteria.ResourceCriteria;
import org.rhq.core.domain.measurement.DataType;
import org.rhq.core.domain.measurement.DisplayType;
import org.rhq.core.domain.measurement.MeasurementDefinition;
import org.rhq.core.domain.measurement.MeasurementSchedule;
import org.rhq.core.domain.measurement.MeasurementScheduleRequest;
import org.rhq.core.domain.measurement.NumericType;
import org.rhq.core.domain.measurement.ResourceMeasurementScheduleRequest;
import org.rhq.core.domain.measurement.composite.MeasurementScheduleComposite;
import org.rhq.core.domain.resource.Agent;
import org.rhq.core.domain.resource.InventoryStatus;
import org.rhq.core.domain.resource.ResourceType;
import org.rhq.core.domain.server.PersistenceUtility;
import org.rhq.core.domain.util.OrderingField;
import org.rhq.core.domain.util.PageControl;
import org.rhq.core.domain.util.PageList;
import org.rhq.core.domain.util.PageOrdering;
import org.rhq.core.util.collection.ArrayUtils;
import org.rhq.core.util.jdbc.JDBCUtil;
import org.rhq.enterprise.server.agentclient.AgentClient;
import org.rhq.enterprise.server.auth.SubjectManagerLocal;
import org.rhq.enterprise.server.authz.AuthorizationManagerLocal;
import org.rhq.enterprise.server.authz.PermissionException;
import org.rhq.enterprise.server.authz.RequiredPermission;
import org.rhq.enterprise.server.authz.RequiredPermissions;
import org.rhq.enterprise.server.common.PerformanceMonitorInterceptor;
import org.rhq.enterprise.server.core.AgentManagerLocal;
import org.rhq.enterprise.server.measurement.MeasurementException;
import org.rhq.enterprise.server.measurement.MeasurementNotFoundException;
import org.rhq.enterprise.server.measurement.MeasurementScheduleManagerLocal;
import org.rhq.enterprise.server.measurement.MeasurementScheduleManagerRemote;
import org.rhq.enterprise.server.measurement.NotifyAgentsOfScheduleUpdatesJob;
import org.rhq.enterprise.server.resource.ResourceManagerLocal;
import org.rhq.enterprise.server.resource.group.ResourceGroupManagerLocal;
import org.rhq.enterprise.server.scheduler.SchedulerLocal;
import org.rhq.enterprise.server.util.CriteriaQueryGenerator;
import org.rhq.enterprise.server.util.CriteriaQueryRunner;
import org.rhq.enterprise.server.util.LookupUtil;

@Stateless
@Resource(name="RHQ_DS", mappedName="java:jboss/datasources/RHQDS")
@Interceptors(value={PerformanceMonitorInterceptor.class})
public class MeasurementScheduleManagerBean
implements MeasurementScheduleManagerLocal,
MeasurementScheduleManagerRemote {
    @PersistenceContext(unitName="rhqpu")
    private EntityManager entityManager;
    @Resource(name="RHQ_DS", mappedName="java:jboss/datasources/RHQDS")
    private DataSource dataSource;
    @EJB
    private AgentManagerLocal agentManager;
    @EJB
    private AuthorizationManagerLocal authorizationManager;
    @EJB
    private ResourceManagerLocal resourceManager;
    @EJB
    private ResourceGroupManagerLocal resourceGroupManager;
    @EJB
    private MeasurementScheduleManagerLocal measurementScheduleManager;
    @EJB
    private SubjectManagerLocal subjectManager;
    private final Log log = LogFactory.getLog(MeasurementScheduleManagerBean.class);
    public static final String TRIGGER_NAME = "TriggerName";
    public static final String TRIGGER_GROUP_NAME = "TriggerGroupName";
    public static final String SCHEDULE_SUBQUERY = "ScheduleSubQuery";
    public static final String ENTITYCONTEXT_RESOURCEID = "EntityContext.resourceId";
    public static final String ENTITYCONTEXT_GROUPID = "EntityContext.groupId";
    public static final String ENTITYCONTEXT_PARENT_RESOURCEID = "EntityContext.parentResourceId";
    public static final String ENTITYCONTEXT_RESOURCETYPEID = "EntityContext.resourceTypeId";

    @Override
    public Set<ResourceMeasurementScheduleRequest> findSchedulesForResourceAndItsDescendants(int[] resourceIds, boolean getDescendents) {
        HashSet<ResourceMeasurementScheduleRequest> allSchedules = new HashSet<ResourceMeasurementScheduleRequest>();
        this.getSchedulesForResourceAndItsDescendants(resourceIds, allSchedules, getDescendents);
        return allSchedules;
    }

    @Override
    public AgentClient getAgentClientForSchedule(MeasurementSchedule sched) {
        org.rhq.core.domain.resource.Resource pRes = sched.getResource();
        Agent agent = pRes.getAgent();
        AgentClient ac = this.agentManager.getAgentClient(agent);
        return ac;
    }

    public MeasurementSchedule getScheduleById(int scheduleId) {
        MeasurementSchedule ms;
        try {
            ms = (MeasurementSchedule)this.entityManager.find(MeasurementSchedule.class, (Object)scheduleId);
        }
        catch (NoResultException n) {
            ms = null;
        }
        return ms;
    }

    @Override
    public List<MeasurementSchedule> findSchedulesByIds(int[] scheduleIds) {
        if (scheduleIds == null || scheduleIds.length == 0) {
            return new ArrayList<MeasurementSchedule>();
        }
        Query q = this.entityManager.createNamedQuery("MeasurementSchedule.findByIds");
        q.setParameter("ids", (Object)ArrayUtils.wrapInList((int[])scheduleIds));
        List ret = q.getResultList();
        return ret;
    }

    @Override
    public MeasurementSchedule getScheduleById(Subject subject, int scheduleId) {
        MeasurementSchedule schedule = (MeasurementSchedule)this.entityManager.find(MeasurementSchedule.class, (Object)scheduleId);
        if (schedule == null) {
            return null;
        }
        if (!this.authorizationManager.canViewResource(subject, schedule.getResource().getId())) {
            throw new PermissionException("User[" + subject.getName() + "] does not have permission to view measurementSchedule[id=" + scheduleId + "]");
        }
        schedule.getDefinition().getId();
        return schedule;
    }

    private void verifyMinimumCollectionInterval(MeasurementSchedule schedule) {
        schedule.setInterval(this.verifyMinimumCollectionInterval(schedule.getInterval()));
    }

    private long verifyMinimumCollectionInterval(long collectionInterval) {
        long validCollectionInterval = collectionInterval;
        if (collectionInterval < 30000L) {
            validCollectionInterval = 30000L;
        }
        return validCollectionInterval;
    }

    @Override
    public List<MeasurementSchedule> findSchedulesByResourceIdsAndDefinitionId(Subject subject, int[] resourceIds, int definitionId) {
        return this.findSchedulesByResourcesAndDefinitions(subject, resourceIds, new int[]{definitionId});
    }

    @Override
    public List<MeasurementSchedule> findSchedulesByResourceIdsAndDefinitionIds(int[] resourceIds, int[] definitionIds) {
        Query query = this.entityManager.createNamedQuery("MeasurementSchedule.findByResourceIdsAndDefinitionIds");
        query.setParameter("definitionIds", (Object)ArrayUtils.wrapInList((int[])definitionIds));
        query.setParameter("resourceIds", (Object)ArrayUtils.wrapInList((int[])resourceIds));
        List results = query.getResultList();
        return results;
    }

    private List<MeasurementSchedule> findSchedulesByResourcesAndDefinitions(Subject subject, int[] resourceIds, int[] definitionIds) {
        for (int resourceId : resourceIds) {
            if (this.authorizationManager.canViewResource(subject, resourceId)) continue;
            throw new PermissionException("User[" + subject.getName() + "] does not have permission to view metric schedules for resource[id=" + resourceId + "]");
        }
        return this.findSchedulesByResourceIdsAndDefinitionIds(resourceIds, definitionIds);
    }

    @Override
    public MeasurementSchedule getSchedule(Subject subject, int resourceId, int definitionId, boolean attachBaseline) throws MeasurementNotFoundException {
        try {
            List<MeasurementSchedule> results = this.findSchedulesByResourcesAndDefinitions(subject, new int[]{resourceId}, new int[]{definitionId});
            if (results.size() != 1) {
                throw new MeasurementException("Could not find measurementSchedule[resourceId=" + resourceId + ", definitionId=" + definitionId + "]");
            }
            MeasurementSchedule schedule = results.get(0);
            if (attachBaseline && schedule.getBaseline() != null) {
                schedule.getBaseline().getId();
            }
            return schedule;
        }
        catch (NoResultException nre) {
            throw new MeasurementNotFoundException(nre);
        }
    }

    @Override
    @Deprecated
    @RequiredPermission(value=Permission.MANAGE_SETTINGS)
    public void disableDefaultCollectionForMeasurementDefinitions(Subject subject, int[] measurementDefinitionIds, boolean updateSchedules) {
        this.modifyDefaultCollectionIntervalForMeasurementDefinitions(subject, measurementDefinitionIds, -1L, updateSchedules);
    }

    @Override
    @Deprecated
    @RequiredPermissions(value={@RequiredPermission(value=Permission.MANAGE_INVENTORY), @RequiredPermission(value=Permission.MANAGE_SETTINGS)})
    public void disableAllDefaultCollections(Subject subject) {
        this.entityManager.createNamedQuery("MeasurementDefinition.disableAll").executeUpdate();
    }

    @Override
    @Deprecated
    @RequiredPermissions(value={@RequiredPermission(value=Permission.MANAGE_INVENTORY), @RequiredPermission(value=Permission.MANAGE_SETTINGS)})
    public void disableAllSchedules(Subject subject) {
        this.entityManager.createNamedQuery("MeasurementSchedule.disableAll").executeUpdate();
    }

    @Override
    public void createSchedulesForExistingResources(ResourceType type, MeasurementDefinition newDefinition) {
        List resources = type.getResources();
        if (resources != null) {
            for (org.rhq.core.domain.resource.Resource res : resources) {
                res.setAgentSynchronizationNeeded();
                MeasurementSchedule sched = new MeasurementSchedule(newDefinition, res);
                sched.setInterval(newDefinition.getDefaultInterval());
                this.entityManager.persist((Object)sched);
            }
        }
    }

    @Override
    @RequiredPermission(value=Permission.MANAGE_SETTINGS)
    @Deprecated
    public void updateDefaultCollectionIntervalForMeasurementDefinitions(Subject subject, int[] measurementDefinitionIds, long collectionInterval, boolean updateExistingSchedules) {
        collectionInterval = this.verifyMinimumCollectionInterval(collectionInterval);
        this.modifyDefaultCollectionIntervalForMeasurementDefinitions(subject, measurementDefinitionIds, collectionInterval, updateExistingSchedules);
    }

    @Override
    @RequiredPermission(value=Permission.MANAGE_SETTINGS)
    public void updateDefaultCollectionIntervalAndEnablementForMeasurementDefinitions(Subject subject, int[] measurementDefinitionIds, long collectionInterval, boolean enable, boolean updateExistingSchedules) {
        this.modifyDefaultCollectionIntervalForMeasurementDefinitions(subject, measurementDefinitionIds, enable, collectionInterval, updateExistingSchedules);
    }

    private void modifyDefaultCollectionIntervalForMeasurementDefinitions(Subject subject, int[] measurementDefinitionIds, long collectionInterval, boolean updateExistingSchedules) {
        if (measurementDefinitionIds == null || measurementDefinitionIds.length == 0) {
            this.log.debug((Object)("update metric template: no definitions supplied (interval = " + collectionInterval));
            return;
        }
        boolean enable = collectionInterval >= 0L;
        for (int batchIndex = 0; batchIndex < measurementDefinitionIds.length; batchIndex += 1000) {
            int[] batchIdArray = ArrayUtils.copyOfRange((int[])measurementDefinitionIds, (int)batchIndex, (int)(batchIndex + 1000));
            this.modifyDefaultCollectionIntervalForMeasurementDefinitions(subject, batchIdArray, enable, collectionInterval, updateExistingSchedules);
        }
    }

    private void modifyDefaultCollectionIntervalForMeasurementDefinitions(Subject subject, int[] measurementDefinitionIds, boolean enable, long collectionInterval, boolean updateExistingSchedules) {
        Connection conn = null;
        PreparedStatement defUpdateStmt = null;
        PreparedStatement schedUpdateStmt = null;
        try {
            conn = this.dataSource.getConnection();
            String queryString = collectionInterval > 0L ? "UPDATE RHQ_MEASUREMENT_DEF   SET DEFAULT_ON = ?, DEFAULT_INTERVAL = ?   WHERE ID IN ( @@DEFINITION_IDS@@ )" : "UPDATE RHQ_MEASUREMENT_DEF   SET DEFAULT_ON = ?   WHERE ID IN ( @@DEFINITION_IDS@@ )";
            String transformedQuery = JDBCUtil.transformQueryForMultipleInParameters((String)queryString, (String)"@@DEFINITION_IDS@@", (int)measurementDefinitionIds.length);
            defUpdateStmt = conn.prepareStatement(transformedQuery);
            int i = 1;
            defUpdateStmt.setBoolean(i++, enable);
            if (collectionInterval > 0L) {
                defUpdateStmt.setLong(i++, collectionInterval);
            }
            JDBCUtil.bindNTimes((PreparedStatement)defUpdateStmt, (int[])measurementDefinitionIds, (int)i);
            defUpdateStmt.executeUpdate();
            if (updateExistingSchedules) {
                HashMap<Integer, ResourceMeasurementScheduleRequest> reqMap = new HashMap<Integer, ResourceMeasurementScheduleRequest>();
                List idsAsList = ArrayUtils.wrapInList((int[])measurementDefinitionIds);
                queryString = collectionInterval > 0L ? "UPDATE RHQ_MEASUREMENT_SCHED   SET ENABLED = ?, COLL_INTERVAL = ?   WHERE DEFINITION IN ( @@DEFINITION_IDS@@ )" : "UPDATE RHQ_MEASUREMENT_SCHED   SET ENABLED = ?   WHERE DEFINITION IN ( @@DEFINITION_IDS@@ )";
                transformedQuery = JDBCUtil.transformQueryForMultipleInParameters((String)queryString, (String)"@@DEFINITION_IDS@@", (int)measurementDefinitionIds.length);
                schedUpdateStmt = conn.prepareStatement(transformedQuery);
                i = 1;
                schedUpdateStmt.setBoolean(i++, enable);
                if (collectionInterval > 0L) {
                    schedUpdateStmt.setLong(i++, collectionInterval);
                }
                JDBCUtil.bindNTimes((PreparedStatement)schedUpdateStmt, (int[])measurementDefinitionIds, (int)i++);
                schedUpdateStmt.executeUpdate();
                queryString = "SELECT ms.id, ms.interval, ms.resource.id, ms.definition.name, ms.definition.dataType, ms.definition.rawNumericType FROM  MeasurementSchedule ms WHERE ms.definition.id IN ( :definitionIds )";
                Query query = this.entityManager.createQuery(queryString);
                query.setParameter("definitionIds", (Object)idsAsList);
                List rs = query.getResultList();
                for (Object[] row : rs) {
                    i = 0;
                    int n = (Integer)row[i++];
                    long existingInterval = (Long)row[i++];
                    int resourceId = (Integer)row[i++];
                    String name = (String)row[i++];
                    DataType dataType = (DataType)row[i++];
                    NumericType numericType = (NumericType)row[i++];
                    ResourceMeasurementScheduleRequest req = (ResourceMeasurementScheduleRequest)reqMap.get(resourceId);
                    if (null == req) {
                        req = new ResourceMeasurementScheduleRequest(resourceId);
                        reqMap.put(resourceId, req);
                    }
                    MeasurementScheduleRequest msr = new MeasurementScheduleRequest(n, name, collectionInterval > 0L ? collectionInterval : existingInterval, enable, dataType, numericType);
                    req.addMeasurementScheduleRequest(msr);
                }
                HashMap agentUpdates = null;
                agentUpdates = new HashMap();
                for (Integer n : reqMap.keySet()) {
                    Agent agent = this.agentManager.getAgentByResourceId(this.subjectManager.getOverlord(), n);
                    if (null == agent) {
                        if (!this.log.isDebugEnabled()) continue;
                        this.log.debug((Object)("Ignoring measurement schedule change for non-agent-related resource [" + n + "]. It is probably waiting to be uninventoried."));
                        continue;
                    }
                    HashSet agentUpdate = (HashSet)agentUpdates.get(agent);
                    if (agentUpdate == null) {
                        agentUpdate = new HashSet();
                        agentUpdates.put(agent, agentUpdate);
                    }
                    agentUpdate.add(reqMap.get(n));
                }
                for (Map.Entry entry : agentUpdates.entrySet()) {
                    boolean synced = this.sendUpdatedSchedulesToAgent((Agent)entry.getKey(), (Set)entry.getValue());
                    if (synced) continue;
                    int agentId = ((Agent)entry.getKey()).getId();
                    this.setAgentSynchronizationNeededByDefinitionsForAgent(agentId, idsAsList);
                }
            }
        }
        catch (Exception e) {
            try {
                String errorMessage = "Error updating measurement definitions";
                SQLException sqle = null;
                if (e instanceof SQLException) {
                    sqle = (SQLException)e;
                } else if (e.getCause() instanceof SQLException) {
                    sqle = (SQLException)e.getCause();
                }
                if (sqle != null) {
                    String s = JDBCUtil.convertSQLExceptionToString((SQLException)((SQLException)e));
                    errorMessage = errorMessage + ": " + s;
                }
                this.log.error((Object)errorMessage, (Throwable)e);
                throw new MeasurementException("Error updating measurement definitions: " + e);
            }
            catch (Throwable throwable) {
                JDBCUtil.safeClose(defUpdateStmt);
                JDBCUtil.safeClose(schedUpdateStmt);
                JDBCUtil.safeClose((Connection)conn);
                throw throwable;
            }
        }
        JDBCUtil.safeClose((Statement)defUpdateStmt);
        JDBCUtil.safeClose(schedUpdateStmt);
        JDBCUtil.safeClose((Connection)conn);
    }

    @Override
    public int updateSchedulesForContext(Subject subject, EntityContext context, int[] measurementDefinitionIds, long collectionInterval) {
        collectionInterval = this.verifyMinimumCollectionInterval(collectionInterval);
        String measurementScheduleSubQuery = this.getMeasurementScheduleSubQueryForContext(subject, context, measurementDefinitionIds);
        String updateQuery = "UPDATE MeasurementSchedule    SET interval = :interval,        enabled = true  WHERE id IN ( " + measurementScheduleSubQuery + " ) ";
        Query query = this.entityManager.createQuery(updateQuery);
        query.setParameter("interval", (Object)collectionInterval);
        int affectedRows = query.executeUpdate();
        this.scheduleJobToPushScheduleUpdatesToAgents(context, measurementScheduleSubQuery);
        return affectedRows;
    }

    @Override
    public int enableSchedulesForContext(Subject subject, EntityContext context, int[] measurementDefinitionIds) {
        String measurementScheduleSubQuery = this.getMeasurementScheduleSubQueryForContext(subject, context, measurementDefinitionIds);
        String updateQuery = "UPDATE MeasurementSchedule    SET enabled = true  WHERE id IN ( " + measurementScheduleSubQuery + " ) ";
        Query query = this.entityManager.createQuery(updateQuery);
        int affectedRows = query.executeUpdate();
        this.scheduleJobToPushScheduleUpdatesToAgents(context, measurementScheduleSubQuery);
        return affectedRows;
    }

    @Override
    public int disableSchedulesForContext(Subject subject, EntityContext context, int[] measurementDefinitionIds) {
        String measurementScheduleSubQuery = this.getMeasurementScheduleSubQueryForContext(subject, context, measurementDefinitionIds);
        String updateQuery = "UPDATE MeasurementSchedule    SET enabled = false  WHERE id IN ( " + measurementScheduleSubQuery + " ) ";
        Query query = this.entityManager.createQuery(updateQuery);
        int affectedRows = query.executeUpdate();
        this.scheduleJobToPushScheduleUpdatesToAgents(context, measurementScheduleSubQuery);
        return affectedRows;
    }

    private void scheduleJobToPushScheduleUpdatesToAgents(EntityContext entityContext, String scheduleSubQuery) {
        try {
            SchedulerLocal scheduler = LookupUtil.getSchedulerBean();
            String DEFAULT_AGENT_JOB = "AGENT NOTIFICATION JOB";
            String DEFAULT_AGENT_GROUP = "AGENT NOTIFICATION GROUP";
            String DEFAULT_AGENT_TRIGGER = "AGENT NOTIFICATION TRIGGER";
            String randomSuffix = UUID.randomUUID().toString();
            String jobName = "AGENT NOTIFICATION JOB - " + randomSuffix;
            JobDetail jobDetail = new JobDetail(jobName, "AGENT NOTIFICATION GROUP", NotifyAgentsOfScheduleUpdatesJob.class);
            String triggerName = "AGENT NOTIFICATION TRIGGER - " + randomSuffix;
            SimpleTrigger simpleTrigger = new SimpleTrigger(triggerName, "AGENT NOTIFICATION GROUP", new Date());
            JobDataMap jobDataMap = simpleTrigger.getJobDataMap();
            jobDataMap.put(TRIGGER_NAME, triggerName);
            jobDataMap.put(TRIGGER_GROUP_NAME, "AGENT NOTIFICATION GROUP");
            jobDataMap.put(SCHEDULE_SUBQUERY, scheduleSubQuery);
            jobDataMap.put(ENTITYCONTEXT_RESOURCEID, Integer.toString(entityContext.getResourceId()));
            jobDataMap.put(ENTITYCONTEXT_GROUPID, Integer.toString(entityContext.getGroupId()));
            jobDataMap.put(ENTITYCONTEXT_PARENT_RESOURCEID, Integer.toString(entityContext.getParentResourceId()));
            jobDataMap.put(ENTITYCONTEXT_RESOURCETYPEID, Integer.toString(entityContext.getResourceTypeId()));
            if (this.isJobScheduled(scheduler, "AGENT NOTIFICATION JOB", "AGENT NOTIFICATION GROUP")) {
                simpleTrigger.setJobName("AGENT NOTIFICATION JOB");
                simpleTrigger.setJobGroup("AGENT NOTIFICATION GROUP");
                scheduler.scheduleJob((Trigger)simpleTrigger);
            } else {
                scheduler.scheduleJob(jobDetail, (Trigger)simpleTrigger);
            }
        }
        catch (RuntimeException e) {
            this.log.error((Object)"Failed to schedule agents update notification.", (Throwable)e);
            this.notifyAgentsOfScheduleUpdates(entityContext, scheduleSubQuery);
        }
        catch (SchedulerException e) {
            this.log.error((Object)"Failed to schedule agents update notification.", (Throwable)e);
            this.notifyAgentsOfScheduleUpdates(entityContext, scheduleSubQuery);
        }
    }

    private boolean isJobScheduled(Scheduler scheduler, String name, String group) {
        boolean isScheduled = false;
        try {
            JobDetail jobDetail = scheduler.getJobDetail(name, group);
            if (jobDetail != null) {
                isScheduled = true;
            }
        }
        catch (SchedulerException se) {
            this.log.error((Object)"Error getting job detail", (Throwable)se);
        }
        return isScheduled;
    }

    @Override
    public void notifyAgentsOfScheduleUpdates(EntityContext entityContext, String scheduleSubQuery) {
        List agentIds = new ArrayList();
        try {
            String agentsQueryString = "SELECT DISTINCT ms.resource.agent.id   FROM MeasurementSchedule ms  WHERE ms.id IN ( " + scheduleSubQuery + " ) ";
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("agentsQueryString: " + agentsQueryString));
            }
            Query agentsQuery = this.entityManager.createQuery(agentsQueryString);
            agentIds = agentsQuery.getResultList();
        }
        catch (Throwable t) {
            this.log.error((Object)"Could not notify agents of updates", t);
        }
        String scheduleRequestQueryString = "SELECT ms.resource.id,        ms.id,        ms.definition.name,        ms.interval,        ms.enabled,        ms.definition.dataType,        ms.definition.rawNumericType   FROM MeasurementSchedule ms  WHERE ms.id IN ( " + scheduleSubQuery + " ) " + "   AND ms.resource.agent.id = :agentId";
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("scheduleRequestQueryString: " + scheduleRequestQueryString));
        }
        Query scheduleRequestQuery = this.entityManager.createQuery(scheduleRequestQueryString);
        HashMap<Integer, ResourceMeasurementScheduleRequest> agentRequests = new HashMap<Integer, ResourceMeasurementScheduleRequest>();
        Iterator i$ = agentIds.iterator();
        while (i$.hasNext()) {
            int nextAgentId = (Integer)i$.next();
            scheduleRequestQuery.setParameter("agentId", (Object)nextAgentId);
            List scheduleRequests = scheduleRequestQuery.getResultList();
            for (Object[] nextScheduleDataSet : scheduleRequests) {
                int resourceId = (Integer)nextScheduleDataSet[0];
                ResourceMeasurementScheduleRequest resourceRequest = (ResourceMeasurementScheduleRequest)agentRequests.get(resourceId);
                if (resourceRequest == null) {
                    resourceRequest = new ResourceMeasurementScheduleRequest(resourceId);
                    agentRequests.put(resourceId, resourceRequest);
                }
                MeasurementScheduleRequest requestData = new MeasurementScheduleRequest(((Integer)nextScheduleDataSet[1]).intValue(), (String)nextScheduleDataSet[2], ((Long)nextScheduleDataSet[3]).longValue(), ((Boolean)nextScheduleDataSet[4]).booleanValue(), (DataType)nextScheduleDataSet[5], (NumericType)nextScheduleDataSet[6]);
                resourceRequest.addMeasurementScheduleRequest(requestData);
            }
            boolean markResources = false;
            try {
                Agent nextAgent = this.agentManager.getAgentByID(nextAgentId);
                AgentClient agentClient = this.agentManager.getAgentClient(nextAgent);
                boolean couldPing = agentClient.ping(2000L);
                if (couldPing) {
                    HashSet requestsToSend = new HashSet(agentRequests.values());
                    agentClient.getMeasurementAgentService().updateCollection(requestsToSend);
                } else {
                    this.log.error((Object)("Could not send measurement schedule updates to agent[id=" + nextAgentId + "], marking resources for update; agent ping failed"));
                    markResources = true;
                }
            }
            catch (Throwable t) {
                this.log.error((Object)("Could not send measurement schedule updates to agent[id=" + nextAgentId + "], marking resources for update"), t);
                markResources = true;
            }
            if (!markResources) continue;
            this.markResources(entityContext, nextAgentId);
        }
    }

    private void markResources(EntityContext context, int agentId) {
        ResourceCriteria criteria = new ResourceCriteria();
        if (context.type == EntityContext.Type.Resource) {
            criteria.addFilterId(Integer.valueOf(context.resourceId));
        } else if (context.type == EntityContext.Type.ResourceGroup) {
            criteria.addFilterImplicitGroupIds(new Integer[]{context.groupId});
        } else if (context.type == EntityContext.Type.AutoGroup) {
            criteria.addFilterParentResourceId(Integer.valueOf(context.parentResourceId));
            criteria.addFilterResourceTypeId(Integer.valueOf(context.resourceTypeId));
        }
        criteria.addFilterAgentId(Integer.valueOf(agentId));
        try {
            CriteriaQueryGenerator generator = new CriteriaQueryGenerator((Criteria)criteria);
            generator.alterProjection("resource.id");
            String resourceSubQuery = generator.getParameterReplacedQuery(false);
            String markResourceQueryString = "UPDATE Resource res    SET res.mtime = :now  WHERE res.id IN ( " + resourceSubQuery + " ) ";
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("markResourceQueryString: " + markResourceQueryString));
            }
            Query markResourceQuery = this.entityManager.createQuery(markResourceQueryString);
            markResourceQuery.setParameter("now", (Object)System.currentTimeMillis());
            int affectedRows = markResourceQuery.executeUpdate();
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Marked " + affectedRows + " for future measurement scheudle update"));
            }
        }
        catch (Throwable t) {
            this.log.error((Object)"Could not notify agents of updates", t);
        }
    }

    public String getMeasurementScheduleSubQueryForContext(Subject subject, EntityContext context, int[] measurementDefinitionIds) {
        if (context.type == EntityContext.Type.Resource) {
            if (!this.authorizationManager.hasResourcePermission(subject, Permission.MANAGE_MEASUREMENTS, context.resourceId)) {
                throw new PermissionException("User [" + subject.getName() + "] does not have permission to manage schedules for resource[id=" + context.resourceId + "]");
            }
        } else if (context.type == EntityContext.Type.ResourceGroup) {
            if (!this.authorizationManager.hasGroupPermission(subject, Permission.MANAGE_MEASUREMENTS, context.groupId)) {
                throw new PermissionException("User [" + subject.getName() + "] does not have permission to manage schedules for resourceGroup[id=" + context.groupId + "]");
            }
        } else if (context.type == EntityContext.Type.AutoGroup && !this.authorizationManager.hasAutoGroupPermission(subject, Permission.MANAGE_MEASUREMENTS, context.parentResourceId, context.resourceTypeId)) {
            throw new PermissionException("User [" + subject.getName() + "] does not have permission to manage schedules for autoGroup[parentResourceId=" + context.parentResourceId + ", resourceTypeId=" + context.resourceTypeId + "]");
        }
        MeasurementScheduleCriteria criteria = new MeasurementScheduleCriteria();
        if (context.type == EntityContext.Type.Resource) {
            criteria.addFilterResourceId(Integer.valueOf(context.resourceId));
        } else if (context.type == EntityContext.Type.ResourceGroup) {
            criteria.addFilterResourceGroupId(Integer.valueOf(context.groupId));
        } else if (context.type == EntityContext.Type.AutoGroup) {
            criteria.addFilterAutoGroupParentResourceId(Integer.valueOf(context.parentResourceId));
            criteria.addFilterAutoGroupResourceTypeId(Integer.valueOf(context.resourceTypeId));
        }
        criteria.addFilterDefinitionIds(ArrayUtils.wrapInArray((int[])measurementDefinitionIds));
        CriteriaQueryGenerator generator = new CriteriaQueryGenerator(subject, (Criteria)criteria);
        generator.alterProjection("measurementschedule.id");
        String measurementScheduleSubQuery = generator.getParameterReplacedQuery(false);
        return measurementScheduleSubQuery;
    }

    private void setAgentSynchronizationNeededByDefinitionsForAgent(int agentId, List<Integer> measurementDefinitionIds) {
        String updateSQL = "UPDATE Resource res    SET res.mtime = :now  WHERE res.agent.id = :agentId AND        res.resourceType.id IN ( SELECT md.resourceType.id                                   FROM MeasurementDefinition md                                  WHERE md.id IN ( :definitionIds ) )";
        Query updateQuery = this.entityManager.createQuery(updateSQL);
        updateQuery.setParameter("now", (Object)System.currentTimeMillis());
        updateQuery.setParameter("agentId", (Object)agentId);
        updateQuery.setParameter("definitionIds", measurementDefinitionIds);
        int updateCount = updateQuery.executeUpdate();
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("" + updateCount + " resources mtime fields were updated as a result of this metric template update"));
        }
    }

    @Override
    public void updateSchedulesForAutoGroup(Subject subject, int parentResourceId, int childResourceType, int[] measurementDefinitionIds, long collectionInterval) {
        this.updateSchedulesForContext(subject, EntityContext.forAutoGroup((int)parentResourceId, (int)childResourceType), measurementDefinitionIds, collectionInterval);
    }

    @Override
    @Deprecated
    public void disableSchedulesForAutoGroup(Subject subject, int parentResourceId, int childResourceType, int[] measurementDefinitionIds) {
        this.disableSchedulesForContext(subject, EntityContext.forAutoGroup((int)parentResourceId, (int)childResourceType), measurementDefinitionIds);
    }

    @Override
    @Deprecated
    public void enableSchedulesForAutoGroup(Subject subject, int parentResourceId, int childResourceType, int[] measurementDefinitionIds) {
        this.enableSchedulesForContext(subject, EntityContext.forAutoGroup((int)parentResourceId, (int)childResourceType), measurementDefinitionIds);
    }

    @Override
    public List<MeasurementSchedule> findSchedulesForResourceAndType(Subject subject, int resourceId, DataType dataType, DisplayType displayType, boolean enabledOnly) {
        OrderingField sortOrder = new OrderingField("ms.definition.displayName", PageOrdering.ASC);
        Query query = PersistenceUtility.createQueryWithOrderBy((EntityManager)this.entityManager, (String)"MeasurementSchedule.FIND_ALL_FOR_RESOURCE_ID", (OrderingField[])new OrderingField[]{sortOrder});
        query.setParameter("resourceId", (Object)resourceId);
        query.setParameter("dataType", (Object)dataType);
        query.setParameter("displayType", (Object)displayType);
        query.setParameter("enabled", (Object)(enabledOnly ? Boolean.valueOf(true) : null));
        List results = query.getResultList();
        return results;
    }

    private boolean sendUpdatedSchedulesToAgent(Agent agent, Set<ResourceMeasurementScheduleRequest> resourceMeasurementScheduleRequest) {
        try {
            AgentClient agentClient = LookupUtil.getAgentManager().getAgentClient(agent);
            if (!agentClient.ping(2000L)) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("Won't send MeasurementSchedules to offline Agent[id=" + agent.getId() + "]"));
                }
                return false;
            }
            agentClient.getMeasurementAgentService().updateCollection(resourceMeasurementScheduleRequest);
            return true;
        }
        catch (Throwable t) {
            this.log.error((Object)("Error updating MeasurementSchedules for Agent[id=" + agent.getId() + "]: "), t);
            return false;
        }
    }

    @Override
    public List<MeasurementSchedule> findSchedulesByResourceIdAndDefinitionIds(Subject subject, int resourceId, int[] definitionIds) {
        return this.findSchedulesByResourcesAndDefinitions(subject, new int[]{resourceId}, definitionIds);
    }

    private void getSchedulesForResourceAndItsDescendants(int[] resourceIds, Set<ResourceMeasurementScheduleRequest> allSchedules, boolean getDescendents) {
        if (resourceIds == null || resourceIds.length == 0) {
            return;
        }
        try {
            for (int batchIndex = 0; batchIndex < resourceIds.length; batchIndex += 1000) {
                int[] batchIds = ArrayUtils.copyOfRange((int[])resourceIds, (int)batchIndex, (int)(batchIndex + 1000));
                this.measurementScheduleManager.insertSchedulesFor(batchIds);
                this.measurementScheduleManager.returnSchedulesFor(batchIds, allSchedules);
                if (!getDescendents) continue;
                int[] batchChildrenIds = this.getChildrenIdByParentIds(batchIds);
                this.getSchedulesForResourceAndItsDescendants(batchChildrenIds, allSchedules, getDescendents);
            }
        }
        catch (Throwable t) {
            this.log.warn((Object)("problem creating schedules for resourceIds [" + Arrays.toString(resourceIds) + "]"), t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    public int insertSchedulesFor(int[] batchIds) throws Exception {
        Connection conn = null;
        Statement insertStatement = null;
        int created = -1;
        try {
            conn = this.dataSource.getConnection();
            DatabaseType dbType = DatabaseTypeFactory.getDatabaseType((Connection)conn);
            String insertQueryString = null;
            if (dbType instanceof PostgresqlDatabaseType) {
                insertQueryString = "INSERT INTO RHQ_MEASUREMENT_SCHED ( ID, ENABLED, COLL_INTERVAL, DEFINITION, RESOURCE_ID )      SELECT nextval('RHQ_MEASUREMENT_SCHED_ID_SEQ'),             def.DEFAULT_ON AS defaultOn,             def.DEFAULT_INTERVAL AS interval,             def.ID AS definitionId,             res.ID AS resourceId        FROM RHQ_RESOURCE res, RHQ_RESOURCE_TYPE type, RHQ_MEASUREMENT_DEF def       WHERE ( res.ID in ( @@RESOURCES@@ ) )         AND type.ID = res.RESOURCE_TYPE_ID         AND type.ID = def.RESOURCE_TYPE_ID         AND NOT EXISTS ( SELECT ms.id                            FROM RHQ_MEASUREMENT_SCHED ms                           WHERE ms.RESOURCE_ID = res.ID                             AND ms.DEFINITION = def.ID ) ";
            } else if (dbType instanceof OracleDatabaseType || dbType instanceof H2DatabaseType) {
                insertQueryString = "INSERT INTO RHQ_MEASUREMENT_SCHED ( ID, ENABLED, COLL_INTERVAL, DEFINITION, RESOURCE_ID )      SELECT RHQ_MEASUREMENT_SCHED_ID_SEQ.nextval,             defaultOn, interval, definitionId, resourceId        FROM ( SELECT def.DEFAULT_ON AS defaultOn,                      def.DEFAULT_INTERVAL AS interval,                      def.ID AS definitionId,                      res.ID AS resourceId                 FROM RHQ_RESOURCE res, RHQ_RESOURCE_TYPE type, RHQ_MEASUREMENT_DEF def                WHERE ( res.ID in ( @@RESOURCES@@ ) )                  AND type.ID = res.RESOURCE_TYPE_ID                  AND type.ID = def.RESOURCE_TYPE_ID                  AND NOT EXISTS ( SELECT ms.id                                     FROM RHQ_MEASUREMENT_SCHED ms                                    WHERE ms.RESOURCE_ID = res.ID                                      AND ms.DEFINITION = def.ID ) ) ";
            } else if (dbType instanceof SQLServerDatabaseType) {
                insertQueryString = "INSERT INTO RHQ_MEASUREMENT_SCHED ( ENABLED, COLL_INTERVAL, DEFINITION, RESOURCE_ID )      SELECT def.DEFAULT_ON AS defaultOn,             def.DEFAULT_INTERVAL AS interval,             def.ID AS definitionId,             res.ID AS resourceId        FROM RHQ_RESOURCE res, RHQ_RESOURCE_TYPE type, RHQ_MEASUREMENT_DEF def       WHERE ( res.ID in ( @@RESOURCES@@ ) )         AND type.ID = res.RESOURCE_TYPE_ID         AND type.ID = def.RESOURCE_TYPE_ID         AND NOT EXISTS ( SELECT ms.id                            FROM RHQ_MEASUREMENT_SCHED ms                           WHERE ms.RESOURCE_ID = res.ID                             AND ms.DEFINITION = def.ID ) ";
            } else {
                throw new IllegalArgumentException("Unknown database type, can't continue: " + dbType);
            }
            insertQueryString = JDBCUtil.transformQueryForMultipleInParameters((String)insertQueryString, (String)"@@RESOURCES@@", (int)batchIds.length);
            insertStatement = conn.prepareStatement(insertQueryString);
            JDBCUtil.bindNTimes((PreparedStatement)insertStatement, (int[])batchIds, (int)1);
            created = insertStatement.executeUpdate();
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Batch created [" + created + "] default measurement schedules for resource batch [" + batchIds + "]"));
            }
        }
        finally {
            if (insertStatement != null) {
                try {
                    insertStatement.close();
                }
                catch (Exception e) {}
            }
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (Exception e) {}
            }
        }
        return created;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    public int returnSchedulesFor(int[] batchIds, Set<ResourceMeasurementScheduleRequest> allSchedules) throws Exception {
        Connection conn = null;
        Statement resultsStatement = null;
        int created = -1;
        try {
            conn = this.dataSource.getConnection();
            String resultsQueryString = "SELECT ms.RESOURCE_ID, ms.ID, def.NAME, ms.COLL_INTERVAL, ms.ENABLED, def.DATA_TYPE, def.RAW_NUMERIC_TYPE   FROM RHQ_MEASUREMENT_SCHED ms   JOIN RHQ_MEASUREMENT_DEF def ON ms.DEFINITION = def.ID  WHERE ms.RESOURCE_ID IN ( @@RESOURCES@@ )";
            resultsQueryString = JDBCUtil.transformQueryForMultipleInParameters((String)resultsQueryString, (String)"@@RESOURCES@@", (int)batchIds.length);
            resultsStatement = conn.prepareStatement(resultsQueryString);
            JDBCUtil.bindNTimes((PreparedStatement)resultsStatement, (int[])batchIds, (int)1);
            HashMap<Integer, ResourceMeasurementScheduleRequest> scheduleRequestMap = new HashMap<Integer, ResourceMeasurementScheduleRequest>();
            ResultSet results = resultsStatement.executeQuery();
            try {
                while (results.next()) {
                    ResourceMeasurementScheduleRequest scheduleRequest;
                    Integer resourceId = results.getInt(1);
                    Integer scheduleId = results.getInt(2);
                    String definitionName = results.getString(3);
                    Long interval = results.getLong(4);
                    Boolean enabled = results.getBoolean(5);
                    DataType dataType = DataType.values()[results.getInt(6)];
                    NumericType rawNumericType = NumericType.values()[results.getInt(7)];
                    if (results.wasNull()) {
                        rawNumericType = null;
                    }
                    if ((scheduleRequest = (ResourceMeasurementScheduleRequest)scheduleRequestMap.get(resourceId)) == null) {
                        scheduleRequest = new ResourceMeasurementScheduleRequest(resourceId.intValue());
                        scheduleRequestMap.put(resourceId, scheduleRequest);
                        allSchedules.add(scheduleRequest);
                    }
                    MeasurementScheduleRequest requestData = new MeasurementScheduleRequest(scheduleId.intValue(), definitionName, interval.longValue(), enabled.booleanValue(), dataType, rawNumericType);
                    scheduleRequest.addMeasurementScheduleRequest(requestData);
                }
            }
            finally {
                results.close();
            }
        }
        finally {
            if (resultsStatement != null) {
                try {
                    resultsStatement.close();
                }
                catch (Exception e) {}
            }
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (Exception e) {}
            }
        }
        return created;
    }

    private int[] getChildrenIdByParentIds(int[] batchIds) {
        Query query = this.entityManager.createNamedQuery("Resource.findChildrenIdsByParentIds");
        query.setParameter("parentIds", (Object)ArrayUtils.wrapInList((int[])batchIds));
        List results = query.getResultList();
        int[] batchChildrenIds = ArrayUtils.unwrapCollection((Collection)results);
        return batchChildrenIds;
    }

    @Override
    public int getScheduledMeasurementsPerMinute() {
        Number rate = 0;
        try {
            Query query = this.entityManager.createNamedQuery("MeasurementSchedule.getScheduledMeasurementsPerMinute");
            query.setParameter("status", (Object)InventoryStatus.COMMITTED);
            rate = (Number)query.getSingleResult();
        }
        catch (Throwable t) {
            this.measurementScheduleManager.errorCorrectSchedules();
        }
        return rate == null ? 0 : rate;
    }

    @Override
    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    public void errorCorrectSchedules() {
        try {
            long now = System.currentTimeMillis();
            String updateResourcesQueryString = " UPDATE Resource     SET mtime = :currentTime   WHERE id IN ( SELECT ms.resource.id                   FROM MeasurementSchedule ms                  WHERE ms.interval < 30000 ) ";
            Query updateResourcesQuery = this.entityManager.createQuery(updateResourcesQueryString);
            updateResourcesQuery.setParameter("currentTime", (Object)now);
            int resourcesUpdatedCount = updateResourcesQuery.executeUpdate();
            String updateSchedulesQueryString = " UPDATE MeasurementSchedule     SET interval = 30000   WHERE interval < 30000 ";
            Query updateSchedulesQuery = this.entityManager.createQuery(updateSchedulesQueryString);
            int schedulesUpdatedCount = updateSchedulesQuery.executeUpdate();
            if (resourcesUpdatedCount > 0) {
                String findResourcesQueryString = " SELECT res.id    FROM Resource res   WHERE res.mtime = :currentTime ";
                Query findResourcesQuery = this.entityManager.createQuery(findResourcesQueryString);
                findResourcesQuery.setParameter("currentTime", (Object)now);
                List updatedResourceIds = findResourcesQuery.getResultList();
                this.updateMeasurementSchedulesForResources(ArrayUtils.unwrapCollection((Collection)updatedResourceIds));
                this.log.error((Object)("MeasurementSchedule data was corrupt: automatically updated " + resourcesUpdatedCount + " resources and " + schedulesUpdatedCount + " to correct the issue; agents were notified"));
            } else if (this.log.isDebugEnabled()) {
                this.log.debug((Object)"MeasurementSchedule data was checked for corruption, but all data was consistent");
            }
        }
        catch (Throwable t) {
            this.log.error((Object)"There was a problem correcting errors for MeasurementSchedules", t);
        }
    }

    private void updateMeasurementSchedulesForResources(int[] resourceIds) {
        Agent agent;
        if (resourceIds.length == 0) {
            return;
        }
        Subject overlord = this.subjectManager.getOverlord();
        PageList<org.rhq.core.domain.resource.Resource> resources = this.resourceManager.findResourceByIds(overlord, resourceIds, false, PageControl.getUnlimitedInstance());
        Set<ResourceMeasurementScheduleRequest> requests = this.findSchedulesForResourceAndItsDescendants(resourceIds, false);
        HashMap agentScheduleMap = new HashMap();
        for (org.rhq.core.domain.resource.Resource resource : resources) {
            agent = resource.getAgent();
            HashSet<ResourceMeasurementScheduleRequest> agentSchedules = (HashSet<ResourceMeasurementScheduleRequest>)agentScheduleMap.get(agent);
            if (agentSchedules == null) {
                agentSchedules = new HashSet<ResourceMeasurementScheduleRequest>();
                agentScheduleMap.put(agent, agentSchedules);
            }
            for (ResourceMeasurementScheduleRequest request : requests) {
                int resId = resource.getId();
                if (request.getResourceId() != resId) continue;
                agentSchedules.add(request);
            }
        }
        for (Map.Entry agentScheduleEntry : agentScheduleMap.entrySet()) {
            agent = (Agent)agentScheduleEntry.getKey();
            Set schedules = (Set)agentScheduleEntry.getValue();
            try {
                this.sendUpdatedSchedulesToAgent(agent, schedules);
            }
            catch (Throwable t) {
                if (!this.log.isDebugEnabled()) continue;
                this.log.debug((Object)("Tried to immediately sync agent[name=" + agent.getName() + "] with error-corrected schedules failed"));
            }
        }
    }

    @Override
    public void disableSchedulesForResource(Subject subject, int resourceId, int[] measurementDefinitionIds) {
        this.disableSchedulesForContext(subject, EntityContext.forResource((int)resourceId), measurementDefinitionIds);
    }

    @Override
    public void disableSchedulesForCompatibleGroup(Subject subject, int groupId, int[] measurementDefinitionIds) {
        this.disableSchedulesForContext(subject, EntityContext.forGroup((int)groupId), measurementDefinitionIds);
    }

    @Override
    @RequiredPermission(value=Permission.MANAGE_SETTINGS)
    public void disableSchedulesForResourceType(Subject subject, int[] measurementDefinitionIds, boolean updateExistingSchedules) {
        this.modifyDefaultCollectionIntervalForMeasurementDefinitions(subject, measurementDefinitionIds, -1L, updateExistingSchedules);
    }

    @Override
    @Deprecated
    public void disableMeasurementTemplates(Subject subject, int[] measurementDefinitionIds) {
        this.disableDefaultCollectionForMeasurementDefinitions(subject, measurementDefinitionIds, true);
    }

    @Override
    public void enableSchedulesForResource(Subject subject, int resourceId, int[] measurementDefinitionIds) {
        this.enableSchedulesForContext(subject, EntityContext.forResource((int)resourceId), measurementDefinitionIds);
    }

    @Override
    public void enableSchedulesForCompatibleGroup(Subject subject, int groupId, int[] measurementDefinitionIds) {
        this.enableSchedulesForContext(subject, EntityContext.forGroup((int)groupId), measurementDefinitionIds);
    }

    @Override
    @RequiredPermission(value=Permission.MANAGE_SETTINGS)
    public void enableSchedulesForResourceType(Subject subject, int[] measurementDefinitionIds, boolean updateExistingSchedules) {
        this.modifyDefaultCollectionIntervalForMeasurementDefinitions(subject, measurementDefinitionIds, 0L, updateExistingSchedules);
    }

    @Override
    public void enableMeasurementTemplates(Subject subject, int[] measurementDefinitionIds) {
        this.modifyDefaultCollectionIntervalForMeasurementDefinitions(subject, measurementDefinitionIds, 0L, true);
    }

    @Override
    public void updateSchedule(Subject subject, MeasurementSchedule schedule) {
        MeasurementSchedule attached = (MeasurementSchedule)this.entityManager.find(MeasurementSchedule.class, (Object)schedule.getId());
        if (!this.authorizationManager.hasResourcePermission(subject, Permission.MANAGE_MEASUREMENTS, attached.getResource().getId())) {
            throw new PermissionException("User[" + subject.getName() + "] does not have permission to view measurementSchedule[id=" + schedule.getId() + "]");
        }
        this.verifyMinimumCollectionInterval(schedule);
        this.entityManager.merge((Object)schedule);
    }

    @Override
    public void updateSchedulesForResource(Subject subject, int resourceId, int[] measurementDefinitionIds, long collectionInterval) {
        this.updateSchedulesForContext(subject, EntityContext.forResource((int)resourceId), measurementDefinitionIds, collectionInterval);
    }

    @Override
    public void updateSchedulesForCompatibleGroup(Subject subject, int groupId, int[] measurementDefinitionIds, long collectionInterval) {
        this.updateSchedulesForContext(subject, EntityContext.forGroup((int)groupId), measurementDefinitionIds, collectionInterval);
    }

    @Override
    @RequiredPermission(value=Permission.MANAGE_SETTINGS)
    public void updateSchedulesForResourceType(Subject subject, int[] measurementDefinitionIds, long collectionInterval, boolean updateExistingSchedules) {
        collectionInterval = this.verifyMinimumCollectionInterval(collectionInterval);
        this.modifyDefaultCollectionIntervalForMeasurementDefinitions(subject, measurementDefinitionIds, collectionInterval, updateExistingSchedules);
    }

    @Override
    @Deprecated
    public void updateMeasurementTemplates(Subject subject, int[] measurementDefinitionIds, long collectionInterval) {
        collectionInterval = this.verifyMinimumCollectionInterval(collectionInterval);
        this.updateDefaultCollectionIntervalForMeasurementDefinitions(subject, measurementDefinitionIds, collectionInterval, true);
    }

    @Override
    public PageList<MeasurementScheduleComposite> getMeasurementScheduleCompositesByContext(Subject subject, EntityContext context, PageControl pc) {
        PageList definitions;
        CriteriaQueryRunner queryRunner;
        CriteriaQueryGenerator generator;
        MeasurementDefinitionCriteria criteria;
        switch (context.type) {
            case Resource: {
                if (this.authorizationManager.canViewResource(subject, context.resourceId)) break;
                throw new PermissionException("User [" + subject.getName() + "] does not have permission to view measurement schedules for resource[id=" + context.resourceId + "]");
            }
            case ResourceGroup: {
                if (this.authorizationManager.canViewGroup(subject, context.groupId)) break;
                throw new PermissionException("User [" + subject.getName() + "] does not have permission to view measurement schedules for resourceGroup[id=" + context.groupId + "]");
            }
            case AutoGroup: {
                if (this.authorizationManager.canViewAutoGroup(subject, context.parentResourceId, context.resourceTypeId)) break;
                throw new PermissionException("User [" + subject.getName() + "] does not have permission to view measurement schedules for autoGroup[parentResourceId=" + context.parentResourceId + ", resourceTypeId=" + context.resourceTypeId + "]");
            }
        }
        HashMap<Integer, Long> definitionIntervalMap = new HashMap<Integer, Long>();
        HashMap<Integer, Boolean> definitionEnabledMap = new HashMap<Integer, Boolean>();
        if (context.type == EntityContext.Type.ResourceTemplate) {
            criteria = new MeasurementDefinitionCriteria();
            criteria.addFilterResourceTypeId(Integer.valueOf(context.resourceTypeId));
            generator = new CriteriaQueryGenerator(subject, (Criteria)criteria);
            queryRunner = new CriteriaQueryRunner((Criteria)criteria, generator, this.entityManager);
            definitions = queryRunner.execute();
            for (MeasurementDefinition definition : definitions) {
                definitionIntervalMap.put(definition.getId(), definition.getDefaultInterval());
                definitionEnabledMap.put(definition.getId(), definition.isDefaultOn());
            }
        } else {
            criteria = new MeasurementScheduleCriteria();
            switch (context.type) {
                case Resource: {
                    criteria.addFilterResourceId(Integer.valueOf(context.resourceId));
                    break;
                }
                case ResourceGroup: {
                    criteria.addFilterResourceGroupId(Integer.valueOf(context.groupId));
                    break;
                }
                case AutoGroup: {
                    criteria.addFilterAutoGroupParentResourceId(Integer.valueOf(context.parentResourceId));
                    criteria.addFilterAutoGroupResourceTypeId(Integer.valueOf(context.resourceTypeId));
                }
            }
            criteria.setPageControl(pc);
            pc.addDefaultOrderingField("definition.displayName");
            generator = new CriteriaQueryGenerator(subject, (Criteria)criteria);
            generator.alterProjection(" distinct orderingField0");
            queryRunner = new CriteriaQueryRunner((Criteria)criteria, generator, this.entityManager);
            definitions = queryRunner.execute();
            criteria.setPageControl(PageControl.getUnlimitedInstance());
            generator.setGroupByClause(" measurementschedule.definition.id ");
            generator.alterProjection(" measurementschedule.definition.id,  min(measurementschedule.interval),  max(measurementschedule.interval) ");
            Query query = generator.getQuery(this.entityManager);
            List definitionIntervalResults = query.getResultList();
            criteria.addFilterEnabled(Boolean.valueOf(true));
            generator.alterProjection(" measurementschedule.definition.id, count(measurementschedule.id) ");
            query = generator.getQuery(this.entityManager);
            List definitionEnabledResults = query.getResultList();
            for (Object[] nextInterval : definitionIntervalResults) {
                long maxInterval;
                int definitionId = (Integer)nextInterval[0];
                long minInterval = (Long)nextInterval[1];
                long interval = minInterval != (maxInterval = ((Long)nextInterval[2]).longValue()) ? 0L : minInterval;
                definitionIntervalMap.put(definitionId, interval);
            }
            int size = this.getResourceCount(context);
            for (Object[] nextEnabled : definitionEnabledResults) {
                int definitionId = (Integer)nextEnabled[0];
                long enabledCount = (Long)nextEnabled[1];
                Boolean enabled = null;
                if (enabledCount == (long)size) {
                    enabled = true;
                } else if (enabledCount == 0L) {
                    enabled = false;
                }
                definitionEnabledMap.put(definitionId, enabled);
            }
        }
        ArrayList<MeasurementScheduleComposite> composites = new ArrayList<MeasurementScheduleComposite>();
        for (MeasurementDefinition next : definitions) {
            int definitionId = next.getId();
            Boolean enabled = false;
            if (definitionEnabledMap.containsKey(definitionId)) {
                enabled = (Boolean)definitionEnabledMap.get(definitionId);
            }
            long interval = (Long)definitionIntervalMap.get(definitionId);
            MeasurementScheduleComposite result = new MeasurementScheduleComposite(next, enabled, interval);
            composites.add(result);
        }
        return new PageList(composites, composites.size(), pc);
    }

    private int getResourceCount(EntityContext context) {
        if (context.type == EntityContext.Type.Resource) {
            return 1;
        }
        if (context.type == EntityContext.Type.ResourceGroup) {
            return this.resourceGroupManager.getExplicitGroupMemberCount(context.groupId);
        }
        if (context.type == EntityContext.Type.AutoGroup) {
            ResourceCriteria criteria = new ResourceCriteria();
            criteria.addFilterParentResourceId(Integer.valueOf(context.parentResourceId));
            criteria.addFilterResourceTypeId(Integer.valueOf(context.resourceTypeId));
            criteria.setPageControl(PageControl.getSingleRowInstance());
            PageList<org.rhq.core.domain.resource.Resource> results = this.resourceManager.findResourcesByCriteria(this.subjectManager.getOverlord(), criteria);
            return results.getTotalSize();
        }
        return 0;
    }

    @Override
    public PageList<MeasurementSchedule> findSchedulesByCriteria(Subject subject, MeasurementScheduleCriteria criteria) {
        CriteriaQueryGenerator generator = new CriteriaQueryGenerator(subject, (Criteria)criteria);
        if (!this.authorizationManager.isInventoryManager(subject)) {
            generator.setAuthorizationResourceFragment(CriteriaQueryGenerator.AuthorizationTokenType.RESOURCE, subject.getId());
        }
        CriteriaQueryRunner queryRunner = new CriteriaQueryRunner((Criteria)criteria, generator, this.entityManager);
        return queryRunner.execute();
    }
}

