/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.naming.util;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.rhq.enterprise.server.naming.util.DecoratorSetContext;

public class DecoratorPicker<Type, Decorator extends Type> {
    private DecoratorSetContext<Type, Decorator> context;

    public DecoratorSetContext<Type, Decorator> getContext() {
        return this.context;
    }

    public void setContext(DecoratorSetContext<Type, Decorator> decoratorSetContext) {
        this.context = decoratorSetContext;
    }

    public Set<Decorator> getDecoratorsForMethod(Method method) throws Exception {
        return this.getDecoratorsForClass_Private(method.getDeclaringClass());
    }

    public Set<Decorator> getDecoratorsForClass(Class<? extends Type> cls) throws Exception {
        return this.getDecoratorsForClass_Private(cls);
    }

    public Type decorate(Type object) throws Exception {
        Set<Decorator> decs = this.getDecoratorsForClass_Private(object.getClass());
        Object ret = object;
        for (Decorator d : decs) {
            this.context.init(d, ret);
            ret = d;
        }
        return ret;
    }

    public Type decorate(Type object, Class<?> significantSuperClass) throws Exception {
        Set<Decorator> decs = this.getDecoratorsForClass_Private(significantSuperClass);
        Object ret = object;
        for (Decorator d : decs) {
            this.context.init(d, ret);
            ret = d;
        }
        return ret;
    }

    private Set<Decorator> getDecoratorsForClass_Private(Class<?> cls) throws Exception {
        Set<Class<Type>> ifaces = this.getNearestApplicableInterfaces(cls);
        HashSet<Decorator> ret = new HashSet<Decorator>();
        for (Class<Type> iface : ifaces) {
            for (Class<Decorator> decClass : this.getMatch(iface)) {
                ret.add(this.context.instantiate(decClass));
            }
        }
        return ret;
    }

    private Set<Class<? extends Type>> getNearestApplicableInterfaces(Class<?> cls) {
        ArrayList<Class<Type>> ifaces = new ArrayList<Class<Type>>(this.getAllApplicableInterfaces(cls));
        Iterator it = ifaces.iterator();
        block0: while (it.hasNext()) {
            Class c = (Class)it.next();
            for (int i = 0; i < ifaces.size(); ++i) {
                Class nextC = (Class)ifaces.get(i);
                if (c.equals(nextC) || !c.isAssignableFrom(nextC)) continue;
                it.remove();
                continue block0;
            }
        }
        return new HashSet<Class<? extends Type>>(ifaces);
    }

    private Set<Class<? extends Type>> getAllApplicableInterfaces(Class<?> cls) {
        HashSet<Class<Type>> ifaces = new HashSet<Class<Type>>();
        for (Class<Type> iface : this.context.getSupportedInterfaces()) {
            if (!iface.isAssignableFrom(cls)) continue;
            ifaces.add(iface);
        }
        if (ifaces.isEmpty()) {
            throw new IllegalArgumentException("Class " + cls + " doesn't implement any of the applicable interfaces. Cannot find decorators for it.");
        }
        return ifaces;
    }

    private Set<Class<? extends Decorator>> getMatch(Class<?> targetIface) {
        HashSet<Class<Decorator>> ret = new HashSet<Class<Decorator>>();
        for (Class<Decorator> cls : this.context.getDecoratorClasses()) {
            if (!Arrays.asList(cls.getInterfaces()).contains(targetIface)) continue;
            ret.add(cls);
        }
        return ret;
    }
}

