/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.rest;

import freemarker.cache.ClassTemplateLoader;
import freemarker.cache.MultiTemplateLoader;
import freemarker.cache.TemplateLoader;
import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import javax.ejb.EJB;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriInfo;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.infinispan.Cache;
import org.infinispan.manager.CacheContainer;
import org.rhq.core.domain.auth.Subject;
import org.rhq.core.domain.resource.ResourceType;
import org.rhq.core.domain.resource.group.GroupCategory;
import org.rhq.core.domain.resource.group.ResourceGroup;
import org.rhq.enterprise.server.resource.ResourceManagerLocal;
import org.rhq.enterprise.server.resource.group.ResourceGroupManagerLocal;
import org.rhq.enterprise.server.rest.BadArgumentException;
import org.rhq.enterprise.server.rest.StuffNotFoundException;
import org.rhq.enterprise.server.rest.domain.GroupRest;
import org.rhq.enterprise.server.rest.domain.Link;
import org.rhq.enterprise.server.rest.domain.ResourceWithType;

@Resource(name="ISPN", mappedName="java:jboss/infinispan/rhq")
public class AbstractRestBean {
    Log log = LogFactory.getLog((String)this.getClass().getName());
    private static final CacheKey META_KEY = new CacheKey("rhq.rest.resourceMeta", 0);
    @Resource(name="ISPN")
    protected CacheContainer container;
    protected Cache<CacheKey, Object> cache;
    protected Subject caller;
    @EJB
    ResourceManagerLocal resMgr;
    @EJB
    ResourceGroupManagerLocal resourceGroupManager;

    @PostConstruct
    public void start() {
        this.cache = this.container.getCache("REST-API");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String renderTemplate(String templateName, Object objectToRender) {
        block7: {
            String string;
            Configuration config = new Configuration();
            ClassTemplateLoader ctl = new ClassTemplateLoader(this.getClass(), "/rest_templates/");
            TemplateLoader[] loaders = new TemplateLoader[]{ctl};
            MultiTemplateLoader mtl = new MultiTemplateLoader(loaders);
            config.setTemplateLoader((TemplateLoader)mtl);
            if (!templateName.endsWith(".ftl")) {
                templateName = templateName + ".ftl";
            }
            Template template = config.getTemplate(templateName);
            StringWriter out = new StringWriter();
            try {
                HashMap<String, Object> root = new HashMap<String, Object>();
                root.put("var", objectToRender);
                template.process(root, (Writer)out);
                string = out.toString();
            }
            catch (Throwable throwable) {
                try {
                    out.close();
                    throw throwable;
                }
                catch (IOException ioe) {
                    this.log.error((Object)ioe);
                    break block7;
                }
                catch (TemplateException te) {
                    this.log.error((Object)te.getMessage());
                }
            }
            out.close();
            return string;
        }
        return null;
    }

    protected <T> T getFromCache(int id, Class<T> clazz) {
        CacheKey key = new CacheKey(clazz, id);
        return this.getFromCache(key, clazz);
    }

    protected <T> T getFromCache(CacheKey key, Class<T> clazz) {
        Object o = null;
        CacheValue value = (CacheValue)this.cache.get((Object)key);
        if (null != value) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Cache Hit for " + key));
            }
            if (value.getReaders().contains(this.caller.getId())) {
                o = value.getValue();
            } else if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Cache Hit ignored, caller " + this.caller.toString() + " not found"));
            }
        } else if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Cache Miss for " + key));
        }
        return (T)o;
    }

    protected <T> boolean putToCache(int id, Class<T> clazz, T o) {
        CacheKey key = new CacheKey(clazz, id);
        return this.putToCache(key, o);
    }

    protected <T> boolean putToCache(CacheKey key, T o) {
        boolean result = false;
        CacheValue value = (CacheValue)this.cache.get((Object)key);
        if (null != value) {
            value.getReaders().add(this.caller.getId());
            value.setValue(o);
        } else {
            value = new CacheValue(o, this.caller.getId());
        }
        try {
            this.cache.put((Object)key, (Object)value);
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Cache Put " + key));
            }
            result = true;
        }
        catch (Exception e) {
            this.log.warn((Object)e.getMessage());
        }
        return result;
    }

    protected void putResourceToCache(org.rhq.core.domain.resource.Resource res) {
        this.putToCache(res.getId(), org.rhq.core.domain.resource.Resource.class, res);
        CacheKey callerKey = new CacheKey("rhq.rest.caller", this.caller.getId());
        try {
            HashSet<Integer> visibleResources = (HashSet<Integer>)this.cache.get((Object)callerKey);
            if (null == visibleResources) {
                visibleResources = new HashSet<Integer>();
            }
            visibleResources.add(res.getId());
            this.cache.put((Object)callerKey, visibleResources);
            HashMap<Integer, Integer> childParentMap = (HashMap<Integer, Integer>)this.cache.get((Object)META_KEY);
            if (null == childParentMap) {
                childParentMap = new HashMap<Integer, Integer>();
            }
            int pid = res.getParentResource() == null ? 0 : res.getParentResource().getId();
            childParentMap.put(res.getId(), pid);
            this.cache.put((Object)META_KEY, childParentMap);
        }
        catch (Exception e) {
            this.log.warn((Object)e.getMessage());
        }
    }

    protected List<org.rhq.core.domain.resource.Resource> getResourcesFromCacheByParentId(int pid) {
        ArrayList candidateIds = new ArrayList();
        ArrayList<org.rhq.core.domain.resource.Resource> ret = new ArrayList<org.rhq.core.domain.resource.Resource>();
        Map childParentMap = (Map)this.cache.get((Object)META_KEY);
        if (null != childParentMap) {
            try {
                for (Map.Entry entry : childParentMap.entrySet()) {
                    if ((Integer)entry.getValue() != pid) continue;
                    candidateIds.add(entry.getKey());
                }
                CacheKey callerKey = new CacheKey("rhq.rest.caller", this.caller.getId());
                Set visibleResources = (Set)this.cache.get((Object)callerKey);
                Iterator iter = candidateIds.iterator();
                while (iter.hasNext()) {
                    Integer resId = (Integer)iter.next();
                    if (visibleResources.contains(resId)) continue;
                    iter.remove();
                }
                for (Integer resId : candidateIds) {
                    ret.add(this.getFromCache(resId, org.rhq.core.domain.resource.Resource.class));
                }
            }
            catch (Exception e) {
                this.log.warn((Object)e.getMessage());
            }
        }
        return ret;
    }

    protected org.rhq.core.domain.resource.Resource getResourceFromCache(int resourceid) {
        org.rhq.core.domain.resource.Resource res = null;
        CacheKey callerKey = new CacheKey("rhq.rest.caller", this.caller.getId());
        Set visibleResources = (Set)this.cache.get((Object)callerKey);
        if (null != visibleResources) {
            try {
                if (visibleResources.contains(resourceid)) {
                    res = this.getFromCache(resourceid, org.rhq.core.domain.resource.Resource.class);
                }
            }
            catch (Exception e) {
                this.log.warn((Object)e.getMessage());
            }
        }
        return res;
    }

    protected <T> boolean removeFromCache(int id, Class<T> clazz) {
        CacheKey key = new CacheKey(clazz, id);
        Object cacheValue = this.cache.remove((Object)key);
        if (null != cacheValue) {
            this.log.debug((Object)("Cache Remove " + key));
        }
        return true;
    }

    public ResourceWithType fillRWT(org.rhq.core.domain.resource.Resource res, UriInfo uriInfo) {
        ResourceType resourceType = res.getResourceType();
        ResourceWithType rwt = new ResourceWithType(res.getName(), res.getId());
        rwt.setTypeName(resourceType.getName());
        rwt.setTypeId(resourceType.getId());
        rwt.setPluginName(resourceType.getPlugin());
        org.rhq.core.domain.resource.Resource parent = res.getParentResource();
        if (parent != null) {
            rwt.setParentId(parent.getId());
        } else {
            rwt.setParentId(0);
        }
        rwt.setAncestry(res.getAncestry());
        UriBuilder uriBuilder = uriInfo.getBaseUriBuilder();
        uriBuilder.path("/operation/definitions");
        uriBuilder.queryParam("resourceId", new Object[]{res.getId()});
        URI uri = uriBuilder.build(new Object[0]);
        Link link = new Link("operationDefinitions", uri.toString());
        rwt.addLink(link);
        uriBuilder = uriInfo.getBaseUriBuilder();
        uriBuilder.path("/resource/{id}");
        uri = uriBuilder.build(new Object[]{res.getId()});
        link = new Link("self", uri.toString());
        rwt.addLink(link);
        uriBuilder = uriInfo.getBaseUriBuilder();
        uriBuilder.path("/resource/{id}/schedules");
        uri = uriBuilder.build(new Object[]{res.getId()});
        link = new Link("schedules", uri.toString());
        rwt.addLink(link);
        uriBuilder = uriInfo.getBaseUriBuilder();
        uriBuilder.path("/resource/{id}/availability");
        uri = uriBuilder.build(new Object[]{res.getId()});
        link = new Link("availability", uri.toString());
        rwt.addLink(link);
        uriBuilder = uriInfo.getBaseUriBuilder();
        uriBuilder.path("/resource/{id}/children");
        uri = uriBuilder.build(new Object[]{res.getId()});
        link = new Link("children", uri.toString());
        rwt.addLink(link);
        if (parent != null) {
            uriBuilder = uriInfo.getBaseUriBuilder();
            uriBuilder.path("/resource/{id}/");
            uri = uriBuilder.build(new Object[]{parent.getId()});
            link = new Link("parent", uri.toString());
            rwt.addLink(link);
        }
        return rwt;
    }

    protected org.rhq.core.domain.resource.Resource fetchResource(int resourceId) {
        org.rhq.core.domain.resource.Resource res = this.resMgr.getResource(this.caller, resourceId);
        if (res == null) {
            throw new StuffNotFoundException("Resource with id " + resourceId);
        }
        return res;
    }

    protected ResourceGroup fetchGroup(int groupId, boolean requireCompatible) {
        ResourceGroup resourceGroup = this.resourceGroupManager.getResourceGroup(this.caller, groupId);
        if (resourceGroup == null) {
            throw new StuffNotFoundException("Group with id " + groupId);
        }
        if (requireCompatible && resourceGroup.getGroupCategory() != GroupCategory.COMPATIBLE) {
            throw new BadArgumentException("Group with id " + groupId, "it is no compatible group");
        }
        return resourceGroup;
    }

    protected GroupRest fillGroup(ResourceGroup group, UriInfo uriInfo) {
        GroupRest gr = new GroupRest(group.getName());
        gr.setId(group.getId());
        gr.setCategory(group.getGroupCategory());
        gr.setRecursive(group.isRecursive());
        if (group.getGroupDefinition() != null) {
            gr.setDynaGroupDefinitionId(group.getGroupDefinition().getId());
        }
        gr.setExplicitCount(group.getExplicitResources().size());
        gr.setImplicitCount(group.getImplicitResources().size());
        UriBuilder uriBuilder = uriInfo.getBaseUriBuilder();
        uriBuilder.path("/group/{id}");
        URI uri = uriBuilder.build(new Object[]{group.getId()});
        Link link = new Link("edit", uri.toASCIIString());
        gr.getLinks().add(link);
        uriBuilder = uriInfo.getBaseUriBuilder();
        uriBuilder.path("/group/{id}/metricDefinitions");
        uri = uriBuilder.build(new Object[]{group.getId()});
        link = new Link("metricDefinitions", uri.toASCIIString());
        gr.getLinks().add(link);
        return gr;
    }

    private static class CacheValue {
        private Object value;
        private Set<Integer> readers = new HashSet<Integer>();

        public CacheValue(Object value, int readerId) {
            this.readers.add(readerId);
            this.value = value;
        }

        public Object getValue() {
            return this.value;
        }

        public void setValue(Object value) {
            this.value = value;
        }

        public Set<Integer> getReaders() {
            return this.readers;
        }
    }

    protected static class CacheKey {
        private String namespace;
        private int id;

        public CacheKey(Class<?> clazz, int id) {
            this(clazz.getName(), id);
        }

        public CacheKey(String namespace, int id) {
            this.namespace = namespace;
            this.id = id;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.namespace == null ? 0 : this.namespace.hashCode());
            result = 31 * result + this.id;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            CacheKey other = (CacheKey)obj;
            if (this.namespace == null ? other.namespace != null : !this.namespace.equals(other.namespace)) {
                return false;
            }
            return this.id == other.id;
        }

        public String toString() {
            return "CacheKey [namespace=" + this.namespace + ", id=" + this.id + "]";
        }
    }
}

