/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.rest;

import com.wordnik.swagger.annotations.Api;
import com.wordnik.swagger.annotations.ApiError;
import com.wordnik.swagger.annotations.ApiErrors;
import com.wordnik.swagger.annotations.ApiOperation;
import com.wordnik.swagger.annotations.ApiParam;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.ejb.EJB;
import javax.ejb.Stateless;
import javax.interceptor.Interceptors;
import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.EntityTag;
import javax.ws.rs.core.GenericEntity;
import javax.ws.rs.core.Request;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriInfo;
import org.jboss.resteasy.annotations.GZIP;
import org.rhq.core.domain.alert.AlertCondition;
import org.rhq.core.domain.alert.AlertConditionCategory;
import org.rhq.core.domain.alert.AlertConditionOperator;
import org.rhq.core.domain.alert.AlertDampening;
import org.rhq.core.domain.alert.AlertDefinition;
import org.rhq.core.domain.alert.AlertPriority;
import org.rhq.core.domain.alert.BooleanExpression;
import org.rhq.core.domain.alert.notification.AlertNotification;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.Property;
import org.rhq.core.domain.configuration.PropertySimple;
import org.rhq.core.domain.configuration.definition.ConfigurationDefinition;
import org.rhq.core.domain.configuration.definition.PropertyDefinition;
import org.rhq.core.domain.configuration.definition.PropertyDefinitionSimple;
import org.rhq.core.domain.criteria.AlertDefinitionCriteria;
import org.rhq.core.domain.measurement.MeasurementDefinition;
import org.rhq.core.domain.resource.ResourceType;
import org.rhq.core.domain.resource.group.ResourceGroup;
import org.rhq.core.domain.util.PageList;
import org.rhq.enterprise.server.alert.AlertConditionManagerLocal;
import org.rhq.enterprise.server.alert.AlertDefinitionManagerLocal;
import org.rhq.enterprise.server.alert.AlertManagerLocal;
import org.rhq.enterprise.server.alert.AlertNotificationManagerLocal;
import org.rhq.enterprise.server.plugin.pc.alert.AlertSenderInfo;
import org.rhq.enterprise.server.plugin.pc.alert.AlertSenderPluginManager;
import org.rhq.enterprise.server.resource.ResourceTypeManagerLocal;
import org.rhq.enterprise.server.resource.group.ResourceGroupManagerLocal;
import org.rhq.enterprise.server.rest.AbstractRestBean;
import org.rhq.enterprise.server.rest.BadArgumentException;
import org.rhq.enterprise.server.rest.SetCallerInterceptor;
import org.rhq.enterprise.server.rest.StuffNotFoundException;
import org.rhq.enterprise.server.rest.domain.AlertConditionRest;
import org.rhq.enterprise.server.rest.domain.AlertDefinitionRest;
import org.rhq.enterprise.server.rest.domain.AlertNotificationRest;
import org.rhq.enterprise.server.rest.domain.AlertSender;
import org.rhq.enterprise.server.rest.domain.Link;

@Produces(value={"application/json", "application/xml", "text/plain"})
@Path(value="/alert")
@Api(value="Deal with Alert Definitions", description="This api deals with alert definitions. Everything  is purely experimental at the moment and can change without notice at any time.")
@Stateless
@Interceptors(value={SetCallerInterceptor.class})
public class AlertDefinitionHandlerBean
extends AbstractRestBean {
    @EJB
    AlertDefinitionManagerLocal alertDefinitionManager;
    @EJB
    AlertNotificationManagerLocal notificationMgr;
    @EJB
    AlertConditionManagerLocal conditionMgr;
    @EJB
    AlertManagerLocal alertManager;
    @EJB
    ResourceGroupManagerLocal resourceGroupMgr;
    @EJB
    ResourceTypeManagerLocal resourceTypeMgr;
    @PersistenceContext(unitName="rhqpu")
    private EntityManager entityManager;

    @GET
    @Path(value="/definition")
    @ApiOperation(value="Redirects to /alert/definitions")
    public Response redirectDefinitionToDefinitions(@Context UriInfo uriInfo) {
        UriBuilder uriBuilder = uriInfo.getRequestUriBuilder();
        uriBuilder.replacePath("/rest/alert/definitions");
        Response.ResponseBuilder builder = Response.seeOther((URI)uriBuilder.build(new Object[0]));
        return builder.build();
    }

    @GZIP
    @GET
    @Path(value="/definitions")
    @ApiOperation(value="List all Alert Definition")
    public List<AlertDefinitionRest> listAlertDefinitions(@ApiParam(value="Page number", defaultValue="0") @QueryParam(value="page") int page, @ApiParam(value="Limit to status, UNUSED AT THE MOMENT ") @QueryParam(value="status") String status) {
        AlertDefinitionCriteria criteria = new AlertDefinitionCriteria();
        criteria.setPaging(page, 20);
        PageList<AlertDefinition> defs = this.alertDefinitionManager.findAlertDefinitionsByCriteria(this.caller, criteria);
        ArrayList<AlertDefinitionRest> ret = new ArrayList<AlertDefinitionRest>(defs.size());
        for (AlertDefinition def : defs) {
            AlertDefinitionRest adr = this.definitionToDomain(def, false);
            ret.add(adr);
        }
        return ret;
    }

    @GET
    @Path(value="/definition/{id}")
    @ApiOperation(value="Get one AlertDefinition by id", responseClass="AlertDefinitionRest")
    @ApiError(code=404, reason="No definition found with the passed id.")
    public Response getAlertDefinition(@ApiParam(value="Id of the alert definition to retrieve") @PathParam(value="id") int definitionId, @ApiParam(value="Should conditions be returned too?") @QueryParam(value="full") @DefaultValue(value="false") boolean full, @Context Request request) {
        AlertDefinition def = this.alertDefinitionManager.getAlertDefinition(this.caller, definitionId);
        if (def == null) {
            throw new StuffNotFoundException("AlertDefinition with id " + definitionId);
        }
        EntityTag eTag = new EntityTag(Integer.toHexString(def.hashCode()));
        Response.ResponseBuilder builder = request.evaluatePreconditions(eTag);
        if (builder == null) {
            AlertDefinitionRest adr = this.definitionToDomain(def, full);
            builder = Response.ok((Object)adr);
        }
        builder.tag(eTag);
        return builder.build();
    }

    @POST
    @Path(value="/definitions")
    @ApiOperation(value="Create an AlertDefinition for the resource/group/resource type passed as query param. One and only one of the three params must be given at any time.")
    @ApiErrors(value={@ApiError(code=406, reason="There was not exactly one of 'resourceId','groupId' or 'resourceTypeId' given"), @ApiError(code=404, reason="A non existing alert notification sender was requested.")})
    public Response createAlertDefinition(@ApiParam(value="The id of the resource to attach the definition to") @QueryParam(value="resourceId") Integer resourceId, @ApiParam(value="The id of the group to attach the definition to") @QueryParam(value="groupId") Integer groupId, @ApiParam(value="The id of the resource type to attach the definition to") @QueryParam(value="resourceTypeId") Integer resourceTypeId, @ApiParam(value="The data for the new definition") AlertDefinitionRest adr, @Context UriInfo uriInfo) {
        AlertDefinition recoveryDef;
        int i = 0;
        if (resourceId != null) {
            ++i;
        }
        if (groupId != null) {
            ++i;
        }
        if (resourceTypeId != null) {
            ++i;
        }
        if (i != 1) {
            throw new BadArgumentException("query param", "You must give exactly one query param out of 'resourceId', 'groupId' or 'resourceTypeId'");
        }
        AlertDefinition alertDefinition = new AlertDefinition();
        alertDefinition.setName(adr.getName());
        alertDefinition.setEnabled(adr.isEnabled());
        if (adr.getPriority() == null) {
            adr.setPriority("LOW");
        }
        alertDefinition.setPriority(AlertPriority.valueOf((String)adr.getPriority().toUpperCase()));
        alertDefinition.setConditionExpression(BooleanExpression.valueOf((String)adr.getConditionMode().toUpperCase()));
        alertDefinition.setRecoveryId(Integer.valueOf(adr.getRecoveryId()));
        if (groupId != null) {
            ResourceGroup group = this.resourceGroupMgr.getResourceGroup(this.caller, groupId);
            alertDefinition.setResourceGroup(group);
        }
        if (resourceTypeId != null) {
            ResourceType type = this.resourceTypeMgr.getResourceTypeById(this.caller, resourceTypeId);
            alertDefinition.setResourceType(type);
        }
        HashSet<AlertCondition> conditions = new HashSet<AlertCondition>(adr.getConditions().size());
        for (AlertConditionRest acr : adr.getConditions()) {
            AlertCondition condition = this.conditionRestToCondition(acr);
            conditions.add(condition);
        }
        alertDefinition.setConditions(conditions);
        ArrayList<AlertNotification> notifications = new ArrayList<AlertNotification>(adr.getNotifications().size());
        AlertSenderPluginManager pluginManager = this.alertManager.getAlertPluginManager();
        for (AlertNotificationRest anr : adr.getNotifications()) {
            AlertNotification notification = this.notificationRestToNotification(alertDefinition, anr);
            if (pluginManager.getAlertSenderForNotification(notification) == null) {
                throw new StuffNotFoundException("AlertSender with name [" + anr.getSenderName() + "]");
            }
            notifications.add(notification);
        }
        alertDefinition.setAlertNotifications(notifications);
        this.setDampeningFromRest(alertDefinition, adr);
        if (adr.getRecoveryId() > 0 && (recoveryDef = this.alertDefinitionManager.getAlertDefinition(this.caller, adr.getRecoveryId())) != null) {
            alertDefinition.setRecoveryId(Integer.valueOf(adr.getRecoveryId()));
        }
        int definitionId = this.alertDefinitionManager.createAlertDefinition(this.caller, alertDefinition, resourceId, false);
        AlertDefinition updatedDefinition = this.alertDefinitionManager.getAlertDefinition(this.caller, definitionId);
        AlertDefinitionRest uadr = this.definitionToDomain(updatedDefinition, true);
        uadr.setId(definitionId);
        UriBuilder uriBuilder = uriInfo.getBaseUriBuilder();
        uriBuilder.path("/alert/definition/{id}");
        URI uri = uriBuilder.build(new Object[]{definitionId});
        Response.ResponseBuilder builder = Response.created((URI)uri);
        builder.entity((Object)uadr);
        return builder.build();
    }

    @PUT
    @Path(value="/definition/{id}")
    @ApiOperation(value="Update the alert definition (priority, enablement, dampening, recovery)", notes="Priority must be HIGH,LOW,MEDIUM. If not provided, LOW is assumed.")
    @ApiError(code=404, reason="No AlertDefinition with the passed id exists")
    public Response updateDefinition(@ApiParam(value="Id of the alert definition to update") @PathParam(value="id") int definitionId, @ApiParam(value="Data for the update") AlertDefinitionRest definitionRest) {
        AlertDefinition recoveryDef;
        AlertDefinition definition = this.alertDefinitionManager.getAlertDefinition(this.caller, definitionId);
        if (definition == null) {
            throw new StuffNotFoundException("AlertDefinition with id " + definitionId);
        }
        definition = new AlertDefinition(definition);
        definition.setEnabled(definitionRest.isEnabled());
        if (definitionRest.getPriority() != null) {
            definition.setPriority(AlertPriority.valueOf((String)definitionRest.getPriority()));
        } else {
            definition.setPriority(AlertPriority.LOW);
        }
        this.setDampeningFromRest(definition, definitionRest);
        if (definitionRest.getRecoveryId() > 0 && (recoveryDef = this.alertDefinitionManager.getAlertDefinition(this.caller, definitionRest.getRecoveryId())) != null) {
            definition.setRecoveryId(Integer.valueOf(definitionRest.getRecoveryId()));
        }
        definition = this.alertDefinitionManager.updateAlertDefinitionInternal(this.caller, definitionId, definition, true, true, true);
        this.entityManager.flush();
        EntityTag eTag = new EntityTag(Integer.toHexString(definition.hashCode()));
        AlertDefinitionRest adr = this.definitionToDomain(definition, false);
        Response.ResponseBuilder builder = Response.ok((Object)adr);
        builder.tag(eTag);
        return builder.build();
    }

    @DELETE
    @Path(value="definition/{id}")
    @ApiOperation(value="Delete an alert definition")
    public Response deleteDefinition(@ApiParam(value="Id of the definition to delete") @PathParam(value="id") int definitionId) {
        this.alertDefinitionManager.removeAlertDefinitions(this.caller, new int[]{definitionId});
        return Response.noContent().build();
    }

    private void setDampeningFromRest(AlertDefinition alertDefinition, AlertDefinitionRest adr) {
        int num;
        String tmp;
        AlertDampening.Category dampeningCategory;
        try {
            dampeningCategory = AlertDampening.Category.valueOf((String)adr.getDampeningCategory());
        }
        catch (Exception e) {
            AlertDampening.Category[] vals = AlertDampening.Category.values();
            StringBuilder builder = new StringBuilder();
            for (int i = 0; i < vals.length; ++i) {
                builder.append(vals[i].name());
                if (i >= vals.length - 1) continue;
                builder.append(", ");
            }
            throw new BadArgumentException("dampening category", "Allowed values are: " + builder.toString());
        }
        AlertDampening dampening = new AlertDampening(dampeningCategory);
        if (adr.getDampeningCount() != null) {
            if (adr.getDampeningCount().contains(" ")) {
                tmp = adr.getDampeningCount().trim();
                num = Integer.parseInt(tmp.substring(0, tmp.indexOf(32)));
                tmp = tmp.substring(tmp.lastIndexOf(32)).trim();
                dampening.setValue(num);
                dampening.setValueUnits(AlertDampening.TimeUnits.valueOf((String)tmp.toUpperCase()));
            } else {
                dampening.setValue(Integer.parseInt(adr.getDampeningCount()));
            }
        }
        if (adr.getDampeningPeriod() != null) {
            if (adr.getDampeningPeriod().contains(" ")) {
                tmp = adr.getDampeningPeriod().trim();
                num = Integer.parseInt(tmp.substring(0, tmp.indexOf(32)));
                tmp = tmp.substring(tmp.lastIndexOf(32)).trim();
                dampening.setPeriod(num);
                dampening.setPeriodUnits(AlertDampening.TimeUnits.valueOf((String)tmp.toUpperCase()));
            } else {
                dampening.setPeriod(Integer.parseInt(adr.getDampeningPeriod()));
            }
        }
        alertDefinition.setAlertDampening(dampening);
    }

    private AlertNotification notificationRestToNotification(AlertDefinition alertDefinition, AlertNotificationRest anr) {
        AlertNotification notification = new AlertNotification(anr.getSenderName());
        notification.setAlertDefinition(alertDefinition);
        Configuration configuration = new Configuration();
        for (Map.Entry<String, Object> entry : anr.getConfig().entrySet()) {
            configuration.put((Property)new PropertySimple(entry.getKey(), entry.getValue()));
        }
        notification.setConfiguration(configuration);
        return notification;
    }

    @POST
    @Path(value="definition/{id}/conditions")
    @ApiOperation(value="Add a new alert condition to an existing alert definition")
    @ApiError(code=404, reason="No AlertDefinition with the passed id exists")
    public Response addConditionToDefinition(@ApiParam(value="The id of the alert definition") @PathParam(value="id") int definitionId, @ApiParam(value="The condition to add") AlertConditionRest conditionRest, @Context UriInfo uriInfo) {
        AlertDefinition definition = this.alertDefinitionManager.getAlertDefinition(this.caller, definitionId);
        if (definition == null) {
            throw new StuffNotFoundException("AlertDefinition with id " + definitionId);
        }
        AlertCondition condition = this.conditionRestToCondition(conditionRest);
        definition.addCondition(condition);
        this.alertDefinitionManager.updateAlertDefinition(this.caller, definitionId, definition, false);
        Response.ResponseBuilder builder = this.getResponseBuilderForCondition(definitionId, uriInfo, condition, true);
        return builder.build();
    }

    @DELETE
    @Path(value="condition/{cid}")
    @ApiOperation(value="Remove an alert condition")
    public Response deleteCondition(@ApiParam(value="The id of the condition to remove") @PathParam(value="cid") int conditionId) {
        Integer definitionId;
        try {
            definitionId = this.findDefinitionIdForConditionId(conditionId);
        }
        catch (NoResultException nre) {
            return Response.noContent().build();
        }
        AlertDefinition definition2 = (AlertDefinition)this.entityManager.find(AlertDefinition.class, (Object)definitionId);
        AlertCondition condition = null;
        for (AlertCondition c : definition2.getConditions()) {
            if (c.getId() != conditionId) continue;
            condition = c;
        }
        definition2.getConditions().remove(condition);
        this.alertDefinitionManager.updateAlertDefinition(this.caller, definitionId, definition2, true);
        return Response.noContent().build();
    }

    private Integer findDefinitionIdForConditionId(int conditionId) {
        Query q = this.entityManager.createQuery("SELECT condition.alertDefinition.id FROM AlertCondition condition WHERE condition.id = :id ");
        q.setParameter("id", (Object)conditionId);
        Object o = q.getSingleResult();
        return (Integer)o;
    }

    @PUT
    @Path(value="condition/{cid}")
    @ApiOperation(value="Update an existing condition of an alert definition.Note that the update will change the id of the condition")
    @ApiError(code=404, reason="Condition with passed id does not exist")
    public Response updateCondition(@ApiParam(value="The id of the condition to update") @PathParam(value="cid") int conditionId, @ApiParam(value="The updated condition") AlertConditionRest conditionRest, @Context UriInfo uriInfo) {
        Integer definitionId;
        try {
            definitionId = this.findDefinitionIdForConditionId(conditionId);
        }
        catch (NoResultException nre) {
            throw new StuffNotFoundException("Condition with id " + conditionId);
        }
        AlertDefinition definition = (AlertDefinition)this.entityManager.find(AlertDefinition.class, (Object)definitionId);
        AlertCondition condition = null;
        Iterator iterator = definition.getConditions().iterator();
        while (iterator.hasNext()) {
            AlertCondition oldCondition = (AlertCondition)iterator.next();
            if (oldCondition.getId() != conditionId) continue;
            condition = new AlertCondition(oldCondition);
            oldCondition.setAlertDefinition(null);
            iterator.remove();
            this.entityManager.remove((Object)oldCondition);
        }
        AlertCondition restCondition = this.conditionRestToCondition(conditionRest);
        condition.setOption(conditionRest.getOption());
        condition.setComparator(conditionRest.getComparator());
        condition.setMeasurementDefinition(restCondition.getMeasurementDefinition());
        condition.setThreshold(conditionRest.getThreshold());
        condition.setTriggerId(conditionRest.getTriggerId());
        definition.getConditions().add(condition);
        this.alertDefinitionManager.updateAlertDefinitionInternal(this.caller, definitionId, definition, true, true, true);
        this.entityManager.flush();
        Response.ResponseBuilder builder = this.getResponseBuilderForCondition(definitionId, uriInfo, condition, false);
        return builder.build();
    }

    @GET
    @Path(value="condition/{cid}")
    @ApiOperation(value="Retrieve a condition of an alert definition by its condition id")
    @ApiError(code=404, reason="No condition with the passed id exists")
    public Response getCondition(@ApiParam(value="The id of the condition to retrieve") @PathParam(value="cid") int conditionId) {
        AlertCondition condition = this.conditionMgr.getAlertConditionById(conditionId);
        if (condition == null) {
            throw new StuffNotFoundException("No condition with id " + conditionId);
        }
        AlertConditionRest acr = this.conditionToConditionRest(condition);
        return Response.ok((Object)acr).build();
    }

    private AlertCondition conditionRestToCondition(AlertConditionRest conditionRest) {
        AlertCondition condition = new AlertCondition();
        condition.setName(conditionRest.getName().name());
        condition.setCategory(AlertConditionCategory.valueOf((String)conditionRest.getCategory().getName()));
        condition.setOption(conditionRest.getOption());
        condition.setComparator(conditionRest.getComparator());
        MeasurementDefinition md = (MeasurementDefinition)this.entityManager.find(MeasurementDefinition.class, (Object)conditionRest.getMeasurementDefinition());
        condition.setMeasurementDefinition(md);
        condition.setThreshold(conditionRest.getThreshold());
        condition.setTriggerId(conditionRest.getTriggerId());
        return condition;
    }

    private Response.ResponseBuilder getResponseBuilderForCondition(int definitionId, UriInfo uriInfo, AlertCondition originalCondition, boolean isCreate) {
        Response.ResponseBuilder builder;
        AlertDefinition updatedDefinition = this.alertDefinitionManager.getAlertDefinition(this.caller, definitionId);
        Set conditions = updatedDefinition.getConditions();
        int conditionId = -1;
        AlertCondition createdCondition = null;
        for (AlertCondition cond : conditions) {
            if (!cond.getName().equals(originalCondition.getName())) continue;
            conditionId = cond.getId();
            createdCondition = cond;
        }
        UriBuilder uriBuilder = uriInfo.getBaseUriBuilder();
        uriBuilder.path("/alert/condition/{cid}");
        URI uri = uriBuilder.build(new Object[]{conditionId});
        AlertConditionRest result = this.conditionToConditionRest(createdCondition);
        if (isCreate) {
            builder = Response.created((URI)uri);
        } else {
            builder = Response.ok();
            builder.location(uri);
        }
        builder.entity((Object)result);
        return builder;
    }

    @GET
    @Path(value="notification/{nid}")
    @ApiOperation(value="Return a notification definition by its id")
    @ApiError(code=404, reason="No notification with the passed id found")
    public Response getNotification(@ApiParam(value="The id of the notification definition to retrieve") @PathParam(value="nid") int notificationId) {
        AlertNotification notification = this.notificationMgr.getAlertNotification(this.caller, notificationId);
        if (notification == null) {
            throw new StuffNotFoundException("No notification with id " + notificationId);
        }
        AlertNotificationRest anr = this.notificationToNotificationRest(notification);
        return Response.ok((Object)anr).build();
    }

    @DELETE
    @Path(value="notification/{nid}")
    @ApiOperation(value="Remove a notification definition")
    public Response deleteNotification(@ApiParam(value="The id of the notification definition to remove") @PathParam(value="nid") int notificationId) {
        AlertNotification notification = this.notificationMgr.getAlertNotification(this.caller, notificationId);
        if (notification != null) {
            AlertDefinition definition = this.alertDefinitionManager.getAlertDefinition(this.caller, notification.getAlertDefinition().getId());
            definition.getAlertNotifications().remove(notification);
            this.alertDefinitionManager.updateAlertDefinitionInternal(this.caller, definition.getId(), definition, true, true, true);
            this.entityManager.flush();
        }
        return Response.noContent().build();
    }

    @PUT
    @Path(value="notification/{nid}")
    @ApiOperation(value="Update a notification definition")
    @ApiError(code=404, reason="There is no notification with the passed id")
    public Response updateNotification(@ApiParam(value="The id of the notification definition to update") @PathParam(value="nid") int notificationId, @ApiParam(value="The updated notification definition to use") AlertNotificationRest notificationRest) {
        AlertNotification notification = this.notificationMgr.getAlertNotification(this.caller, notificationId);
        if (notification == null) {
            throw new StuffNotFoundException("No notification with id " + notificationId);
        }
        AlertDefinition definition = this.alertDefinitionManager.getAlertDefinition(this.caller, notification.getAlertDefinition().getId());
        AlertNotification newNotif = this.notificationRestToNotification(definition, notificationRest);
        notification.setConfiguration(newNotif.getConfiguration());
        notification.setExtraConfiguration(newNotif.getExtraConfiguration());
        this.alertDefinitionManager.updateAlertDefinitionInternal(this.caller, definition.getId(), definition, true, true, true);
        this.entityManager.flush();
        List notifications = definition.getAlertNotifications();
        int newNotifId = 0;
        for (AlertNotification n : notifications) {
            if (!n.getSenderName().equals(notification.getSenderName())) continue;
            newNotifId = n.getId();
        }
        AlertNotification result = this.notificationMgr.getAlertNotification(this.caller, newNotifId);
        AlertNotificationRest resultRest = this.notificationToNotificationRest(result);
        return Response.ok((Object)resultRest).build();
    }

    @POST
    @Path(value="definition/{id}/notifications")
    @ApiOperation(value="Add a new notification definition to an alert definition")
    @ApiErrors(value={@ApiError(code=404, reason="Requested alert notification sender does not exist"), @ApiError(code=404, reason="There is no alert definition with the passed id")})
    public Response addNotificationToDefinition(@ApiParam(value="Id of the alert definition that should get the notification definition") @PathParam(value="id") int definitionId, @ApiParam(value="The notification definition to add") AlertNotificationRest notificationRest, @Context UriInfo uriInfo) {
        AlertNotification notification = new AlertNotification(notificationRest.getSenderName());
        AlertSenderPluginManager pluginManager = this.alertManager.getAlertPluginManager();
        if (pluginManager.getAlertSenderForNotification(notification) == null) {
            throw new StuffNotFoundException("AlertSender with name [" + notificationRest.getSenderName() + "]");
        }
        AlertDefinition definition = this.alertDefinitionManager.getAlertDefinition(this.caller, definitionId);
        if (definition == null) {
            throw new StuffNotFoundException("AlertDefinition with id " + definitionId);
        }
        int existingNotificationCount = definition.getAlertNotifications().size();
        definition.addAlertNotification(notification);
        Configuration configuration = new Configuration();
        for (Map.Entry<String, Object> entry : notificationRest.getConfig().entrySet()) {
            configuration.put((Property)new PropertySimple(entry.getKey(), entry.getValue()));
        }
        notification.setConfiguration(configuration);
        this.alertDefinitionManager.updateAlertDefinitionInternal(this.caller, definitionId, definition, false, true, true);
        this.alertDefinitionManager.getAlertDefinition(this.caller, definitionId);
        this.entityManager.flush();
        AlertDefinition updatedDefinition = this.alertDefinitionManager.getAlertDefinitionById(this.caller, definitionId);
        List notifs = updatedDefinition.getAlertNotifications();
        assert (notifs.size() == existingNotificationCount + 1);
        AlertNotification updatedNotification = (AlertNotification)notifs.get(existingNotificationCount);
        AlertNotificationRest updatedNotificationRest = this.notificationToNotificationRest(updatedNotification);
        int notificationId = updatedNotification.getId();
        UriBuilder uriBuilder = uriInfo.getBaseUriBuilder();
        uriBuilder.path("/alert/notification/{nid}");
        URI uri = uriBuilder.build(new Object[]{notificationId});
        Response.ResponseBuilder builder = Response.created((URI)uri);
        builder.entity((Object)updatedNotificationRest);
        return builder.build();
    }

    @Produces(value={"application/json", "application/xml"})
    @ApiOperation(value="Return a list of alert notification senders with a short description. The list does not include the configuration definition.")
    @GET
    @GZIP
    @Path(value="senders")
    public Response getAlertSenders(@Context UriInfo uriInfo) {
        List<String> senderNames = this.notificationMgr.listAllAlertSenders();
        ArrayList<AlertSender> senderList = new ArrayList<AlertSender>(senderNames.size());
        for (String senderName : senderNames) {
            AlertSenderInfo info = this.notificationMgr.getAlertInfoForSender(senderName);
            AlertSender sender = new AlertSender(senderName);
            sender.setDescription(info.getDescription());
            UriBuilder uriBuilder = uriInfo.getBaseUriBuilder();
            uriBuilder.path("/alert/sender/{name}");
            URI uri = uriBuilder.build(new Object[]{sender.getSenderName()});
            Link self = new Link("self", uri.toString());
            sender.setLink(self);
            senderList.add(sender);
        }
        GenericEntity<List<AlertSender>> entity = new GenericEntity<List<AlertSender>>(senderList){};
        Response.ResponseBuilder builder = Response.ok((Object)entity);
        return builder.build();
    }

    @Produces(value={"application/json", "application/xml"})
    @ApiOperation(value="Return an alert notification sender by name. This includes information about the configuration it expects")
    @GET
    @GZIP
    @Path(value="sender/{name}")
    @ApiError(code=404, reason="There is no sender with the passed name")
    public Response getAlertSenderByName(@ApiParam(value="Name of the sender to retrieve") @PathParam(value="name") String senderName, @Context UriInfo uriInfo) {
        AlertSenderInfo info = this.notificationMgr.getAlertInfoForSender(senderName);
        if (info == null) {
            throw new StuffNotFoundException("Alert sender with name [" + senderName + "]");
        }
        AlertSender sender = new AlertSender(senderName);
        sender.setDescription(info.getDescription());
        ConfigurationDefinition definition = this.notificationMgr.getConfigurationDefinitionForSender(senderName);
        for (PropertyDefinition pd : definition.getPropertyDefinitions().values()) {
            if (pd instanceof PropertyDefinitionSimple) {
                PropertyDefinitionSimple pds = (PropertyDefinitionSimple)pd;
                sender.getConfigDefinition().put(pds.getName(), pds.getType().name());
                continue;
            }
            this.log.warn((Object)("Property " + pd.getName() + " for sender " + senderName + " is not of a supported type"));
        }
        UriBuilder uriBuilder = uriInfo.getBaseUriBuilder();
        uriBuilder.path("/alert/sender/{name}");
        URI uri = uriBuilder.build(new Object[]{sender.getSenderName()});
        Link self = new Link("self", uri.toString());
        sender.setLink(self);
        Response.ResponseBuilder builder = Response.ok((Object)sender);
        return builder.build();
    }

    AlertDefinitionRest definitionToDomain(AlertDefinition def, boolean full) {
        AlertDefinitionRest adr = new AlertDefinitionRest(def.getId());
        adr.setName(def.getName());
        adr.setEnabled(def.getEnabled());
        adr.setPriority(def.getPriority().getName());
        adr.setConditionMode(def.getConditionExpression().toString());
        adr.setRecoveryId(def.getRecoveryId());
        if (full) {
            List notifications;
            Set conditions = def.getConditions();
            if (conditions.size() > 0) {
                ArrayList<AlertConditionRest> conditionRestList = new ArrayList<AlertConditionRest>(conditions.size());
                for (AlertCondition condition : conditions) {
                    AlertConditionRest acr = this.conditionToConditionRest(condition);
                    conditionRestList.add(acr);
                }
                adr.setConditions(conditionRestList);
            }
            if ((notifications = def.getAlertNotifications()).size() > 0) {
                ArrayList<AlertNotificationRest> notificationRestList = new ArrayList<AlertNotificationRest>(notifications.size());
                for (AlertNotification notification : notifications) {
                    AlertNotificationRest anr = this.notificationToNotificationRest(notification);
                    notificationRestList.add(anr);
                }
                adr.setNotifications(notificationRestList);
            }
        }
        AlertDampening dampening = def.getAlertDampening();
        adr.setDampeningCategory(dampening.getCategory().name());
        AlertDampening.TimeUnits units = dampening.getValueUnits();
        String s = units != null ? " " + units.name() : "";
        adr.setDampeningCount(dampening.getValue() + s);
        units = dampening.getPeriodUnits();
        s = units != null ? " " + units.name() : "";
        adr.setDampeningPeriod(dampening.getPeriod() + s);
        return adr;
    }

    private AlertNotificationRest notificationToNotificationRest(AlertNotification notification) {
        AlertNotificationRest anr = new AlertNotificationRest();
        anr.setId(notification.getId());
        anr.setSenderName(notification.getSenderName());
        for (Map.Entry entry : notification.getConfiguration().getSimpleProperties().entrySet()) {
            anr.getConfig().put((String)entry.getKey(), ((PropertySimple)entry.getValue()).getStringValue());
        }
        return anr;
    }

    private AlertConditionRest conditionToConditionRest(AlertCondition condition) {
        AlertConditionRest acr = new AlertConditionRest();
        acr.setId(condition.getId());
        acr.setName(AlertConditionOperator.valueOf((String)condition.getName()));
        acr.setCategory(condition.getCategory());
        acr.setOption(condition.getOption());
        acr.setComparator(condition.getComparator());
        acr.setMeasurementDefinition(condition.getMeasurementDefinition() == null ? 0 : condition.getMeasurementDefinition().getId());
        acr.setThreshold(condition.getThreshold());
        acr.setTriggerId(condition.getTriggerId());
        return acr;
    }
}

