/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.rest;

import com.wordnik.swagger.annotations.Api;
import com.wordnik.swagger.annotations.ApiError;
import com.wordnik.swagger.annotations.ApiErrors;
import com.wordnik.swagger.annotations.ApiOperation;
import com.wordnik.swagger.annotations.ApiParam;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.ejb.EJB;
import javax.ejb.Stateless;
import javax.interceptor.Interceptors;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.EntityTag;
import javax.ws.rs.core.GenericEntity;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Request;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriInfo;
import org.jboss.resteasy.annotations.GZIP;
import org.jboss.resteasy.annotations.cache.Cache;
import org.rhq.core.domain.alert.Alert;
import org.rhq.core.domain.alert.AlertCondition;
import org.rhq.core.domain.alert.AlertConditionLog;
import org.rhq.core.domain.alert.AlertDefinition;
import org.rhq.core.domain.alert.AlertPriority;
import org.rhq.core.domain.alert.notification.AlertNotificationLog;
import org.rhq.core.domain.criteria.AlertCriteria;
import org.rhq.core.domain.criteria.Criteria;
import org.rhq.core.domain.resource.Resource;
import org.rhq.core.domain.util.PageControl;
import org.rhq.core.domain.util.PageList;
import org.rhq.core.domain.util.PageOrdering;
import org.rhq.enterprise.server.alert.AlertManagerLocal;
import org.rhq.enterprise.server.rest.AbstractRestBean;
import org.rhq.enterprise.server.rest.AlertDefinitionHandlerBean;
import org.rhq.enterprise.server.rest.BadArgumentException;
import org.rhq.enterprise.server.rest.SetCallerInterceptor;
import org.rhq.enterprise.server.rest.StuffNotFoundException;
import org.rhq.enterprise.server.rest.domain.AlertDefinitionRest;
import org.rhq.enterprise.server.rest.domain.AlertRest;
import org.rhq.enterprise.server.rest.domain.IntegerValue;
import org.rhq.enterprise.server.rest.domain.Link;
import org.rhq.enterprise.server.rest.domain.ResourceWithType;
import org.rhq.enterprise.server.rest.domain.StringValue;

@Produces(value={"application/json", "application/xml", "text/html"})
@Path(value="/alert")
@Api(value="Deal with Alerts", description="This api deals with alerts that have fired.")
@Stateless
@Interceptors(value={SetCallerInterceptor.class})
public class AlertHandlerBean
extends AbstractRestBean {
    @EJB
    AlertManagerLocal alertManager;

    @GZIP
    @GET
    @Path(value="/")
    @ApiOperation(value="List all alerts, possibly limiting by resource or alert definition, priority and start time", multiValueResponse=true, responseClass="List<AlertRest>")
    @ApiErrors(value={@ApiError(code=406, reason="There are 'resourceId' and 'definitionId' passed as query parameters"), @ApiError(code=406, reason="Page size was 0"), @ApiError(code=406, reason="Page number was < 1")})
    public Response listAlerts(@ApiParam(value="Page number") @QueryParam(value="page") @DefaultValue(value="1") int page, @ApiParam(value="Page size; use -1 for 'unlimited'") @QueryParam(value="size") @DefaultValue(value="100") int size, @ApiParam(value="Limit to priority", allowableValues="High, Medium, Low, All") @DefaultValue(value="All") @QueryParam(value="prio") String prio, @ApiParam(value="Should full resources and definitions be sent") @QueryParam(value="slim") @DefaultValue(value="false") boolean slim, @ApiParam(value="If non-null only send alerts that have fired after this time, time is millisecond since epoch") @QueryParam(value="since") Long since, @ApiParam(value="Id of a resource to limit search for") @QueryParam(value="resourceId") Integer resourceId, @ApiParam(value="If of an alert definition to search for") @QueryParam(value="definitionId") Integer definitionId, @Context UriInfo uriInfo, @Context HttpHeaders headers) {
        Response.ResponseBuilder builder;
        if (resourceId != null && definitionId != null) {
            throw new BadArgumentException("At most one of 'resourceId' and 'definitionId' may be given");
        }
        if (size == 0) {
            throw new BadArgumentException("size", "Must not be 0");
        }
        if (page < 1) {
            throw new BadArgumentException("page", "Must be >=1");
        }
        AlertCriteria criteria = new AlertCriteria();
        if (size == -1) {
            PageControl pageControl = PageControl.getUnlimitedInstance();
            pageControl.setPageNumber(page);
            criteria.setPageControl(pageControl);
        } else {
            criteria.setPaging(page - 1, size);
        }
        if (since != null) {
            criteria.addFilterStartTime(since);
        }
        if (resourceId != null) {
            criteria.addFilterResourceIds(new Integer[]{resourceId});
        }
        if (definitionId != null) {
            criteria.addFilterAlertDefinitionIds(new Integer[]{definitionId});
        }
        if (!prio.equals("All")) {
            AlertPriority alertPriority = AlertPriority.valueOf((String)prio.toUpperCase());
            criteria.addFilterPriorities(new AlertPriority[]{alertPriority});
        }
        criteria.addSortCtime(PageOrdering.DESC);
        PageList<Alert> alerts = this.alertManager.findAlertsByCriteria(this.caller, criteria);
        ArrayList<AlertRest> ret = new ArrayList<AlertRest>(alerts.size());
        for (Alert al : alerts) {
            AlertRest ar = this.alertToDomain(al, uriInfo, slim);
            ret.add(ar);
        }
        MediaType type = (MediaType)headers.getAcceptableMediaTypes().get(0);
        if (type.equals((Object)MediaType.TEXT_HTML_TYPE)) {
            builder = Response.ok((Object)this.renderTemplate("listAlerts.ftl", ret), (MediaType)type);
        } else {
            GenericEntity<List<AlertRest>> entity = new GenericEntity<List<AlertRest>>(ret){};
            builder = Response.ok((Object)entity);
        }
        return builder.build();
    }

    @GET
    @Path(value="count")
    @ApiOperation(value="Return a count of alerts in the system depending on criteria")
    public IntegerValue countAlerts(@ApiParam(value="If non-null only send alerts that have fired after this time, time is millisecond since epoch") @QueryParam(value="since") Long since) {
        AlertCriteria criteria = new AlertCriteria();
        criteria.setPageControl(PageControl.getUnlimitedInstance());
        criteria.fetchAlertDefinition(false);
        criteria.fetchConditionLogs(false);
        criteria.fetchRecoveryAlertDefinition(false);
        criteria.fetchNotificationLogs(false);
        criteria.setRestriction(Criteria.Restriction.COUNT_ONLY);
        if (since != null) {
            criteria.addFilterStartTime(since);
        }
        PageList<Alert> alerts = this.alertManager.findAlertsByCriteria(this.caller, criteria);
        int count = alerts.getTotalSize();
        return new IntegerValue(count);
    }

    @GET
    @Cache(maxAge=60)
    @Path(value="/{id}")
    @ApiOperation(value="Get one alert with the passed id", responseClass="AlertRest")
    public Response getAlert(@ApiParam(value="Id of the alert to retrieve") @PathParam(value="id") int id, @ApiParam(value="Should full resources and definitions be sent") @QueryParam(value="slim") @DefaultValue(value="false") boolean slim, @Context UriInfo uriInfo, @Context Request request, @Context HttpHeaders headers) {
        Alert al = this.findAlertWithId(id);
        MediaType type = (MediaType)headers.getAcceptableMediaTypes().get(0);
        EntityTag eTag = new EntityTag(Integer.toHexString(al.hashCode()));
        Response.ResponseBuilder builder = request.evaluatePreconditions(eTag);
        if (builder == null) {
            AlertRest ar = this.alertToDomain(al, uriInfo, slim);
            builder = type.equals((Object)MediaType.TEXT_HTML_TYPE) ? Response.ok((Object)this.renderTemplate("alert.ftl", ar), (MediaType)type) : Response.ok((Object)ar);
        }
        builder.tag(eTag);
        return builder.build();
    }

    @GET
    @Path(value="/{id}/conditions")
    @Cache(maxAge=300)
    @ApiOperation(value="Return the condition logs for the given alert")
    public Response getConditionLogs(@ApiParam(value="Id of the alert to retrieve") @PathParam(value="id") int id, @Context Request request, @Context UriInfo uriInfo, @Context HttpHeaders headers) {
        Response.ResponseBuilder builder;
        Alert al = this.findAlertWithId(id);
        Set conditions = al.getConditionLogs();
        MediaType type = (MediaType)headers.getAcceptableMediaTypes().get(0);
        if (type.equals((Object)MediaType.APPLICATION_XML_TYPE)) {
            ArrayList<StringValue> result = new ArrayList<StringValue>(conditions.size());
            for (AlertConditionLog log : conditions) {
                AlertCondition condition = log.getCondition();
                String entry = String.format("category='%s', name='%s', comparator='%s', threshold='%s', option='%s' : %s", condition.getCategory(), condition.getName(), condition.getComparator(), condition.getThreshold(), condition.getOption(), log.getValue());
                StringValue sv = new StringValue(entry);
                result.add(sv);
            }
            GenericEntity<List<StringValue>> entity = new GenericEntity<List<StringValue>>(result){};
            builder = Response.ok((Object)entity);
        } else {
            ArrayList<String> result = new ArrayList<String>(conditions.size());
            for (AlertConditionLog log : conditions) {
                AlertCondition condition = log.getCondition();
                String entry = String.format("category='%s', name='%s', comparator='%s', threshold='%s', option='%s' : %s", condition.getCategory(), condition.getName(), condition.getComparator(), condition.getThreshold(), condition.getOption(), log.getValue());
                result.add(entry);
            }
            builder = type.equals((Object)MediaType.TEXT_HTML_TYPE) ? Response.ok((Object)this.renderTemplate("genericStringList.ftl", result), (MediaType)type) : Response.ok(result);
        }
        return builder.build();
    }

    @GET
    @Path(value="/{id}/notifications")
    @Cache(maxAge=60)
    @ApiOperation(value="Return the notification logs for the given alert")
    public Response getNotificationLogs(@ApiParam(value="Id of the alert to retrieve") @PathParam(value="id") int id, @Context Request request, @Context UriInfo uriInfo, @Context HttpHeaders headers) {
        Response.ResponseBuilder builder;
        Alert al = this.findAlertWithId(id);
        MediaType type = (MediaType)headers.getAcceptableMediaTypes().get(0);
        List notifications = al.getAlertNotificationLogs();
        if (type.equals((Object)MediaType.APPLICATION_XML_TYPE)) {
            ArrayList<StringValue> result = new ArrayList<StringValue>(notifications.size());
            for (AlertNotificationLog log : notifications) {
                String entry = log.getSender() + ": " + log.getResultState() + ": " + log.getMessage();
                StringValue sv = new StringValue(entry);
                result.add(sv);
            }
            GenericEntity<List<StringValue>> entity = new GenericEntity<List<StringValue>>(result){};
            builder = Response.ok((Object)entity);
        } else {
            ArrayList<String> result = new ArrayList<String>(notifications.size());
            for (AlertNotificationLog log : notifications) {
                String entry = log.getSender() + ": " + log.getResultState() + ": " + log.getMessage();
                result.add(entry);
            }
            builder = type.equals((Object)MediaType.TEXT_HTML_TYPE) ? Response.ok((Object)this.renderTemplate("genericStringList.ftl", result), (MediaType)type) : Response.ok(result);
        }
        return builder.build();
    }

    @PUT
    @Path(value="/{id}")
    @ApiOperation(value="Mark the alert as acknowledged (by the caller)", notes="Returns a slim version of the alert")
    public AlertRest ackAlert(@ApiParam(value="Id of the alert to acknowledge") @PathParam(value="id") int id, @Context UriInfo uriInfo) {
        this.findAlertWithId(id);
        int count = this.alertManager.acknowledgeAlerts(this.caller, new int[]{id});
        Alert al = this.findAlertWithId(id);
        AlertRest ar = this.alertToDomain(al, uriInfo, true);
        return ar;
    }

    @DELETE
    @Path(value="/{id}")
    @ApiOperation(value="Remove the alert from the lit of alerts")
    public void purgeAlert(@ApiParam(value="Id of the alert to remove") @PathParam(value="id") int id) {
        this.alertManager.deleteAlerts(this.caller, new int[]{id});
    }

    @GET
    @Cache(maxAge=300)
    @Path(value="/{id}/definition")
    @ApiOperation(value="Get the alert definition (basics) for the alert")
    public AlertDefinitionRest getDefinitionForAlert(@ApiParam(value="Id of the alert to show the definition") @PathParam(value="id") int alertId) {
        Alert al = this.findAlertWithId(alertId);
        AlertDefinition def = al.getAlertDefinition();
        AlertDefinitionHandlerBean adhb = new AlertDefinitionHandlerBean();
        AlertDefinitionRest ret = adhb.definitionToDomain(def, false);
        return ret;
    }

    private Alert findAlertWithId(int id) {
        AlertCriteria criteria = new AlertCriteria();
        criteria.addFilterId(Integer.valueOf(id));
        PageList<Alert> alerts = this.alertManager.findAlertsByCriteria(this.caller, criteria);
        if (alerts.isEmpty()) {
            throw new StuffNotFoundException("Alert with id " + id);
        }
        return (Alert)alerts.get(0);
    }

    public AlertRest alertToDomain(Alert al, UriInfo uriInfo, boolean slim) {
        AlertDefinitionRest alertDefinitionRest;
        AlertRest ret = new AlertRest();
        ret.setId(al.getId());
        AlertDefinition alertDefinition = al.getAlertDefinition();
        ret.setName(alertDefinition.getName());
        if (slim) {
            alertDefinitionRest = new AlertDefinitionRest(alertDefinition.getId());
        } else {
            AlertDefinitionHandlerBean adhb = new AlertDefinitionHandlerBean();
            alertDefinitionRest = adhb.definitionToDomain(alertDefinition, false);
        }
        ret.setAlertDefinition(alertDefinitionRest);
        ret.setDefinitionEnabled(alertDefinition.getEnabled());
        if (al.getAcknowledgingSubject() != null) {
            ret.setAckBy(al.getAcknowledgingSubject());
            ret.setAckTime(al.getAcknowledgeTime());
        }
        ret.setAlertTime(al.getCtime());
        ret.setDescription(this.alertManager.prettyPrintAlertConditions(al, false));
        Resource r = this.fetchResource(alertDefinition.getResource().getId());
        ResourceWithType rwt = slim ? new ResourceWithType(r.getName(), r.getId()) : this.fillRWT(r, uriInfo);
        ret.setResource(rwt);
        UriBuilder builder = uriInfo.getBaseUriBuilder();
        builder.path("/alert/{id}/conditions");
        URI uri = builder.build(new Object[]{al.getId()});
        Link link = new Link("conditions", uri.toString());
        ret.addLink(link);
        builder = uriInfo.getBaseUriBuilder();
        builder.path("/alert/{id}/notifications");
        uri = builder.build(new Object[]{al.getId()});
        link = new Link("notification", uri.toString());
        ret.addLink(link);
        builder = uriInfo.getBaseUriBuilder();
        builder.path("/alert/{id}/definition");
        uri = builder.build(new Object[]{al.getId()});
        link = new Link("definition", uri.toString());
        ret.addLink(link);
        return ret;
    }
}

