/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.rest;

import com.wordnik.swagger.annotations.ApiOperation;
import com.wordnik.swagger.annotations.ApiParam;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.ejb.EJB;
import javax.ejb.Stateless;
import javax.interceptor.Interceptors;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.CacheControl;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.EntityTag;
import javax.ws.rs.core.GenericEntity;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Request;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriInfo;
import org.jboss.resteasy.annotations.GZIP;
import org.jboss.resteasy.annotations.cache.Cache;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.Property;
import org.rhq.core.domain.configuration.PropertySimple;
import org.rhq.core.domain.configuration.definition.ConfigurationDefinition;
import org.rhq.core.domain.configuration.definition.PropertyDefinition;
import org.rhq.core.domain.configuration.definition.PropertyDefinitionSimple;
import org.rhq.core.domain.criteria.ResourceOperationHistoryCriteria;
import org.rhq.core.domain.operation.JobId;
import org.rhq.core.domain.operation.OperationDefinition;
import org.rhq.core.domain.operation.OperationRequestStatus;
import org.rhq.core.domain.operation.ResourceOperationHistory;
import org.rhq.core.domain.operation.bean.ResourceOperationSchedule;
import org.rhq.core.domain.resource.Resource;
import org.rhq.core.domain.resource.ResourceType;
import org.rhq.core.domain.util.PageList;
import org.rhq.core.domain.util.PageOrdering;
import org.rhq.enterprise.server.operation.OperationManagerLocal;
import org.rhq.enterprise.server.resource.ResourceManagerLocal;
import org.rhq.enterprise.server.rest.AbstractRestBean;
import org.rhq.enterprise.server.rest.ParameterMissingException;
import org.rhq.enterprise.server.rest.SetCallerInterceptor;
import org.rhq.enterprise.server.rest.StuffNotFoundException;
import org.rhq.enterprise.server.rest.domain.Link;
import org.rhq.enterprise.server.rest.domain.OperationDefinitionRest;
import org.rhq.enterprise.server.rest.domain.OperationHistoryRest;
import org.rhq.enterprise.server.rest.domain.OperationRest;
import org.rhq.enterprise.server.rest.domain.SimplePropDef;

@Path(value="/operation")
@Produces(value={"application/json", "application/xml"})
@Stateless
@Interceptors(value={SetCallerInterceptor.class})
public class OperationsHandlerBean
extends AbstractRestBean {
    @EJB
    OperationManagerLocal opsManager;
    @EJB
    ResourceManagerLocal resourceManager;

    @GET
    @Path(value="definition/{id}")
    @Cache(maxAge=1200)
    @ApiOperation(value="Retrieve a single operation definition by its id")
    public Response getOperationDefinition(@ApiParam(value="Id of the definition to retrieve") @PathParam(value="id") int definitionId, @ApiParam(value="Id of a resource that supports this operation") @QueryParam(value="resourceId") Integer resourceId, @Context UriInfo uriInfo, @Context Request request, @Context HttpHeaders httpHeaders) {
        EntityTag eTag;
        Response.ResponseBuilder builder;
        OperationDefinition def = this.getFromCache(definitionId, OperationDefinition.class);
        if (def == null) {
            def = this.opsManager.getOperationDefinition(this.caller, definitionId);
            if (def == null) {
                throw new StuffNotFoundException("OperationDefinition with id " + definitionId);
            }
            this.putToCache(definitionId, OperationDefinition.class, def);
        }
        if ((builder = request.evaluatePreconditions(eTag = new EntityTag(Integer.toHexString(def.hashCode())))) == null) {
            OperationDefinitionRest odr = new OperationDefinitionRest();
            odr.setId(def.getId());
            odr.setName(def.getName());
            this.copyParamsForDefinition(def, odr);
            builder = Response.ok((Object)odr);
            if (resourceId != null) {
                UriBuilder uriBuilder = uriInfo.getBaseUriBuilder();
                uriBuilder.path("/operation/definition/{id}");
                uriBuilder.queryParam("resourceId", new Object[]{resourceId});
                Link createLink = new Link("create", uriBuilder.build(new Object[]{definitionId}).toString());
                odr.addLink(createLink);
            }
        }
        builder.tag(eTag);
        return builder.build();
    }

    private void copyParamsForDefinition(OperationDefinition def, OperationDefinitionRest odr) {
        ConfigurationDefinition cd = def.getParametersConfigurationDefinition();
        if (cd == null) {
            return;
        }
        for (Map.Entry entry : cd.getPropertyDefinitions().entrySet()) {
            PropertyDefinition pd = (PropertyDefinition)entry.getValue();
            if (pd instanceof PropertyDefinitionSimple) {
                PropertyDefinitionSimple pds = (PropertyDefinitionSimple)pd;
                SimplePropDef prop = new SimplePropDef();
                prop.setName(pds.getName());
                prop.setRequired(pds.isRequired());
                prop.setType(pds.getType());
                prop.setDefaultValue(pds.getDefaultValue());
                odr.addParam(prop);
            }
            this.log.debug((Object)("copyParams: " + pd.getName() + " not yet supported"));
        }
    }

    @GZIP
    @GET
    @Path(value="definitions")
    @Cache(maxAge=1200)
    @ApiOperation(value="List all operation definitions for a resource")
    public Response getOperationDefinitions(@ApiParam(value="Id of the resource", required=true) @QueryParam(value="resourceId") Integer resourceId, @Context UriInfo uriInfo, @Context Request request, @Context HttpHeaders httpHeaders) {
        if (resourceId == null) {
            throw new ParameterMissingException("resourceId");
        }
        Resource res = this.resourceManager.getResource(this.caller, resourceId);
        if (res == null) {
            throw new StuffNotFoundException("resource with id " + resourceId);
        }
        ResourceType resourceType = res.getResourceType();
        EntityTag eTag = new EntityTag(Integer.toHexString(resourceType.hashCode()));
        Response.ResponseBuilder builder = request.evaluatePreconditions(eTag);
        if (builder == null) {
            Set opDefList = resourceType.getOperationDefinitions();
            ArrayList<OperationDefinitionRest> resultList = new ArrayList<OperationDefinitionRest>(opDefList.size());
            for (OperationDefinition def : opDefList) {
                this.putToCache(def.getId(), OperationDefinition.class, def);
                OperationDefinitionRest odr = new OperationDefinitionRest();
                odr.setId(def.getId());
                odr.setName(def.getName());
                this.copyParamsForDefinition(def, odr);
                UriBuilder uriBuilder = uriInfo.getBaseUriBuilder();
                uriBuilder.path("/operation/definition/{id}");
                uriBuilder.queryParam("resourceId", new Object[]{resourceId});
                Link createLink = new Link("create", uriBuilder.build(new Object[]{def.getId()}).toString());
                odr.addLink(createLink);
                resultList.add(odr);
            }
            GenericEntity<List<OperationDefinitionRest>> entity = new GenericEntity<List<OperationDefinitionRest>>(resultList){};
            builder = Response.ok((Object)entity);
        }
        builder.tag(eTag);
        return builder.build();
    }

    @POST
    @Path(value="definition/{id}")
    @ApiOperation(value="Create a new (draft) operation from the passed definition id for the passed resource")
    public Response createOperation(@ApiParam(value="Id of the definition") @PathParam(value="id") int definitionId, @ApiParam(value="Id of the resource", required=true) @QueryParam(value="resourceId") Integer resourceId, @Context UriInfo uriInfo) {
        if (resourceId == null) {
            throw new ParameterMissingException("resourceId");
        }
        Resource res = this.resourceManager.getResource(this.caller, resourceId);
        if (res == null) {
            throw new StuffNotFoundException("resource with id " + resourceId);
        }
        OperationDefinition opDef = this.opsManager.getOperationDefinition(this.caller, definitionId);
        if (opDef == null) {
            throw new StuffNotFoundException("Operation definition with id " + definitionId);
        }
        OperationRest operationRest = new OperationRest(resourceId, definitionId);
        operationRest.setId((int)System.currentTimeMillis());
        operationRest.setReadyToSubmit(false);
        operationRest.setName(opDef.getName());
        ConfigurationDefinition paramDefinition = opDef.getParametersConfigurationDefinition();
        if (paramDefinition != null) {
            for (PropertyDefinition propDefs : paramDefinition.getNonGroupedProperties()) {
                operationRest.getParams().put(propDefs.getName(), "TODO");
            }
        }
        UriBuilder uriBuilder = uriInfo.getBaseUriBuilder();
        uriBuilder.path("/operation/{id}");
        URI uri = uriBuilder.build(new Object[]{operationRest.getId()});
        Link editLink = new Link("edit", uri.toString());
        operationRest.addLink(editLink);
        Response.ResponseBuilder builder = Response.ok((Object)operationRest);
        this.putToCache(operationRest.getId(), OperationRest.class, operationRest);
        return builder.build();
    }

    @GET
    @Path(value="{id}")
    @ApiOperation(value="Return a (draft) operation")
    public Response getOperation(@ApiParam(value="Id of the operation to retrieve") @PathParam(value="id") int operationId) {
        OperationRest op = this.getFromCache(operationId, OperationRest.class);
        if (op == null) {
            throw new StuffNotFoundException("Operation with id " + operationId);
        }
        return Response.ok((Object)op).build();
    }

    @PUT
    @Path(value="{id}")
    @Consumes(value={"application/json", "application/xml"})
    @ApiOperation(value="Update a (draft) operation. If the state is set to 'ready', the operation will be scheduled")
    public Response updateOperation(@ApiParam(value="Id of the operation to update") @PathParam(value="id") int operationId, OperationRest operation, @Context UriInfo uriInfo) {
        if (!operation.isReadyToSubmit() && operation.getDefinitionId() > 0 && !operation.getName().isEmpty()) {
            operation.setReadyToSubmit(true);
        }
        if (operation.isReadyToSubmit()) {
            Configuration parameters = new Configuration();
            for (Map.Entry<String, Object> entry : operation.getParams().entrySet()) {
                parameters.put((Property)new PropertySimple(entry.getKey(), entry.getValue()));
            }
            ResourceOperationSchedule sched = this.opsManager.scheduleResourceOperation(this.caller, operation.getResourceId(), operation.getName(), 0L, 0L, 0, -1, parameters, "Test");
            JobId jobId = new JobId(sched.getJobName(), sched.getJobGroup());
            UriBuilder uriBuilder = uriInfo.getBaseUriBuilder();
            uriBuilder.path("/operation/history/{id}");
            URI uri = uriBuilder.build(new Object[]{jobId});
            Link histLink = new Link("history", uri.toString());
            operation.addLink(histLink);
        } else {
            UriBuilder uriBuilder = uriInfo.getBaseUriBuilder();
            uriBuilder.path("/operation/{id}");
            URI uri = uriBuilder.build(new Object[]{operation.getId()});
            Link editLink = new Link("edit", uri.toString());
            operation.addLink(editLink);
        }
        this.putToCache(operation.getId(), OperationRest.class, operation);
        Response.ResponseBuilder builder = Response.ok((Object)operation);
        return builder.build();
    }

    @DELETE
    @Path(value="{id}")
    @ApiOperation(value="Delete a (draft) operation")
    public Response cancelOperation(@ApiParam(value="Id of the operation to remove") @PathParam(value="id") int operationId) {
        this.log.info((Object)"Cancel called");
        this.removeFromCache(operationId, OperationRest.class);
        return null;
    }

    @GZIP
    @GET
    @Path(value="history/{id}")
    @ApiOperation(value="Return the outcome of the scheduled operation")
    @Produces(value={"application/json", "application/xml", "text/html"})
    public Response outcome(@ApiParam(value="Name of the submitted job.") @PathParam(value="id") String jobName, @Context UriInfo uriInfo, @Context Request request, @Context HttpHeaders httpHeaders) {
        MediaType mediaType = (MediaType)httpHeaders.getAcceptableMediaTypes().get(0);
        ResourceOperationHistoryCriteria criteria = new ResourceOperationHistoryCriteria();
        JobId jobId = new JobId(jobName);
        criteria.addFilterJobId(jobId);
        PageList<ResourceOperationHistory> list = this.opsManager.findResourceOperationHistoriesByCriteria(this.caller, criteria);
        if (list == null || list.isEmpty()) {
            this.log.info((Object)("No history with id " + jobId + " found"));
            throw new StuffNotFoundException("OperationHistory with id " + jobId);
        }
        ResourceOperationHistory history = (ResourceOperationHistory)list.get(0);
        OperationHistoryRest hist = this.historyToHistoryRest(history, uriInfo);
        Response.ResponseBuilder builder = mediaType.equals((Object)MediaType.TEXT_HTML_TYPE) ? Response.ok((Object)this.renderTemplate("operationHistory.ftl", hist)) : Response.ok((Object)hist);
        if (history.getStatus() == OperationRequestStatus.SUCCESS) {
            CacheControl cc = new CacheControl();
            cc.setMaxAge(1200);
            builder.cacheControl(cc);
        }
        return builder.build();
    }

    @GZIP
    @GET
    @Path(value="history")
    @ApiOperation(value="Return the outcome of the executed operations for a resource")
    @Produces(value={"application/json", "application/xml", "text/html"})
    public Response listHistory(@ApiParam(value="Id of a resource to limit to") @QueryParam(value="resourceId") int resourceId, @Context UriInfo uriInfo, @Context Request request, @Context HttpHeaders httpHeaders) {
        Response.ResponseBuilder builder;
        ResourceOperationHistoryCriteria criteria = new ResourceOperationHistoryCriteria();
        if (resourceId > 0) {
            criteria.addFilterResourceIds(new Integer[]{resourceId});
        }
        criteria.addSortEndTime(PageOrdering.DESC);
        PageList<ResourceOperationHistory> list = this.opsManager.findResourceOperationHistoriesByCriteria(this.caller, criteria);
        ArrayList<OperationHistoryRest> result = new ArrayList<OperationHistoryRest>(list.size());
        for (ResourceOperationHistory roh : list) {
            OperationHistoryRest historyRest = this.historyToHistoryRest(roh, uriInfo);
            result.add(historyRest);
        }
        MediaType mediaType = (MediaType)httpHeaders.getAcceptableMediaTypes().get(0);
        if (mediaType.equals((Object)MediaType.TEXT_HTML_TYPE)) {
            builder = Response.ok((Object)this.renderTemplate("listOperationHistory.ftl", result));
        } else {
            GenericEntity<List<OperationHistoryRest>> res = new GenericEntity<List<OperationHistoryRest>>(result){};
            builder = Response.ok((Object)res);
        }
        return builder.build();
    }

    @DELETE
    @Path(value="history/{id}")
    @ApiOperation(value="Delete the operation history item with the passed id")
    public Response deleteOperationHistoryItem(@ApiParam(value="Name fo the submitted job") @PathParam(value="id") String jobName) {
        ResourceOperationHistoryCriteria criteria = new ResourceOperationHistoryCriteria();
        criteria.addFilterJobId(new JobId(jobName));
        PageList<ResourceOperationHistory> list = this.opsManager.findResourceOperationHistoriesByCriteria(this.caller, criteria);
        if (list != null && !list.isEmpty()) {
            ResourceOperationHistory history = (ResourceOperationHistory)list.get(0);
            this.opsManager.deleteOperationHistory(this.caller, history.getId(), false);
        }
        return Response.noContent().build();
    }

    private OperationHistoryRest historyToHistoryRest(ResourceOperationHistory history, UriInfo uriInfo) {
        String status = history.getStatus() == null ? " - no information yet -" : history.getStatus().getDisplayName();
        OperationHistoryRest hist = new OperationHistoryRest();
        hist.setStatus(status);
        if (history.getResource() != null) {
            hist.setResourceName(history.getResource().getName());
        }
        hist.setOperationName(history.getOperationDefinition().getName());
        hist.lastModified(history.getModifiedTime());
        if (history.getErrorMessage() != null) {
            hist.setErrorMessage(history.getErrorMessage());
        }
        if (history.getResults() != null) {
            Configuration results = history.getResults();
            for (Property p : results.getProperties()) {
                String val = p instanceof PropertySimple ? ((PropertySimple)p).getStringValue() : p.toString();
                hist.getResult().put(p.getName(), val);
            }
        }
        String jobName = history.getJobName();
        String jobGroup = history.getJobGroup();
        JobId jobId = new JobId(jobName, jobGroup);
        hist.setJobId(jobId.toString());
        UriBuilder uriBuilder = uriInfo.getBaseUriBuilder();
        uriBuilder.path("/operation/history/{id}");
        URI url = uriBuilder.build(new Object[]{jobId});
        Link self = new Link("self", url.toString());
        hist.getLinks().add(self);
        return hist;
    }
}

