/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.rest;

import com.wordnik.swagger.annotations.Api;
import com.wordnik.swagger.annotations.ApiError;
import com.wordnik.swagger.annotations.ApiOperation;
import com.wordnik.swagger.annotations.ApiParam;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import javax.ejb.EJB;
import javax.ejb.Stateless;
import javax.interceptor.Interceptors;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.CacheControl;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.GenericEntity;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.StreamingOutput;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriInfo;
import org.jboss.resteasy.annotations.GZIP;
import org.rhq.core.domain.drift.DriftCategory;
import org.rhq.enterprise.server.rest.AbstractRestBean;
import org.rhq.enterprise.server.rest.BadArgumentException;
import org.rhq.enterprise.server.rest.SetCallerInterceptor;
import org.rhq.enterprise.server.rest.domain.Link;
import org.rhq.enterprise.server.rest.reporting.AlertDefinitionLocal;
import org.rhq.enterprise.server.rest.reporting.ConfigurationHistoryLocal;
import org.rhq.enterprise.server.rest.reporting.DriftComplianceLocal;
import org.rhq.enterprise.server.rest.reporting.InventorySummaryLocal;
import org.rhq.enterprise.server.rest.reporting.PlatformUtilizationLocal;
import org.rhq.enterprise.server.rest.reporting.RecentAlertLocal;
import org.rhq.enterprise.server.rest.reporting.RecentDriftLocal;
import org.rhq.enterprise.server.rest.reporting.RecentOperationsLocal;
import org.rhq.enterprise.server.rest.reporting.SuspectMetricLocal;

@Stateless
@Path(value="/reports")
@Produces(value={"text/csv"})
@Api(value="Provide the reports that are also run from the Reports section of the UI. All reports are only available in CSV format")
@Interceptors(value={SetCallerInterceptor.class})
public class ReportsHandlerBean
extends AbstractRestBean {
    @EJB
    AlertDefinitionLocal alertDefinitionLocal;
    @EJB
    ConfigurationHistoryLocal configurationHistoryLocal;
    @EJB
    DriftComplianceLocal driftComplianceLocal;
    @EJB
    InventorySummaryLocal inventorySummaryLocal;
    @EJB
    PlatformUtilizationLocal platformUtilizationLocal;
    @EJB
    RecentAlertLocal recentAlertLocal;
    @EJB
    RecentDriftLocal recentDriftLocal;
    @EJB
    RecentOperationsLocal recentOperationsLocal;
    @EJB
    SuspectMetricLocal suspectMetricLocal;
    String[] reports = new String[]{"alertDefinitions", "configurationHistory", "driftCompliance", "inventorySummary", "platformUtilization", "recentAlerts", "recentDrift", "recentOperations", "suspectMetrics"};

    @GET
    @Path(value="/")
    @ApiOperation(value="List the available reports", responseClass="String", multiValueResponse=true)
    @Produces(value={"text/html", "application/json", "application/xml", "text/csv"})
    public Response listReports(@Context HttpHeaders headers, @Context UriInfo uriInfo) {
        ArrayList<Link> links = new ArrayList<Link>(this.reports.length);
        for (String report : this.reports) {
            UriBuilder uriBuilder = uriInfo.getBaseUriBuilder();
            uriBuilder.path("/reports/{report}");
            URI uri = uriBuilder.build(new Object[]{report});
            Link link = new Link(report, uri.toString());
            links.add(link);
        }
        MediaType mediaType = (MediaType)headers.getAcceptableMediaTypes().get(0);
        Response.ResponseBuilder builder = Response.ok();
        if (mediaType.getType().equals("text") && mediaType.getSubtype().equals("csv")) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Report,URL\n");
            for (Link link : links) {
                stringBuilder.append(link.getRel()).append(",").append(link.getHref());
                stringBuilder.append('\n');
            }
            builder.entity((Object)stringBuilder.toString());
        } else if (mediaType.equals((Object)MediaType.TEXT_HTML_TYPE)) {
            builder.entity((Object)this.renderTemplate("reportIndex", links));
        } else {
            GenericEntity<List<Link>> list = new GenericEntity<List<Link>>(links){};
            builder.entity((Object)list);
        }
        CacheControl cacheControl = new CacheControl();
        cacheControl.setMaxAge(86400);
        builder.cacheControl(cacheControl);
        return builder.build();
    }

    @GZIP
    @GET
    @Path(value="alertDefinitions")
    @ApiOperation(value="Export the AlertDefinitions as CSV", responseClass="String", multiValueResponse=true)
    public StreamingOutput alertDefinitions(@Context HttpServletRequest request) {
        return this.alertDefinitionLocal.alertDefinitionsInternal(request, this.caller);
    }

    @GZIP
    @GET
    @Path(value="configurationHistory")
    @ApiOperation(value="Export the Configuration History data as CSV", responseClass="String", multiValueResponse=true)
    public StreamingOutput configurationHistory(@Context HttpServletRequest request) {
        return this.configurationHistoryLocal.configurationHistoryInternal(request, this.caller);
    }

    @GZIP
    @GET
    @Path(value="driftCompliance")
    @ApiOperation(value="Export the drift compliance data", responseClass="String", multiValueResponse=true)
    public StreamingOutput generateDriftComplianceReport(@Context HttpServletRequest request, @QueryParam(value="resourceTypeId") String resourceTypeId, @QueryParam(value="version") String version) {
        return this.driftComplianceLocal.generateReportInternal(request, resourceTypeId, version, this.caller);
    }

    @GZIP
    @GET
    @Path(value="inventorySummary")
    @ApiOperation(value="Export the Inventory Summary data as CSV", responseClass="String", multiValueResponse=true)
    public StreamingOutput generateInventorySummaryReport(@Context HttpServletRequest request, @QueryParam(value="resourceTypeId") String resourceTypeId, @QueryParam(value="version") String version) {
        return this.inventorySummaryLocal.generateReportInternal(request, resourceTypeId, version, this.caller);
    }

    @GZIP
    @GET
    @Path(value="platformUtilization")
    @ApiOperation(value="Export the Platform utilization data as CSV", responseClass="String", multiValueResponse=true)
    public StreamingOutput generateReport(@Context HttpServletRequest request) {
        return this.platformUtilizationLocal.generateReportInternal(request, this.caller);
    }

    @GZIP
    @GET
    @Path(value="recentAlerts")
    @ApiOperation(value="Export the Recent Alert data as CSV", responseClass="String", multiValueResponse=true)
    public StreamingOutput recentAlerts(@QueryParam(value="alertPriority") @DefaultValue(value="high,medium,low") String alertPriority, @QueryParam(value="startTime") Long startTime, @QueryParam(value="endTime") Long endTime, @Context HttpServletRequest request) {
        return this.recentAlertLocal.recentAlertsInternal(alertPriority, startTime, endTime, request, this.caller);
    }

    @GZIP
    @GET
    @Path(value="recentDrift")
    @ApiOperation(value="Export the Recent drift data as CSV", responseClass="String", multiValueResponse=true)
    @ApiError(code=404, reason="If no category is provided or the category is wrong")
    public StreamingOutput recentDrift(@ApiParam(value="Drift categories to report on", allowableValues="FILE_ADDED, FILE_CHANGED, FILE_REMOVED") @QueryParam(value="categories") String categories, @QueryParam(value="snapshot") Integer snapshot, @QueryParam(value="path") String path, @QueryParam(value="definition") String definitionName, @QueryParam(value="startTime") Long startTime, @QueryParam(value="endTime") Long endTime, @Context HttpServletRequest request) {
        String[] cats;
        if (categories == null) {
            throw new BadArgumentException("categories", "You need to provide at least one category");
        }
        for (String cat : cats = categories.split(",")) {
            try {
                DriftCategory.valueOf((String)cat.toUpperCase());
            }
            catch (IllegalArgumentException iae) {
                throw new BadArgumentException("category", cat);
            }
        }
        return this.recentDriftLocal.recentDriftInternal(categories, snapshot, path, definitionName, startTime, endTime, request, this.caller);
    }

    @GZIP
    @GET
    @Path(value="recentOperations")
    @ApiOperation(value="Export the Recent Operations Data as CSV", responseClass="String", multiValueResponse=true)
    public StreamingOutput recentOperations(@ApiParam(value="Status to look for. If parameter is not given, all values are used") @QueryParam(value="status") @DefaultValue(value="inprogress,success,failure,canceled") String operationRequestStatus, @ApiParam(value="The start time in ms since epoch of the time range to export.") @QueryParam(value="startTime") Long startTime, @ApiParam(value="The end time in ms since epoch of the time range to export. Defaults to 'now' if only the start time is given") @QueryParam(value="endTime") Long endTime, @Context HttpServletRequest request) {
        return this.recentOperationsLocal.recentOperationsInternal(operationRequestStatus, startTime, endTime, request, this.caller);
    }

    @GZIP
    @GET
    @Path(value="suspectMetrics")
    @ApiOperation(value="Export the Suspect Metrics data as CSV", responseClass="String", multiValueResponse=true)
    public StreamingOutput suspectMetrics(@Context HttpServletRequest request) {
        return this.suspectMetricLocal.suspectMetricsInternal(request, this.caller);
    }
}

