/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.rest;

import com.wordnik.swagger.annotations.Api;
import com.wordnik.swagger.annotations.ApiError;
import com.wordnik.swagger.annotations.ApiOperation;
import com.wordnik.swagger.annotations.ApiParam;
import java.net.URI;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import javax.ejb.EJB;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import javax.interceptor.Interceptors;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.EntityTag;
import javax.ws.rs.core.GenericEntity;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Request;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriInfo;
import org.jboss.resteasy.annotations.GZIP;
import org.jboss.resteasy.annotations.cache.Cache;
import org.jboss.resteasy.links.AddLinks;
import org.jboss.resteasy.links.LinkResource;
import org.rhq.core.domain.alert.Alert;
import org.rhq.core.domain.criteria.AlertCriteria;
import org.rhq.core.domain.criteria.AvailabilityCriteria;
import org.rhq.core.domain.criteria.ResourceCriteria;
import org.rhq.core.domain.discovery.AvailabilityReport;
import org.rhq.core.domain.measurement.Availability;
import org.rhq.core.domain.measurement.AvailabilityType;
import org.rhq.core.domain.measurement.DataType;
import org.rhq.core.domain.measurement.MeasurementDefinition;
import org.rhq.core.domain.measurement.MeasurementSchedule;
import org.rhq.core.domain.resource.Agent;
import org.rhq.core.domain.resource.InventoryStatus;
import org.rhq.core.domain.resource.Resource;
import org.rhq.core.domain.resource.ResourceCategory;
import org.rhq.core.domain.resource.ResourceType;
import org.rhq.core.domain.util.PageControl;
import org.rhq.core.domain.util.PageList;
import org.rhq.core.domain.util.PageOrdering;
import org.rhq.enterprise.server.alert.AlertManagerLocal;
import org.rhq.enterprise.server.core.AgentManagerLocal;
import org.rhq.enterprise.server.measurement.AvailabilityManagerLocal;
import org.rhq.enterprise.server.measurement.MeasurementScheduleManagerLocal;
import org.rhq.enterprise.server.resource.ResourceAlreadyExistsException;
import org.rhq.enterprise.server.resource.ResourceTypeManagerLocal;
import org.rhq.enterprise.server.rest.AbstractRestBean;
import org.rhq.enterprise.server.rest.BadArgumentException;
import org.rhq.enterprise.server.rest.SetCallerInterceptor;
import org.rhq.enterprise.server.rest.StuffNotFoundException;
import org.rhq.enterprise.server.rest.domain.AvailabilityRest;
import org.rhq.enterprise.server.rest.domain.Link;
import org.rhq.enterprise.server.rest.domain.MetricSchedule;
import org.rhq.enterprise.server.rest.domain.ResourceWithChildren;
import org.rhq.enterprise.server.rest.domain.ResourceWithType;
import org.rhq.enterprise.server.rest.domain.StringValue;

@Produces(value={"application/json", "application/xml", "text/html"})
@Path(value="/resource")
@Api(value="Resource related", description="This endpoint deals with individual resources, not resource groups")
@Interceptors(value={SetCallerInterceptor.class})
@Stateless
public class ResourceHandlerBean
extends AbstractRestBean {
    private static final String NO_RESOURCE_FOR_ID = "If no resource with the passed id exists";
    @EJB
    AvailabilityManagerLocal availMgr;
    @EJB
    MeasurementScheduleManagerLocal scheduleManager;
    @EJB
    AlertManagerLocal alertManager;
    @EJB
    ResourceTypeManagerLocal resourceTypeManager;
    @EJB
    AgentManagerLocal agentMgr;
    @PersistenceContext(unitName="rhqpu")
    private EntityManager entityManager;

    @GET
    @Path(value="/{id:\\d+}")
    @Cache(isPrivate=true, maxAge=120)
    @ApiOperation(value="Retrieve a single resource", responseClass="ResourceWithType")
    @ApiError(code=404, reason="If no resource with the passed id exists")
    public Response getResource(@ApiParam(value="Id of the resource to retrieve") @PathParam(value="id") int id, @Context Request request, @Context HttpHeaders headers, @Context UriInfo uriInfo) {
        EntityTag eTag;
        Resource res = this.fetchResource(id);
        long mtime = res.getMtime();
        Response.ResponseBuilder builder = request.evaluatePreconditions(new Date(mtime), eTag = new EntityTag(Long.toOctalString((long)res.hashCode() + mtime)));
        if (builder != null) {
            return builder.build();
        }
        ResourceWithType rwt = this.fillRWT(res, uriInfo);
        MediaType mediaType = (MediaType)headers.getAcceptableMediaTypes().get(0);
        builder = mediaType.equals((Object)MediaType.TEXT_HTML_TYPE) ? Response.ok((Object)this.renderTemplate("resourceWithType", rwt), (MediaType)mediaType) : Response.ok((Object)rwt);
        return builder.build();
    }

    @GET
    @GZIP
    @Path(value="/")
    @ApiOperation(value="Search for resources by the given search string, possibly limited by category and paged", responseClass="ResourceWithType")
    public Response getResourcesByQuery(@ApiParam(value="String to search in the resource name") @QueryParam(value="q") String q, @ApiParam(value="Limit to category (PLATFORM, SERVER, SERVICE") @QueryParam(value="category") String category, @ApiParam(value="Page size for paging") @QueryParam(value="ps") @DefaultValue(value="20") int pageSize, @ApiParam(value="Page for paging") @QueryParam(value="page") Integer page, @Context HttpHeaders headers, @Context UriInfo uriInfo) {
        ResourceCriteria criteria = new ResourceCriteria();
        if (q != null) {
            criteria.addFilterName(q);
        }
        if (category != null) {
            criteria.addFilterResourceCategories(new ResourceCategory[]{ResourceCategory.valueOf((String)category.toUpperCase())});
        }
        if (page != null) {
            criteria.setPaging(page.intValue(), pageSize);
            criteria.addSortName(PageOrdering.ASC);
        }
        PageList<Resource> ret = this.resMgr.findResourcesByCriteria(this.caller, criteria);
        Response.ResponseBuilder builder = this.getResponseBuilderForResourceList(headers, uriInfo, ret, page, pageSize);
        return builder.build();
    }

    @GZIP
    @GET
    @Path(value="/platforms")
    @Cache(isPrivate=true, maxAge=300)
    @ApiOperation(value="List all platforms in the system", multiValueResponse=true, responseClass="ResourceWithType")
    public Response getPlatforms(@Context HttpHeaders headers, @Context UriInfo uriInfo) {
        PageControl pc = new PageControl();
        PageList<Resource> ret = this.resMgr.findResourcesByCategory(this.caller, ResourceCategory.PLATFORM, InventoryStatus.COMMITTED, pc);
        Response.ResponseBuilder builder = this.getResponseBuilderForResourceList(headers, uriInfo, ret, null, 20);
        return builder.build();
    }

    private Response.ResponseBuilder getResponseBuilderForResourceList(HttpHeaders headers, UriInfo uriInfo, PageList<Resource> resources, Integer page, int pageSize) {
        ArrayList<ResourceWithType> rwtList = new ArrayList<ResourceWithType>(resources.size());
        for (Resource r : resources) {
            this.putToCache(r.getId(), Resource.class, r);
            ResourceWithType rwt = this.fillRWT(r, uriInfo);
            rwtList.add(rwt);
        }
        MediaType mediaType = (MediaType)headers.getAcceptableMediaTypes().get(0);
        Response.ResponseBuilder builder = Response.ok();
        builder.type(mediaType);
        if (page != null) {
            UriBuilder uriBuilder;
            if (resources.getTotalSize() > page * pageSize) {
                int nextPage = page + 1;
                uriBuilder = uriInfo.getRequestUriBuilder();
                uriBuilder.replaceQueryParam("page", new Object[]{nextPage});
                builder.header("Link", (Object)new Link("next", uriBuilder.build(new Object[0]).toString()));
            }
            if (page > 1) {
                int prevPage = page - 1;
                uriBuilder = uriInfo.getRequestUriBuilder();
                uriBuilder.replaceQueryParam("page", new Object[]{prevPage});
                builder.header("prev", (Object)uriBuilder.build(new Object[0]).toString());
            }
        }
        if (mediaType.equals((Object)MediaType.TEXT_HTML_TYPE)) {
            builder.entity((Object)this.renderTemplate("listResourceWithType", rwtList));
        } else {
            GenericEntity<List<ResourceWithType>> list = new GenericEntity<List<ResourceWithType>>(rwtList){};
            builder.entity((Object)list);
        }
        return builder;
    }

    @GET
    @GZIP
    @Path(value="/{id}/hierarchy")
    @Produces(value={"application/json", "application/xml"})
    @ApiOperation(value="Retrieve the hierarchy of resources starting with the passed one", multiValueResponse=true, responseClass="ResourceWithType")
    @ApiError(code=404, reason="If no resource with the passed id exists")
    public ResourceWithChildren getHierarchy(@ApiParam(value="Id of the resource to start with") @PathParam(value="id") int baseResourceId) {
        Resource start = this.obtainResource(baseResourceId);
        return this.getHierarchy(start);
    }

    private ResourceWithChildren getHierarchy(Resource baseResource) {
        ResourceWithChildren rwc = new ResourceWithChildren("" + baseResource.getId(), baseResource.getName());
        PageControl pc = new PageControl();
        PageList<Resource> ret = this.resMgr.findResourceByParentAndInventoryStatus(this.caller, baseResource, InventoryStatus.COMMITTED, pc);
        if (!ret.isEmpty()) {
            ArrayList<ResourceWithChildren> resList = new ArrayList<ResourceWithChildren>(ret.size());
            for (Resource res : ret) {
                ResourceWithChildren child = this.getHierarchy(res);
                resList.add(child);
                this.putToCache(res.getId(), Resource.class, res);
            }
            if (!resList.isEmpty()) {
                rwc.setChildren(resList);
            }
        }
        return rwc;
    }

    @GET
    @Path(value="/{id}/availability")
    @ApiError(code=404, reason="If no resource with the passed id exists")
    @ApiOperation(value="Return the current availability for the passed resource", responseClass="AvailabilityRest")
    public Response getAvailability(@ApiParam(value="Id of the resource to query") @PathParam(value="id") int resourceId, @Context HttpHeaders headers) {
        Availability avail = this.availMgr.getCurrentAvailabilityForResource(this.caller, resourceId);
        AvailabilityRest availabilityRest = avail.getAvailabilityType() != null ? new AvailabilityRest(avail.getAvailabilityType(), avail.getStartTime(), avail.getResource().getId()) : new AvailabilityRest(avail.getStartTime(), resourceId);
        MediaType mediaType = (MediaType)headers.getAcceptableMediaTypes().get(0);
        Response.ResponseBuilder builder = mediaType.equals((Object)MediaType.TEXT_HTML_TYPE) ? Response.ok((Object)this.renderTemplate("availability.ftl", availabilityRest), (MediaType)mediaType) : Response.ok((Object)availabilityRest);
        return builder.build();
    }

    @GZIP
    @GET
    @Path(value="/{id}/availability/history")
    @ApiError(code=404, reason="If no resource with the passed id exists")
    @ApiOperation(value="Return the availability history for the passed resource", responseClass="AvailabilityRest", multiValueResponse=true)
    public Response getAvailabilityHistory(@ApiParam(value="Id of the resource to query") @PathParam(value="id") int resourceId, @ApiParam(value="Start time", defaultValue="30 days ago") @QueryParam(value="start") long start, @ApiParam(value="End time", defaultValue="Now") @QueryParam(value="end") long end, @Context HttpHeaders headers) {
        Response.ResponseBuilder builder;
        Object availabilityRest;
        if (end == 0L) {
            end = System.currentTimeMillis();
        }
        if (start == 0L) {
            start = end - 2592000000L;
        }
        AvailabilityCriteria criteria = new AvailabilityCriteria();
        criteria.addFilterInterval(Long.valueOf(start), Long.valueOf(end));
        criteria.addFilterResourceId(Integer.valueOf(resourceId));
        criteria.addSortStartTime(PageOrdering.DESC);
        PageList<Availability> points = this.availMgr.findAvailabilityByCriteria(this.caller, criteria);
        ArrayList<Object> ret = new ArrayList<Object>(points.size());
        for (Availability avail : points) {
            availabilityRest = avail.getAvailabilityType() != null ? new AvailabilityRest(avail.getAvailabilityType(), avail.getStartTime(), avail.getResource().getId()) : new AvailabilityRest(avail.getStartTime(), resourceId);
            if (avail.getEndTime() != null) {
                ((AvailabilityRest)availabilityRest).setUntil(avail.getEndTime());
            }
            ret.add(availabilityRest);
        }
        MediaType mediaType = (MediaType)headers.getAcceptableMediaTypes().get(0);
        if (mediaType.equals((Object)MediaType.TEXT_HTML_TYPE)) {
            builder = Response.ok((Object)this.renderTemplate("listAvailability.ftl", ret), (MediaType)mediaType);
        } else {
            availabilityRest = new GenericEntity<List<AvailabilityRest>>(ret){};
            builder = Response.ok((Object)availabilityRest);
        }
        return builder.build();
    }

    @PUT
    @Path(value="/{id}/availability")
    @ApiOperation(value="Set the current availability of the passed resource")
    @TransactionAttribute(value=TransactionAttributeType.NEVER)
    public void reportAvailability(@ApiParam(value="Id of the resource to update") @PathParam(value="id") int resourceId, @ApiParam(value="New Availability setting", required=true) AvailabilityRest avail) {
        if (avail.getResourceId() != resourceId) {
            throw new IllegalArgumentException("Resource Ids do not match");
        }
        Resource resource = this.obtainResource(resourceId);
        AvailabilityType at = AvailabilityType.valueOf((String)avail.getType());
        if (resource.getResourceType().getCategory() == ResourceCategory.PLATFORM && at == AvailabilityType.DISABLED) {
            throw new BadArgumentException("Availability", "Platforms must not be set to DISABLED");
        }
        Agent agent = this.agentMgr.getAgentByResourceId(this.caller, resourceId);
        AvailabilityReport report = new AvailabilityReport(true, agent.getName());
        Availability availability = new Availability(resource, Long.valueOf(avail.getSince()), at);
        report.addAvailability(availability);
        this.availMgr.mergeAvailabilityReport(report);
    }

    @GZIP
    @GET
    @Path(value="/{id}/schedules")
    @LinkResource(rel="schedules", value=MetricSchedule.class)
    @Cache(isPrivate=true, maxAge=60)
    @ApiOperation(value="Get the metric schedules of the passed resource id", multiValueResponse=true, responseClass="MetricSchedule")
    @ApiError(code=404, reason="If no resource with the passed id exists")
    public Response getSchedules(@ApiParam(value="Id of the resource to obtain the schedules for") @PathParam(value="id") int resourceId, @ApiParam(value="Limit by type", allowableValues="<empty>, all, metric, trait, measurement") @QueryParam(value="type") @DefaultValue(value="all") String scheduleType, @ApiParam(value="Limit by enabled schedules") @QueryParam(value="enabledOnly") @DefaultValue(value="true") boolean enabledOnly, @ApiParam(value="Limit by name") @QueryParam(value="name") String name, @Context HttpHeaders headers, @Context UriInfo uriInfo) {
        Response.ResponseBuilder builder;
        if (scheduleType.equals("metric")) {
            scheduleType = DataType.MEASUREMENT.toString().toLowerCase();
        }
        Resource res = this.resMgr.getResource(this.caller, resourceId);
        Set schedules = res.getSchedules();
        ArrayList<MetricSchedule> ret = new ArrayList<MetricSchedule>(schedules.size());
        for (MeasurementSchedule schedule : schedules) {
            URI uri;
            UriBuilder uriBuilder;
            this.putToCache(schedule.getId(), MeasurementSchedule.class, schedule);
            MeasurementDefinition definition = schedule.getDefinition();
            if (!"all".equals(scheduleType) && !scheduleType.toLowerCase().equals(definition.getDataType().toString().toLowerCase()) || enabledOnly && (!enabledOnly || !schedule.isEnabled()) || name != null && (name == null || !name.equals(definition.getName()))) continue;
            MetricSchedule ms = new MetricSchedule(schedule.getId(), definition.getName(), definition.getDisplayName(), schedule.isEnabled(), schedule.getInterval(), definition.getUnits().toString(), definition.getDataType().toString());
            if (definition.getDataType() == DataType.MEASUREMENT) {
                uriBuilder = uriInfo.getBaseUriBuilder();
                uriBuilder.path("/metric/data/{id}");
                uri = uriBuilder.build(new Object[]{schedule.getId()});
                Link metricLink = new Link("metric", uri.toString());
                ms.addLink(metricLink);
                uriBuilder = uriInfo.getBaseUriBuilder();
                uriBuilder.path("/metric/data/{id}/raw");
                uri = uriBuilder.build(new Object[]{schedule.getId()});
                metricLink = new Link("metric-raw", uri.toString());
                ms.addLink(metricLink);
            }
            uriBuilder = uriInfo.getBaseUriBuilder();
            uriBuilder.path("resource/" + schedule.getResource().getId());
            uri = uriBuilder.build(new Object[0]);
            Link link = new Link("resource", uri.toString());
            ms.addLink(link);
            ret.add(ms);
        }
        MediaType mediaType = (MediaType)headers.getAcceptableMediaTypes().get(0);
        if (mediaType.equals((Object)MediaType.TEXT_HTML_TYPE)) {
            builder = Response.ok((Object)this.renderTemplate("listMetricSchedule", ret), (MediaType)mediaType);
        } else {
            GenericEntity<List<MetricSchedule>> list = new GenericEntity<List<MetricSchedule>>(ret){};
            builder = Response.ok((Object)list, (MediaType)mediaType);
        }
        return builder.build();
    }

    @GZIP
    @GET
    @Path(value="/{id}/children")
    @LinkResource(rel="children", value=ResourceWithType.class)
    @ApiOperation(value="Get the direct children of the passed resource")
    @ApiError(code=404, reason="If no resource with the passed id exists")
    public Response getChildren(@ApiParam(value="Id of the resource to get children") @PathParam(value="id") int id, @Context HttpHeaders headers, @Context UriInfo uriInfo) {
        Response.ResponseBuilder builder;
        PageControl pc = new PageControl();
        Resource parent = this.fetchResource(id);
        PageList<Resource> ret = this.resMgr.findResourceByParentAndInventoryStatus(this.caller, parent, InventoryStatus.COMMITTED, pc);
        ArrayList<ResourceWithType> rwtList = new ArrayList<ResourceWithType>(ret.size());
        for (Resource r : ret) {
            ResourceWithType rwt = this.fillRWT(r, uriInfo);
            rwtList.add(rwt);
        }
        MediaType mediaType = (MediaType)headers.getAcceptableMediaTypes().get(0);
        if (mediaType.equals((Object)MediaType.TEXT_HTML_TYPE)) {
            builder = Response.ok((Object)this.renderTemplate("listResourceWithType", rwtList), (MediaType)mediaType);
        } else {
            GenericEntity<List<ResourceWithType>> list = new GenericEntity<List<ResourceWithType>>(rwtList){};
            builder = Response.ok((Object)list);
        }
        return builder.build();
    }

    private Resource obtainResource(int resourceId) {
        Resource resource = this.resMgr.getResource(this.caller, resourceId);
        if (resource == null && (resource = this.resMgr.getResource(this.caller, resourceId)) != null) {
            this.putToCache(resourceId, Resource.class, resource);
        }
        return resource;
    }

    @GZIP
    @AddLinks
    @GET
    @Path(value="/{id}/alerts")
    @ApiError(code=404, reason="If no resource with the passed id exists")
    @ApiOperation(value="Get a list of links to the alerts for the passed resource")
    public List<Link> getAlertsForResource(@ApiParam(value="Id of the resource to query") @PathParam(value="id") int resourceId) {
        AlertCriteria criteria = new AlertCriteria();
        criteria.addFilterResourceIds(new Integer[]{resourceId});
        PageList<Alert> alerts = this.alertManager.findAlertsByCriteria(this.caller, criteria);
        ArrayList<Link> links = new ArrayList<Link>(alerts.size());
        for (Alert al : alerts) {
            Link link = new Link();
            link.setRel("alert");
            link.setHref("/alert/" + al.getId());
            links.add(link);
        }
        return links;
    }

    @ApiOperation(value="Create a new platform in the Server. If the platform already exists, this is a no-op.The platform internally has a special name so that it will not clash with one that was generatedvia a normal RHQ agent. DEPRECATED Use POST /platforms instead")
    @POST
    @Path(value="platform/{name}")
    public Response createPlatformOLD(@ApiParam(value="Name of the platform") @PathParam(value="name") String name, @ApiParam(value="Type of the platform", allowableValues="Linux,Windows,... TODO") StringValue typeValue, @Context UriInfo uriInfo) {
        String typeName = typeValue.getValue();
        return this.createPlatformInternal(name, typeName, uriInfo);
    }

    @POST
    @Path(value="platforms")
    @ApiOperation(value="Create a new platform in the Server. If the platform already exists, this is a no-op.The platform internally has a special name so that it will not clash with one that was generatedvia a normal RHQ agent. Only resourceName and typeName need to be supplied in the passed object")
    public Response createPlatform(@ApiParam(value="The info about the platform. Only type name and resource name need to be supplied") ResourceWithType resource, @Context UriInfo uriInfo) {
        String typeName = resource.getTypeName();
        String resourceName = resource.getResourceName();
        return this.createPlatformInternal(resourceName, typeName, uriInfo);
    }

    private Response createPlatformInternal(String name, String typeName, UriInfo uriInfo) {
        ResourceType type = this.resourceTypeManager.getResourceTypeByNameAndPlugin(typeName, "Platforms");
        if (type == null) {
            throw new StuffNotFoundException("Platform with type [" + typeName + "]");
        }
        String resourceKey = "p:" + name;
        Resource r = this.resMgr.getResourceByParentAndKey(this.caller, null, resourceKey, "Platforms", typeName);
        if (r != null) {
            ResourceWithType rwt = this.fillRWT(r, uriInfo);
            UriBuilder uriBuilder = uriInfo.getBaseUriBuilder();
            uriBuilder.path("/resource/{id}");
            URI uri = uriBuilder.build(new Object[]{r.getId()});
            Response.ResponseBuilder builder = Response.created((URI)uri);
            builder.entity((Object)rwt);
            return builder.build();
        }
        Agent agent = new Agent("dummy-agent:name" + name, "-dummy-p:" + name, 12345, "http://foo.com/p:name/" + name, "abc-" + name);
        this.agentMgr.createAgent(agent);
        Resource platform = new Resource(resourceKey, name, type);
        platform.setUuid(UUID.randomUUID().toString());
        platform.setAgent(agent);
        platform.setInventoryStatus(InventoryStatus.COMMITTED);
        platform.setModifiedBy(this.caller.getName());
        platform.setDescription(type.getDescription() + ". Created via REST-api");
        platform.setItime(System.currentTimeMillis());
        try {
            this.resMgr.createResource(this.caller, platform, -1);
            this.createSchedules(platform);
            ResourceWithType rwt = this.fillRWT(platform, uriInfo);
            UriBuilder uriBuilder = uriInfo.getBaseUriBuilder();
            uriBuilder.path("/resource/{id}");
            URI uri = uriBuilder.build(new Object[]{platform.getId()});
            Response.ResponseBuilder builder = Response.created((URI)uri);
            builder.entity((Object)rwt);
            return builder.build();
        }
        catch (ResourceAlreadyExistsException e) {
            throw new IllegalArgumentException(e);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @ApiOperation(value="Create a resource with a given type below a certain parent. DEPRECATED Use POST / instead")
    @POST
    @Path(value="{name}")
    public Response createResourceOLD(@ApiParam(value="Name of the new resource") @PathParam(value="name") String name, @ApiParam(value="Name of the Resource type") StringValue typeValue, @ApiParam(value="Name of the plugin providing the type") @QueryParam(value="plugin") String plugin, @ApiParam(value="Id of the future parent to attach this to") @QueryParam(value="parentId") int parentId, @Context UriInfo uriInfo) {
        String typeName = typeValue.getValue();
        return this.createResourceInternal(name, plugin, parentId, typeName, uriInfo);
    }

    @POST
    @Path(value="/")
    @ApiOperation(value="Create a new resource as a child of an existing resource\u00a1")
    public Response createResource(@ApiParam(value="THe info about the resource. You need to supply resource name, resource type name, plugin name, id of the parent") ResourceWithType resource, @Context UriInfo uriInfo) {
        return this.createResourceInternal(resource.getResourceName(), resource.getPluginName(), resource.getParentId(), resource.getTypeName(), uriInfo);
    }

    private Response createResourceInternal(String name, String plugin, int parentId, String typeName, UriInfo uriInfo) {
        Resource parent = this.resMgr.getResourceById(this.caller, parentId);
        ResourceType resType = this.resourceTypeManager.getResourceTypeByNameAndPlugin(typeName, plugin);
        if (resType == null) {
            throw new StuffNotFoundException("ResourceType with name [" + typeName + "] and plugin [" + plugin + "]");
        }
        String resourceKey = "res:" + name + ":" + parentId;
        Resource r = this.resMgr.getResourceByParentAndKey(this.caller, parent, resourceKey, plugin, typeName);
        if (r != null) {
            ResourceWithType rwt = this.fillRWT(r, uriInfo);
            UriBuilder uriBuilder = uriInfo.getBaseUriBuilder();
            uriBuilder.path("/resource/{id}");
            URI uri = uriBuilder.build(new Object[]{r.getId()});
            Response.ResponseBuilder builder = Response.created((URI)uri);
            builder.entity((Object)rwt);
            return builder.build();
        }
        Resource res = new Resource(resourceKey, name, resType);
        res.setUuid(UUID.randomUUID().toString());
        res.setAgent(parent.getAgent());
        res.setParentResource(parent);
        res.setInventoryStatus(InventoryStatus.COMMITTED);
        res.setDescription(resType.getDescription() + ". Created via REST-api");
        try {
            this.resMgr.createResource(this.caller, res, parent.getId());
            this.createSchedules(res);
            ResourceWithType rwt = this.fillRWT(res, uriInfo);
            UriBuilder uriBuilder = uriInfo.getBaseUriBuilder();
            uriBuilder.path("/resource/{id}");
            URI uri = uriBuilder.build(new Object[]{res.getId()});
            Response.ResponseBuilder builder = Response.created((URI)uri);
            builder.entity((Object)rwt);
            return builder.build();
        }
        catch (ResourceAlreadyExistsException e) {
            throw new IllegalArgumentException(e);
        }
    }

    @DELETE
    @Path(value="/{id}")
    @ApiOperation(value="Remove a resource from inventory")
    public Response uninventoryOrDeleteResource(@PathParam(value="id") int resourceId) {
        this.resMgr.uninventoryResource(this.caller, resourceId);
        return Response.status((Response.Status)Response.Status.NO_CONTENT).build();
    }

    private void createSchedules(Resource resource) {
        ResourceType rt = resource.getResourceType();
        Set definitions = rt.getMetricDefinitions();
        for (MeasurementDefinition definition : definitions) {
            MeasurementSchedule schedule = new MeasurementSchedule(definition, resource);
            schedule.setEnabled(definition.isDefaultOn());
            schedule.setInterval(definition.getDefaultInterval());
            this.entityManager.persist((Object)schedule);
        }
    }
}

