/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.rest;

import com.wordnik.swagger.annotations.Api;
import com.wordnik.swagger.annotations.ApiOperation;
import java.util.Map;
import javax.ejb.EJB;
import javax.ejb.Stateless;
import javax.interceptor.Interceptors;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.jboss.resteasy.annotations.GZIP;
import org.rhq.core.domain.cloud.Server;
import org.rhq.enterprise.server.cloud.instance.ServerManagerLocal;
import org.rhq.enterprise.server.rest.AbstractRestBean;
import org.rhq.enterprise.server.rest.SetCallerInterceptor;
import org.rhq.enterprise.server.rest.domain.Status;
import org.rhq.enterprise.server.rest.domain.StringValue;
import org.rhq.enterprise.server.system.SystemInfoManagerLocal;

@Api(value="Provide system status information")
@Path(value="/status")
@Produces(value={"application/json", "application/xml", "text/html"})
@Stateless
@Interceptors(value={SetCallerInterceptor.class})
public class StatusHandlerBean
extends AbstractRestBean {
    @EJB
    SystemInfoManagerLocal infoMgr;
    @EJB
    ServerManagerLocal serverManager;

    @GZIP
    @ApiOperation(value="Retrieve the current configured state of the server along with some runtime information.Caller must have MANAGE_SETTINGS to access this endpoint.", responseClass="Map 'values' with map of key-value pairs describing the status")
    @GET
    @Path(value="/")
    public Response getStatus(@Context HttpHeaders httpHeaders) {
        Response.ResponseBuilder builder;
        Map<String, String> statusMap = this.infoMgr.getSystemInformation(this.caller);
        Status status = new Status();
        status.setValues(statusMap);
        MediaType mediaType = (MediaType)httpHeaders.getAcceptableMediaTypes().get(0);
        if (mediaType.equals((Object)MediaType.TEXT_HTML_TYPE)) {
            String htmlString = this.renderTemplate("status", status);
            builder = Response.ok((Object)htmlString, (MediaType)mediaType);
        } else {
            builder = Response.ok((Object)status, (MediaType)((MediaType)httpHeaders.getAcceptableMediaTypes().get(0)));
        }
        return builder.build();
    }

    @GET
    @Path(value="/server")
    @ApiOperation(value="Get the operation mode of this server")
    public StringValue serverState() {
        Server server = this.serverManager.getServer();
        return new StringValue(server.getOperationMode().name());
    }
}

