/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.rest;

import com.wordnik.swagger.annotations.Api;
import com.wordnik.swagger.annotations.ApiOperation;
import com.wordnik.swagger.annotations.ApiParam;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import javax.ejb.EJB;
import javax.ejb.Stateless;
import javax.interceptor.Interceptors;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.EntityTag;
import javax.ws.rs.core.GenericEntity;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Request;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.jboss.resteasy.annotations.GZIP;
import org.jboss.resteasy.annotations.cache.Cache;
import org.rhq.core.domain.auth.Subject;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.Property;
import org.rhq.core.domain.configuration.PropertySimple;
import org.rhq.core.domain.resource.Resource;
import org.rhq.core.domain.resource.group.ResourceGroup;
import org.rhq.enterprise.server.auth.SubjectManagerLocal;
import org.rhq.enterprise.server.resource.ResourceManagerLocal;
import org.rhq.enterprise.server.resource.ResourceNotFoundException;
import org.rhq.enterprise.server.resource.group.ResourceGroupNotFoundException;
import org.rhq.enterprise.server.rest.AbstractRestBean;
import org.rhq.enterprise.server.rest.SetCallerInterceptor;
import org.rhq.enterprise.server.rest.StuffNotFoundException;
import org.rhq.enterprise.server.rest.domain.GroupRest;
import org.rhq.enterprise.server.rest.domain.ResourceWithType;
import org.rhq.enterprise.server.rest.domain.UserRest;

@Produces(value={"application/json", "application/xml", "text/plain", "text/html"})
@Path(value="/user")
@Api(value="Api that deals with user related stuff")
@Interceptors(value={SetCallerInterceptor.class})
@Stateless
public class UserHandlerBean
extends AbstractRestBean {
    public static final String RESOURCE_HEALTH_RESOURCES = ".dashContent.resourcehealth.resources";
    public static final String GROUP_HEALTH_GROUPS = ".dashContent.grouphealth.groups";
    @EJB
    SubjectManagerLocal subjectManager;
    @EJB
    ResourceManagerLocal resourceManager;
    @PersistenceContext(unitName="rhqpu")
    private EntityManager entityManager;

    @GZIP
    @GET
    @Path(value="favorites/resource")
    @ApiOperation(value="Return a list of favorite resources of the caller", multiValueResponse=true, responseClass="ResourceWithType")
    public Response getFavorites(@Context UriInfo uriInfo, @Context HttpHeaders httpHeaders) {
        Response.ResponseBuilder builder;
        Set<Integer> favIds = this.getResourceIdsForFavorites();
        ArrayList<ResourceWithType> ret = new ArrayList<ResourceWithType>();
        MediaType mediaType = (MediaType)httpHeaders.getAcceptableMediaTypes().get(0);
        for (Integer id : favIds) {
            try {
                Resource res = this.resourceManager.getResource(this.caller, id);
                ResourceWithType rwt = this.fillRWT(res, uriInfo);
                ret.add(rwt);
            }
            catch (Exception e) {
                if (e instanceof ResourceNotFoundException) {
                    this.log.debug((Object)("Favorite resource with id " + id + " not found - not returning to the user"));
                    continue;
                }
                this.log.warn((Object)("Retrieving resource with id " + id + " failed: " + e.getLocalizedMessage()));
            }
        }
        if (mediaType.equals((Object)MediaType.TEXT_HTML_TYPE)) {
            builder = Response.ok((Object)this.renderTemplate("listResourceWithType", ret), (MediaType)mediaType);
        } else {
            GenericEntity<List<ResourceWithType>> list = new GenericEntity<List<ResourceWithType>>(ret){};
            builder = Response.ok((Object)list);
        }
        return builder.build();
    }

    @GZIP
    @GET
    @Path(value="favorites/group")
    @ApiOperation(value="Return a list of favorite groups of the caller", multiValueResponse=true, responseClass="GroupRest")
    public Response getGroupFavorites(@Context UriInfo uriInfo, @Context HttpHeaders httpHeaders) {
        Response.ResponseBuilder builder;
        Set<Integer> favIds = this.getGroupIdsForFavorites();
        ArrayList<GroupRest> ret = new ArrayList<GroupRest>();
        MediaType mediaType = (MediaType)httpHeaders.getAcceptableMediaTypes().get(0);
        for (Integer id : favIds) {
            try {
                ResourceGroup res = this.resourceGroupManager.getResourceGroup(this.caller, id);
                GroupRest rwt = this.fillGroup(res, uriInfo);
                ret.add(rwt);
            }
            catch (Exception e) {
                if (e instanceof ResourceGroupNotFoundException) {
                    this.log.debug((Object)("Favorite group with id " + id + " not found - not returning to the user"));
                    continue;
                }
                this.log.warn((Object)("Retrieving group with id " + id + " failed: " + e.getLocalizedMessage()));
            }
        }
        if (mediaType.equals((Object)MediaType.TEXT_HTML_TYPE)) {
            builder = Response.ok((Object)this.renderTemplate("listGroup", ret), (MediaType)mediaType);
        } else {
            GenericEntity<List<GroupRest>> list = new GenericEntity<List<GroupRest>>(ret){};
            builder = Response.ok((Object)list);
        }
        return builder.build();
    }

    @PUT
    @Path(value="favorites/resource/{id}")
    @ApiOperation(value="Add a resource as favorite for the caller")
    public void addFavoriteResource(@ApiParam(name="id", value="Id of the resource") @PathParam(value="id") int resourceId) {
        this.fetchResource(resourceId);
        Set<Integer> favIds = this.getResourceIdsForFavorites();
        if (!favIds.contains(resourceId)) {
            favIds.add(resourceId);
            this.updateResourceFavorites(favIds);
        }
    }

    @PUT
    @Path(value="favorites/group/{id}")
    @ApiOperation(value="Add a group as favorite for the caller")
    public void addFavoriteResourceGroup(@ApiParam(name="id", value="Id of the group") @PathParam(value="id") int groupId) {
        this.fetchGroup(groupId, false);
        Set<Integer> favIds = this.getGroupIdsForFavorites();
        if (!favIds.contains(groupId)) {
            favIds.add(groupId);
            this.updateGroupFavorites(favIds);
        }
    }

    @DELETE
    @Path(value="favorites/resource/{id}")
    @ApiOperation(value="Remove a resource from favorites")
    public void removeResourceFromFavorites(@ApiParam(name="id", value="Id of the resource") @PathParam(value="id") int id) {
        Set<Integer> favIds = this.getResourceIdsForFavorites();
        if (favIds.contains(id)) {
            favIds.remove(id);
            this.updateResourceFavorites(favIds);
        }
    }

    @DELETE
    @Path(value="favorites/group/{id}")
    @ApiOperation(value="Remove a group from favorites")
    public void removeResourceGroupFromFavorites(@ApiParam(name="id", value="Id of the group") @PathParam(value="id") int id) {
        Set<Integer> favIds = this.getGroupIdsForFavorites();
        if (favIds.contains(id)) {
            favIds.remove(id);
            this.updateGroupFavorites(favIds);
        }
    }

    @GET
    @Cache(maxAge=600)
    @Path(value="{id}")
    @ApiOperation(value="Get info about a user", responseClass="UserRest")
    public Response getUserDetails(@ApiParam(value="Login of the user") @PathParam(value="id") String loginName, @Context Request request, @Context HttpHeaders headers) {
        Subject subject = this.subjectManager.getSubjectByName(loginName);
        if (subject == null) {
            throw new StuffNotFoundException("User with login " + loginName);
        }
        EntityTag eTag = new EntityTag(Long.toOctalString(subject.hashCode()));
        Response.ResponseBuilder builder = request.evaluatePreconditions(eTag);
        if (builder == null) {
            UserRest user = new UserRest(subject.getId(), subject.getName());
            user.setFirstName(subject.getFirstName());
            user.setLastName(subject.getLastName());
            user.setEmail(subject.getEmailAddress());
            user.setTel(subject.getPhoneNumber());
            MediaType mediaType = (MediaType)headers.getAcceptableMediaTypes().get(0);
            builder = Response.ok((Object)user, (MediaType)mediaType);
            builder.tag(eTag);
        }
        return builder.build();
    }

    private void updateResourceFavorites(Set<Integer> favIds) {
        Configuration conf = this.caller.getUserConfiguration();
        StringBuilder builder = this.buildFavStringFromSet(favIds);
        PropertySimple prop = conf.getSimple(RESOURCE_HEALTH_RESOURCES);
        if (prop == null) {
            conf.put((Property)new PropertySimple(RESOURCE_HEALTH_RESOURCES, (Object)builder.toString()));
        } else {
            prop.setStringValue(builder.toString());
        }
        this.caller.setUserConfiguration(conf);
        this.subjectManager.updateSubject(this.caller, this.caller);
    }

    private void updateGroupFavorites(Set<Integer> favIds) {
        Configuration conf = this.caller.getUserConfiguration();
        StringBuilder builder = this.buildFavStringFromSet(favIds);
        PropertySimple prop = conf.getSimple(GROUP_HEALTH_GROUPS);
        if (prop == null) {
            conf.put((Property)new PropertySimple(GROUP_HEALTH_GROUPS, (Object)builder.toString()));
        } else {
            prop.setStringValue(builder.toString());
        }
        this.caller.setUserConfiguration(conf);
        this.subjectManager.updateSubject(this.caller, this.caller);
    }

    private Set<Integer> getResourceIdsForFavorites() {
        Configuration conf = this.caller.getUserConfiguration();
        String favsString = conf.getSimpleValue(RESOURCE_HEALTH_RESOURCES, "");
        Set<Integer> favIds = this.getIdsFromFavString(favsString);
        return favIds;
    }

    private Set<Integer> getGroupIdsForFavorites() {
        Configuration conf = this.caller.getUserConfiguration();
        String favsString = conf.getSimpleValue(GROUP_HEALTH_GROUPS, "");
        Set<Integer> favIds = this.getIdsFromFavString(favsString);
        return favIds;
    }

    private Set<Integer> getIdsFromFavString(String favsString) {
        TreeSet<Integer> favIds = new TreeSet<Integer>();
        if (!favsString.isEmpty()) {
            String[] favStringArray;
            for (String tmp : favStringArray = favsString.split("\\|")) {
                favIds.add(Integer.valueOf(tmp));
            }
        }
        return favIds;
    }

    private StringBuilder buildFavStringFromSet(Set<Integer> favIds) {
        StringBuilder builder = new StringBuilder();
        Iterator<Integer> iter = favIds.iterator();
        while (iter.hasNext()) {
            builder.append(iter.next());
            if (!iter.hasNext()) continue;
            builder.append('|');
        }
        return builder;
    }
}

