/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.rest.domain;

import com.wordnik.swagger.annotations.ApiClass;
import com.wordnik.swagger.annotations.ApiProperty;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlRootElement;
import org.rhq.enterprise.server.rest.domain.AlertConditionRest;
import org.rhq.enterprise.server.rest.domain.AlertNotificationRest;

@ApiClass(value="Representation of an AlertDefinition")
@XmlRootElement(name="definition")
public class AlertDefinitionRest {
    int id;
    String name;
    boolean enabled;
    String priority = "LOW";
    int recoveryId;
    String conditionMode = "ANY";
    List<AlertConditionRest> conditions = new ArrayList<AlertConditionRest>();
    List<AlertNotificationRest> notifications = new ArrayList<AlertNotificationRest>();
    String dampeningCategory;
    String dampeningCount;
    String dampeningPeriod;

    public AlertDefinitionRest() {
    }

    public AlertDefinitionRest(int id) {
        this.id = id;
    }

    @ApiProperty(value="The id of the definition")
    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    @ApiProperty(value="The name of the definition")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @ApiProperty(value="Is the definition enabled(=active)?")
    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    @ApiProperty(value="The priority of the definition", allowableValues="LOW, MEDIUM, HIGH")
    public String getPriority() {
        return this.priority;
    }

    public void setPriority(String priority) {
        this.priority = priority;
    }

    @ApiProperty(value="Id of an alert definition to recover")
    public int getRecoveryId() {
        return this.recoveryId;
    }

    public void setRecoveryId(int recoveryId) {
        this.recoveryId = recoveryId;
    }

    @ApiProperty(value="Expression to use for condition logic", allowableValues="ALL, ANY")
    public String getConditionMode() {
        return this.conditionMode;
    }

    public void setConditionMode(String conditionMode) {
        this.conditionMode = conditionMode;
    }

    @ApiProperty(value="List of Conditions. Only sent if explicitly requested.")
    public List<AlertConditionRest> getConditions() {
        return this.conditions;
    }

    public void setConditions(List<AlertConditionRest> conditions) {
        this.conditions = conditions;
    }

    @ApiProperty(value="List of notifications. Only sent if explicitly requested.")
    public List<AlertNotificationRest> getNotifications() {
        return this.notifications;
    }

    public void setNotifications(List<AlertNotificationRest> notifications) {
        this.notifications = notifications;
    }

    @ApiProperty(value="Category for dampening. ONCE means 'disable definition after firing'", allowableValues="NONE, CONSECUTIVE_COUNT, PARTIAL_COUNT, INVERSE_COUNT, DURATION_COUNT, NO_DUPLICATES, ONCE")
    public String getDampeningCategory() {
        return this.dampeningCategory;
    }

    public void setDampeningCategory(String dampeningCategory) {
        this.dampeningCategory = dampeningCategory;
    }

    @ApiProperty(value="Number of occurrences of an alert (in a given period)")
    public String getDampeningCount() {
        return this.dampeningCount;
    }

    public void setDampeningCount(String dampeningCount) {
        this.dampeningCount = dampeningCount;
    }

    @ApiProperty(value="Period to check events. Only applicable for PARTIAL_COUNT, DURATION_COUNT, INVERSE_COUNT")
    public String getDampeningPeriod() {
        return this.dampeningPeriod;
    }

    public void setDampeningPeriod(String dampeningPeriod) {
        this.dampeningPeriod = dampeningPeriod;
    }
}

