/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.rest.reporting;

import java.io.IOException;
import java.io.OutputStream;
import javax.ejb.EJB;
import javax.ejb.Stateless;
import javax.interceptor.Interceptors;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.StreamingOutput;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.domain.alert.AlertDefinition;
import org.rhq.core.domain.auth.Subject;
import org.rhq.core.domain.criteria.AlertDefinitionCriteria;
import org.rhq.core.domain.util.PageList;
import org.rhq.enterprise.server.alert.AlertDefinitionManagerLocal;
import org.rhq.enterprise.server.resource.ResourceManagerLocal;
import org.rhq.enterprise.server.rest.AbstractRestBean;
import org.rhq.enterprise.server.rest.ReportsInterceptor;
import org.rhq.enterprise.server.rest.reporting.AlertDefinitionLocal;
import org.rhq.enterprise.server.rest.reporting.CsvWriter;
import org.rhq.enterprise.server.rest.reporting.PropertyConverter;
import org.rhq.enterprise.server.rest.reporting.ReportFormatHelper;
import org.rhq.enterprise.server.util.CriteriaQuery;
import org.rhq.enterprise.server.util.CriteriaQueryExecutor;

@Interceptors(value={ReportsInterceptor.class})
@Stateless
public class AlertDefinitionHandler
extends AbstractRestBean
implements AlertDefinitionLocal {
    private final Log log = LogFactory.getLog(AlertDefinitionHandler.class);
    @EJB
    private AlertDefinitionManagerLocal alertDefinitionManager;
    @EJB
    ResourceManagerLocal resourceManager;

    @Override
    public StreamingOutput alertDefinitions(HttpServletRequest request) {
        return this.alertDefinitionsInternal(request, this.caller);
    }

    @Override
    public StreamingOutput alertDefinitionsInternal(final HttpServletRequest request, Subject user) {
        this.caller = user;
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Received request to generate report for " + this.caller));
        }
        return new StreamingOutput(){

            public void write(OutputStream stream) throws IOException, WebApplicationException {
                AlertDefinitionCriteria criteria = new AlertDefinitionCriteria();
                criteria.addFilterResourceOnly(true);
                criteria.fetchGroupAlertDefinition(true);
                criteria.fetchResource(true);
                criteria.fetchResourceType(true);
                CriteriaQueryExecutor<AlertDefinition, AlertDefinitionCriteria> queryExecutor = new CriteriaQueryExecutor<AlertDefinition, AlertDefinitionCriteria>(){

                    @Override
                    public PageList<AlertDefinition> execute(AlertDefinitionCriteria criteria) {
                        return AlertDefinitionHandler.this.alertDefinitionManager.findAlertDefinitionsByCriteria(AlertDefinitionHandler.this.caller, criteria);
                    }
                };
                CriteriaQuery<AlertDefinition, AlertDefinitionCriteria> query = new CriteriaQuery<AlertDefinition, AlertDefinitionCriteria>(criteria, queryExecutor);
                CsvWriter<AlertDefinition> csvWriter = new CsvWriter<AlertDefinition>();
                csvWriter.setColumns("name", "description", "enabled", "priority", "parent", "ancestry", "detailsURL");
                csvWriter.setPropertyConverter("parent", new PropertyConverter<AlertDefinition>(){

                    @Override
                    public Object convert(AlertDefinition alertDef, String propertyName) {
                        return this.getParentURL(alertDef);
                    }
                });
                csvWriter.setPropertyConverter("ancestry", new PropertyConverter<AlertDefinition>(){

                    @Override
                    public Object convert(AlertDefinition alertDef, String propertyName) {
                        return ReportFormatHelper.parseAncestry(alertDef.getResource().getAncestry());
                    }
                });
                csvWriter.setPropertyConverter("detailsURL", new PropertyConverter<AlertDefinition>(){

                    @Override
                    public Object convert(AlertDefinition alertDef, String propertyName) {
                        return this.getDetailsURL(alertDef);
                    }
                });
                stream.write((this.getHeader() + "\n").getBytes());
                for (AlertDefinition alertDef : query) {
                    csvWriter.write(alertDef, stream);
                }
            }

            private String getParentURL(AlertDefinition alertDef) {
                Integer templateId = alertDef.getParentId();
                if (templateId != null && templateId > 0) {
                    return this.getBaseURL() + "/#Administration/Configuration/AlertDefTemplates/" + alertDef.getResource().getResourceType().getId() + "/" + templateId;
                }
                if (alertDef.getGroupAlertDefinition() != null) {
                    return this.getBaseURL() + "/#ResourceGroup/" + alertDef.getGroupAlertDefinition().getResourceGroup().getId() + "/Alerts/Definitions/" + alertDef.getGroupAlertDefinition().getId();
                }
                return "";
            }

            private String getHeader() {
                return "Name,Description,Enabled,Priority,Parent,Ancestry,Details URL";
            }

            private String getDetailsURL(AlertDefinition alertDef) {
                return this.getBaseURL() + "/#Resource/" + alertDef.getResource().getId() + "/Alerts/Definitions/" + alertDef.getId();
            }

            private String getBaseURL() {
                String protocol = request.isSecure() ? "https" : "http";
                return protocol + "://" + request.getServerName() + ":" + request.getServerPort() + "/coregui";
            }
        };
    }
}

