/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.rest.reporting;

import java.text.DecimalFormat;
import org.rhq.core.domain.measurement.MeasurementUnits;
import org.rhq.core.domain.measurement.composite.MeasurementNumericValueAndUnits;
import org.rhq.core.domain.measurement.util.MeasurementConversionException;

public class MeasurementConverter {
    private static final int MAX_PRECISION_DIGITS = 4;
    private static final String NULL_OR_NAN_FORMATTED_VALUE = "--no data available--";

    public static String format(Double value, MeasurementUnits targetUnits, boolean bestFit) {
        return MeasurementConverter.format(value, targetUnits, bestFit, null, null);
    }

    public static String format(Double value, MeasurementUnits targetUnits, boolean bestFit, Integer minimumFractionDigits, Integer maximumFractionDigits) {
        if (value == null || Double.isNaN(value)) {
            return NULL_OR_NAN_FORMATTED_VALUE;
        }
        if (bestFit) {
            MeasurementNumericValueAndUnits valueAndUnits = MeasurementConverter.fit(value, targetUnits);
            value = valueAndUnits.getValue();
            targetUnits = valueAndUnits.getUnits();
        }
        if (targetUnits != null && MeasurementUnits.Family.RELATIVE == targetUnits.getFamily()) {
            value = MeasurementUnits.scaleUp((Double)value, (MeasurementUnits)targetUnits);
        }
        DecimalFormat numberFormat = new DecimalFormat(MeasurementConverter.getFormat(minimumFractionDigits != null ? minimumFractionDigits : 1, maximumFractionDigits != null ? maximumFractionDigits : 1));
        String formatted = numberFormat.format(value);
        return MeasurementConverter.format(formatted, targetUnits);
    }

    public static String format(String value, MeasurementUnits targetUnits) {
        if (targetUnits == null) {
            return value;
        }
        return value + MeasurementConverter.getMeasurementUnitAbbreviation(targetUnits);
    }

    public static MeasurementNumericValueAndUnits fit(Double origin, MeasurementUnits units) {
        return MeasurementConverter.fit(origin, units, null, null);
    }

    public static MeasurementNumericValueAndUnits fit(Double origin, MeasurementUnits units, MeasurementUnits lowUnits, MeasurementUnits highUnits) {
        MeasurementUnits smallerUnits;
        int nextOrdinal;
        int minOrdinal;
        Double smallerValue;
        MeasurementUnits biggerUnits;
        MeasurementNumericValueAndUnits currentValueAndUnits;
        int nextOrdinal2;
        int maxOrdinal;
        if (null == units) {
            return new MeasurementNumericValueAndUnits(origin, units);
        }
        if (MeasurementUnits.Family.ABSOLUTE == units.getFamily() || MeasurementUnits.Family.DURATION == units.getFamily()) {
            return new MeasurementNumericValueAndUnits(origin, units);
        }
        if (MeasurementUnits.Family.RELATIVE == units.getFamily()) {
            return new MeasurementNumericValueAndUnits(origin, units);
        }
        if (MeasurementUnits.Family.TEMPERATURE == units.getFamily()) {
            return new MeasurementNumericValueAndUnits(origin, units);
        }
        if (Math.abs(origin) < 1.0E-9) {
            return new MeasurementNumericValueAndUnits(origin, units);
        }
        boolean wasNegative = false;
        if (origin < 0.0) {
            wasNegative = true;
            origin = -origin.doubleValue();
        }
        MeasurementNumericValueAndUnits nextValueAndUnits = new MeasurementNumericValueAndUnits(origin, units);
        int n = maxOrdinal = highUnits != null ? highUnits.ordinal() + 1 : MeasurementUnits.values().length;
        while ((nextOrdinal2 = (currentValueAndUnits = nextValueAndUnits).getUnits().ordinal() + 1) != maxOrdinal && (biggerUnits = MeasurementUnits.values()[nextOrdinal2]).getFamily() == currentValueAndUnits.getUnits().getFamily() && (nextValueAndUnits = new MeasurementNumericValueAndUnits(smallerValue = MeasurementConverter.scale(currentValueAndUnits, biggerUnits), biggerUnits)).getValue() > 1.0) {
        }
        int n2 = minOrdinal = lowUnits != null ? lowUnits.ordinal() - 1 : -1;
        while (currentValueAndUnits.getValue() < 1.0 && (nextOrdinal = currentValueAndUnits.getUnits().ordinal() - 1) != minOrdinal && (smallerUnits = MeasurementUnits.values()[nextOrdinal]).getFamily() == currentValueAndUnits.getUnits().getFamily()) {
            Double biggerValue = MeasurementConverter.scale(currentValueAndUnits, smallerUnits);
            currentValueAndUnits = nextValueAndUnits = new MeasurementNumericValueAndUnits(biggerValue, smallerUnits);
        }
        if (wasNegative) {
            return new MeasurementNumericValueAndUnits(Double.valueOf(-currentValueAndUnits.getValue().doubleValue()), currentValueAndUnits.getUnits());
        }
        return currentValueAndUnits;
    }

    public static Double scale(MeasurementNumericValueAndUnits origin, MeasurementUnits targetUnits) throws MeasurementConversionException {
        MeasurementUnits originUnits = origin.getUnits();
        Double originValue = origin.getValue();
        return originValue * MeasurementUnits.calculateOffset((MeasurementUnits)originUnits, (MeasurementUnits)targetUnits);
    }

    public static String getMeasurementUnitAbbreviation(MeasurementUnits units) {
        switch (units) {
            case NONE: {
                return "";
            }
            case PERCENTAGE: {
                return "%";
            }
            case BYTES: {
                return "B";
            }
            case KILOBYTES: {
                return "KB";
            }
            case MEGABYTES: {
                return "MB";
            }
            case GIGABYTES: {
                return "GB";
            }
            case TERABYTES: {
                return "TB";
            }
            case PETABYTES: {
                return "PB";
            }
            case BITS: {
                return "b";
            }
            case KILOBITS: {
                return "kb";
            }
            case MEGABITS: {
                return "Mb";
            }
            case GIGABITS: {
                return "Gb";
            }
            case TERABITS: {
                return "Tb";
            }
            case PETABITS: {
                return "Pb";
            }
            case EPOCH_MILLISECONDS: {
                return "";
            }
            case EPOCH_SECONDS: {
                return "";
            }
            case JIFFYS: {
                return "j";
            }
            case NANOSECONDS: {
                return "ns";
            }
            case MICROSECONDS: {
                return "us";
            }
            case MILLISECONDS: {
                return "ms";
            }
            case SECONDS: {
                return "s";
            }
            case MINUTES: {
                return "m";
            }
            case HOURS: {
                return "h";
            }
            case DAYS: {
                return "d";
            }
            case CELSIUS: {
                return "C";
            }
            case KELVIN: {
                return "K";
            }
            case FAHRENHEIGHT: {
                return "F";
            }
        }
        return units.toString();
    }

    public static String getFormat(int minDigits, int maxDigits) {
        int i;
        StringBuilder buf = new StringBuilder("0.");
        for (i = 0; i < minDigits; ++i) {
            buf.append("0");
        }
        for (i = 0; i < maxDigits - minDigits; ++i) {
            buf.append("#");
        }
        return buf.toString();
    }
}

