/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.scheduler.jobs;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.quartz.JobDataMap;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.rhq.core.domain.alert.AlertConditionOperator;
import org.rhq.core.domain.measurement.AvailabilityType;
import org.rhq.core.domain.measurement.ResourceAvailability;
import org.rhq.enterprise.server.alert.engine.AlertConditionCacheStats;
import org.rhq.enterprise.server.alert.engine.model.AvailabilityDurationComposite;
import org.rhq.enterprise.server.scheduler.jobs.AbstractStatefulJob;
import org.rhq.enterprise.server.util.LookupUtil;

public class AlertAvailabilityDurationJob
extends AbstractStatefulJob {
    private static final Log LOG = LogFactory.getLog(AlertAvailabilityDurationJob.class);
    public static final String DATAMAP_CONDITION_ID = "alertConditionId";
    public static final String DATAMAP_DURATION = "duration";
    public static final String DATAMAP_OPERATOR = "alertConditionOperator";
    public static final String DATAMAP_RESOURCE_ID = "resourceId";

    @Override
    public void executeJobCode(JobExecutionContext context) throws JobExecutionException {
        JobDataMap jobDataMap = context.getTrigger().getJobDataMap();
        int conditionId = Integer.valueOf(jobDataMap.getString(DATAMAP_CONDITION_ID));
        int resourceId = Integer.valueOf(jobDataMap.getString(DATAMAP_RESOURCE_ID));
        long duration = Long.valueOf(jobDataMap.getString(DATAMAP_DURATION));
        AlertConditionOperator operator = AlertConditionOperator.valueOf((String)jobDataMap.getString(DATAMAP_OPERATOR));
        ResourceAvailability resourceAvail = LookupUtil.getResourceAvailabilityManager().getLatestAvailability(resourceId);
        AvailabilityType availType = resourceAvail.getAvailabilityType();
        boolean checkConditions = false;
        switch (operator) {
            case AVAIL_DURATION_DOWN: {
                checkConditions = AvailabilityType.DOWN == availType;
                break;
            }
            case AVAIL_DURATION_NOT_UP: {
                boolean bl = checkConditions = AvailabilityType.UP != availType;
            }
        }
        if (checkConditions) {
            AvailabilityDurationComposite composite = new AvailabilityDurationComposite(conditionId, operator, resourceId, availType, duration);
            AlertConditionCacheStats stats = LookupUtil.getAlertConditionCacheManager().checkConditions(composite);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("AlertAvailabilityDurationJob: " + stats.toString()));
            }
        }
    }
}

