/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.system;

import java.util.HashMap;
import java.util.Map;
import javax.ejb.EJB;
import javax.ejb.Stateless;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.domain.alert.Alert;
import org.rhq.core.domain.alert.AlertDefinition;
import org.rhq.core.domain.auth.Subject;
import org.rhq.core.domain.common.ProductInfo;
import org.rhq.core.domain.common.ServerDetails;
import org.rhq.core.domain.common.composite.SystemSetting;
import org.rhq.core.domain.common.composite.SystemSettings;
import org.rhq.core.domain.criteria.AlertCriteria;
import org.rhq.core.domain.criteria.AlertDefinitionCriteria;
import org.rhq.core.domain.criteria.Criteria;
import org.rhq.core.domain.criteria.ResourceCriteria;
import org.rhq.core.domain.resource.Resource;
import org.rhq.core.domain.resource.ResourceCategory;
import org.rhq.core.domain.util.PageList;
import org.rhq.enterprise.server.alert.AlertDefinitionManagerLocal;
import org.rhq.enterprise.server.alert.AlertManagerLocal;
import org.rhq.enterprise.server.measurement.MeasurementScheduleManagerLocal;
import org.rhq.enterprise.server.resource.ResourceManagerLocal;
import org.rhq.enterprise.server.system.SystemInfoManagerLocal;
import org.rhq.enterprise.server.system.SystemManagerLocal;

@Stateless
public class SystemInfoManagerBean
implements SystemInfoManagerLocal {
    Log log = LogFactory.getLog((String)"SystemInfoManager");
    @EJB
    SystemManagerLocal systemManager;
    @EJB
    MeasurementScheduleManagerLocal scheduleManager;
    @EJB
    ResourceManagerLocal resourceManager;
    @EJB
    AlertManagerLocal alertManager;
    @EJB
    AlertDefinitionManagerLocal alertDefinitionManager;

    @Override
    public Map<String, String> getSystemInformation(Subject caller) {
        HashMap<String, String> result = new HashMap<String, String>();
        ServerDetails details = this.systemManager.getServerDetails(caller);
        HashMap detailsMap = details.getDetails();
        for (Map.Entry detail : detailsMap.entrySet()) {
            result.put(((ServerDetails.Detail)detail.getKey()).toString(), (String)detail.getValue());
        }
        ProductInfo productInfo = details.getProductInfo();
        result.put("BuildNumber", productInfo.getBuildNumber());
        result.put("FullName", productInfo.getFullName());
        result.put("Name", productInfo.getName());
        SystemSettings systemSettings = this.systemManager.getSystemSettings(caller);
        Map settingsMap = systemSettings.toMap();
        for (Map.Entry detail : settingsMap.entrySet()) {
            String key = (String)detail.getKey();
            if (key.equals(SystemSetting.LDAP_BIND_PW.getInternalName()) || key.equals(SystemSetting.HELP_PASSWORD.getInternalName())) {
                if (detail.getValue() == null) {
                    result.put(key, "- null -");
                    continue;
                }
                result.put(key, "- non null -");
                continue;
            }
            result.put(key, (String)detail.getValue());
        }
        result.putAll(this.getStats(caller));
        return result;
    }

    @Override
    public void dumpToLog(Subject caller) {
        Map<String, String> infoMap = this.getSystemInformation(caller);
        StringBuilder builder = new StringBuilder("\n");
        for (Map.Entry<String, String> entry : infoMap.entrySet()) {
            builder.append(entry.getKey());
            builder.append(": [");
            builder.append(entry.getValue());
            builder.append("]\n");
        }
        this.log.info((Object)("SystemInformation: ********" + builder.toString() + "********"));
    }

    private Map<String, String> getStats(Subject caller) {
        HashMap<String, String> result = new HashMap<String, String>();
        ResourceCriteria criteria = new ResourceCriteria();
        criteria.addFilterResourceCategories(new ResourceCategory[]{ResourceCategory.PLATFORM});
        criteria.setRestriction(Criteria.Restriction.COUNT_ONLY);
        PageList<Resource> resList = this.resourceManager.findResourcesByCriteria(caller, criteria);
        result.put("PlatformCount", String.valueOf(resList.getTotalSize()));
        criteria = new ResourceCriteria();
        criteria.addFilterResourceCategories(new ResourceCategory[]{ResourceCategory.SERVER});
        criteria.setRestriction(Criteria.Restriction.COUNT_ONLY);
        resList = this.resourceManager.findResourcesByCriteria(caller, criteria);
        result.put("ServerCount", String.valueOf(resList.getTotalSize()));
        criteria = new ResourceCriteria();
        criteria.addFilterResourceCategories(new ResourceCategory[]{ResourceCategory.SERVICE});
        criteria.setRestriction(Criteria.Restriction.COUNT_ONLY);
        resList = this.resourceManager.findResourcesByCriteria(caller, criteria);
        result.put("ServiceCount", String.valueOf(resList.getTotalSize()));
        AlertCriteria alertCriteria = new AlertCriteria();
        alertCriteria.setRestriction(Criteria.Restriction.COUNT_ONLY);
        PageList<Alert> alertList = this.alertManager.findAlertsByCriteria(caller, alertCriteria);
        result.put("AlertCount", String.valueOf(alertList.getTotalSize()));
        AlertDefinitionCriteria alertDefinitionCriteria = new AlertDefinitionCriteria();
        alertDefinitionCriteria.setRestriction(Criteria.Restriction.COUNT_ONLY);
        PageList<AlertDefinition> defList = this.alertDefinitionManager.findAlertDefinitionsByCriteria(caller, alertDefinitionCriteria);
        result.put("AlertDefinitionCount", String.valueOf(defList.getTotalSize()));
        result.put("SchedulesPerMinute", String.valueOf(this.scheduleManager.getScheduledMeasurementsPerMinute()));
        return result;
    }
}

