/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.util;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.rhq.core.domain.criteria.BaseCriteria;
import org.rhq.core.domain.util.PageControl;
import org.rhq.core.domain.util.PageList;
import org.rhq.enterprise.server.util.CriteriaQueryExecutor;

public class CriteriaQuery<T, C extends BaseCriteria>
implements Iterable<T> {
    private C criteria;
    private CriteriaQueryExecutor<T, C> queryExecutor;

    public CriteriaQuery(C criteria, CriteriaQueryExecutor<T, C> queryExecutor) {
        this.criteria = criteria;
        this.queryExecutor = queryExecutor;
    }

    @Override
    public Iterator<T> iterator() {
        return new QueryResultsIterator(this.executeQuery());
    }

    private PageList<T> executeQuery() {
        return this.queryExecutor.execute(this.criteria);
    }

    private class QueryResultsIterator
    implements Iterator<T> {
        private int count;
        private PageList<T> currentPage;
        private Iterator<T> iterator;

        public QueryResultsIterator(PageList<T> firstPage) {
            this.currentPage = firstPage;
            this.iterator = this.currentPage.iterator();
        }

        @Override
        public boolean hasNext() {
            return this.count < this.currentPage.getTotalSize();
        }

        @Override
        public T next() {
            if (!this.iterator.hasNext()) {
                if (this.count == this.currentPage.getTotalSize()) {
                    throw new NoSuchElementException();
                }
                PageControl pc = this.currentPage.getPageControl();
                CriteriaQuery.this.criteria.setPaging(pc.getPageNumber() + 1, pc.getPageSize());
                this.currentPage = CriteriaQuery.this.queryExecutor.execute(CriteriaQuery.this.criteria);
                this.iterator = this.currentPage.iterator();
            }
            Object next = this.iterator.next();
            ++this.count;
            return next;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("This iterator does not support removal.");
        }
    }
}

