/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.cloud;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ejb.EJB;
import javax.ejb.Stateless;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import javax.persistence.TypedQuery;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.quartz.SimpleTrigger;
import org.quartz.Trigger;
import org.rhq.core.domain.auth.Subject;
import org.rhq.core.domain.authz.Permission;
import org.rhq.core.domain.cloud.StorageNode;
import org.rhq.core.domain.cloud.StorageNodeLoadComposite;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.criteria.Criteria;
import org.rhq.core.domain.criteria.StorageNodeCriteria;
import org.rhq.core.domain.measurement.AvailabilityType;
import org.rhq.core.domain.measurement.MeasurementAggregate;
import org.rhq.core.domain.measurement.MeasurementUnits;
import org.rhq.core.domain.resource.InventoryStatus;
import org.rhq.core.domain.resource.Resource;
import org.rhq.core.domain.util.PageList;
import org.rhq.core.util.StringUtil;
import org.rhq.enterprise.server.authz.RequiredPermission;
import org.rhq.enterprise.server.cloud.StorageNodeManagerLocal;
import org.rhq.enterprise.server.cloud.StorageNodeManagerRemote;
import org.rhq.enterprise.server.measurement.MeasurementDataManagerLocal;
import org.rhq.enterprise.server.rest.reporting.MeasurementConverter;
import org.rhq.enterprise.server.scheduler.SchedulerLocal;
import org.rhq.enterprise.server.scheduler.jobs.StorageNodeMaintenanceJob;
import org.rhq.enterprise.server.util.CriteriaQueryGenerator;
import org.rhq.enterprise.server.util.CriteriaQueryRunner;

@Stateless
public class StorageNodeManagerBean
implements StorageNodeManagerLocal,
StorageNodeManagerRemote {
    private final Log log = LogFactory.getLog(StorageNodeManagerBean.class);
    private static final String RHQ_STORAGE_RESOURCE_TYPE = "RHQ Storage Node";
    private static final String RHQ_STORAGE_PLUGIN = "RHQStorage";
    private static final String RHQ_STORAGE_CQL_PORT_PROPERTY = "nativeTransportPort";
    private static final String RHQ_STORAGE_JMX_PORT_PROPERTY = "jmxPort";
    private static final String RHQ_STORAGE_ADDRESS_PROPERTY = "host";
    private static final String SEEDS_PROP = "rhq.cassandra.seeds";
    @PersistenceContext(unitName="rhqpu")
    private EntityManager entityManager;
    @EJB
    private MeasurementDataManagerLocal measurementManager;
    @EJB
    private SchedulerLocal quartzScheduler;

    @Override
    public synchronized List<StorageNode> scanForStorageNodes() {
        String seeds;
        List<StorageNode> existingStorageNodes = this.getStorageNodes();
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Found existing storage nodes [" + StringUtil.listToString(existingStorageNodes) + "] in the database"));
        }
        if (StringUtil.isEmpty((String)(seeds = System.getProperty(SEEDS_PROP))) && existingStorageNodes.isEmpty()) {
            throw new IllegalStateException("There are no existing storage nodes defined in the RHQ database and the system property [rhq.cassandra.seeds] is not set. The RHQ server will not be able to connect to the RHQ storage node(s). The [rhq.cassandra.seeds] property should be defined in rhq-server.properties.");
        }
        List<StorageNode> seedNodes = this.parseSeedsProperty(seeds);
        boolean clusterMaintenanceNeeded = false;
        List<StorageNode> newNodes = null;
        if (existingStorageNodes.isEmpty()) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)"No storage node entities exist in the database");
                this.log.debug((Object)("Persisting seed nodes [" + StringUtil.listToString(seedNodes) + "]"));
            }
        } else {
            newNodes = this.findNewStorageNodes(existingStorageNodes, seedNodes);
            if (!newNodes.isEmpty()) {
                this.log.info((Object)"Detected topology change. New seed nodes will be persisted.");
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("Persisting new seed nodes [" + StringUtil.listToString(newNodes)));
                }
                clusterMaintenanceNeeded = true;
            }
        }
        HashMap<String, StorageNode> storageNodeMap = new HashMap<String, StorageNode>(existingStorageNodes.size() + seedNodes.size());
        for (StorageNode existingStorageNode : existingStorageNodes) {
            storageNodeMap.put(existingStorageNode.getAddress(), existingStorageNode);
        }
        for (StorageNode seedNode : seedNodes) {
            StorageNode existing = (StorageNode)storageNodeMap.get(seedNode.getAddress());
            if (existing != null) {
                if (existing.getJmxPort() != seedNode.getJmxPort() || existing.getCqlPort() != seedNode.getCqlPort() || existing.getResource() != seedNode.getResource()) {
                    existing.setMtime(new Date().getTime());
                }
                seedNode.setResource(existing.getResource());
            }
            storageNodeMap.put(seedNode.getAddress(), seedNode);
        }
        this.discoverResourceInformation(storageNodeMap);
        this.updateStorageNodes(storageNodeMap);
        if (clusterMaintenanceNeeded) {
            this.scheduleQuartzJob();
        }
        return new ArrayList<StorageNode>(storageNodeMap.values());
    }

    @Override
    public void linkResource(Resource resource) {
        List<StorageNode> storageNodes = this.getStorageNodes();
        Configuration resourceConfig = resource.getPluginConfiguration();
        String configAddress = resourceConfig.getSimpleValue(RHQ_STORAGE_ADDRESS_PROPERTY);
        if (configAddress != null) {
            boolean storageNodeFound = false;
            if (storageNodes != null) {
                for (StorageNode storageNode : storageNodes) {
                    if (!configAddress.equals(storageNode.getAddress())) continue;
                    storageNode.setResource(resource);
                    storageNode.setOperationMode(StorageNode.OperationMode.NORMAL);
                    storageNodeFound = true;
                    break;
                }
            }
            if (!storageNodeFound) {
                int cqlPort = Integer.parseInt(resourceConfig.getSimpleValue(RHQ_STORAGE_CQL_PORT_PROPERTY));
                int jmxPort = Integer.parseInt(resourceConfig.getSimpleValue(RHQ_STORAGE_JMX_PORT_PROPERTY));
                StorageNode storageNode = new StorageNode();
                storageNode.setAddress(configAddress);
                storageNode.setCqlPort(cqlPort);
                storageNode.setJmxPort(jmxPort);
                storageNode.setResource(resource);
                storageNode.setOperationMode(StorageNode.OperationMode.NORMAL);
                this.entityManager.persist((Object)storageNode);
                this.scheduleQuartzJob();
            }
        }
    }

    @Override
    @RequiredPermission(value=Permission.MANAGE_SETTINGS)
    public StorageNodeLoadComposite getLoad(Subject subject, StorageNode node, long beginTime, long endTime) {
        StorageNodeLoadComposite result = new StorageNodeLoadComposite(node, beginTime, endTime);
        String tokensMetric = "Tokens";
        String ownershipMetric = "Ownership";
        String loadMetric = "Load";
        String diskUsedPercentageMetric = "Calculated.DiskSpaceUsedPercentage";
        String heapCommittedMetric = "{HeapMemoryUsage.committed}";
        String heapUsedMetric = "{HeapMemoryUsage.used}";
        String heapUsedPercentageMetric = "Calculated.HeapUsagePercentage";
        if (node.getResource() == null && (node = (StorageNode)this.entityManager.find(StorageNode.class, (Object)node.getId())).getResource() == null) {
            throw new IllegalStateException("This storage node [" + node.getId() + "] has no associated resource.");
        }
        int resourceId = node.getResource().getId();
        TypedQuery query = this.entityManager.createNamedQuery("StorageNode.findScheduleIdsByParentResourceIdAndMeasurementDefinitionNames", Object[].class);
        query.setParameter("parrentId", (Object)resourceId).setParameter("metricNames", Arrays.asList("Tokens", "Ownership", "Load", "Calculated.DiskSpaceUsedPercentage"));
        List scheduleIds = query.getResultList();
        HashMap<String, Integer> scheduleIdsMap = new HashMap<String, Integer>(4);
        for (Object[] pair : scheduleIds) {
            scheduleIdsMap.put((String)pair[0], (Integer)pair[1]);
        }
        query = this.entityManager.createNamedQuery("StorageNode.findScheduleIdsByGrandparentResourceIdAndMeasurementDefinitionNames", Object[].class);
        query.setParameter("grandparrentId", (Object)resourceId).setParameter("metricNames", Arrays.asList("{HeapMemoryUsage.committed}", "{HeapMemoryUsage.used}", "Calculated.HeapUsagePercentage"));
        scheduleIds = query.getResultList();
        for (Object[] pair : scheduleIds) {
            scheduleIdsMap.put((String)pair[0], (Integer)pair[1]);
        }
        if (!scheduleIdsMap.isEmpty()) {
            if (scheduleIdsMap.get("Tokens") != null) {
                MeasurementAggregate tokensAggregate = this.measurementManager.getAggregate(subject, (Integer)scheduleIdsMap.get("Tokens"), beginTime, endTime);
                result.setTokens(tokensAggregate);
            }
            if (scheduleIdsMap.get("Ownership") != null) {
                StorageNodeLoadComposite.MeasurementAggregateWithUnits ownershipAggregateWithUnits = this.getMeasurementAggregateWithUnits(subject, (Integer)scheduleIdsMap.get("Ownership"), MeasurementUnits.PERCENTAGE, beginTime, endTime);
                result.setActuallyOwns(ownershipAggregateWithUnits);
            }
            if (scheduleIdsMap.get("Load") != null) {
                StorageNodeLoadComposite.MeasurementAggregateWithUnits loadAggregateWithUnits = this.getMeasurementAggregateWithUnits(subject, (Integer)scheduleIdsMap.get("Load"), MeasurementUnits.BYTES, beginTime, endTime);
                result.setLoad(loadAggregateWithUnits);
            }
            if (scheduleIdsMap.get("Calculated.DiskSpaceUsedPercentage") != null) {
                StorageNodeLoadComposite.MeasurementAggregateWithUnits diskUsedPercentageAggregateWithUnits = this.getMeasurementAggregateWithUnits(subject, (Integer)scheduleIdsMap.get("Calculated.DiskSpaceUsedPercentage"), MeasurementUnits.PERCENTAGE, beginTime, endTime);
                result.setDiskSpacePercentageUsed(diskUsedPercentageAggregateWithUnits);
            }
            if (scheduleIdsMap.get("{HeapMemoryUsage.committed}") != null) {
                StorageNodeLoadComposite.MeasurementAggregateWithUnits heapCommittedAggregateWithUnits = this.getMeasurementAggregateWithUnits(subject, (Integer)scheduleIdsMap.get("{HeapMemoryUsage.committed}"), MeasurementUnits.BYTES, beginTime, endTime);
                result.setHeapCommitted(heapCommittedAggregateWithUnits);
            }
            if (scheduleIdsMap.get("{HeapMemoryUsage.used}") != null) {
                StorageNodeLoadComposite.MeasurementAggregateWithUnits heapUsedAggregateWithUnits = this.getMeasurementAggregateWithUnits(subject, (Integer)scheduleIdsMap.get("{HeapMemoryUsage.used}"), MeasurementUnits.BYTES, beginTime, endTime);
                result.setHeapUsed(heapUsedAggregateWithUnits);
            }
            if (scheduleIdsMap.get("Calculated.HeapUsagePercentage") != null) {
                StorageNodeLoadComposite.MeasurementAggregateWithUnits heapUsedPercentageAggregateWithUnits = this.getMeasurementAggregateWithUnits(subject, (Integer)scheduleIdsMap.get("Calculated.HeapUsagePercentage"), MeasurementUnits.PERCENTAGE, beginTime, endTime);
                result.setHeapPercentageUsed(heapUsedPercentageAggregateWithUnits);
            }
        }
        return result;
    }

    private StorageNodeLoadComposite.MeasurementAggregateWithUnits getMeasurementAggregateWithUnits(Subject subject, int schedId, MeasurementUnits units, long beginTime, long endTime) {
        MeasurementAggregate measurementAggregate = this.measurementManager.getAggregate(subject, schedId, beginTime, endTime);
        StorageNodeLoadComposite.MeasurementAggregateWithUnits measurementAggregateWithUnits = new StorageNodeLoadComposite.MeasurementAggregateWithUnits(measurementAggregate, units);
        measurementAggregateWithUnits.setFormattedValue(this.getSummaryString(measurementAggregate, units));
        return measurementAggregateWithUnits;
    }

    @Override
    public List<StorageNode> getStorageNodes() {
        TypedQuery query = this.entityManager.createNamedQuery("StorageNode.findAll", StorageNode.class);
        return query.getResultList();
    }

    @Override
    @RequiredPermission(value=Permission.MANAGE_SETTINGS)
    public PageList<StorageNode> findStorageNodesByCriteria(Subject subject, StorageNodeCriteria criteria) {
        CriteriaQueryGenerator generator = new CriteriaQueryGenerator(subject, (Criteria)criteria);
        CriteriaQueryRunner runner = new CriteriaQueryRunner((Criteria)criteria, generator, this.entityManager);
        return runner.execute();
    }

    private String getSummaryString(MeasurementAggregate aggregate, MeasurementUnits units) {
        String formattedValue = "Min: " + MeasurementConverter.format(aggregate.getMin(), units, true) + ", Max: " + MeasurementConverter.format(aggregate.getMax(), units, true) + ", Avg: " + MeasurementConverter.format(aggregate.getAvg(), units, true);
        return formattedValue;
    }

    private List<StorageNode> parseSeedsProperty(String seedsProperty) {
        String[] seeds = seedsProperty.split(",");
        ArrayList<StorageNode> storageNodes = new ArrayList<StorageNode>();
        for (String seed : seeds) {
            StorageNode node = new StorageNode();
            node.setOperationMode(StorageNode.OperationMode.INSTALLED);
            node.parseNodeInformation(seed);
            storageNodes.add(node);
        }
        return storageNodes;
    }

    private List<StorageNode> findNewStorageNodes(List<StorageNode> nodes, List<StorageNode> seedNodes) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"Checking system property [rhq.cassandra.seeds] for any new nodes to be persisted");
        }
        ArrayList<StorageNode> newNodes = new ArrayList<StorageNode>();
        for (StorageNode seedNode : seedNodes) {
            if (nodes.contains(seedNode)) continue;
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Detected new storage node [" + seedNode + "]"));
            }
            newNodes.add(seedNode);
        }
        return newNodes;
    }

    private void scheduleQuartzJob() {
        String jobName = StorageNodeMaintenanceJob.class.getName();
        String jobGroupName = StorageNodeMaintenanceJob.class.getName();
        String triggerName = StorageNodeMaintenanceJob.class.getName();
        Date jobTime = new Date(System.currentTimeMillis() + 30000L);
        SimpleTrigger trigger = new SimpleTrigger(triggerName, jobGroupName, jobTime);
        trigger.setJobName(jobName);
        trigger.setJobGroup(jobGroupName);
        try {
            this.quartzScheduler.scheduleJob((Trigger)trigger);
        }
        catch (Throwable t) {
            this.log.warn((Object)"Unable to schedule storage node maintenance job", t);
        }
    }

    private void updateStorageNodes(Map<String, StorageNode> storageNodeMap) {
        for (Map.Entry<String, StorageNode> storageNodeEntry : storageNodeMap.entrySet()) {
            TypedQuery query = this.entityManager.createNamedQuery("StorageNode.findByName", StorageNode.class);
            query.setParameter("address", (Object)storageNodeEntry.getKey());
            List result = query.getResultList();
            if (!result.isEmpty()) {
                storageNodeEntry.getValue().setId(((StorageNode)result.get(0)).getId());
                this.entityManager.merge((Object)storageNodeEntry.getValue());
                continue;
            }
            this.entityManager.persist((Object)storageNodeEntry.getValue());
        }
        this.entityManager.flush();
    }

    private void discoverResourceInformation(Map<String, StorageNode> storageNodeMap) {
        Query query = this.entityManager.createNamedQuery("ResourceType.findByNameAndPlugin").setParameter("name", (Object)RHQ_STORAGE_RESOURCE_TYPE).setParameter("plugin", (Object)RHQ_STORAGE_PLUGIN);
        List resourceTypes = query.getResultList();
        if (resourceTypes.isEmpty()) {
            return;
        }
        query = this.entityManager.createNamedQuery("Resource.findByType_admin").setParameter("type", resourceTypes.get(0));
        List cassandraResources = query.getResultList();
        for (Resource resource : cassandraResources) {
            Configuration resourceConfiguration = resource.getPluginConfiguration();
            String host = resourceConfiguration.getSimpleValue(RHQ_STORAGE_ADDRESS_PROPERTY);
            if (host == null || !storageNodeMap.containsKey(host)) continue;
            StorageNode storageNode = storageNodeMap.get(host);
            storageNode.setResource(resource);
            if (resource.getInventoryStatus() == InventoryStatus.NEW) {
                storageNode.setOperationMode(StorageNode.OperationMode.INSTALLED);
                continue;
            }
            if (resource.getInventoryStatus() != InventoryStatus.COMMITTED || resource.getCurrentAvailability().getAvailabilityType() != AvailabilityType.UP) continue;
            storageNode.setOperationMode(StorageNode.OperationMode.NORMAL);
        }
    }
}

