/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.core.comm;

import java.io.InputStream;
import java.io.OutputStream;
import java.lang.management.ManagementFactory;
import javax.management.MBeanServer;
import javax.management.MBeanServerInvocationHandler;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.util.exception.WrappedRemotingException;
import org.rhq.enterprise.communications.ServiceContainer;
import org.rhq.enterprise.communications.command.client.RemoteInputStream;
import org.rhq.enterprise.communications.command.client.RemoteOutputStream;
import org.rhq.enterprise.server.core.comm.ServerCommunicationsServiceMBean;

public class ServerCommunicationsServiceUtil {
    private static final Log LOG = LogFactory.getLog(ServerCommunicationsServiceUtil.class);

    private ServerCommunicationsServiceUtil() {
    }

    public static ServerCommunicationsServiceMBean getService() {
        ServerCommunicationsServiceMBean serverBootstrapService;
        try {
            MBeanServer mbean_server = ManagementFactory.getPlatformMBeanServer();
            serverBootstrapService = MBeanServerInvocationHandler.newProxyInstance(mbean_server, ServerCommunicationsServiceMBean.OBJECT_NAME, ServerCommunicationsServiceMBean.class, false);
        }
        catch (Exception e) {
            LOG.error((Object)"Could not find server comm service - agent communications are not allowed at this time");
            throw new WrappedRemotingException((Throwable)new Exception("Cannot get server comm service; unable to communicate with agents", e));
        }
        return serverBootstrapService;
    }

    public static RemoteInputStream remoteInputStream(InputStream in) throws Exception {
        ServiceContainer sc = ServerCommunicationsServiceUtil.getService().getServiceContainer();
        return new RemoteInputStream(in, sc);
    }

    public static RemoteOutputStream remoteInputStream(OutputStream out) throws Exception {
        ServiceContainer sc = ServerCommunicationsServiceUtil.getService().getServiceContainer();
        return new RemoteOutputStream(out, sc);
    }
}

