/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.sync;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.zip.GZIPInputStream;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.domain.auth.Subject;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.sync.ConsistencyValidatorFailureReport;
import org.rhq.core.domain.sync.ExportReport;
import org.rhq.core.domain.sync.ExportWrapper;
import org.rhq.core.domain.sync.ExporterMessages;
import org.rhq.core.domain.sync.ImportConfiguration;
import org.rhq.core.domain.sync.ImportConfigurationDefinition;
import org.rhq.core.domain.sync.ImportReport;
import org.rhq.core.util.stream.StreamUtil;
import org.rhq.enterprise.server.sync.DefaultImportConfigurationDescriptor;
import org.rhq.enterprise.server.sync.ExportReader;
import org.rhq.enterprise.server.sync.ExportingInputStream;
import org.rhq.enterprise.server.sync.ImportException;
import org.rhq.enterprise.server.sync.SynchronizationManagerLocal;
import org.rhq.enterprise.server.sync.SynchronizationManagerRemote;
import org.rhq.enterprise.server.sync.Synchronizer;
import org.rhq.enterprise.server.sync.SynchronizerFactory;
import org.rhq.enterprise.server.sync.ValidationException;
import org.rhq.enterprise.server.sync.importers.ExportedEntityMatcher;
import org.rhq.enterprise.server.sync.importers.Importer;
import org.rhq.enterprise.server.sync.validators.ConsistencyValidator;
import org.rhq.enterprise.server.sync.validators.EntityValidator;
import org.rhq.enterprise.server.sync.validators.InconsistentStateException;
import org.rhq.enterprise.server.xmlschema.ConfigurationInstanceDescriptorUtil;
import org.rhq.enterprise.server.xmlschema.generated.configuration.instance.ConfigurationInstanceDescriptor;

@Stateless
public class SynchronizationManagerBean
implements SynchronizationManagerLocal,
SynchronizationManagerRemote {
    private static final Log LOG = LogFactory.getLog(SynchronizationManagerBean.class);
    @PersistenceContext(unitName="rhqpu")
    private EntityManager entityManager;
    private JAXBContext defaultImportConfigurationJAXBContext;
    private SynchronizerFactory synchronizerFactory = new SynchronizerFactory();

    public SynchronizationManagerBean() {
        try {
            this.defaultImportConfigurationJAXBContext = JAXBContext.newInstance((Class[])new Class[]{DefaultImportConfigurationDescriptor.class});
        }
        catch (JAXBException e) {
            throw new IllegalStateException("Failed to create DefaultImportConfigurationDescriptor unmarshaller. This should never happen.");
        }
    }

    @Override
    public void setSynchronizerFactory(SynchronizerFactory factory) {
        this.synchronizerFactory = factory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @TransactionAttribute(value=TransactionAttributeType.NOT_SUPPORTED)
    public ExportReport exportAllSubsystems(Subject subject) {
        ExportWrapper localExport = this.exportAllSubsystemsLocally(subject);
        byte[] buffer = new byte[65536];
        ByteArrayOutputStream out = new ByteArrayOutputStream(10240);
        try {
            int cnt = 0;
            while ((cnt = localExport.getExportFile().read(buffer)) != -1) {
                out.write(buffer, 0, cnt);
            }
            ExportReport exportReport = new ExportReport(localExport.getMessagesPerExporter(), out.toByteArray());
            return exportReport;
        }
        catch (Exception e) {
            ExportReport exportReport = new ExportReport(e.getMessage());
            return exportReport;
        }
        finally {
            try {
                out.close();
            }
            catch (Exception e) {
                LOG.error((Object)"Closing a byte array output stream failed. This should never happen.");
            }
            try {
                localExport.getExportFile().close();
            }
            catch (Exception e) {
                LOG.warn((Object)"Failed to close the export file stream.", (Throwable)e);
            }
        }
    }

    @Override
    @TransactionAttribute(value=TransactionAttributeType.NOT_SUPPORTED)
    public ExportWrapper exportAllSubsystemsLocally(Subject subject) {
        Set<Synchronizer<?, ?>> allSynchronizers = this.getInitializedSynchronizers(subject);
        HashMap<String, ExporterMessages> messages = new HashMap<String, ExporterMessages>();
        try {
            return new ExportWrapper(messages, (InputStream)new ExportingInputStream(allSynchronizers, messages));
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to initialize the export.", e);
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public ImportReport importAllSubsystems(Subject subject, InputStream exportFile, List<ImportConfiguration> configurations) throws ValidationException, ImportException {
        ImportReport importReport;
        File tmpFile = null;
        FileOutputStream tmpFileOut = null;
        tmpFile = File.createTempFile("rhq-synchronization", "tmp");
        tmpFileOut = new FileOutputStream(tmpFile);
        StreamUtil.copy((InputStream)exportFile, (OutputStream)tmpFileOut);
        tmpFileOut.close();
        StreamUtil.safeClose((Closeable)tmpFileOut);
        GZIPInputStream in = null;
        try {
            Map<String, Configuration> configsPerImports = this.getConfigPerImporter(configurations);
            in = new GZIPInputStream(new BufferedInputStream(new FileInputStream(tmpFile)));
            this.validateExport(subject, in, configsPerImports);
            ((InputStream)in).close();
            in = new GZIPInputStream(new BufferedInputStream(new FileInputStream(tmpFile)));
            importReport = this.importExportFile(subject, in, configsPerImports);
        }
        catch (XMLStreamException e) {
            try {
                throw new ImportException("Failed import due to XML parsing error.", e);
                catch (IOException e2) {
                    throw new ImportException("The provided file is not a gzipped XML.", e2);
                }
            }
            catch (Throwable throwable) {
                StreamUtil.safeClose(in);
                tmpFile.delete();
                throw throwable;
            }
        }
        catch (IOException e) {
            try {
                throw new ImportException("Failed to copy the exportFile to a temporary location.", e);
            }
            catch (Throwable throwable) {
                StreamUtil.safeClose(tmpFileOut);
                throw throwable;
            }
        }
        StreamUtil.safeClose((Closeable)in);
        tmpFile.delete();
        return importReport;
    }

    @Override
    public ImportReport importAllSubsystems(Subject subject, byte[] exportFile, List<ImportConfiguration> configurations) throws ValidationException, ImportException {
        return this.importAllSubsystems(subject, new ByteArrayInputStream(exportFile), configurations);
    }

    @Override
    public void validate(Subject subject, InputStream exportFile) throws ValidationException {
        try {
            this.validateExport(subject, exportFile, Collections.<String, Configuration>emptyMap());
        }
        catch (XMLStreamException e) {
            throw new ValidationException("Failed to parse the export file.", e);
        }
    }

    @Override
    public void validate(Subject subject, byte[] exportFile) throws ValidationException {
        this.validate(subject, new ByteArrayInputStream(exportFile));
    }

    @Override
    public ImportConfigurationDefinition getImportConfigurationDefinition(String synchronizerClass) {
        try {
            Class<?> cls = Class.forName(synchronizerClass);
            if (!Synchronizer.class.isAssignableFrom(cls)) {
                LOG.debug((Object)("Supplied synchronizer class does not implement the synchronizer interface: '" + synchronizerClass + "'."));
                return null;
            }
            Synchronizer syn = (Synchronizer)cls.newInstance();
            return new ImportConfigurationDefinition(synchronizerClass, syn.getImporter().getImportConfigurationDefinition());
        }
        catch (ClassNotFoundException e) {
            LOG.debug((Object)("Supplied synchronizer class is invalid: '" + synchronizerClass + "'."), (Throwable)e);
            return null;
        }
        catch (Exception e) {
            LOG.error((Object)("Failed to instantiate the synchronizer '" + synchronizerClass + "'. This should not happen."));
            throw new IllegalStateException("Failed to instantiate synchronizer '" + synchronizerClass + ".", e);
        }
    }

    @Override
    public List<ImportConfigurationDefinition> getImportConfigurationDefinitionOfAllSynchronizers() {
        ArrayList<ImportConfigurationDefinition> ret = new ArrayList<ImportConfigurationDefinition>();
        for (Synchronizer<?, ?> syn : this.synchronizerFactory.getAllSynchronizers()) {
            ret.add(new ImportConfigurationDefinition(syn.getClass().getName(), syn.getImporter().getImportConfigurationDefinition()));
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void validateExport(Subject subject, InputStream exportFile, Map<String, Configuration> importConfigs) throws ValidationException, XMLStreamException {
        XMLStreamReader rdr = XMLInputFactory.newInstance().createXMLStreamReader(exportFile);
        try {
            HashSet<ConsistencyValidatorFailureReport> failures = new HashSet<ConsistencyValidatorFailureReport>();
            HashSet<ConsistencyValidator> consistencyValidators = new HashSet<ConsistencyValidator>();
            while (rdr.hasNext()) {
                switch (rdr.next()) {
                    case 1: {
                        String tagName = rdr.getName().getLocalPart();
                        if ("validator".equals(tagName)) {
                            ConsistencyValidator validator = null;
                            String validatorClass = rdr.getAttributeValue(null, "class");
                            if (!this.isConsistencyValidatorClass(validatorClass)) {
                                LOG.info((Object)("The export file contains an unknown consistency validator: " + validatorClass + ". Ignoring."));
                                break;
                            }
                            try {
                                validator = this.validateSingle(rdr, subject);
                            }
                            catch (Exception e) {
                                failures.add(new ConsistencyValidatorFailureReport(validatorClass, SynchronizationManagerBean.printExceptionToString(e)));
                            }
                            if (validator == null) break;
                            consistencyValidators.add(validator);
                            break;
                        }
                        if (!"entities".equals(tagName)) break;
                        String synchronizerClass = rdr.getAttributeValue(null, "id");
                        try {
                            failures.addAll(this.validateEntities(rdr, subject, consistencyValidators, importConfigs));
                            break;
                        }
                        catch (Exception e) {
                            throw new ValidationException("Validation failed unexpectedly while processing the entities exported by the synchronizer '" + synchronizerClass + "'.", e);
                        }
                    }
                }
            }
            if (!failures.isEmpty()) {
                throw new ValidationException(failures);
            }
        }
        finally {
            rdr.close();
        }
    }

    private boolean isConsistencyValidatorClass(String validatorClass) {
        try {
            Class<?> cls = Class.forName(validatorClass);
            return ConsistencyValidator.class.isAssignableFrom(cls);
        }
        catch (Exception e) {
            return false;
        }
    }

    private <E, X> Set<ConsistencyValidatorFailureReport> validateEntities(XMLStreamReader rdr, Subject subject, Set<ConsistencyValidator> consistencyValidators, Map<String, Configuration> importConfigurations) throws Exception {
        String synchronizerClass = rdr.getAttributeValue(null, "id");
        HashSet<ConsistencyValidatorFailureReport> ret = new HashSet<ConsistencyValidatorFailureReport>();
        Synchronizer synchronizer = this.instantiate(synchronizerClass, Synchronizer.class, "The id attribute of entities doesn't correspond to a class implementing the Synchronizer interface.");
        synchronizer.initialize(subject, this.entityManager);
        Importer importer = synchronizer.getImporter();
        Set<ConsistencyValidator> requriedConsistencyValidators = synchronizer.getRequiredValidators();
        for (ConsistencyValidator v : requriedConsistencyValidators) {
            if (consistencyValidators.contains(v)) continue;
            ret.add(new ConsistencyValidatorFailureReport(v.getClass().getName(), "The validator '" + v.getClass().getName() + "' is required by the synchronizer '" + synchronizerClass + "' but was not found in the export file."));
        }
        if (!ret.isEmpty()) {
            return ret;
        }
        boolean configured = false;
        Configuration importConfiguration = importConfigurations.get(synchronizerClass);
        Set validators = null;
        if (importConfiguration != null) {
            importer.configure(importConfiguration);
            validators = importer.getEntityValidators();
            for (EntityValidator v : validators) {
                v.initialize(subject, this.entityManager);
            }
            configured = true;
        }
        while (rdr.hasNext()) {
            boolean bailout = false;
            switch (rdr.next()) {
                case 1: {
                    if ("default-configuration".equals(rdr.getName().getLocalPart())) {
                        if (configured) break;
                        importConfiguration = this.getDefaultConfiguration(rdr);
                        break;
                    }
                    if (!"data".equals(rdr.getName().getLocalPart())) break;
                    if (!configured) {
                        importer.configure(importConfiguration);
                        validators = importer.getEntityValidators();
                        for (EntityValidator v : validators) {
                            v.initialize(subject, this.entityManager);
                        }
                        configured = true;
                    }
                    rdr.nextTag();
                    Object exportedEntity = importer.unmarshallExportedEntity(new ExportReader(rdr));
                    for (EntityValidator validator : validators) {
                        try {
                            validator.validateExportedEntity(exportedEntity);
                        }
                        catch (Exception e) {
                            ValidationException v = new ValidationException("Failed to validate entity [" + exportedEntity + "]", e);
                            ret.add(new ConsistencyValidatorFailureReport(validator.getClass().getName(), SynchronizationManagerBean.printExceptionToString(v)));
                        }
                    }
                    break;
                }
                case 2: {
                    if (!"entities".equals(rdr.getName().getLocalPart())) break;
                    bailout = true;
                }
            }
            if (!bailout) continue;
            break;
        }
        return ret;
    }

    private ImportReport importExportFile(Subject subject, InputStream exportFile, Map<String, Configuration> importerConfigs) throws ImportException, XMLStreamException {
        XMLStreamReader rdr = XMLInputFactory.newInstance().createXMLStreamReader(exportFile);
        ImportReport report = new ImportReport();
        block5: while (rdr.hasNext()) {
            switch (rdr.next()) {
                case 1: {
                    String tagName = rdr.getName().getLocalPart();
                    if (!"entities".equals(tagName)) break;
                    try {
                        String synchronizer = rdr.getAttributeValue(null, "id");
                        String notes = this.importSingle(subject, importerConfigs, rdr);
                        if (notes == null) continue block5;
                        report.getImporterNotes().put(synchronizer, notes);
                        break;
                    }
                    catch (Exception e) {
                        throw new ImportException("Import failed.", e);
                    }
                }
            }
        }
        return report;
    }

    private ConsistencyValidator validateSingle(XMLStreamReader rdr, Subject subject) throws InstantiationException, IllegalAccessException, ClassNotFoundException, XMLStreamException, InconsistentStateException {
        String validatorClassName = rdr.getAttributeValue(null, "class");
        ConsistencyValidator validator = this.instantiate(validatorClassName, ConsistencyValidator.class, "The validator class denoted in the export file ('%s') does not implement the ConsistencyValidator interface. This should not happen.");
        validator.initialize(subject, this.entityManager);
        validator.initializeExportedStateValidation(new ExportReader(rdr));
        validator.validateExportedState();
        return validator;
    }

    private <E, X> String importSingle(Subject subject, Map<String, Configuration> importConfigs, XMLStreamReader rdr) throws Exception {
        String synchronizerClassName = rdr.getAttributeValue(null, "id");
        Synchronizer synchronizer = this.instantiate(synchronizerClassName, Synchronizer.class, "The synchronizer denoted in the export file ('%s') does not implement the importer interface. This should not happen.");
        synchronizer.initialize(subject, this.entityManager);
        Importer importer = synchronizer.getImporter();
        ExportedEntityMatcher matcher = null;
        boolean configured = false;
        Configuration importConfiguration = importConfigs.get(synchronizerClassName);
        if (importConfiguration != null) {
            importer.configure(importConfiguration);
            matcher = importer.getExportedEntityMatcher();
            configured = true;
        }
        while (rdr.hasNext()) {
            boolean bailout = false;
            switch (rdr.next()) {
                case 1: {
                    if ("default-configuration".equals(rdr.getName().getLocalPart())) {
                        if (configured) break;
                        importConfiguration = this.getDefaultConfiguration(rdr);
                        break;
                    }
                    if (!"data".equals(rdr.getName().getLocalPart())) break;
                    if (!configured) {
                        importer.configure(importConfiguration);
                        matcher = importer.getExportedEntityMatcher();
                        configured = true;
                    }
                    rdr.nextTag();
                    Object exportedEntity = importer.unmarshallExportedEntity(new ExportReader(rdr));
                    Object entity = matcher == null ? null : (Object)matcher.findMatch(exportedEntity);
                    importer.update(entity, exportedEntity);
                    break;
                }
                case 2: {
                    if (!"entities".equals(rdr.getName().getLocalPart())) break;
                    bailout = true;
                }
            }
            if (!bailout) continue;
            break;
        }
        if (!configured) {
            importer.configure(importConfiguration);
        }
        return importer.finishImport();
    }

    private static String printExceptionToString(Throwable t) {
        StringWriter str = new StringWriter();
        PrintWriter wrt = new PrintWriter(str);
        t.printStackTrace(wrt);
        return str.toString();
    }

    private <T> T instantiate(String className, Class<T> desiredClass, String notAssignableErrorMessage) throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        Class<?> cls = Class.forName(className);
        if (!desiredClass.isAssignableFrom(cls)) {
            throw new IllegalStateException(String.format(notAssignableErrorMessage, className, desiredClass.getName()));
        }
        Object instance = cls.newInstance();
        return desiredClass.cast(instance);
    }

    private Set<Synchronizer<?, ?>> getInitializedSynchronizers(Subject subject) {
        Set<Synchronizer<?, ?>> ret = this.synchronizerFactory.getAllSynchronizers();
        for (Synchronizer<?, ?> s : ret) {
            s.initialize(subject, this.entityManager);
        }
        return ret;
    }

    private Map<String, Configuration> getConfigPerImporter(List<ImportConfiguration> list) {
        HashMap<String, Configuration> ret = new HashMap<String, Configuration>();
        if (list != null) {
            for (ImportConfiguration ic : list) {
                ret.put(ic.getSynchronizerClassName(), ic.getConfiguration());
            }
        }
        return ret;
    }

    private Configuration getDefaultConfiguration(XMLStreamReader rdr) throws JAXBException {
        Unmarshaller unmarshaller = this.defaultImportConfigurationJAXBContext.createUnmarshaller();
        DefaultImportConfigurationDescriptor descriptor = (DefaultImportConfigurationDescriptor)((Object)unmarshaller.unmarshal(rdr));
        ConfigurationInstanceDescriptorUtil.ConfigurationAndDefinition ccd = ConfigurationInstanceDescriptorUtil.createConfigurationAndDefinition((ConfigurationInstanceDescriptor)descriptor);
        return ccd.configuration;
    }
}

