/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.alert;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.ejb.EJB;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.domain.alert.AlertDefinition;
import org.rhq.core.domain.auth.Subject;
import org.rhq.core.domain.authz.Permission;
import org.rhq.core.domain.resource.InventoryStatus;
import org.rhq.core.domain.resource.ResourceType;
import org.rhq.core.domain.server.PersistenceUtility;
import org.rhq.core.domain.util.PageControl;
import org.rhq.core.domain.util.PageList;
import org.rhq.core.domain.util.PageOrdering;
import org.rhq.core.util.collection.ArrayUtils;
import org.rhq.enterprise.server.alert.AlertDefinitionCreationException;
import org.rhq.enterprise.server.alert.AlertDefinitionManagerLocal;
import org.rhq.enterprise.server.alert.AlertDefinitionUpdateException;
import org.rhq.enterprise.server.alert.AlertNotificationValidationException;
import org.rhq.enterprise.server.alert.AlertTemplateManagerLocal;
import org.rhq.enterprise.server.alert.InvalidAlertDefinitionException;
import org.rhq.enterprise.server.auth.SubjectManagerLocal;
import org.rhq.enterprise.server.authz.AuthorizationManagerLocal;
import org.rhq.enterprise.server.authz.RequiredPermission;
import org.rhq.enterprise.server.resource.ResourceTypeManagerLocal;
import org.rhq.enterprise.server.resource.ResourceTypeNotFoundException;
import org.rhq.enterprise.server.safeinvoker.HibernateDetachUtility;

@Stateless
public class AlertTemplateManagerBean
implements AlertTemplateManagerLocal {
    private static final Log LOG = LogFactory.getLog(AlertTemplateManagerBean.class);
    @PersistenceContext(unitName="rhqpu")
    private EntityManager entityManager;
    @EJB
    private AuthorizationManagerLocal authorizationManager;
    @EJB
    private AlertDefinitionManagerLocal alertDefinitionManager;
    @EJB
    private ResourceTypeManagerLocal resourceTypeManager;
    @EJB
    private SubjectManagerLocal subjectManager;

    @Override
    public PageList<AlertDefinition> getAlertTemplates(Subject user, int resourceTypeId, PageControl pageControl) {
        pageControl.initDefaultOrderingField("ctime", PageOrdering.DESC);
        Query queryCount = PersistenceUtility.createCountQuery((EntityManager)this.entityManager, (String)"AlertDefinition.findByResourceType");
        Query query = PersistenceUtility.createQueryWithOrderBy((EntityManager)this.entityManager, (String)"AlertDefinition.findByResourceType", (PageControl)pageControl);
        queryCount.setParameter("typeId", (Object)resourceTypeId);
        query.setParameter("typeId", (Object)resourceTypeId);
        long totalCount = (Long)queryCount.getSingleResult();
        List list = query.getResultList();
        return new PageList((Collection)list, (int)totalCount, pageControl);
    }

    private List<Integer> getChildrenAlertDefinitionIds(Subject user, int alertTemplateId) {
        Query query = this.entityManager.createNamedQuery("AlertDefinition.findByAlertTemplateId");
        query.setParameter("alertTemplateId", (Object)alertTemplateId);
        List list = query.getResultList();
        return list;
    }

    private List<Integer> getCommittedResourceIdsNeedingTemplateApplication(Subject user, int alertTemplateId, int resourceTypeId) {
        Query query = this.entityManager.createNamedQuery("AlertDefinition.findResourceIdsNeedingTemplateApplication");
        query.setParameter("alertTemplateId", (Object)alertTemplateId);
        query.setParameter("resourceTypeId", (Object)resourceTypeId);
        query.setParameter("inventoryStatus", (Object)InventoryStatus.COMMITTED);
        List list = query.getResultList();
        return list;
    }

    @Override
    @RequiredPermission(value=Permission.MANAGE_SETTINGS)
    @TransactionAttribute(value=TransactionAttributeType.NOT_SUPPORTED)
    public int createAlertTemplate(Subject user, AlertDefinition alertTemplate, Integer resourceTypeId) throws InvalidAlertDefinitionException, ResourceTypeNotFoundException, AlertDefinitionCreationException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("createAlertTemplate: " + alertTemplate));
        }
        ResourceType type = this.resourceTypeManager.getResourceTypeById(user, resourceTypeId);
        alertTemplate.setResourceType(type);
        AlertDefinition persistedAlertTemplate = null;
        try {
            persistedAlertTemplate = this.alertDefinitionManager.createAlertDefinitionInNewTransaction(user, alertTemplate, null, true);
        }
        catch (Throwable t) {
            throw new AlertDefinitionCreationException("Could not create alertTemplate for " + type + " with data " + alertTemplate.toSimpleString(), t);
        }
        Throwable firstThrowable = null;
        List<Integer> resourceIdsForType = this.getCommittedResourceIdsNeedingTemplateApplication(user, persistedAlertTemplate.getId(), resourceTypeId);
        ArrayList<Integer> resourceIdsInError = new ArrayList<Integer>();
        for (Integer resourceId : resourceIdsForType) {
            try {
                AlertDefinition childAlertDefinition = new AlertDefinition(persistedAlertTemplate);
                childAlertDefinition.setParentId(Integer.valueOf(alertTemplate.getId()));
                this.alertDefinitionManager.createDependentAlertDefinition(user, childAlertDefinition, resourceId);
            }
            catch (Throwable t) {
                if (firstThrowable == null) {
                    firstThrowable = t;
                }
                resourceIdsInError.add(resourceId);
            }
        }
        if (firstThrowable != null) {
            throw new AlertDefinitionCreationException("Could not create child alert definition for Resources " + resourceIdsInError + " with template" + alertTemplate.toSimpleString(), firstThrowable);
        }
        return persistedAlertTemplate.getId();
    }

    @Override
    public void updateAlertDefinitionsForResource(Subject user, Integer resourceId) throws AlertDefinitionCreationException, InvalidAlertDefinitionException {
        if (!this.authorizationManager.isOverlord(user)) {
            throw new AlertDefinitionCreationException("Updating the alert definitions for a resource is an implicit system operation; It can only be performed by the overlord");
        }
        Query query = this.entityManager.createQuery(" SELECT template    FROM AlertDefinition template, Resource res   WHERE template.resourceType.id = res.resourceType.id     AND res.id = :resourceId     AND template.deleted = false     AND template.id NOT IN ( SELECT ad.id                                FROM AlertDefinition ad                               WHERE ad.resource.id = :resourceId                                 AND ad.deleted = false ) ");
        query.setParameter("resourceId", (Object)resourceId);
        List unappliedTemplates = query.getResultList();
        for (AlertDefinition template : unappliedTemplates) {
            AlertDefinition childAlertDefinition = new AlertDefinition(template);
            childAlertDefinition.setParentId(Integer.valueOf(template.getId()));
            try {
                HibernateDetachUtility.nullOutUninitializedFields((Object)childAlertDefinition, (HibernateDetachUtility.SerializationType)HibernateDetachUtility.SerializationType.SERIALIZATION);
                this.alertDefinitionManager.createAlertDefinitionInNewTransaction(user, childAlertDefinition, resourceId, false);
            }
            catch (Throwable t) {
                throw new AlertDefinitionCreationException("Failed to create child AlertDefinition for Resource[id=" + resourceId + "] with template " + template.toSimpleString());
            }
        }
    }

    @Override
    @RequiredPermission(value=Permission.MANAGE_SETTINGS)
    public void removeAlertTemplates(Subject user, Integer[] alertTemplateIds) {
        Subject overlord = this.subjectManager.getOverlord();
        for (Integer alertTemplateId : alertTemplateIds) {
            List<Integer> alertDefinitions = this.getChildrenAlertDefinitionIds(user, alertTemplateId);
            this.alertDefinitionManager.removeAlertDefinitions(user, new int[]{alertTemplateId});
            this.alertDefinitionManager.removeAlertDefinitions(overlord, ArrayUtils.unwrapCollection(alertDefinitions));
        }
    }

    @Override
    @RequiredPermission(value=Permission.MANAGE_SETTINGS)
    public void enableAlertTemplates(Subject user, Integer[] alertTemplateIds) {
        Subject overlord = this.subjectManager.getOverlord();
        for (Integer alertTemplateId : alertTemplateIds) {
            List<Integer> alertDefinitions = this.getChildrenAlertDefinitionIds(user, alertTemplateId);
            this.alertDefinitionManager.enableAlertDefinitions(user, new int[]{alertTemplateId});
            this.alertDefinitionManager.enableAlertDefinitions(overlord, ArrayUtils.unwrapCollection(alertDefinitions));
        }
    }

    @Override
    @RequiredPermission(value=Permission.MANAGE_SETTINGS)
    public void disableAlertTemplates(Subject user, Integer[] alertTemplateIds) {
        Subject overlord = this.subjectManager.getOverlord();
        for (Integer alertTemplateId : alertTemplateIds) {
            List<Integer> alertDefinitions = this.getChildrenAlertDefinitionIds(user, alertTemplateId);
            this.alertDefinitionManager.disableAlertDefinitions(user, new int[]{alertTemplateId});
            this.alertDefinitionManager.disableAlertDefinitions(overlord, ArrayUtils.unwrapCollection(alertDefinitions));
        }
    }

    @Override
    @RequiredPermission(value=Permission.MANAGE_SETTINGS)
    @TransactionAttribute(value=TransactionAttributeType.NOT_SUPPORTED)
    public AlertDefinition updateAlertTemplate(Subject user, AlertDefinition alertTemplate, boolean resetMatching) throws InvalidAlertDefinitionException, AlertDefinitionUpdateException, AlertNotificationValidationException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("updateAlertTemplate: " + alertTemplate));
        }
        AlertDefinition updated = null;
        try {
            updated = this.alertDefinitionManager.updateAlertDefinition(user, alertTemplate.getId(), alertTemplate, resetMatching);
        }
        catch (Throwable t) {
            throw new AlertDefinitionUpdateException("Failed to update an AlertTemplate " + alertTemplate.toSimpleString(), t);
        }
        Subject overlord = this.subjectManager.getOverlord();
        Throwable firstThrowable = null;
        List<Integer> alertDefinitions = this.getChildrenAlertDefinitionIds(overlord, alertTemplate.getId());
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Need to update the following children alert definition ids: " + alertDefinitions));
        }
        ArrayList<Integer> alertDefinitionIdsInError = new ArrayList<Integer>();
        for (Integer alertDefinitionId : alertDefinitions) {
            try {
                this.alertDefinitionManager.updateDependentAlertDefinition(user, alertDefinitionId, updated, resetMatching);
            }
            catch (Throwable t) {
                if (firstThrowable == null) {
                    firstThrowable = t;
                }
                alertDefinitionIdsInError.add(alertDefinitionId);
            }
        }
        List<Integer> resourceIds = this.getCommittedResourceIdsNeedingTemplateApplication(overlord, alertTemplate.getId(), this.getResourceTypeIdForAlertTemplateId(alertTemplate.getId()));
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Need to re-create alert definitions for the following resource ids: " + resourceIds));
        }
        ArrayList<Integer> resourceIdsInError = new ArrayList<Integer>();
        for (Integer resourceId : resourceIds) {
            try {
                AlertDefinition childAlertDefinition = new AlertDefinition(updated);
                childAlertDefinition.setParentId(Integer.valueOf(alertTemplate.getId()));
                this.alertDefinitionManager.createAlertDefinitionInNewTransaction(overlord, childAlertDefinition, resourceId, false);
            }
            catch (Throwable t) {
                if (firstThrowable == null) {
                    firstThrowable = t;
                }
                resourceIdsInError.add(resourceId);
            }
        }
        if (firstThrowable != null) {
            StringBuilder error = new StringBuilder();
            if (alertDefinitionIdsInError.size() != 0) {
                error.append("Failed to update child AlertDefinitions " + alertDefinitionIdsInError + "; ");
            }
            if (resourceIdsInError.size() != 0) {
                error.append("Failed to re-create child AlertDefinition for Resources " + resourceIdsInError + "; ");
            }
            throw new AlertDefinitionUpdateException(error.toString(), firstThrowable);
        }
        return updated;
    }

    private int getResourceTypeIdForAlertTemplateId(int alertTemplateId) {
        Query query = this.entityManager.createQuery("SELECT template.resourceType.id   FROM AlertDefinition template  WHERE template.id = :alertTemplateId");
        query.setParameter("alertTemplateId", (Object)alertTemplateId);
        int typeId = ((Number)query.getSingleResult()).intValue();
        return typeId;
    }
}

