/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.cloud;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.ejb.Asynchronous;
import javax.ejb.EJB;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.TypedQuery;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.domain.alert.Alert;
import org.rhq.core.domain.auth.Subject;
import org.rhq.core.domain.authz.Permission;
import org.rhq.core.domain.cloud.StorageClusterSettings;
import org.rhq.core.domain.cloud.StorageNode;
import org.rhq.core.domain.cloud.StorageNodeConfigurationComposite;
import org.rhq.core.domain.cloud.StorageNodeLoadComposite;
import org.rhq.core.domain.common.JobTrigger;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.Property;
import org.rhq.core.domain.configuration.PropertyList;
import org.rhq.core.domain.configuration.PropertySimple;
import org.rhq.core.domain.criteria.AlertCriteria;
import org.rhq.core.domain.criteria.Criteria;
import org.rhq.core.domain.criteria.ResourceCriteria;
import org.rhq.core.domain.criteria.ResourceOperationHistoryCriteria;
import org.rhq.core.domain.criteria.StorageNodeCriteria;
import org.rhq.core.domain.measurement.MeasurementAggregate;
import org.rhq.core.domain.measurement.MeasurementUnits;
import org.rhq.core.domain.measurement.composite.MeasurementDataNumericHighLowComposite;
import org.rhq.core.domain.operation.OperationRequestStatus;
import org.rhq.core.domain.operation.ResourceOperationHistory;
import org.rhq.core.domain.operation.bean.ResourceOperationSchedule;
import org.rhq.core.domain.resource.Resource;
import org.rhq.core.domain.util.PageControl;
import org.rhq.core.domain.util.PageList;
import org.rhq.core.domain.util.PageOrdering;
import org.rhq.core.domain.util.collection.ArrayUtils;
import org.rhq.enterprise.server.alert.AlertManagerLocal;
import org.rhq.enterprise.server.auth.SubjectManagerLocal;
import org.rhq.enterprise.server.authz.RequiredPermission;
import org.rhq.enterprise.server.cloud.StorageNodeManagerLocal;
import org.rhq.enterprise.server.cloud.StorageNodeManagerRemote;
import org.rhq.enterprise.server.configuration.ConfigurationManagerLocal;
import org.rhq.enterprise.server.measurement.MeasurementDataManagerLocal;
import org.rhq.enterprise.server.operation.OperationManagerLocal;
import org.rhq.enterprise.server.resource.ResourceManagerLocal;
import org.rhq.enterprise.server.resource.ResourceNotFoundException;
import org.rhq.enterprise.server.resource.ResourceTypeManagerLocal;
import org.rhq.enterprise.server.rest.reporting.MeasurementConverter;
import org.rhq.enterprise.server.scheduler.SchedulerLocal;
import org.rhq.enterprise.server.storage.StorageClientManagerBean;
import org.rhq.enterprise.server.storage.StorageClusterSettingsManagerLocal;
import org.rhq.enterprise.server.storage.StorageNodeOperationsHandlerLocal;
import org.rhq.enterprise.server.util.CriteriaQueryGenerator;
import org.rhq.enterprise.server.util.CriteriaQueryRunner;
import org.rhq.enterprise.server.util.LookupUtil;

@Stateless
public class StorageNodeManagerBean
implements StorageNodeManagerLocal,
StorageNodeManagerRemote {
    private final Log log = LogFactory.getLog(StorageNodeManagerBean.class);
    private static final String RHQ_STORAGE_CQL_PORT_PROPERTY = "nativeTransportPort";
    private static final String RHQ_STORAGE_GOSSIP_PORT_PROPERTY = "storagePort";
    private static final String RHQ_STORAGE_JMX_PORT_PROPERTY = "jmxPort";
    private static final String RHQ_STORAGE_ADDRESS_PROPERTY = "host";
    private static final int OPERATION_QUERY_TIMEOUT = 20000;
    private static final int MAX_ITERATIONS = 10;
    private static final String UPDATE_CONFIGURATION_OPERATION = "updateConfiguration";
    private static final String RESTART_OPERATION = "restart";
    private static final String METRIC_TOKENS = "Tokens";
    private static final String METRIC_OWNERSHIP = "Ownership";
    private static final String METRIC_DATA_DISK_USED_PERCENTAGE = "Calculated.DataDiskUsedPercentage";
    private static final String METRIC_TOTAL_DISK_USED_PERCENTAGE = "Calculated.TotalDiskUsedPercentage";
    private static final String METRIC_FREE_DISK_TO_DATA_RATIO = "Calculated.FreeDiskToDataSizeRatio";
    private static final String METRIC_LOAD = "Load";
    private static final String METRIC_KEY_CACHE_SIZE = "KeyCacheSize";
    private static final String METRIC_ROW_CACHE_SIZE = "RowCacheSize";
    private static final String METRIC_TOTAL_COMMIT_LOG_SIZE = "TotalCommitlogSize";
    private static final String METRIC_HEAP_COMMITED = "{HeapMemoryUsage.committed}";
    private static final String METRIC_HEAP_USED = "{HeapMemoryUsage.used}";
    private static final String METRIC_HEAP_USED_PERCENTAGE = "Calculated.HeapUsagePercentage";
    @PersistenceContext(unitName="rhqpu")
    private EntityManager entityManager;
    @EJB
    private MeasurementDataManagerLocal measurementManager;
    @EJB
    private SchedulerLocal quartzScheduler;
    @EJB
    private ResourceTypeManagerLocal resourceTypeManager;
    @EJB
    private SubjectManagerLocal subjectManager;
    @EJB
    private OperationManagerLocal operationManager;
    @EJB
    private AlertManagerLocal alertManager;
    @EJB
    private ConfigurationManagerLocal configurationManager;
    @EJB
    private StorageNodeManagerLocal storageNodeManger;
    @EJB
    private StorageClientManagerBean storageClientManager;
    @EJB
    private ResourceManagerLocal resourceManager;
    @EJB
    private StorageClusterSettingsManagerLocal storageClusterSettingsManager;
    @EJB
    private StorageNodeOperationsHandlerLocal storageNodeOperationsHandler;

    @Override
    public void linkResource(Resource resource) {
        Configuration pluginConfig = resource.getPluginConfiguration();
        String address = pluginConfig.getSimpleValue(RHQ_STORAGE_ADDRESS_PROPERTY);
        if (this.log.isInfoEnabled()) {
            this.log.info((Object)("Linking " + resource + " to storage node at " + address));
        }
        try {
            StorageNode storageNode = this.findStorageNodeByAddress(InetAddress.getByName(address));
            if (storageNode != null) {
                if (this.log.isInfoEnabled()) {
                    this.log.info((Object)(storageNode + " is an existing storage node. No cluster maintenance is necessary."));
                }
                storageNode.setResource(resource);
                storageNode.setOperationMode(StorageNode.OperationMode.NORMAL);
            } else {
                StorageClusterSettings clusterSettings = this.storageClusterSettingsManager.getClusterSettings(this.subjectManager.getOverlord());
                storageNode = this.createStorageNode(resource, clusterSettings);
                if (this.log.isInfoEnabled()) {
                    this.log.info((Object)("Scheduling cluster maintenance to deploy " + storageNode + " into the storage cluster..."));
                }
                if (clusterSettings.getAutomaticDeployment().booleanValue()) {
                    this.log.info((Object)("Deploying " + storageNode));
                    this.deployStorageNode(this.subjectManager.getOverlord(), storageNode);
                } else {
                    this.log.info((Object)("Automatic deployment is disabled. " + storageNode + " will not become part of the " + "cluster until it is deployed."));
                }
            }
        }
        catch (UnknownHostException e) {
            throw new RuntimeException("Could not resolve address [" + address + "]. The resource " + resource + " cannot be linked to a storage node", e);
        }
    }

    @Override
    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    public StorageNode createStorageNode(Resource resource, StorageClusterSettings clusterSettings) {
        Configuration pluginConfig = resource.getPluginConfiguration();
        StorageNode storageNode = new StorageNode();
        storageNode.setAddress(pluginConfig.getSimpleValue(RHQ_STORAGE_ADDRESS_PROPERTY));
        storageNode.setCqlPort(clusterSettings.getCqlPort());
        storageNode.setResource(resource);
        storageNode.setOperationMode(StorageNode.OperationMode.INSTALLED);
        this.entityManager.persist((Object)storageNode);
        return storageNode;
    }

    @Override
    @RequiredPermission(value=Permission.MANAGE_SETTINGS)
    public void deployStorageNode(Subject subject, StorageNode storageNode) {
        storageNode = (StorageNode)this.entityManager.find(StorageNode.class, (Object)storageNode.getId());
        switch (storageNode.getOperationMode()) {
            case INSTALLED: {
                storageNode.setOperationMode(StorageNode.OperationMode.ANNOUNCE);
            }
            case ANNOUNCE: {
                this.reset();
                this.storageNodeOperationsHandler.announceStorageNode(subject, storageNode);
                break;
            }
            case BOOTSTRAP: {
                this.reset();
                this.storageNodeOperationsHandler.bootstrapStorageNode(subject, storageNode);
                break;
            }
            case ADD_MAINTENANCE: {
                this.reset();
                this.storageNodeOperationsHandler.performAddNodeMaintenance(subject, storageNode);
                break;
            }
            default: {
                throw new RuntimeException("Cannot deploy " + storageNode);
            }
        }
    }

    @Override
    @RequiredPermission(value=Permission.MANAGE_SETTINGS)
    public void undeployStorageNode(Subject subject, StorageNode storageNode) {
        storageNode = (StorageNode)this.entityManager.find(StorageNode.class, (Object)storageNode.getId());
        switch (storageNode.getOperationMode()) {
            case INSTALLED: {
                this.reset();
                this.storageNodeOperationsHandler.uninstall(subject, storageNode);
                break;
            }
            case ANNOUNCE: 
            case BOOTSTRAP: {
                this.reset();
                this.storageNodeOperationsHandler.unannounceStorageNode(subject, storageNode);
                break;
            }
            case ADD_MAINTENANCE: 
            case NORMAL: 
            case DECOMMISSION: {
                this.reset();
                this.storageNodeOperationsHandler.decommissionStorageNode(subject, storageNode);
                break;
            }
            case REMOVE_MAINTENANCE: {
                this.reset();
                this.storageNodeOperationsHandler.performRemoveNodeMaintenance(subject, storageNode);
                break;
            }
            case UNANNOUNCE: {
                this.reset();
                this.storageNodeOperationsHandler.unannounceStorageNode(subject, storageNode);
                break;
            }
            case UNINSTALL: {
                this.reset();
                this.storageNodeOperationsHandler.uninstall(subject, storageNode);
                break;
            }
            default: {
                throw new RuntimeException("Cannot undeploy " + storageNode);
            }
        }
    }

    private void reset() {
        for (StorageNode storageNode : this.getStorageNodes()) {
            storageNode.setErrorMessage(null);
            storageNode.setFailedOperation(null);
        }
    }

    private List<StorageNode> combine(List<StorageNode> storageNodes, StorageNode storageNode) {
        ArrayList<StorageNode> newList = new ArrayList<StorageNode>(storageNodes.size() + 1);
        newList.addAll(storageNodes);
        newList.add(storageNode);
        return newList;
    }

    private PropertyList createPropertyListOfAddresses(String propertyName, List<StorageNode> nodes) {
        PropertyList list = new PropertyList(propertyName);
        for (StorageNode storageNode : nodes) {
            list.add((Property)new PropertySimple("address", (Object)storageNode.getAddress()));
        }
        return list;
    }

    @Override
    @RequiredPermission(value=Permission.MANAGE_SETTINGS)
    public StorageNodeLoadComposite getLoad(Subject subject, StorageNode node, long beginTime, long endTime) {
        Integer scheduleId;
        String definitionName;
        int storageNodeResourceId;
        if (!this.storageClientManager.isClusterAvailable()) {
            return new StorageNodeLoadComposite(node, beginTime, endTime);
        }
        try {
            storageNodeResourceId = this.getResourceIdFromStorageNode(node);
        }
        catch (ResourceNotFoundException e) {
            this.log.warn((Object)e.getMessage());
            return new StorageNodeLoadComposite(node, beginTime, endTime);
        }
        HashMap<String, Integer> scheduleIdsMap = new HashMap<String, Integer>();
        for (Object[] tupple : this.getChildrenScheduleIds(storageNodeResourceId)) {
            definitionName = (String)tupple[0];
            scheduleId = (Integer)tupple[2];
            scheduleIdsMap.put(definitionName, scheduleId);
        }
        for (Object[] tupple : this.getGrandchildrenScheduleIds(storageNodeResourceId)) {
            definitionName = (String)tupple[0];
            scheduleId = (Integer)tupple[2];
            scheduleIdsMap.put(definitionName, scheduleId);
        }
        StorageNodeLoadComposite result = new StorageNodeLoadComposite(node, beginTime, endTime);
        MeasurementAggregate totalDiskUsedAggregate = new MeasurementAggregate(Double.valueOf(0.0), Double.valueOf(0.0), Double.valueOf(0.0));
        Integer scheduleId2 = null;
        if (!scheduleIdsMap.isEmpty()) {
            scheduleId2 = (Integer)scheduleIdsMap.get(METRIC_TOKENS);
            if (scheduleId2 != null) {
                MeasurementAggregate tokensAggregate = this.measurementManager.getAggregate(subject, scheduleId2, beginTime, endTime);
                result.setTokens(tokensAggregate);
            }
            if ((scheduleId2 = (Integer)scheduleIdsMap.get(METRIC_OWNERSHIP)) != null) {
                StorageNodeLoadComposite.MeasurementAggregateWithUnits ownershipAggregateWithUnits = this.getMeasurementAggregateWithUnits(subject, scheduleId2, MeasurementUnits.PERCENTAGE, beginTime, endTime);
                result.setActuallyOwns(ownershipAggregateWithUnits);
            }
            if ((scheduleId2 = (Integer)scheduleIdsMap.get(METRIC_DATA_DISK_USED_PERCENTAGE)) != null) {
                StorageNodeLoadComposite.MeasurementAggregateWithUnits dataDiskUsedPercentageAggregateWithUnits = this.getMeasurementAggregateWithUnits(subject, scheduleId2, MeasurementUnits.PERCENTAGE, beginTime, endTime);
                result.setDataDiskUsedPercentage(dataDiskUsedPercentageAggregateWithUnits);
            }
            if ((scheduleId2 = (Integer)scheduleIdsMap.get(METRIC_TOTAL_DISK_USED_PERCENTAGE)) != null) {
                StorageNodeLoadComposite.MeasurementAggregateWithUnits totalDiskUsedPercentageAggregateWithUnits = this.getMeasurementAggregateWithUnits(subject, scheduleId2, MeasurementUnits.PERCENTAGE, beginTime, endTime);
                result.setTotalDiskUsedPercentage(totalDiskUsedPercentageAggregateWithUnits);
            }
            if ((scheduleId2 = (Integer)scheduleIdsMap.get(METRIC_FREE_DISK_TO_DATA_RATIO)) != null) {
                MeasurementAggregate freeDiskToDataRatioAggregate = this.measurementManager.getAggregate(subject, scheduleId2, beginTime, endTime);
                result.setFreeDiskToDataSizeRatio(freeDiskToDataRatioAggregate);
            }
            if ((scheduleId2 = (Integer)scheduleIdsMap.get(METRIC_LOAD)) != null) {
                StorageNodeLoadComposite.MeasurementAggregateWithUnits loadAggregateWithUnits = this.getMeasurementAggregateWithUnits(subject, scheduleId2, MeasurementUnits.BYTES, beginTime, endTime);
                result.setLoad(loadAggregateWithUnits);
                this.updateAggregateTotal(totalDiskUsedAggregate, loadAggregateWithUnits.getAggregate());
            }
            if ((scheduleId2 = (Integer)scheduleIdsMap.get(METRIC_KEY_CACHE_SIZE)) != null) {
                this.updateAggregateTotal(totalDiskUsedAggregate, this.measurementManager.getAggregate(subject, scheduleId2, beginTime, endTime));
            }
            if ((scheduleId2 = (Integer)scheduleIdsMap.get(METRIC_ROW_CACHE_SIZE)) != null) {
                this.updateAggregateTotal(totalDiskUsedAggregate, this.measurementManager.getAggregate(subject, scheduleId2, beginTime, endTime));
            }
            if ((scheduleId2 = (Integer)scheduleIdsMap.get(METRIC_TOTAL_COMMIT_LOG_SIZE)) != null) {
                this.updateAggregateTotal(totalDiskUsedAggregate, this.measurementManager.getAggregate(subject, scheduleId2, beginTime, endTime));
            }
            if (totalDiskUsedAggregate.getMax() > 0.0) {
                StorageNodeLoadComposite.MeasurementAggregateWithUnits totalDiskUsedAggregateWithUnits = new StorageNodeLoadComposite.MeasurementAggregateWithUnits(totalDiskUsedAggregate, MeasurementUnits.BYTES);
                totalDiskUsedAggregateWithUnits.setFormattedValue(this.getSummaryString(totalDiskUsedAggregate, MeasurementUnits.BYTES));
                result.setDataDiskUsed(totalDiskUsedAggregateWithUnits);
            }
            if ((scheduleId2 = (Integer)scheduleIdsMap.get(METRIC_HEAP_COMMITED)) != null) {
                StorageNodeLoadComposite.MeasurementAggregateWithUnits heapCommittedAggregateWithUnits = this.getMeasurementAggregateWithUnits(subject, scheduleId2, MeasurementUnits.BYTES, beginTime, endTime);
                result.setHeapCommitted(heapCommittedAggregateWithUnits);
            }
            if ((scheduleId2 = (Integer)scheduleIdsMap.get(METRIC_HEAP_USED)) != null) {
                StorageNodeLoadComposite.MeasurementAggregateWithUnits heapUsedAggregateWithUnits = this.getMeasurementAggregateWithUnits(subject, scheduleId2, MeasurementUnits.BYTES, beginTime, endTime);
                result.setHeapUsed(heapUsedAggregateWithUnits);
            }
            if ((scheduleId2 = (Integer)scheduleIdsMap.get(METRIC_HEAP_USED_PERCENTAGE)) != null) {
                StorageNodeLoadComposite.MeasurementAggregateWithUnits heapUsedPercentageAggregateWithUnits = this.getMeasurementAggregateWithUnits(subject, scheduleId2, MeasurementUnits.PERCENTAGE, beginTime, endTime);
                result.setHeapPercentageUsed(heapUsedPercentageAggregateWithUnits);
            }
        }
        return result;
    }

    private List<Object[]> getChildrenScheduleIds(int storageNodeResourceId) {
        TypedQuery query = this.entityManager.createNamedQuery("StorageNode.findScheduleIdsByParentResourceIdAndMeasurementDefinitionNames", Object[].class);
        query.setParameter("parrentId", (Object)storageNodeResourceId).setParameter("metricNames", Arrays.asList(METRIC_TOKENS, METRIC_OWNERSHIP, METRIC_LOAD, METRIC_KEY_CACHE_SIZE, METRIC_ROW_CACHE_SIZE, METRIC_TOTAL_COMMIT_LOG_SIZE, METRIC_DATA_DISK_USED_PERCENTAGE, METRIC_TOTAL_DISK_USED_PERCENTAGE, METRIC_FREE_DISK_TO_DATA_RATIO));
        return query.getResultList();
    }

    private List<Object[]> getGrandchildrenScheduleIds(int storageNodeResourceId) {
        TypedQuery query = this.entityManager.createNamedQuery("StorageNode.findScheduleIdsByGrandparentResourceIdAndMeasurementDefinitionNames", Object[].class);
        query.setParameter("grandparrentId", (Object)storageNodeResourceId).setParameter("metricNames", Arrays.asList(METRIC_HEAP_COMMITED, METRIC_HEAP_USED, METRIC_HEAP_USED_PERCENTAGE));
        return query.getResultList();
    }

    private void updateAggregateTotal(MeasurementAggregate accumulator, MeasurementAggregate input) {
        if (!(accumulator == null || input == null || input.getMax() == null || Double.isNaN(input.getMax()) || input.getMin() == null || Double.isNaN(input.getMin()) || input.getAvg() == null || Double.isNaN(input.getAvg()))) {
            accumulator.setAvg(Double.valueOf(accumulator.getAvg() + input.getAvg()));
            accumulator.setMax(Double.valueOf(accumulator.getMax() + input.getMax()));
            accumulator.setMin(Double.valueOf(accumulator.getMin() + input.getMin()));
        }
    }

    @Override
    public List<StorageNode> getStorageNodes() {
        TypedQuery query = this.entityManager.createNamedQuery("StorageNode.findAll", StorageNode.class);
        return query.getResultList();
    }

    @Override
    public List<StorageNode> getClusterNodes() {
        return this.entityManager.createNamedQuery("StorageNode.findAllByModes", StorageNode.class).setParameter("operationModes", Arrays.asList(StorageNode.OperationMode.NORMAL, StorageNode.OperationMode.MAINTENANCE)).getResultList();
    }

    @Override
    public PageList<StorageNodeLoadComposite> getStorageNodeComposites() {
        List<StorageNode> nodes = this.getStorageNodes();
        PageList result = new PageList();
        long endTime = System.currentTimeMillis();
        long beginTime = endTime - 28800000L;
        for (StorageNode node : nodes) {
            if (node.getOperationMode() != StorageNode.OperationMode.INSTALLED) {
                StorageNodeLoadComposite composite = this.getLoad(this.subjectManager.getOverlord(), node, beginTime, endTime);
                int unackAlerts = this.findNotAcknowledgedStorageNodeAlerts(this.subjectManager.getOverlord(), node).size();
                composite.setUnackAlerts(unackAlerts);
                result.add((Object)composite);
                continue;
            }
            result.add((Object)new StorageNodeLoadComposite(node, beginTime, endTime));
        }
        return result;
    }

    @Override
    @RequiredPermission(value=Permission.MANAGE_SETTINGS)
    public PageList<StorageNode> findStorageNodesByCriteria(Subject subject, StorageNodeCriteria criteria) {
        CriteriaQueryGenerator generator = new CriteriaQueryGenerator(subject, (Criteria)criteria);
        CriteriaQueryRunner runner = new CriteriaQueryRunner((Criteria)criteria, generator, this.entityManager);
        return runner.execute();
    }

    @Override
    public StorageNode findStorageNodeByAddress(InetAddress address) {
        TypedQuery query = this.entityManager.createNamedQuery("StorageNode.findByAddress", StorageNode.class);
        query.setParameter("address", (Object)address.getHostAddress());
        List result = query.getResultList();
        if (result != null && result.size() > 0) {
            return (StorageNode)result.get(0);
        }
        return null;
    }

    @Override
    @RequiredPermission(value=Permission.MANAGE_SETTINGS)
    public void prepareNodeForUpgrade(Subject subject, StorageNode storageNode) {
        int storageNodeResourceId = this.getResourceIdFromStorageNode(storageNode);
        OperationManagerLocal operationManager = LookupUtil.getOperationManager();
        Configuration parameters = new Configuration();
        parameters.setSimpleValue("snapshotName", String.valueOf(System.currentTimeMillis()));
        operationManager.scheduleResourceOperation(subject, storageNodeResourceId, "prepareForUpgrade", 0L, 0L, 0, 0, parameters, "Run by StorageNodeManagerBean.prepareNodeForUpgrade()");
    }

    private String getSummaryString(MeasurementAggregate aggregate, MeasurementUnits units) {
        String formattedValue = "Min: " + MeasurementConverter.format(aggregate.getMin(), units, true) + ", Max: " + MeasurementConverter.format(aggregate.getMax(), units, true) + ", Avg: " + MeasurementConverter.format(aggregate.getAvg(), units, true);
        return formattedValue;
    }

    private StorageNodeLoadComposite.MeasurementAggregateWithUnits getMeasurementAggregateWithUnits(Subject subject, int schedId, MeasurementUnits units, long beginTime, long endTime) {
        MeasurementAggregate measurementAggregate = this.measurementManager.getAggregate(subject, schedId, beginTime, endTime);
        StorageNodeLoadComposite.MeasurementAggregateWithUnits measurementAggregateWithUnits = new StorageNodeLoadComposite.MeasurementAggregateWithUnits(measurementAggregate, units);
        measurementAggregateWithUnits.setFormattedValue(this.getSummaryString(measurementAggregate, units));
        return measurementAggregateWithUnits;
    }

    private int getResourceIdFromStorageNode(StorageNode storageNode) {
        int storageNodeId = storageNode.getId();
        if (storageNode.getResource() == null) {
            if ((storageNode = (StorageNode)this.entityManager.find(StorageNode.class, (Object)storageNode.getId())) == null) {
                throw new ResourceNotFoundException("There is no storage node with id [" + storageNodeId + "] stored in the database.");
            }
            if (storageNode.getResource() == null) {
                throw new IllegalStateException("This storage node [" + storageNode.getId() + "] has no associated resource.");
            }
        }
        int resourceId = storageNode.getResource().getId();
        return resourceId;
    }

    @Override
    @RequiredPermission(value=Permission.MANAGE_SETTINGS)
    public void runClusterMaintenance(Subject subject) {
        List<StorageNode> storageNodes = this.getClusterNodes();
        for (StorageNode storageNode : storageNodes) {
            Resource test = storageNode.getResource();
            ResourceCriteria criteria = new ResourceCriteria();
            criteria.addFilterParentResourceId(Integer.valueOf(test.getId()));
            criteria.addFilterResourceTypeName("StorageService");
            criteria.setPageControl(PageControl.getUnlimitedInstance());
            PageList<Resource> resources = this.resourceManager.findResourcesByCriteria(this.subjectManager.getOverlord(), criteria);
            if (resources.size() <= 0) continue;
            Resource storageServiceResource = (Resource)resources.get(0);
            ResourceOperationSchedule newSchedule = new ResourceOperationSchedule();
            newSchedule.setJobTrigger(JobTrigger.createNowTrigger());
            newSchedule.setResource(storageServiceResource);
            newSchedule.setOperationName("takeSnapshot");
            newSchedule.setDescription("Run by StorageNodeManagerBean");
            newSchedule.setParameters(new Configuration());
            this.storageNodeManger.scheduleOperationInNewTransaction(this.subjectManager.getOverlord(), newSchedule);
        }
        if (storageNodes.size() == 1) {
            this.log.info((Object)"Skipping scheduled repair since this is a single-node cluster");
        } else {
            this.storageNodeOperationsHandler.runRepair(this.subjectManager.getOverlord(), storageNodes);
        }
    }

    @Override
    @RequiredPermission(value=Permission.MANAGE_SETTINGS)
    public PageList<Alert> findNotAcknowledgedStorageNodeAlerts(Subject subject) {
        return this.findStorageNodeAlerts(subject, false, null);
    }

    @Override
    @RequiredPermission(value=Permission.MANAGE_SETTINGS)
    public PageList<Alert> findNotAcknowledgedStorageNodeAlerts(Subject subject, StorageNode storageNode) {
        return this.findStorageNodeAlerts(subject, false, storageNode);
    }

    @Override
    @RequiredPermission(value=Permission.MANAGE_SETTINGS)
    public PageList<Alert> findAllStorageNodeAlerts(Subject subject) {
        return this.findStorageNodeAlerts(subject, true, null);
    }

    @Override
    @RequiredPermission(value=Permission.MANAGE_SETTINGS)
    public PageList<Alert> findAllStorageNodeAlerts(Subject subject, StorageNode storageNode) {
        return this.findStorageNodeAlerts(subject, true, storageNode);
    }

    private PageList<Alert> findStorageNodeAlerts(Subject subject, boolean allAlerts, StorageNode storageNode) {
        Integer[] resouceIdsWithAlertDefinitions = this.findResourcesWithAlertDefinitions(storageNode);
        PageList alerts = new PageList();
        if (resouceIdsWithAlertDefinitions != null && resouceIdsWithAlertDefinitions.length != 0) {
            AlertCriteria criteria = new AlertCriteria();
            criteria.setPageControl(PageControl.getUnlimitedInstance());
            criteria.addFilterResourceIds(resouceIdsWithAlertDefinitions);
            criteria.addSortCtime(PageOrdering.DESC);
            alerts = this.alertManager.findAlertsByCriteria(subject, criteria);
            if (!allAlerts) {
                PageList trimmedAlerts = new PageList();
                for (Alert alert : alerts) {
                    if (alert.getAcknowledgeTime() != null && alert.getAcknowledgeTime() > 0L) continue;
                    trimmedAlerts.add((Object)alert);
                }
                alerts = trimmedAlerts;
            }
        }
        return alerts;
    }

    @Override
    public Map<Integer, Integer> findResourcesWithAlertDefinitions() {
        return this.findResourcesWithAlertsToStorageNodeMap(null);
    }

    @Override
    public Integer[] findResourcesWithAlertDefinitions(StorageNode storageNode) {
        Map<Integer, Integer> result = this.findResourcesWithAlertsToStorageNodeMap(storageNode);
        if (result != null) {
            Set<Integer> resourceIds = result.keySet();
            return resourceIds.toArray(new Integer[resourceIds.size()]);
        }
        return new Integer[0];
    }

    private Map<Integer, Integer> findResourcesWithAlertsToStorageNodeMap(StorageNode storageNode) {
        List<StorageNode> initialStorageNodes = this.getStorageNodes();
        initialStorageNodes = storageNode == null ? this.getStorageNodes() : Arrays.asList(storageNode.getResource() == null ? (StorageNode)this.entityManager.find(StorageNode.class, (Object)storageNode.getId()) : storageNode);
        HashMap<Integer, Integer> resourceIdsToStorageNodeMap = new HashMap<Integer, Integer>();
        LinkedList<Resource> unvisitedResources = new LinkedList<Resource>();
        for (StorageNode initialStorageNode : initialStorageNodes) {
            if (initialStorageNode.getResource() == null) continue;
            unvisitedResources.add(initialStorageNode.getResource());
            while (!unvisitedResources.isEmpty()) {
                Set childResources;
                Resource resource = (Resource)unvisitedResources.poll();
                if (resource.getAlertDefinitions() != null) {
                    resourceIdsToStorageNodeMap.put(resource.getId(), initialStorageNode.getId());
                }
                if ((childResources = resource.getChildResources()) == null) continue;
                for (Resource child : childResources) {
                    unvisitedResources.add(child);
                }
            }
        }
        return resourceIdsToStorageNodeMap;
    }

    @Override
    @RequiredPermission(value=Permission.MANAGE_SETTINGS)
    public StorageNodeConfigurationComposite retrieveConfiguration(Subject subject, StorageNode storageNode) {
        StorageNodeConfigurationComposite configuration = new StorageNodeConfigurationComposite(storageNode);
        if (storageNode != null && storageNode.getResource() != null) {
            Resource storageNodeResource = storageNode.getResource();
            Configuration storageNodeConfiguration = this.configurationManager.getResourceConfiguration(subject, storageNodeResource.getId());
            Configuration storageNodePluginConfiguration = this.configurationManager.getPluginConfiguration(subject, storageNodeResource.getId());
            configuration.setHeapSize(storageNodeConfiguration.getSimpleValue("maxHeapSize"));
            configuration.setHeapNewSize(storageNodeConfiguration.getSimpleValue("heapNewSize"));
            configuration.setThreadStackSize(storageNodeConfiguration.getSimpleValue("threadStackSize"));
            configuration.setJmxPort(Integer.parseInt(storageNodePluginConfiguration.getSimpleValue(RHQ_STORAGE_JMX_PORT_PROPERTY)));
        }
        return configuration;
    }

    @Override
    @Asynchronous
    @RequiredPermission(value=Permission.MANAGE_SETTINGS)
    public void updateConfigurationAsync(Subject subject, StorageNodeConfigurationComposite storageNodeConfiguration) {
        this.updateConfiguration(subject, storageNodeConfiguration);
    }

    @Override
    @RequiredPermission(value=Permission.MANAGE_SETTINGS)
    public boolean updateConfiguration(Subject subject, StorageNodeConfigurationComposite storageNodeConfiguration) {
        try {
            StorageNode storageNode = this.findStorageNodeByAddress(InetAddress.getByName(storageNodeConfiguration.getStorageNode().getAddress()));
            if (storageNode != null && storageNode.getResource() != null) {
                Configuration parameters = new Configuration();
                parameters.setSimpleValue(RHQ_STORAGE_JMX_PORT_PROPERTY, storageNodeConfiguration.getJmxPort() + "");
                if (storageNodeConfiguration.getHeapSize() != null) {
                    parameters.setSimpleValue("heapSize", storageNodeConfiguration.getHeapSize() + "");
                }
                if (storageNodeConfiguration.getHeapNewSize() != null) {
                    parameters.setSimpleValue("heapNewSize", storageNodeConfiguration.getHeapNewSize() + "");
                }
                if (storageNodeConfiguration.getThreadStackSize() != null) {
                    parameters.setSimpleValue("threadStackSize", storageNodeConfiguration.getThreadStackSize() + "");
                }
                parameters.setSimpleValue("restartIfRequired", "true");
                Resource storageNodeResource = storageNode.getResource();
                boolean result = this.runOperationAndWaitForResult(subject, storageNodeResource, UPDATE_CONFIGURATION_OPERATION, parameters);
                if (result) {
                    String newJMXPort;
                    Configuration storageNodePluginConfig = this.configurationManager.getPluginConfiguration(subject, storageNodeResource.getId());
                    String existingJMXPort = storageNodePluginConfig.getSimpleValue(RHQ_STORAGE_JMX_PORT_PROPERTY);
                    if (!existingJMXPort.equals(newJMXPort = storageNodeConfiguration.getJmxPort() + "")) {
                        storageNodePluginConfig.setSimpleValue(RHQ_STORAGE_JMX_PORT_PROPERTY, newJMXPort);
                        String existingConnectionURL = storageNodePluginConfig.getSimpleValue("connectorAddress");
                        String newConnectionURL = existingConnectionURL.replace(":" + existingJMXPort + "/", ":" + storageNodeConfiguration.getJmxPort() + "/");
                        storageNodePluginConfig.setSimpleValue("connectorAddress", newConnectionURL);
                        this.configurationManager.updatePluginConfiguration(subject, storageNodeResource.getId(), storageNodePluginConfig);
                    }
                    return result;
                }
            }
            return false;
        }
        catch (UnknownHostException e) {
            throw new RuntimeException("Failed to resolve address for " + storageNodeConfiguration, e);
        }
    }

    @Override
    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    @RequiredPermission(value=Permission.MANAGE_SETTINGS)
    public void scheduleOperationInNewTransaction(Subject subject, ResourceOperationSchedule schedule) {
        this.operationManager.scheduleResourceOperation(subject, schedule);
    }

    @Override
    @RequiredPermission(value=Permission.MANAGE_SETTINGS)
    public Map<String, List<MeasurementDataNumericHighLowComposite>> findStorageNodeLoadDataForLast(Subject subject, StorageNode node, long beginTime, long endTime, int numPoints) {
        int storageNodeResourceId;
        if (!this.storageClientManager.isClusterAvailable()) {
            return Collections.emptyMap();
        }
        try {
            storageNodeResourceId = this.getResourceIdFromStorageNode(node);
        }
        catch (ResourceNotFoundException e) {
            this.log.warn((Object)e.getMessage());
            return Collections.emptyMap();
        }
        LinkedHashMap<String, List<MeasurementDataNumericHighLowComposite>> result = new LinkedHashMap<String, List<MeasurementDataNumericHighLowComposite>>();
        List<Object[]> tupples = this.getChildrenScheduleIds(storageNodeResourceId);
        ArrayList<String> defNames = new ArrayList<String>();
        HashMap resourceWithDefinitionIds = new HashMap();
        for (Object[] tupple : tupples) {
            String defName = (String)tupple[0];
            int definitionId = (Integer)tupple[1];
            int resId = (Integer)tupple[3];
            defNames.add(defName);
            if (resourceWithDefinitionIds.get(resId) == null) {
                resourceWithDefinitionIds.put(resId, new ArrayList(tupples.size()));
            }
            ((List)resourceWithDefinitionIds.get(resId)).add(definitionId);
        }
        int defNameIndex = 0;
        for (Map.Entry entry : resourceWithDefinitionIds.entrySet()) {
            List<List<MeasurementDataNumericHighLowComposite>> storageServiceData = this.measurementManager.findDataForResource(subject, (Integer)entry.getKey(), ArrayUtils.unwrapCollection((Collection)((Collection)entry.getValue())), beginTime, endTime, numPoints);
            for (int i = 0; i < storageServiceData.size(); ++i) {
                List<MeasurementDataNumericHighLowComposite> oneRecord = storageServiceData.get(i);
                result.put((String)defNames.get(defNameIndex++), this.filterNans(oneRecord));
            }
        }
        tupples = this.getGrandchildrenScheduleIds(storageNodeResourceId);
        defNames = new ArrayList();
        int[] definitionIds = new int[tupples.size()];
        definitionIds = new int[tupples.size()];
        int resId = -1;
        int index = 0;
        for (Object[] tupple : tupples) {
            String defName = (String)tupple[0];
            int definitionId = (Integer)tupple[1];
            resId = (Integer)tupple[3];
            defNames.add(defName);
            definitionIds[index++] = definitionId;
        }
        List<List<MeasurementDataNumericHighLowComposite>> memorySubsystemData = this.measurementManager.findDataForResource(subject, resId, definitionIds, beginTime, endTime, numPoints);
        for (int i = 0; i < memorySubsystemData.size(); ++i) {
            List<MeasurementDataNumericHighLowComposite> oneRecord = memorySubsystemData.get(i);
            result.put((String)defNames.get(i), this.filterNans(oneRecord));
        }
        return result;
    }

    private List<MeasurementDataNumericHighLowComposite> filterNans(List<MeasurementDataNumericHighLowComposite> data) {
        if (data == null || data.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<MeasurementDataNumericHighLowComposite> filteredData = new ArrayList<MeasurementDataNumericHighLowComposite>(data.size());
        for (MeasurementDataNumericHighLowComposite number : data) {
            if (Double.isNaN(number.getValue())) continue;
            filteredData.add(number);
        }
        return filteredData;
    }

    private boolean runOperationAndWaitForResult(Subject subject, Resource storageNodeResource, String operationToRun, Configuration parameters) {
        long operationStartTime = System.currentTimeMillis();
        ResourceOperationSchedule newSchedule = new ResourceOperationSchedule();
        newSchedule.setJobTrigger(JobTrigger.createNowTrigger());
        newSchedule.setResource(storageNodeResource);
        newSchedule.setOperationName(operationToRun);
        newSchedule.setDescription("Run by StorageNodeManagerBean");
        newSchedule.setParameters(parameters);
        this.storageNodeManger.scheduleOperationInNewTransaction(subject, newSchedule);
        boolean successResultFound = false;
        for (int iteration = 0; iteration < 10 && !successResultFound; ++iteration) {
            ResourceOperationHistoryCriteria criteria = new ResourceOperationHistoryCriteria();
            criteria.addFilterResourceIds(new Integer[]{storageNodeResource.getId()});
            criteria.addFilterStartTime(Long.valueOf(operationStartTime));
            criteria.addFilterOperationName(operationToRun);
            criteria.addFilterStatus(OperationRequestStatus.SUCCESS);
            criteria.setPageControl(PageControl.getUnlimitedInstance());
            PageList<ResourceOperationHistory> results = this.operationManager.findResourceOperationHistoriesByCriteria(subject, criteria);
            if (results != null && results.size() > 0) {
                successResultFound = true;
            }
            if (successResultFound) break;
            try {
                Thread.sleep(20000L);
                continue;
            }
            catch (Exception e) {
                this.log.error((Object)e);
            }
        }
        return successResultFound;
    }
}

