/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.naming.context;

import java.lang.reflect.Constructor;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.naming.Context;
import org.rhq.enterprise.server.naming.context.AccessCheckingContextDecorator;
import org.rhq.enterprise.server.naming.context.AccessCheckingDirContextDecorator;
import org.rhq.enterprise.server.naming.context.AccessCheckingEventContextDecorator;
import org.rhq.enterprise.server.naming.context.AccessCheckingEventDirContextDecorator;
import org.rhq.enterprise.server.naming.context.AccessCheckingLdapContextDecorator;
import org.rhq.enterprise.server.naming.context.ContextDecorator;
import org.rhq.enterprise.server.naming.util.DecoratorSetContext;

public class AccessCheckingContextDecoratorSetContext
implements DecoratorSetContext<Context, ContextDecorator> {
    private static final Set<Class<? extends ContextDecorator>> DECORATOR_CLASSES;
    private Set<Class<? extends Context>> supportedInterfaces;
    private String[] checkedSchemes;

    public AccessCheckingContextDecoratorSetContext(Set<Class<? extends Context>> supportedInterfaces, String ... checkedSchemes) {
        this.supportedInterfaces = supportedInterfaces;
        this.checkedSchemes = checkedSchemes;
    }

    @Override
    public ContextDecorator instantiate(Class<? extends ContextDecorator> decoratorClass) throws Exception {
        Constructor<? extends ContextDecorator> ctor = decoratorClass.getConstructor(String[].class);
        return ctor.newInstance(new Object[]{this.checkedSchemes});
    }

    @Override
    public Set<Class<? extends Context>> getSupportedInterfaces() {
        return this.supportedInterfaces;
    }

    @Override
    public Set<Class<? extends ContextDecorator>> getDecoratorClasses() {
        return DECORATOR_CLASSES;
    }

    @Override
    public void init(ContextDecorator decorator, Context object) throws Exception {
        decorator.init(object);
    }

    static {
        HashSet<Class<AccessCheckingLdapContextDecorator>> tmp = new HashSet<Class<AccessCheckingLdapContextDecorator>>();
        tmp.add(AccessCheckingContextDecorator.class);
        tmp.add(AccessCheckingDirContextDecorator.class);
        tmp.add(AccessCheckingEventContextDecorator.class);
        tmp.add(AccessCheckingEventDirContextDecorator.class);
        tmp.add(AccessCheckingLdapContextDecorator.class);
        DECORATOR_CLASSES = Collections.unmodifiableSet(tmp);
    }
}

