/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.rest.helper;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.Property;
import org.rhq.core.domain.configuration.PropertyList;
import org.rhq.core.domain.configuration.PropertyMap;
import org.rhq.core.domain.configuration.PropertySimple;
import org.rhq.core.domain.configuration.definition.ConfigurationDefinition;
import org.rhq.core.domain.configuration.definition.PropertyDefinition;
import org.rhq.core.domain.configuration.definition.PropertyDefinitionList;
import org.rhq.core.domain.configuration.definition.PropertyDefinitionMap;
import org.rhq.core.domain.configuration.definition.PropertyDefinitionSimple;
import org.rhq.core.domain.configuration.definition.PropertySimpleType;

public class ConfigurationHelper {
    public static Configuration mapToConfiguration(Map<String, Object> in) {
        Configuration config = new Configuration();
        Set<String> mapKeys = in.keySet();
        for (String mapKey : mapKeys) {
            Object mapValue = in.get(mapKey);
            if (mapValue instanceof Map) {
                Map map = (Map)mapValue;
                PropertyMap propertyMap = ConfigurationHelper.getPropertyMap(mapKey, map);
                config.put((Property)propertyMap);
                continue;
            }
            if (mapValue instanceof List) {
                List objects = (List)mapValue;
                PropertyList propertyList = ConfigurationHelper.getPropertyList(mapKey, objects);
                config.put((Property)propertyList);
                continue;
            }
            config.put((Property)new PropertySimple(mapKey, mapValue));
        }
        return config;
    }

    public static Map<String, Object> configurationToMap(Configuration configuration, ConfigurationDefinition definition, boolean strict) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (configuration == null) {
            return result;
        }
        if (configuration.getProperties().isEmpty()) {
            return result;
        }
        for (Property property : configuration.getProperties()) {
            String propertyName = property.getName();
            PropertyDefinition propertyDefinition = definition.get(propertyName);
            if (propertyDefinition == null) {
                if (!strict) continue;
                throw new IllegalArgumentException("No definition for property " + propertyName + "found");
            }
            Object target = ConfigurationHelper.convertProperty(property, propertyDefinition, strict);
            result.put(propertyName, target);
        }
        return result;
    }

    private static Object convertProperty(Property property, PropertyDefinition propertyDefinition, boolean strict) {
        List<Object> target;
        if (property instanceof PropertyMap) {
            PropertyMap propertyMap = (PropertyMap)property;
            target = ConfigurationHelper.getInnerMap(propertyMap, (PropertyDefinitionMap)propertyDefinition, strict);
        } else if (property instanceof PropertyList) {
            PropertyList propertyList = (PropertyList)property;
            target = ConfigurationHelper.getInnerList(propertyList, (PropertyDefinitionList)propertyDefinition, strict);
        } else {
            target = ConfigurationHelper.convertSimplePropertyValue((PropertySimple)property, (PropertyDefinitionSimple)propertyDefinition);
        }
        return target;
    }

    private static Map<String, Object> getInnerMap(PropertyMap propertyMap, PropertyDefinitionMap propertyDefinition, boolean strict) {
        Map map = propertyMap.getMap();
        HashMap<String, Object> result = new HashMap<String, Object>(map.size());
        Set names = map.keySet();
        for (String name : names) {
            Property property = (Property)map.get(name);
            PropertyDefinition definition = propertyDefinition.get(name);
            Object target = ConfigurationHelper.convertProperty(property, definition, strict);
            result.put(name, target);
        }
        return result;
    }

    private static List<Object> getInnerList(PropertyList propertyList, PropertyDefinitionList definition, boolean strict) {
        ArrayList<Object> result = new ArrayList<Object>(propertyList.getList().size());
        if (definition == null) {
            if (strict) {
                throw new IllegalArgumentException("No Definition exists for " + propertyList.getName());
            }
            return result;
        }
        PropertyDefinition memberDefinition = definition.getMemberDefinition();
        for (Property property : propertyList.getList()) {
            Object target = ConfigurationHelper.convertProperty(property, memberDefinition, strict);
            result.add(target);
        }
        return result;
    }

    private static PropertyList getPropertyList(String propertyName, List<Object> objects) {
        PropertyList propertyList = new PropertyList(propertyName);
        for (Object o : objects) {
            PropertyList target;
            if (o instanceof List) {
                List list = (List)o;
                target = ConfigurationHelper.getPropertyList(propertyName, list);
            } else if (o instanceof Map) {
                Map map = (Map)o;
                target = ConfigurationHelper.getPropertyMap(propertyName, map);
            } else {
                target = new PropertySimple(propertyName, o);
            }
            propertyList.add((Property)target);
        }
        return propertyList;
    }

    private static PropertyMap getPropertyMap(String propertyName, Map<String, Object> map) {
        PropertyMap propertyMap = new PropertyMap(propertyName);
        Set<String> keys = map.keySet();
        for (String key : keys) {
            Object value = map.get(key);
            Object target = value instanceof Map ? ConfigurationHelper.getPropertyMap(key, (Map)value) : (value instanceof List ? ConfigurationHelper.getPropertyList(key, (List)value) : new PropertySimple(key, value));
            propertyMap.put((Property)target);
        }
        return propertyMap;
    }

    public static Object convertSimplePropertyValue(PropertySimple property, PropertyDefinitionSimple definition) {
        Object ret;
        if (definition == null) {
            throw new IllegalArgumentException("No definition provided");
        }
        if (property == null) {
            return null;
        }
        PropertySimpleType type = definition.getType();
        String val = property.getStringValue();
        switch (type) {
            case STRING: {
                ret = val;
                break;
            }
            case INTEGER: {
                ret = Integer.valueOf(val);
                break;
            }
            case BOOLEAN: {
                ret = Boolean.valueOf(val);
                break;
            }
            case LONG: {
                ret = Long.valueOf(val);
                break;
            }
            case FLOAT: {
                ret = Float.valueOf(val);
                break;
            }
            case DOUBLE: {
                ret = Double.valueOf(val);
                break;
            }
            default: {
                ret = val;
            }
        }
        return ret;
    }

    public static List<String> checkConfigurationWrtDefinition(Configuration configuration, ConfigurationDefinition definition) {
        ArrayList<String> messages = new ArrayList<String>();
        if (configuration == null) {
            messages.add("Configuration is null");
        }
        if (definition == null) {
            messages.add("Definition is null");
        }
        if (configuration == null || definition == null) {
            return messages;
        }
        for (PropertyDefinition propDef : definition.getPropertyDefinitions().values()) {
            String name = propDef.getName();
            Property property = configuration.get(name);
            ConfigurationHelper.checkProperty(messages, propDef, property);
        }
        return messages;
    }

    private static void checkProperty(List<String> messages, PropertyDefinition propertyDefinition, Property property) {
        block4: {
            String name;
            block6: {
                block5: {
                    name = propertyDefinition.getName();
                    if (propertyDefinition.isRequired() && property == null) {
                        messages.add("Required property [" + name + "] not found");
                        return;
                    }
                    if (!propertyDefinition.isRequired() && property == null) {
                        return;
                    }
                    boolean good = ConfigurationHelper.checkIfCompatible(propertyDefinition, property, messages);
                    if (!good) break block4;
                    if (!(property instanceof PropertySimple)) break block5;
                    ConfigurationHelper.checkDataTypeOfSimpleProperty((PropertyDefinitionSimple)propertyDefinition, (PropertySimple)property, messages);
                    break block4;
                }
                if (!(property instanceof PropertyList)) break block6;
                PropertyList propertyList = (PropertyList)property;
                PropertyDefinitionList propertyDefinitionList = (PropertyDefinitionList)propertyDefinition;
                for (Property prop : propertyList.getList()) {
                    ConfigurationHelper.checkProperty(messages, propertyDefinitionList.getMemberDefinition(), prop);
                }
                break block4;
            }
            if (!(property instanceof PropertyMap)) break block4;
            PropertyMap propertyMap = (PropertyMap)property;
            PropertyDefinitionMap propertyDefinitionMap = (PropertyDefinitionMap)propertyDefinition;
            for (Map.Entry entry : propertyMap.getMap().entrySet()) {
                Property prop = (Property)entry.getValue();
                PropertyDefinition definition = propertyDefinitionMap.get(name);
                ConfigurationHelper.checkProperty(messages, definition, prop);
            }
        }
    }

    private static void checkDataTypeOfSimpleProperty(PropertyDefinitionSimple propDef, PropertySimple property, List<String> messages) {
        String prefix = "Property [" + property.getName() + "] is ";
        String val = property.getStringValue();
        if (!propDef.isRequired() && property.getStringValue() == null) {
            return;
        }
        if (propDef.isRequired() && property.getStringValue() == null) {
            messages.add(prefix + "required but was 'null'");
            return;
        }
        switch (propDef.getType()) {
            case DOUBLE: {
                try {
                    Double.parseDouble(property.getStringValue());
                }
                catch (NumberFormatException nfe) {
                    messages.add(prefix + "no double : " + val);
                }
                break;
            }
            case FLOAT: {
                float f;
                try {
                    f = Float.parseFloat(property.getStringValue());
                }
                catch (NumberFormatException nfe) {
                    messages.add(prefix + "no float : " + val);
                    break;
                }
                if (!(f < Float.MIN_VALUE) && !(f > Float.MAX_VALUE)) break;
                messages.add(prefix + "no valid float : " + val);
                break;
            }
            case INTEGER: {
                try {
                    Integer.parseInt(property.getStringValue());
                }
                catch (NumberFormatException nfe) {
                    messages.add(prefix + "no integer : " + val);
                }
                break;
            }
            case LONG: {
                try {
                    Long.parseLong(property.getStringValue());
                }
                catch (NumberFormatException nfe) {
                    messages.add(prefix + "no long : " + val);
                }
                break;
            }
            case BOOLEAN: {
                String s = val.toLowerCase();
                if (s.equals("true") || s.equals("false")) break;
                messages.add(prefix + "no boolean : " + val);
                break;
            }
        }
    }

    private static boolean checkIfCompatible(PropertyDefinition propDef, Property property, List<String> messages) {
        boolean good = false;
        if (propDef instanceof PropertyDefinitionSimple && property instanceof PropertySimple) {
            good = true;
        } else if (propDef instanceof PropertyDefinitionMap && property instanceof PropertyMap) {
            good = true;
        } else if (propDef instanceof PropertyDefinitionList && property instanceof PropertyList) {
            good = true;
        }
        if (!good) {
            String name = propDef.getName();
            messages.add("The type of property for [" + name + "] does not match the definition");
        }
        return good;
    }
}

