/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.storage;

import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.ProtocolOptions;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.policies.DefaultRetryPolicy;
import com.datastax.driver.core.policies.LoadBalancingPolicy;
import com.datastax.driver.core.policies.LoggingRetryPolicy;
import com.datastax.driver.core.policies.RetryPolicy;
import com.datastax.driver.core.policies.RoundRobinPolicy;
import java.util.ArrayList;
import java.util.List;
import javax.ejb.ConcurrencyManagement;
import javax.ejb.ConcurrencyManagementType;
import javax.ejb.EJB;
import javax.ejb.Singleton;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.cassandra.schema.SchemaManager;
import org.rhq.cassandra.util.ClusterBuilder;
import org.rhq.core.domain.cloud.StorageNode;
import org.rhq.core.util.StringUtil;
import org.rhq.enterprise.server.cloud.StorageNodeManagerLocal;
import org.rhq.enterprise.server.storage.StorageClusterMonitor;
import org.rhq.server.metrics.DateTimeService;
import org.rhq.server.metrics.MetricsConfiguration;
import org.rhq.server.metrics.MetricsDAO;
import org.rhq.server.metrics.MetricsServer;
import org.rhq.server.metrics.StorageSession;
import org.rhq.server.metrics.StorageStateListener;

@Singleton
@ConcurrencyManagement(value=ConcurrencyManagementType.BEAN)
public class StorageClientManagerBean {
    private final Log log = LogFactory.getLog(StorageClientManagerBean.class);
    private static final String USERNAME_PROP = "rhq.storage.username";
    private static final String PASSWORD_PROP = "rhq.storage.password";
    private static final String RHQ_KEYSPACE = "rhq";
    @EJB
    private StorageNodeManagerLocal storageNodeManager;
    private Cluster cluster;
    private StorageSession session;
    private MetricsConfiguration metricsConfiguration;
    private MetricsDAO metricsDAO;
    private MetricsServer metricsServer;
    private boolean initialized;
    private StorageClusterMonitor storageClusterMonitor;

    public synchronized void init() {
        if (this.initialized) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)"Storage client subsystem is already initialized. Skipping initialization.");
            }
            return;
        }
        this.log.info((Object)"Initializing storage client subsystem");
        String username = this.getRequiredStorageProperty(USERNAME_PROP);
        String password = this.getRequiredStorageProperty(PASSWORD_PROP);
        ArrayList<StorageNode> storageNodes = new ArrayList<StorageNode>();
        for (StorageNode storageNode : this.storageNodeManager.getStorageNodes()) {
            if (storageNode.getOperationMode() != StorageNode.OperationMode.NORMAL && storageNode.getOperationMode() != StorageNode.OperationMode.MAINTENANCE && storageNode.getResource() != null) continue;
            storageNodes.add(storageNode);
        }
        if (storageNodes.isEmpty()) {
            throw new IllegalStateException("There is no storage node metadata stored in the relational database. This may have happened as a result of running dbsetup or deleting rows from rhq_storage_node table. Please re-install the storage node to fix this issue.");
        }
        this.checkSchemaCompability(username, password, storageNodes);
        Session wrappedSession = this.createSession(username, password, storageNodes);
        this.session = new StorageSession(wrappedSession);
        this.storageClusterMonitor = new StorageClusterMonitor();
        this.session.addStorageStateListener((StorageStateListener)this.storageClusterMonitor);
        this.metricsConfiguration = new MetricsConfiguration();
        this.metricsDAO = new MetricsDAO(this.session, this.metricsConfiguration);
        this.initMetricsServer();
        this.initialized = true;
        this.log.info((Object)"Storage client subsystem is now initialized");
    }

    private void checkSchemaCompability(String username, String password, List<StorageNode> storageNodes) {
        String[] nodes = new String[storageNodes.size()];
        for (int index = 0; index < storageNodes.size(); ++index) {
            nodes[index] = storageNodes.get(index).getAddress();
        }
        int cqlPort = storageNodes.get(0).getCqlPort();
        SchemaManager schemaManager = new SchemaManager(username, password, nodes, cqlPort);
        try {
            schemaManager.checkCompatibility();
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public synchronized void shutdown() {
        this.log.info((Object)"Shutting down storage client subsystem");
        if (this.metricsServer != null) {
            this.metricsServer.shutdown();
            this.metricsServer = null;
        }
        this.metricsDAO = null;
        try {
            if (this.cluster != null) {
                this.cluster.shutdown();
            }
        }
        catch (Exception e) {
            this.log.error((Object)"Failed to shutdown the cluster connection manager for the storage cluster.", (Throwable)e);
        }
        this.cluster = null;
        this.session = null;
        this.initialized = false;
    }

    @TransactionAttribute(value=TransactionAttributeType.NOT_SUPPORTED)
    public MetricsDAO getMetricsDAO() {
        return this.metricsDAO;
    }

    @TransactionAttribute(value=TransactionAttributeType.NOT_SUPPORTED)
    public MetricsServer getMetricsServer() {
        return this.metricsServer;
    }

    @TransactionAttribute(value=TransactionAttributeType.NOT_SUPPORTED)
    public StorageSession getSession() {
        return this.session;
    }

    @TransactionAttribute(value=TransactionAttributeType.NOT_SUPPORTED)
    public MetricsConfiguration getMetricsConfiguration() {
        return this.metricsConfiguration;
    }

    @TransactionAttribute(value=TransactionAttributeType.NOT_SUPPORTED)
    public boolean isClusterAvailable() {
        return this.storageClusterMonitor != null && this.storageClusterMonitor.isClusterAvailable();
    }

    private Session createSession(String username, String password, List<StorageNode> storageNodes) {
        ProtocolOptions.Compression compression;
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"Initializing session to connect to storage node cluster");
        }
        ArrayList<String> hostNames = new ArrayList<String>();
        for (StorageNode storageNode : storageNodes) {
            hostNames.add(storageNode.getAddress());
        }
        int port = storageNodes.get(0).getCqlPort();
        boolean compressionEnabled = Boolean.valueOf(System.getProperty("rhq.cassandra.client.compression-enabled", "false"));
        if (compressionEnabled) {
            compression = ProtocolOptions.Compression.SNAPPY;
            this.log.info((Object)"Compression has been enabled for the storage client. Be aware that if your storage nodes do not support compression then the client will not be able to connect to the storage cluster.");
        } else {
            compression = ProtocolOptions.Compression.NONE;
            this.log.debug((Object)"Storage client compression is disabled");
        }
        this.cluster = new ClusterBuilder().addContactPoints(hostNames.toArray(new String[hostNames.size()])).withCredentialsObfuscated(username, password).withPort(port).withLoadBalancingPolicy((LoadBalancingPolicy)new RoundRobinPolicy()).withRetryPolicy((RetryPolicy)new LoggingRetryPolicy((RetryPolicy)DefaultRetryPolicy.INSTANCE)).withCompression(compression).build();
        return this.cluster.connect(RHQ_KEYSPACE);
    }

    private void initMetricsServer() {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Initializing " + MetricsServer.class.getName()));
        }
        this.metricsServer = new MetricsServer();
        this.metricsServer.setDAO(this.metricsDAO);
        this.metricsServer.setConfiguration(this.metricsConfiguration);
        DateTimeService dateTimeService = new DateTimeService();
        dateTimeService.setConfiguration(this.metricsConfiguration);
        this.metricsServer.setDateTimeService(dateTimeService);
        this.metricsServer.init();
    }

    private String getRequiredStorageProperty(String property) {
        String value = System.getProperty(property);
        if (StringUtil.isEmpty((String)property)) {
            throw new IllegalStateException("The system property [" + property + "] is not set. The RHQ " + "server will not be able connect to the RHQ storage node(s). This property should be defined " + "in rhq-server.properties.");
        }
        return value;
    }
}

