/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.storage;

import com.datastax.driver.core.exceptions.NoHostAvailableException;
import java.net.InetAddress;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.enterprise.server.storage.StorageNodeOperationsHandlerLocal;
import org.rhq.enterprise.server.util.LookupUtil;
import org.rhq.server.metrics.StorageStateListener;

public class StorageClusterMonitor
implements StorageStateListener {
    private Log log = LogFactory.getLog(StorageClusterMonitor.class);
    private boolean isClusterAvailable = true;

    public boolean isClusterAvailable() {
        return this.isClusterAvailable;
    }

    public void onStorageNodeUp(InetAddress address) {
        this.log.info((Object)("Storage node at " + address.getHostAddress() + " is up"));
        this.isClusterAvailable = true;
        StorageNodeOperationsHandlerLocal storageOperationsHandler = LookupUtil.getStorageNodeOperationsHandler();
        storageOperationsHandler.performAddNodeMaintenanceIfNecessary(address);
    }

    public void onStorageNodeDown(InetAddress address) {
        this.log.info((Object)("Storage node at " + address.getHostAddress() + " is down"));
    }

    public void onStorageNodeRemoved(InetAddress address) {
        this.log.info((Object)("Storage node at " + address.getHostAddress() + " has been removed from the cluster"));
        StorageNodeOperationsHandlerLocal storageNodeOperationsHandler = LookupUtil.getStorageNodeOperationsHandler();
        storageNodeOperationsHandler.performRemoveNodeMaintenanceIfNecessary(address);
    }

    public void onStorageClusterDown(NoHostAvailableException e) {
        this.isClusterAvailable = false;
    }
}

