/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.storage;

import com.datastax.driver.core.Host;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import javax.ejb.Asynchronous;
import javax.ejb.EJB;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import javax.persistence.EntityManager;
import javax.persistence.EntityNotFoundException;
import javax.persistence.PersistenceContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.joda.time.Hours;
import org.rhq.core.domain.auth.Subject;
import org.rhq.core.domain.cloud.StorageClusterSettings;
import org.rhq.core.domain.cloud.StorageNode;
import org.rhq.core.domain.common.JobTrigger;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.Property;
import org.rhq.core.domain.configuration.PropertyList;
import org.rhq.core.domain.configuration.PropertySimple;
import org.rhq.core.domain.operation.OperationHistory;
import org.rhq.core.domain.operation.ResourceOperationHistory;
import org.rhq.core.domain.operation.bean.ResourceOperationSchedule;
import org.rhq.core.domain.resource.Resource;
import org.rhq.core.domain.resource.ResourceType;
import org.rhq.core.util.StringUtil;
import org.rhq.core.util.exception.ThrowableUtil;
import org.rhq.enterprise.server.auth.SessionManager;
import org.rhq.enterprise.server.auth.SubjectManagerLocal;
import org.rhq.enterprise.server.cloud.StorageNodeManagerLocal;
import org.rhq.enterprise.server.operation.OperationManagerLocal;
import org.rhq.enterprise.server.resource.ResourceManagerLocal;
import org.rhq.enterprise.server.storage.StorageClientManagerBean;
import org.rhq.enterprise.server.storage.StorageClusterSettingsManagerLocal;
import org.rhq.enterprise.server.storage.StorageNodeOperationsHandlerLocal;
import org.rhq.server.metrics.StorageSession;

@Stateless
public class StorageNodeOperationsHandlerBean
implements StorageNodeOperationsHandlerLocal {
    private final Log log = LogFactory.getLog(StorageNodeOperationsHandlerBean.class);
    private static final String STORAGE_NODE_TYPE_NAME = "RHQ Storage Node";
    private static final String STORAGE_NODE_PLUGIN_NAME = "RHQStorage";
    private static final String RUN_REPAIR_PROPERTY = "runRepair";
    private static final String UPDATE_SEEDS_LIST = "updateSeedsList";
    private static final String SEEDS_LIST = "seedsList";
    @PersistenceContext(unitName="rhqpu")
    private EntityManager entityManager;
    @EJB
    private SubjectManagerLocal subjectManager;
    @EJB
    private StorageNodeManagerLocal storageNodeManager;
    @EJB
    private OperationManagerLocal operationManager;
    @EJB
    private StorageClusterSettingsManagerLocal storageClusterSettingsManager;
    @EJB
    private StorageClientManagerBean storageClientManager;
    @EJB
    private StorageNodeOperationsHandlerLocal storageNodeOperationsHandler;
    @EJB
    private ResourceManagerLocal resourceManager;

    @Override
    public void announceStorageNode(Subject subject, StorageNode storageNode) {
        if (this.log.isInfoEnabled()) {
            this.log.info((Object)("Announcing " + storageNode + " to storage node cluster."));
        }
        List clusterNodes = this.entityManager.createNamedQuery("StorageNode.findAllByMode", StorageNode.class).setParameter("operationMode", (Object)StorageNode.OperationMode.NORMAL).getResultList();
        ArrayList<StorageNode> allNodes = new ArrayList<StorageNode>(clusterNodes);
        allNodes.add(storageNode);
        for (StorageNode clusterNode : clusterNodes) {
            clusterNode.setMaintenancePending(true);
        }
        this.announceStorageNode(subject, storageNode, (StorageNode)clusterNodes.get(0), this.createPropertyListOfAddresses("addresses", allNodes));
    }

    private void announceStorageNode(Subject subject, StorageNode newStorageNode, StorageNode clusterNode, PropertyList addresses) {
        if (this.log.isInfoEnabled()) {
            this.log.info((Object)("Announcing " + newStorageNode + " to cluster node " + clusterNode));
        }
        Configuration parameters = new Configuration();
        parameters.put((Property)addresses);
        this.scheduleOperation(subject, clusterNode, parameters, "announce");
    }

    @Override
    public void unannounceStorageNode(Subject subject, StorageNode storageNode) {
        this.log.info((Object)("Unannouncing " + storageNode));
        List clusterNodes = this.entityManager.createNamedQuery("StorageNode.findAllByMode", StorageNode.class).setParameter("operationMode", (Object)StorageNode.OperationMode.NORMAL).getResultList();
        for (StorageNode clusterNode : clusterNodes) {
            clusterNode.setMaintenancePending(true);
        }
        this.unannounceStorageNode(subject, (StorageNode)clusterNodes.get(0), this.createPropertyListOfAddresses("addresses", clusterNodes));
    }

    private void unannounceStorageNode(Subject subject, StorageNode clusterNode, PropertyList addresses) {
        Configuration parameters = new Configuration();
        parameters.put((Property)addresses);
        this.scheduleOperation(subject, clusterNode, parameters, "unannounce");
    }

    @Override
    public void uninstall(Subject subject, StorageNode storageNode) {
        this.log.info((Object)("Uninstalling " + storageNode));
        if (storageNode.getResource() == null) {
            this.finishUninstall(subject, storageNode);
        } else {
            this.scheduleOperation(subject, storageNode, new Configuration(), "uninstall");
        }
    }

    private void finishUninstall(Subject subject, StorageNode storageNode) {
        if (storageNode.getResource() != null) {
            this.log.info((Object)("Removing storage node resource " + storageNode.getResource() + " from inventory"));
            Resource resource = storageNode.getResource();
            this.storageNodeOperationsHandler.detachFromResource(storageNode);
            this.resourceManager.uninventoryResource(subject, resource.getId());
        }
        this.log.info((Object)("Removing storage node entity " + storageNode + " from database"));
        this.entityManager.remove((Object)storageNode);
        this.log.info((Object)(storageNode + " has been undeployed"));
    }

    @Override
    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    public void detachFromResource(StorageNode storageNode) {
        storageNode.setResource(null);
        storageNode.setFailedOperation(null);
    }

    @Override
    public void decommissionStorageNode(Subject subject, StorageNode storageNode) {
        this.log.info((Object)("Preparing to decommission " + storageNode));
        storageNode = this.storageNodeOperationsHandler.setMode(storageNode, StorageNode.OperationMode.DECOMMISSION);
        List storageNodes = this.entityManager.createNamedQuery("StorageNode.findAllByMode", StorageNode.class).setParameter("operationMode", (Object)StorageNode.OperationMode.NORMAL).getResultList();
        boolean runRepair = this.updateSchemaIfNecessary(storageNodes.size() + 1, storageNodes.size());
        storageNode.setMaintenancePending(runRepair);
        storageNode = (StorageNode)this.entityManager.merge((Object)storageNode);
        this.scheduleOperation(subject, storageNode, new Configuration(), "decommission");
    }

    @Override
    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    public void logError(StorageNode.OperationMode newStorageNodeOperationMode, String error, Exception e) {
        try {
            StorageNode newStorageNode = this.findStorageNodeByMode(newStorageNodeOperationMode);
            newStorageNode.setErrorMessage(error + " Check the server log for details. Root cause: " + ThrowableUtil.getRootCause((Throwable)e).getMessage());
        }
        catch (Exception e1) {
            this.log.error((Object)"Failed to log error against storage node", (Throwable)e);
        }
    }

    @Override
    @TransactionAttribute(value=TransactionAttributeType.NOT_SUPPORTED)
    public void performAddNodeMaintenanceIfNecessary(InetAddress storageNodeAddress) {
        try {
            StorageNode storageNode = this.storageNodeManager.findStorageNodeByAddress(storageNodeAddress);
            if (storageNode.getOperationMode() == StorageNode.OperationMode.BOOTSTRAP) {
                storageNode = this.storageNodeOperationsHandler.setMode(storageNode, StorageNode.OperationMode.ADD_MAINTENANCE);
                this.storageNodeOperationsHandler.performAddMaintenance(this.subjectManager.getOverlord(), storageNode);
            }
        }
        catch (Exception e) {
            String msg = "Aborting storage node deployment due to unexpected error while performing add node maintenance.";
            this.log.error((Object)msg, (Throwable)e);
            this.storageNodeOperationsHandler.logError(StorageNode.OperationMode.ADD_MAINTENANCE, msg, e);
        }
    }

    @Override
    @TransactionAttribute(value=TransactionAttributeType.NOT_SUPPORTED)
    public void performAddNodeMaintenance(Subject subject, StorageNode storageNode) {
        try {
            this.storageNodeOperationsHandler.performAddMaintenance(subject, storageNode);
        }
        catch (Exception e) {
            String msg = "Aborting storage node deployment due to unexpected error while performing add node maintenance.";
            this.log.error((Object)msg, (Throwable)e);
            this.storageNodeOperationsHandler.logError(StorageNode.OperationMode.ADD_MAINTENANCE, msg, e);
        }
    }

    @Override
    public void performAddMaintenance(Subject subject, StorageNode storageNode) {
        List clusterNodes = this.entityManager.createNamedQuery("StorageNode.findAllByMode", StorageNode.class).setParameter("operationMode", (Object)StorageNode.OperationMode.NORMAL).getResultList();
        for (StorageNode node : clusterNodes) {
            node.setMaintenancePending(true);
        }
        storageNode.setMaintenancePending(true);
        clusterNodes.add(storageNode);
        boolean runRepair = this.updateSchemaIfNecessary(clusterNodes.size() - 1, clusterNodes.size());
        this.performAddNodeMaintenance(subject, storageNode, runRepair, this.createPropertyListOfAddresses(SEEDS_LIST, clusterNodes));
    }

    private void performAddNodeMaintenance(Subject subject, StorageNode storageNode, boolean runRepair, PropertyList seedsList) {
        if (this.log.isInfoEnabled()) {
            this.log.info((Object)("Running addNodeMaintenance for storage node " + storageNode));
        }
        Configuration params = new Configuration();
        params.put((Property)seedsList);
        params.put((Property)new PropertySimple(RUN_REPAIR_PROPERTY, (Object)runRepair));
        params.put((Property)new PropertySimple(UPDATE_SEEDS_LIST, (Object)Boolean.TRUE));
        this.scheduleOperation(subject, storageNode, params, "addNodeMaintenance", Hours.EIGHT.toStandardSeconds().getSeconds());
    }

    @Override
    @TransactionAttribute(value=TransactionAttributeType.NOT_SUPPORTED)
    public void performRemoveNodeMaintenanceIfNecessary(InetAddress storageNodeAddress) {
        try {
            StorageNode storageNode = this.storageNodeManager.findStorageNodeByAddress(storageNodeAddress);
            if (storageNode.getOperationMode() == StorageNode.OperationMode.DECOMMISSION) {
                storageNode = this.storageNodeOperationsHandler.setMode(storageNode, StorageNode.OperationMode.REMOVE_MAINTENANCE);
                this.storageNodeOperationsHandler.performRemoveMaintenance(this.subjectManager.getOverlord(), storageNode);
            } else {
                this.log.info((Object)("Remove node maintenance has already been run for " + storageNode));
            }
        }
        catch (Exception e) {
            String msg = "Aborting undeployment due to unexpected error while performing remove node maintenance for " + storageNodeAddress.getHostAddress();
            this.log.error((Object)msg, (Throwable)e);
            this.storageNodeOperationsHandler.logError(StorageNode.OperationMode.REMOVE_MAINTENANCE, msg, e);
        }
    }

    @Override
    @TransactionAttribute(value=TransactionAttributeType.NOT_SUPPORTED)
    public void performRemoveNodeMaintenance(Subject subject, StorageNode storageNode) {
        try {
            this.storageNodeOperationsHandler.performRemoveMaintenance(subject, storageNode);
        }
        catch (Exception e) {
            String msg = "Aborting undeployment due to unexpected error while performing remove node maintenance.";
            this.log.error((Object)msg, (Throwable)e);
            this.storageNodeOperationsHandler.logError(StorageNode.OperationMode.REMOVE_MAINTENANCE, msg, e);
        }
    }

    @Override
    public void performRemoveMaintenance(Subject subject, StorageNode storageNode) {
        List clusterNodes = this.entityManager.createNamedQuery("StorageNode.findAllByMode", StorageNode.class).setParameter("operationMode", (Object)StorageNode.OperationMode.NORMAL).getResultList();
        for (StorageNode node : clusterNodes) {
            node.setMaintenancePending(true);
        }
        boolean runRepair = storageNode.isMaintenancePending();
        this.performRemoveNodeMaintenance(subject, (StorageNode)clusterNodes.get(0), runRepair, this.createPropertyListOfAddresses(SEEDS_LIST, clusterNodes));
    }

    private void performRemoveNodeMaintenance(Subject subject, StorageNode storageNode, boolean runRepair, PropertyList seedsList) {
        if (this.log.isInfoEnabled()) {
            this.log.info((Object)("Running remove node maintenance for storage node " + storageNode));
        }
        Configuration params = new Configuration();
        params.put((Property)seedsList);
        params.put((Property)new PropertySimple(RUN_REPAIR_PROPERTY, (Object)runRepair));
        params.put((Property)new PropertySimple(UPDATE_SEEDS_LIST, (Object)true));
        this.scheduleOperation(subject, storageNode, params, "removeNodeMaintenance", Hours.EIGHT.toStandardSeconds().getSeconds());
    }

    @Override
    @Asynchronous
    public void handleOperationUpdateIfNecessary(OperationHistory operationHistory) {
        if (!(operationHistory instanceof ResourceOperationHistory)) {
            return;
        }
        ResourceOperationHistory resourceOperationHistory = (ResourceOperationHistory)operationHistory;
        if (!this.isStorageNodeOperation(resourceOperationHistory)) {
            return;
        }
        if (resourceOperationHistory.getOperationDefinition().getName().equals("announce")) {
            try {
                this.storageNodeOperationsHandler.handleAnnounce(resourceOperationHistory);
            }
            catch (Exception e) {
                String msg = "Aborting storage node deployment due to unexpected error while announcing cluster nodes.";
                this.log.error((Object)msg, (Throwable)e);
                this.storageNodeOperationsHandler.logError(StorageNode.OperationMode.ANNOUNCE, msg, e);
            }
        } else if (operationHistory.getOperationDefinition().getName().equals("prepareForBootstrap")) {
            try {
                this.storageNodeOperationsHandler.handlePrepareForBootstrap(resourceOperationHistory);
            }
            catch (Exception e) {
                String msg = "Aborting storage node deployment due to unexpected error while bootstrapping new node.";
                this.log.error((Object)msg, (Throwable)e);
                this.storageNodeOperationsHandler.logError(StorageNode.OperationMode.BOOTSTRAP, msg, e);
            }
        } else if (operationHistory.getOperationDefinition().getName().equals("addNodeMaintenance")) {
            try {
                this.storageNodeOperationsHandler.handleAddNodeMaintenance(resourceOperationHistory);
            }
            catch (Exception e) {
                String msg = "Aborting storage node deployment due to unexpected error while performing add node maintenance.";
                this.log.error((Object)msg, (Throwable)e);
                this.storageNodeOperationsHandler.logError(StorageNode.OperationMode.ADD_MAINTENANCE, msg, e);
            }
        } else if (operationHistory.getOperationDefinition().getName().equals("decommission")) {
            try {
                this.storageNodeOperationsHandler.handleDecommission(resourceOperationHistory);
            }
            catch (Exception e) {
                String msg = "Aborting undeployment due to unexpected error while decommissioning storage node.";
                this.log.error((Object)msg, (Throwable)e);
                this.storageNodeOperationsHandler.logError(StorageNode.OperationMode.DECOMMISSION, msg, e);
            }
        } else if (operationHistory.getOperationDefinition().getName().equals("removeNodeMaintenance")) {
            try {
                this.storageNodeOperationsHandler.handleRemoveNodeMaintenance(resourceOperationHistory);
            }
            catch (Exception e) {
                String msg = "Aborting undeployment due to unexpected error while performing remove node maintenance.";
                this.log.error((Object)msg, (Throwable)e);
                this.storageNodeOperationsHandler.logError(StorageNode.OperationMode.REMOVE_MAINTENANCE, msg, e);
            }
        } else if (operationHistory.getOperationDefinition().getName().equals("unannounce")) {
            try {
                this.storageNodeOperationsHandler.handleUnannounce(resourceOperationHistory);
            }
            catch (Exception e) {
                String msg = "Aborting undeployment due to unexpected error while performing unannouncement.";
                this.log.error((Object)msg, (Throwable)e);
                this.storageNodeOperationsHandler.logError(StorageNode.OperationMode.UNANNOUNCE, msg, e);
            }
        } else if (operationHistory.getOperationDefinition().getName().equals("uninstall")) {
            try {
                this.storageNodeOperationsHandler.handleUninstall(resourceOperationHistory);
            }
            catch (Exception e) {
                String msg = "Aborting undeployment due to unexpected error while uninstalling.";
                this.log.error((Object)msg, (Throwable)e);
                this.storageNodeOperationsHandler.logError(StorageNode.OperationMode.UNINSTALL, msg, e);
            }
        } else if (operationHistory.getOperationDefinition().getName().equals("repair")) {
            try {
                this.storageNodeOperationsHandler.handleRepair(resourceOperationHistory);
            }
            catch (Exception e) {
                String msg = "Abort scheduled repair maintenance due to unexpected error.";
                this.log.error((Object)msg, (Throwable)e);
            }
        }
    }

    @Override
    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    public void handleAnnounce(ResourceOperationHistory resourceOperationHistory) {
        StorageNode storageNode = this.findStorageNode(resourceOperationHistory.getResource());
        StorageNode newStorageNode = null;
        switch (resourceOperationHistory.getStatus()) {
            case INPROGRESS: {
                return;
            }
            case CANCELED: {
                newStorageNode = this.findStorageNodeByMode(StorageNode.OperationMode.ANNOUNCE);
                this.deploymentOperationCanceled(storageNode, resourceOperationHistory, newStorageNode);
            }
            case FAILURE: {
                newStorageNode = this.findStorageNodeByMode(StorageNode.OperationMode.ANNOUNCE);
                this.deploymentOperationFailed(storageNode, resourceOperationHistory, newStorageNode);
                return;
            }
        }
        storageNode.setMaintenancePending(false);
        Configuration parameters = resourceOperationHistory.getParameters();
        PropertyList addresses = parameters.getList("addresses");
        StorageNode nextNode = this.takeFromMaintenanceQueue();
        newStorageNode = this.findStorageNodeByMode(StorageNode.OperationMode.ANNOUNCE);
        Subject subject = this.getSubject(resourceOperationHistory);
        if (nextNode == null) {
            this.log.info((Object)"Successfully announced new storage node to storage cluster");
            newStorageNode = this.storageNodeOperationsHandler.setMode(newStorageNode, StorageNode.OperationMode.BOOTSTRAP);
            this.storageNodeOperationsHandler.bootstrapStorageNode(subject, newStorageNode);
        } else {
            this.announceStorageNode(subject, newStorageNode, nextNode, addresses.deepCopy(false));
        }
    }

    @Override
    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    public void handleUnannounce(ResourceOperationHistory operationHistory) {
        StorageNode storageNode = this.findStorageNode(operationHistory.getResource());
        StorageNode removedStorageNode = this.findStorageNodeByMode(StorageNode.OperationMode.UNANNOUNCE);
        switch (operationHistory.getStatus()) {
            case INPROGRESS: {
                break;
            }
            case CANCELED: {
                this.undeploymentOperationCanceled(storageNode, operationHistory, removedStorageNode);
                break;
            }
            case FAILURE: {
                this.deploymentOperationFailed(storageNode, operationHistory, removedStorageNode);
                break;
            }
            default: {
                storageNode.setMaintenancePending(false);
                StorageNode nextNode = this.takeFromMaintenanceQueue();
                Subject subject = this.getSubject(operationHistory);
                if (nextNode == null) {
                    this.log.info((Object)("Successfully unannounced " + removedStorageNode + " to storage cluster"));
                    removedStorageNode = this.storageNodeOperationsHandler.setMode(removedStorageNode, StorageNode.OperationMode.UNINSTALL);
                    this.uninstall(this.getSubject(operationHistory), removedStorageNode);
                    break;
                }
                Configuration params = operationHistory.getParameters();
                PropertyList addresses = params.getList("addresses");
                this.unannounceStorageNode(subject, nextNode, addresses.deepCopy(false));
            }
        }
    }

    @Override
    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    public void handlePrepareForBootstrap(ResourceOperationHistory resourceOperationHistory) {
        StorageNode newStorageNode = this.findStorageNode(resourceOperationHistory.getResource());
        switch (resourceOperationHistory.getStatus()) {
            case INPROGRESS: {
                return;
            }
            case CANCELED: {
                this.deploymentOperationCanceled(newStorageNode, resourceOperationHistory);
                return;
            }
            case FAILURE: {
                this.deploymentOperationFailed(newStorageNode, resourceOperationHistory);
                return;
            }
        }
        try {
            this.log.info((Object)("The prepare for bootstrap operation completed successfully for " + newStorageNode));
            Thread.sleep(30000L);
            this.entityManager.refresh((Object)newStorageNode);
            if (newStorageNode.getOperationMode() == StorageNode.OperationMode.BOOTSTRAP) {
                InetAddress address = InetAddress.getByName(newStorageNode.getAddress());
                if (this.isPartOfCluster(address)) {
                    this.log.warn((Object)("We have missed the event notification about " + newStorageNode + " joining the " + "cluster. The next phase of deployment will be started."));
                    this.storageNodeOperationsHandler.performAddNodeMaintenanceIfNecessary(address);
                } else {
                    newStorageNode.setErrorMessage("The prepare for bootstrap operation completed successfully but it appears that " + newStorageNode + " is not yet part of the " + "ring.");
                }
            }
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Interrupted while waiting to verify that " + newStorageNode + " has joined the cluster", e);
        }
        catch (UnknownHostException e) {
            throw new RuntimeException("Failed to parse address for " + newStorageNode, e);
        }
    }

    @Override
    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    public void handleAddNodeMaintenance(ResourceOperationHistory resourceOperationHistory) {
        StorageNode storageNode = this.findStorageNode(resourceOperationHistory.getResource());
        StorageNode newStorageNode = this.findStorageNodeByMode(StorageNode.OperationMode.ADD_MAINTENANCE);
        switch (resourceOperationHistory.getStatus()) {
            case INPROGRESS: {
                return;
            }
            case CANCELED: {
                this.deploymentOperationCanceled(storageNode, resourceOperationHistory, newStorageNode);
                return;
            }
            case FAILURE: {
                this.deploymentOperationFailed(storageNode, resourceOperationHistory, newStorageNode);
                return;
            }
        }
        this.log.info((Object)("Finished running add node maintenance for " + storageNode));
        storageNode.setMaintenancePending(false);
        StorageNode nextNode = this.takeFromMaintenanceQueue();
        if (nextNode == null) {
            this.log.info((Object)"Finished running add node maintenance on all cluster nodes");
            this.storageNodeOperationsHandler.setMode(newStorageNode, StorageNode.OperationMode.NORMAL);
        } else {
            Configuration parameters = resourceOperationHistory.getParameters();
            boolean runRepair = parameters.getSimple(RUN_REPAIR_PROPERTY).getBooleanValue();
            PropertyList seedsList = parameters.getList(SEEDS_LIST).deepCopy(false);
            Subject subject = this.getSubject(resourceOperationHistory);
            this.performAddNodeMaintenance(subject, nextNode, runRepair, seedsList);
        }
    }

    @Override
    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    public void bootstrapStorageNode(Subject subject, StorageNode storageNode) {
        List clusterNodes = this.entityManager.createNamedQuery("StorageNode.findAllByMode", StorageNode.class).setParameter("operationMode", (Object)StorageNode.OperationMode.NORMAL).getResultList();
        clusterNodes.add(storageNode);
        this.prepareNodeForBootstrap(subject, storageNode, this.createPropertyListOfAddresses("addresses", clusterNodes));
    }

    private void prepareNodeForBootstrap(Subject subject, StorageNode storageNode, PropertyList addresses) {
        if (this.log.isInfoEnabled()) {
            this.log.info((Object)("Preparing to bootstrap " + storageNode + " into cluster..."));
        }
        StorageClusterSettings clusterSettings = this.storageClusterSettingsManager.getClusterSettings(subject);
        Configuration parameters = new Configuration();
        parameters.put((Property)new PropertySimple("cqlPort", (Object)clusterSettings.getCqlPort()));
        parameters.put((Property)new PropertySimple("gossipPort", (Object)clusterSettings.getGossipPort()));
        parameters.put((Property)addresses);
        this.scheduleOperation(subject, storageNode, parameters, "prepareForBootstrap");
    }

    @Override
    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    public void handleRemoveNodeMaintenance(ResourceOperationHistory operationHistory) {
        StorageNode storageNode = this.findStorageNode(operationHistory.getResource());
        StorageNode removedStorageNode = this.findStorageNodeByMode(StorageNode.OperationMode.REMOVE_MAINTENANCE);
        switch (operationHistory.getStatus()) {
            case INPROGRESS: {
                break;
            }
            case CANCELED: {
                this.undeploymentOperationCanceled(storageNode, operationHistory, removedStorageNode);
                break;
            }
            case FAILURE: {
                this.undeploymentOperationFailed(storageNode, operationHistory, removedStorageNode);
                break;
            }
            default: {
                this.log.info((Object)("Finished remove node maintenance for " + storageNode));
                storageNode.setMaintenancePending(false);
                StorageNode nextNode = this.takeFromMaintenanceQueue();
                if (nextNode == null) {
                    this.log.info((Object)"Finished running remove node maintenance on all cluster nodes");
                    removedStorageNode = this.storageNodeOperationsHandler.setMode(removedStorageNode, StorageNode.OperationMode.UNANNOUNCE);
                    this.unannounceStorageNode(this.getSubject(operationHistory), removedStorageNode);
                    break;
                }
                Configuration parameters = operationHistory.getParameters();
                boolean runRepair = parameters.getSimple(RUN_REPAIR_PROPERTY).getBooleanValue();
                PropertyList seedsList = parameters.getList(SEEDS_LIST).deepCopy(false);
                Subject subject = this.getSubject(operationHistory);
                this.performRemoveNodeMaintenance(subject, nextNode, runRepair, seedsList);
            }
        }
    }

    @Override
    public void runRepair(Subject subject, List<StorageNode> clusterNodes) {
        this.log.info((Object)"Starting anti-entropy repair on storage cluster");
        for (StorageNode node : clusterNodes) {
            node.setErrorMessage(null);
            node.setFailedOperation(null);
            node.setMaintenancePending(true);
        }
        StorageNode storageNode = this.storageNodeOperationsHandler.setMode(clusterNodes.get(0), StorageNode.OperationMode.MAINTENANCE);
        this.scheduleOperation(subject, storageNode, new Configuration(), "repair", Hours.SIX.toStandardSeconds().getSeconds());
    }

    private void runRepair(Subject subject, StorageNode storageNode) {
        this.scheduleOperation(subject, storageNode, new Configuration(), "repair", Hours.SIX.toStandardSeconds().getSeconds());
    }

    @Override
    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    public void handleRepair(ResourceOperationHistory operationHistory) {
        StorageNode storageNode = this.findStorageNode(operationHistory.getResource());
        switch (operationHistory.getStatus()) {
            case INPROGRESS: {
                break;
            }
            case CANCELED: {
                this.repairCanceled(storageNode, operationHistory);
                break;
            }
            case FAILURE: {
                this.repairFailed(storageNode, operationHistory);
                break;
            }
            default: {
                this.log.info((Object)("Finished running repair on " + storageNode));
                storageNode.setMaintenancePending(false);
                this.storageNodeOperationsHandler.setMode(storageNode, StorageNode.OperationMode.NORMAL);
                StorageNode nextNode = this.takeFromMaintenanceQueue();
                if (nextNode == null) {
                    this.log.info((Object)"Finished running repair on storage cluster");
                    break;
                }
                nextNode = this.storageNodeOperationsHandler.setMode(nextNode, StorageNode.OperationMode.MAINTENANCE);
                this.runRepair(this.getSubject(operationHistory), nextNode);
            }
        }
    }

    @Override
    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    public void handleDecommission(ResourceOperationHistory operationHistory) {
        StorageNode storageNode = this.findStorageNode(operationHistory.getResource());
        switch (operationHistory.getStatus()) {
            case INPROGRESS: {
                break;
            }
            case CANCELED: {
                this.undeploymentOperationCanceled(storageNode, operationHistory);
                break;
            }
            case FAILURE: {
                this.undeploymentOperationFailed(storageNode, operationHistory);
                break;
            }
            default: {
                this.log.info((Object)("Successfully decommissioned " + storageNode));
                try {
                    Thread.sleep(30000L);
                    this.entityManager.refresh((Object)storageNode);
                    if (storageNode.getOperationMode() != StorageNode.OperationMode.DECOMMISSION) break;
                    InetAddress address = InetAddress.getByName(storageNode.getAddress());
                    if (this.isPartOfCluster(address)) {
                        storageNode.setErrorMessage("The decommission operation completed successfully but it appears that " + storageNode + " is still part of ring.");
                        break;
                    }
                    this.log.warn((Object)("We have missed the event notification about " + storageNode + " leaving the " + "cluster. The next phase of undeployment will be started."));
                    this.storageNodeOperationsHandler.performRemoveNodeMaintenanceIfNecessary(address);
                    break;
                }
                catch (EntityNotFoundException e) {
                    break;
                }
                catch (InterruptedException e) {
                    throw new RuntimeException("Interrupted while waiting to verify that " + storageNode + " has been decommissioned and removed from the cluster", e);
                }
                catch (UnknownHostException e) {
                    throw new RuntimeException("Failed to parse address for " + storageNode, e);
                }
            }
        }
    }

    @Override
    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    public void handleUninstall(ResourceOperationHistory operationHistory) {
        StorageNode storageNode = this.findStorageNode(operationHistory.getResource());
        switch (operationHistory.getStatus()) {
            case INPROGRESS: {
                break;
            }
            case CANCELED: {
                this.undeploymentOperationCanceled(storageNode, operationHistory);
                break;
            }
            case FAILURE: {
                this.undeploymentOperationFailed(storageNode, operationHistory);
                break;
            }
            default: {
                this.log.info((Object)("Successfully uninstalled " + storageNode + " from disk"));
                this.finishUninstall(this.getSubject(operationHistory), storageNode);
            }
        }
    }

    @Override
    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    public StorageNode setMode(StorageNode storageNode, StorageNode.OperationMode newMode) {
        storageNode.setOperationMode(newMode);
        return (StorageNode)this.entityManager.merge((Object)storageNode);
    }

    private Subject getSubject(ResourceOperationHistory resourceOperationHistory) {
        Subject subject = this.subjectManager.getSubjectByName(resourceOperationHistory.getSubjectName());
        return SessionManager.getInstance().put(subject);
    }

    private void deploymentOperationCanceled(StorageNode storageNode, ResourceOperationHistory operationHistory, StorageNode newStorageNode) {
        this.operationCanceled(storageNode, operationHistory, newStorageNode, "Deployment");
    }

    private void undeploymentOperationCanceled(StorageNode storageNode, ResourceOperationHistory operationHistory, StorageNode removedStorageNode) {
        this.operationCanceled(storageNode, operationHistory, removedStorageNode, "Undeployment");
    }

    private void operationCanceled(StorageNode storageNode, ResourceOperationHistory operationHistory, StorageNode movingNode, String opType) {
        this.log.error((Object)(opType + " has been aborted due to canceled operation [" + operationHistory.getOperationDefinition().getDisplayName() + " on " + storageNode.getResource() + ": " + operationHistory.getErrorMessage()));
        movingNode.setErrorMessage(opType + " has been aborted due to canceled resource operation on " + storageNode.getAddress());
        storageNode.setErrorMessage(opType + " of " + movingNode.getAddress() + " has been aborted due " + "to cancellation of resource operation [" + operationHistory.getOperationDefinition().getDisplayName() + "].");
        storageNode.setFailedOperation(operationHistory);
    }

    private void deploymentOperationCanceled(StorageNode newStorageNode, ResourceOperationHistory operationHistory) {
        this.operationCanceled(newStorageNode, operationHistory, "Deployment");
    }

    private void undeploymentOperationCanceled(StorageNode storageNode, ResourceOperationHistory operationHistory) {
        this.operationCanceled(storageNode, operationHistory, "Undeployment");
    }

    private void repairCanceled(StorageNode storageNode, ResourceOperationHistory operationHistory) {
        this.operationCanceled(storageNode, operationHistory, "Scheduled repair");
    }

    private void operationCanceled(StorageNode storageNode, ResourceOperationHistory operationHistory, String opType) {
        this.log.error((Object)(opType + " has been aborted due to canceled operation [" + operationHistory.getOperationDefinition().getDisplayName() + " on " + storageNode.getResource() + ": " + operationHistory.getErrorMessage()));
        storageNode.setErrorMessage(opType + " has been aborted due to canceled resource operation [" + operationHistory.getOperationDefinition().getDisplayName() + "].");
        storageNode.setFailedOperation(operationHistory);
    }

    private void deploymentOperationFailed(StorageNode storageNode, ResourceOperationHistory operationHistory, StorageNode newStorageNode) {
        this.operationFailed(storageNode, operationHistory, newStorageNode, "Deployment");
    }

    private void undeploymentOperationFailed(StorageNode storageNode, ResourceOperationHistory operationHistory, StorageNode removedNode) {
        this.operationFailed(storageNode, operationHistory, removedNode, "Undeployment");
    }

    private void deploymentOperationFailed(StorageNode storageNode, ResourceOperationHistory operationHistory) {
        this.operationFailed(storageNode, operationHistory, "Deployment");
    }

    private void undeploymentOperationFailed(StorageNode storageNode, ResourceOperationHistory operationHistory) {
        this.operationFailed(storageNode, operationHistory, "Undeployment");
    }

    private void repairFailed(StorageNode storageNode, ResourceOperationHistory operationHistory) {
        this.operationFailed(storageNode, operationHistory, "Scheduled repair");
    }

    private void operationFailed(StorageNode storageNode, ResourceOperationHistory operationHistory, String opType) {
        this.log.error((Object)(opType + " has been aborted due to failed operation [" + operationHistory.getOperationDefinition().getDisplayName() + "] on " + storageNode.getResource() + ": " + operationHistory.getErrorMessage()));
        storageNode.setErrorMessage(opType + " has been aborted due to failed resource operation [" + operationHistory.getOperationDefinition().getDisplayName() + "].");
        storageNode.setFailedOperation(operationHistory);
    }

    private void operationFailed(StorageNode storageNode, ResourceOperationHistory operationHistory, StorageNode movingNode, String opType) {
        this.log.error((Object)(opType + " has been aborted due to failed operation [" + operationHistory.getOperationDefinition().getDisplayName() + "] on " + storageNode.getResource() + ": " + operationHistory.getErrorMessage()));
        movingNode.setErrorMessage(opType + " has been aborted due to failed resource operation on " + storageNode.getAddress());
        storageNode.setErrorMessage(opType + " of " + movingNode.getAddress() + " has been aborted due " + "to failed resource operation [" + operationHistory.getOperationDefinition().getDisplayName() + "].");
        storageNode.setFailedOperation(operationHistory);
    }

    private StorageNode findStorageNode(Resource resource) {
        for (StorageNode storageNode : this.storageNodeManager.getStorageNodes()) {
            if (storageNode.getResource().getId() != resource.getId()) continue;
            return storageNode;
        }
        return null;
    }

    private StorageNode takeFromMaintenanceQueue() {
        List storageNodes = this.entityManager.createQuery("SELECT s FROM StorageNode s WHERE s.operationMode = :operationMode AND s.maintenancePending = :maintenancePending", StorageNode.class).setParameter("operationMode", (Object)StorageNode.OperationMode.NORMAL).setParameter("maintenancePending", (Object)true).getResultList();
        if (storageNodes.isEmpty()) {
            return null;
        }
        return (StorageNode)storageNodes.get(0);
    }

    private StorageNode findStorageNodeByMode(StorageNode.OperationMode operationMode) {
        return (StorageNode)this.entityManager.createNamedQuery("StorageNode.findAllByMode", StorageNode.class).setParameter("operationMode", (Object)operationMode).getSingleResult();
    }

    private boolean isStorageNodeOperation(ResourceOperationHistory operationHistory) {
        if (operationHistory == null) {
            return false;
        }
        ResourceType resourceType = operationHistory.getOperationDefinition().getResourceType();
        return resourceType.getName().equals(STORAGE_NODE_TYPE_NAME) && resourceType.getPlugin().equals(STORAGE_NODE_PLUGIN_NAME);
    }

    private boolean updateSchemaIfNecessary(int previousClusterSize, int newClusterSize) {
        boolean isRepairNeeded;
        int replicationFactor = 1;
        if (previousClusterSize == 0) {
            throw new IllegalStateException("previousClusterSize cannot be 0");
        }
        if (newClusterSize == 0) {
            throw new IllegalStateException("newClusterSize cannot be 0");
        }
        if (Math.abs(newClusterSize - previousClusterSize) != 1) {
            throw new IllegalStateException("The absolute difference between previousClusterSize[" + previousClusterSize + "] and newClusterSize[" + newClusterSize + "] must be 1");
        }
        if (newClusterSize == 1) {
            isRepairNeeded = false;
            replicationFactor = 1;
        } else if (previousClusterSize > 4 && newClusterSize == 4) {
            isRepairNeeded = false;
        } else if (previousClusterSize == 4 && newClusterSize == 3) {
            isRepairNeeded = true;
            replicationFactor = 2;
        } else if (previousClusterSize == 3 && newClusterSize == 2) {
            isRepairNeeded = false;
        } else if (previousClusterSize == 1 && newClusterSize == 2) {
            isRepairNeeded = true;
            replicationFactor = 2;
        } else if (previousClusterSize == 2 && newClusterSize == 3) {
            isRepairNeeded = false;
        } else if (previousClusterSize == 3 && newClusterSize == 4) {
            isRepairNeeded = true;
            replicationFactor = 3;
        } else if (previousClusterSize == 4 && newClusterSize > 4) {
            isRepairNeeded = false;
        } else {
            throw new IllegalStateException("previousClusterSize[" + previousClusterSize + "] and newClusterSize[" + newClusterSize + "] is not supported");
        }
        if (isRepairNeeded) {
            this.updateReplicationFactor(replicationFactor);
            if (previousClusterSize == 1) {
                this.updateGCGraceSeconds(691200);
            }
        } else if (newClusterSize == 1) {
            this.updateReplicationFactor(1);
            this.updateGCGraceSeconds(0);
        }
        return isRepairNeeded;
    }

    private void updateReplicationFactor(int replicationFactor) {
        StorageSession session = this.storageClientManager.getSession();
        session.execute("ALTER KEYSPACE rhq WITH replication = {'class': 'SimpleStrategy', 'replication_factor': " + replicationFactor + "}");
        session.execute("ALTER KEYSPACE system_auth WITH replication = {'class': 'SimpleStrategy', 'replication_factor': " + replicationFactor + "}");
    }

    private void updateGCGraceSeconds(int seconds) {
        StorageSession session = this.storageClientManager.getSession();
        session.execute("ALTER COLUMNFAMILY rhq.metrics_index WITH gc_grace_seconds = " + seconds);
        session.execute("ALTER COLUMNFAMILY rhq.raw_metrics WITH gc_grace_seconds = " + seconds);
        session.execute("ALTER COLUMNFAMILY rhq.one_hour_metrics WITH gc_grace_seconds = " + seconds);
        session.execute("ALTER COLUMNFAMILY rhq.six_hour_metrics WITH gc_grace_seconds = " + seconds);
        session.execute("ALTER COLUMNFAMILY rhq.twenty_four_hour_metrics WITH gc_grace_seconds = " + seconds);
        session.execute("ALTER COLUMNFAMILY rhq.schema_version WITH gc_grace_seconds = " + seconds);
    }

    private String getRequiredStorageProperty(String property) {
        String value = System.getProperty(property);
        if (StringUtil.isEmpty((String)property)) {
            throw new IllegalStateException("The system property [" + property + "] is not set. The RHQ " + "server will not be able connect to the RHQ storage node(s). This property should be defined " + "in rhq-server.properties.");
        }
        return value;
    }

    private void scheduleOperation(Subject subject, StorageNode storageNode, Configuration parameters, String operation) {
        this.scheduleOperation(subject, storageNode, parameters, operation, 300);
    }

    private void scheduleOperation(Subject subject, StorageNode storageNode, Configuration parameters, String operation, int timeout) {
        ResourceOperationSchedule schedule = new ResourceOperationSchedule();
        schedule.setResource(storageNode.getResource());
        schedule.setJobTrigger(JobTrigger.createNowTrigger());
        schedule.setSubject(subject);
        schedule.setOperationName(operation);
        parameters.setSimpleValue("rhq.timeout", Integer.toString(timeout));
        schedule.setParameters(parameters);
        this.operationManager.scheduleResourceOperation(subject, schedule);
    }

    private PropertyList createPropertyListOfAddresses(String propertyName, List<StorageNode> nodes) {
        PropertyList list = new PropertyList(propertyName);
        for (StorageNode storageNode : nodes) {
            list.add((Property)new PropertySimple("address", (Object)storageNode.getAddress()));
        }
        return list;
    }

    private boolean isPartOfCluster(InetAddress address) {
        StorageSession session = this.storageClientManager.getSession();
        for (Host host : session.getCluster().getMetadata().getAllHosts()) {
            if (!host.getAddress().equals(address)) continue;
            return true;
        }
        return false;
    }
}

