/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.util;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.rhq.core.domain.criteria.BaseCriteria;
import org.rhq.core.domain.util.PageControl;
import org.rhq.core.domain.util.PageList;
import org.rhq.enterprise.server.util.CriteriaQueryExecutor;

public class CriteriaQuery<T, C extends BaseCriteria>
implements Iterable<T> {
    private C criteria;
    private CriteriaQueryExecutor<T, C> queryExecutor;

    public CriteriaQuery(C criteria, CriteriaQueryExecutor<T, C> queryExecutor) {
        this.criteria = criteria;
        this.queryExecutor = queryExecutor;
    }

    @Override
    public Iterator<T> iterator() {
        return new QueryResultsIterator(this.executeQuery());
    }

    private PageList<T> executeQuery() {
        return this.queryExecutor.execute(this.criteria);
    }

    protected class QueryResultsIterator
    implements Iterator<T> {
        private int count;
        private PageList<T> currentPage;
        private Iterator<T> iterator;
        private T deletable = null;
        private ArrayList<T> forDeletion = new ArrayList();

        public QueryResultsIterator(PageList<T> firstPage) {
            this.currentPage = firstPage;
            this.iterator = this.currentPage.iterator();
            this.count = firstPage == null || firstPage.getPageControl() == null ? 0 : firstPage.getPageControl().getStartRow();
        }

        @Override
        public boolean hasNext() {
            return this.count < this.currentPage.getTotalSize();
        }

        @Override
        public T next() {
            if (!this.iterator.hasNext()) {
                if (this.count == this.currentPage.getTotalSize()) {
                    throw new NoSuchElementException();
                }
                this.deletable = null;
                if (!this.forDeletion.isEmpty()) {
                    this.currentPage.removeAll(this.forDeletion);
                    this.forDeletion.clear();
                }
                PageControl pcCurrent = this.currentPage.getPageControl();
                PageControl pcOverrides = CriteriaQuery.this.criteria.getPageControlOverrides();
                if (null != pcOverrides) {
                    pcOverrides.setPageNumber(pcOverrides.getPageNumber() + 1);
                } else {
                    CriteriaQuery.this.criteria.setPaging(pcCurrent.getPageNumber() + 1, pcCurrent.getPageSize());
                }
                this.currentPage.clear();
                this.currentPage = CriteriaQuery.this.queryExecutor.execute(CriteriaQuery.this.criteria);
                this.iterator = this.currentPage.iterator();
            }
            Object next = this.iterator.next();
            this.deletable = next;
            ++this.count;
            return next;
        }

        @Override
        public void remove() {
            if (this.deletable == null) {
                throw new IllegalStateException("Not allowed to call remove() without calling next() just before this call.");
            }
            this.forDeletion.add(this.deletable);
            this.deletable = null;
        }
    }
}

