/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.util;

import java.lang.reflect.Field;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.Hibernate;
import org.rhq.core.domain.criteria.Criteria;
import org.rhq.core.domain.util.PageControl;
import org.rhq.core.domain.util.PageList;
import org.rhq.enterprise.server.util.CriteriaQueryGenerator;
import org.rhq.enterprise.server.util.CriteriaUtil;
import org.rhq.enterprise.server.util.PhantomReadMaxAttemptsExceededException;
import org.rhq.enterprise.server.util.QueryUtility;

public class CriteriaQueryRunner<T> {
    private static final Log LOG = LogFactory.getLog(CriteriaQueryRunner.class);
    private Criteria criteria;
    private CriteriaQueryGenerator queryGenerator;
    private EntityManager entityManager;
    private boolean automaticFetching;
    private static final QueryUtility.PagedDataFetchSettings DATA_FETCH_SETTINGS = new QueryUtility.PagedDataFetchSettings();

    public CriteriaQueryRunner(Criteria criteria, CriteriaQueryGenerator queryGenerator, EntityManager entityManager) {
        this(criteria, queryGenerator, entityManager, true);
    }

    public CriteriaQueryRunner(Criteria criteria, CriteriaQueryGenerator queryGenerator, EntityManager entityManager, boolean automaticFetching) {
        this.criteria = criteria;
        this.queryGenerator = queryGenerator;
        this.entityManager = entityManager;
        this.automaticFetching = automaticFetching;
    }

    public PageList<T> execute() {
        Object results;
        PageControl pageControl = CriteriaQueryGenerator.getPageControl(this.criteria);
        Criteria.Restriction criteriaRestriction = this.criteria.getRestriction();
        if (criteriaRestriction == null) {
            try {
                results = QueryUtility.fetchPagedDataAndCount(this.queryGenerator.getQuery(this.entityManager), this.queryGenerator.getCountQuery(this.entityManager), pageControl, DATA_FETCH_SETTINGS);
            }
            catch (PhantomReadMaxAttemptsExceededException e) {
                LOG.warn((Object)("Could not get consistent results of the paged data and a total count for " + CriteriaUtil.toString(this.criteria) + ". After " + e.getNumberOfAttempts() + " attempts, the collection size" + " is " + e.getList().size() + ", while the count query reports " + e.getList().getTotalSize() + " for " + pageControl + ". The discrepancy has not cleared up in " + e.getMillisecondsSpentTrying() + "ms so we're giving up, " + "returning inconsistent results. Note that is most possibly NOT an error. It is likely " + "caused by concurrent database activity that changes the contents of the database that the " + "criteria query is querying."), (Throwable)new Exception());
                results = e.getList();
            }
            this.finalizeCollection((List<?>)results);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("restriction=" + criteriaRestriction + ", resultSize=" + results.size() + ", resultCount=" + results.getTotalSize()));
            }
        } else if (criteriaRestriction == Criteria.Restriction.COUNT_ONLY) {
            results = new PageList(this.getCount(), pageControl);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("restriction=" + criteriaRestriction + ", resultCount=" + results.getTotalSize()));
            }
        } else if (criteriaRestriction == Criteria.Restriction.COLLECTION_ONLY) {
            results = new PageList(this.getCollection(), pageControl);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("restriction=" + criteriaRestriction + ", resultSize=" + results.size()));
            }
        } else {
            throw new IllegalArgumentException(this.getClass().getSimpleName() + " does not support query execution for criteria with " + Criteria.Restriction.class.getSimpleName() + " " + criteriaRestriction);
        }
        return results;
    }

    private Collection<? extends T> getCollection() {
        Query query = this.queryGenerator.getQuery(this.entityManager);
        List results = query.getResultList();
        this.finalizeCollection(results);
        return results;
    }

    private void finalizeCollection(List<?> results) {
        if (this.automaticFetching) {
            if (!this.queryGenerator.getPersistentBagFields().isEmpty()) {
                for (Object entity : results) {
                    this.initPersistentBags(entity);
                }
            }
            if (!this.queryGenerator.getJoinFetchFields().isEmpty()) {
                for (Object entity : results) {
                    this.initJoinFetchFields(entity);
                }
            }
        }
    }

    private int getCount() {
        Query countQuery = this.queryGenerator.getCountQuery(this.entityManager);
        long count = (Long)countQuery.getSingleResult();
        return (int)count;
    }

    public void initFetchFields(Object entity) {
        this.initPersistentBags(entity);
        this.initJoinFetchFields(entity);
    }

    private void initPersistentBags(Object entity) {
        for (Field persistentBagField : this.queryGenerator.getPersistentBagFields()) {
            this.initialize(entity, persistentBagField);
        }
    }

    private void initJoinFetchFields(Object entity) {
        for (Field joinFetchField : this.queryGenerator.getJoinFetchFields()) {
            this.initialize(entity, joinFetchField);
        }
    }

    private void initialize(Object entity, Field field) {
        try {
            field.setAccessible(true);
            Object instance = field.get(entity);
            Hibernate.initialize((Object)instance);
            if (instance instanceof Iterable) {
                Iterator it = ((Iterable)instance).iterator();
                while (it.hasNext()) {
                    it.next();
                }
            }
        }
        catch (Exception e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Could not initialize " + field + "  Following exception has caused the problem: "), (Throwable)e);
            }
            LOG.warn((Object)("Could not initialize " + field));
        }
    }

    static {
        DATA_FETCH_SETTINGS.setThrowOnMaxAttempts(true);
    }
}

