/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.bundle.filetemplate.recipe;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.StreamTokenizer;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.rhq.bundle.filetemplate.recipe.BundleRecipeCommand;
import org.rhq.bundle.filetemplate.recipe.CommandRecipeCommand;
import org.rhq.bundle.filetemplate.recipe.ConfigDefRecipeCommand;
import org.rhq.bundle.filetemplate.recipe.DeployRecipeCommand;
import org.rhq.bundle.filetemplate.recipe.FileRecipeCommand;
import org.rhq.bundle.filetemplate.recipe.RealizeRecipeCommand;
import org.rhq.bundle.filetemplate.recipe.RecipeCommand;
import org.rhq.bundle.filetemplate.recipe.RecipeContext;
import org.rhq.bundle.filetemplate.recipe.ScriptRecipeCommand;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.system.SystemInfoFactory;
import org.rhq.core.template.TemplateEngine;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RecipeParser {
    private Map<String, RecipeCommand> recipeCommands = this.createRecipeCommands();
    private Pattern replacementVariableDeclarationPattern;
    private Pattern replacementVariableNamePattern;
    private String systemReplacementVariablePrefix;
    private boolean replaceVariables = false;

    public RecipeParser() {
        this.setupReplacementPatterns();
    }

    public boolean isReplaceReplacementVariables() {
        return this.replaceVariables;
    }

    public void setReplaceReplacementVariables(boolean flag) {
        this.replaceVariables = flag;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parseRecipe(RecipeContext context) throws Exception {
        context.setParser(this);
        try {
            BufferedReader recipeReader = new BufferedReader(new StringReader(context.getRecipe()));
            String line = recipeReader.readLine();
            while (line != null) {
                this.parseRecipeCommandLine(context, line);
                line = recipeReader.readLine();
            }
        }
        finally {
            context.setParser(null);
        }
    }

    protected void parseRecipeCommandLine(RecipeContext context, String line) throws Exception {
        String string = line = null == line ? line : line.trim();
        if (null == line || line.length() == 0 || line.startsWith("#")) {
            return;
        }
        if (this.isReplaceReplacementVariables()) {
            line = this.replaceReplacementVariables(context, line);
        }
        String[] commandLineArray = this.splitCommandLine(line);
        String commandName = commandLineArray[0];
        String[] arguments = this.extractArguments(commandLineArray);
        RecipeCommand recipeCommand = this.recipeCommands.get(commandName);
        if (recipeCommand == null) {
            throw new Exception("Unknown command in recipe [" + commandName + "]");
        }
        Set<String> replacementVars = this.getReplacementVariables(line);
        if (replacementVars != null) {
            context.addReplacementVariables(replacementVars);
        }
        try {
            recipeCommand.parse(this, context, arguments);
        }
        catch (Exception e) {
            throw new Exception("Error in recipe, line [" + line + "]", e);
        }
    }

    protected HashMap<String, RecipeCommand> createRecipeCommands() {
        RecipeCommand[] knownCommands;
        HashMap<String, RecipeCommand> commands = new HashMap<String, RecipeCommand>();
        for (RecipeCommand recipeCommand : knownCommands = new RecipeCommand[]{new ScriptRecipeCommand(), new BundleRecipeCommand(), new ConfigDefRecipeCommand(), new CommandRecipeCommand(), new FileRecipeCommand(), new RealizeRecipeCommand(), new DeployRecipeCommand()}) {
            commands.put(recipeCommand.getName(), recipeCommand);
        }
        return commands;
    }

    protected Set<String> getReplacementVariables(String cmdLine) {
        HashSet<String> replacementVariables = null;
        Matcher matcher = this.replacementVariableDeclarationPattern.matcher(cmdLine);
        while (matcher.find()) {
            String replacementDeclaration = matcher.group();
            Matcher nameMatcher = this.replacementVariableNamePattern.matcher(replacementDeclaration);
            if (!nameMatcher.find()) {
                throw new IllegalArgumentException("Bad replacement declaration [" + replacementDeclaration + "]");
            }
            String replacementVariable = nameMatcher.group();
            if (replacementVariable.startsWith(this.systemReplacementVariablePrefix)) continue;
            if (replacementVariables == null) {
                replacementVariables = new HashSet<String>(1);
            }
            replacementVariables.add(replacementVariable);
        }
        return replacementVariables;
    }

    public String replaceReplacementVariables(RecipeContext context, String input) {
        Configuration replacementValues = context.getReplacementVariableValues();
        TemplateEngine templateEngine = null;
        StringBuffer buffer = new StringBuffer();
        Matcher matcher = this.replacementVariableDeclarationPattern.matcher(input);
        while (matcher.find()) {
            String next = matcher.group();
            Matcher nameMatcher = this.replacementVariableNamePattern.matcher(next);
            if (nameMatcher.find()) {
                String value;
                String key = nameMatcher.group();
                String string = value = replacementValues != null ? replacementValues.getSimpleValue(key, null) : null;
                if (value == null) {
                    if (templateEngine == null) {
                        templateEngine = SystemInfoFactory.fetchTemplateEngine();
                    }
                    value = templateEngine.replaceTokens(next);
                }
                if (value != null) {
                    next = value;
                }
            }
            matcher.appendReplacement(buffer, Matcher.quoteReplacement(next));
        }
        matcher.appendTail(buffer);
        return buffer.toString();
    }

    protected String[] splitCommandLine(String cmdLine) {
        ByteArrayInputStream in = new ByteArrayInputStream(cmdLine.getBytes());
        StreamTokenizer strtok = new StreamTokenizer(new InputStreamReader(in));
        ArrayList<String> args = new ArrayList<String>();
        boolean keep_going = true;
        strtok.ordinaryChars(48, 57);
        strtok.ordinaryChar(46);
        strtok.ordinaryChar(45);
        strtok.ordinaryChar(39);
        strtok.wordChars(33, 127);
        strtok.quoteChar(34);
        while (keep_going) {
            int nextToken;
            try {
                nextToken = strtok.nextToken();
            }
            catch (IOException e) {
                nextToken = -1;
            }
            if (nextToken == -3) {
                args.add(strtok.sval);
                continue;
            }
            if (nextToken == 34) {
                args.add(strtok.sval);
                continue;
            }
            if (nextToken != -1 && nextToken != 10) continue;
            keep_going = false;
        }
        return args.toArray(new String[args.size()]);
    }

    protected String[] extractArguments(String[] commandLine) {
        int newLength = commandLine.length - 1;
        String[] argsOnly = new String[newLength];
        System.arraycopy(commandLine, 1, argsOnly, 0, newLength);
        return argsOnly;
    }

    private void setupReplacementPatterns() {
        this.replacementVariableDeclarationPattern = Pattern.compile("@@\\s*(\\w+\\.?)+\\s*@@");
        this.replacementVariableNamePattern = Pattern.compile("(\\w+\\.?)+");
        this.systemReplacementVariablePrefix = "rhq.system.";
    }
}

