/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.bundle.filetemplate.recipe;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.rhq.bundle.filetemplate.recipe.RecipeParser;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.Property;
import org.rhq.core.domain.configuration.PropertySimple;
import org.rhq.core.util.updater.DeploymentProperties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RecipeContext {
    private RecipeParser parser;
    private final String recipe;
    private boolean unknownRecipe;
    private final DeploymentProperties deploymentProperties;
    private final Map<String, String> deployFiles;
    private final Map<String, String> files;
    private final Set<String> realizedFiles;
    private final Set<String> replacementVariables;
    private Configuration replacementVariableValues;
    private final List<Script> scripts;
    private final List<Command> commands;

    public RecipeContext(String recipe) {
        if (recipe == null) {
            throw new IllegalArgumentException("recipe == null");
        }
        this.recipe = recipe;
        this.deployFiles = new HashMap<String, String>();
        this.files = new HashMap<String, String>();
        this.realizedFiles = new HashSet<String>();
        this.replacementVariables = new HashSet<String>();
        this.scripts = new ArrayList<Script>();
        this.commands = new ArrayList<Command>();
        this.deploymentProperties = new DeploymentProperties();
        this.unknownRecipe = true;
    }

    public RecipeParser getParser() {
        return this.parser;
    }

    public void setParser(RecipeParser parser) {
        this.parser = parser;
    }

    public boolean isUnknownRecipe() {
        return this.unknownRecipe;
    }

    public void setUnknownRecipe(boolean unknownRecipe) {
        this.unknownRecipe = unknownRecipe;
    }

    public String getRecipe() {
        return this.recipe;
    }

    public DeploymentProperties getDeploymentProperties() {
        return this.deploymentProperties;
    }

    public Map<String, String> getDeployFiles() {
        return this.deployFiles;
    }

    public void addDeployFile(String filename, String directory) {
        this.deployFiles.put(filename, directory);
    }

    public Map<String, String> getFiles() {
        return this.files;
    }

    public void addFile(String source, String destination) {
        this.files.put(source, destination);
    }

    public Set<String> getRealizedFiles() {
        return this.realizedFiles;
    }

    public void addRealizedFile(String file) {
        this.realizedFiles.add(file);
    }

    public Set<String> getReplacementVariables() {
        return this.replacementVariables;
    }

    public void addReplacementVariables(Set<String> replacementVariables) {
        this.replacementVariables.addAll(replacementVariables);
    }

    public Configuration getReplacementVariableValues() {
        return this.replacementVariableValues;
    }

    public void setReplacementVariableValues(Configuration configuration) {
        this.replacementVariableValues = configuration;
    }

    public void addReplacementVariableValue(String name, String value) {
        Configuration values = this.getReplacementVariableValues();
        if (values == null) {
            values = new Configuration();
            this.setReplacementVariableValues(values);
        }
        values.put((Property)new PropertySimple(name, (Object)value));
    }

    public Set<String> getScriptFiles() {
        HashSet<String> scriptFiles = new HashSet<String>();
        for (Script script : this.scripts) {
            scriptFiles.add(script.getExecutable());
        }
        return scriptFiles;
    }

    public void addScript(String exe, List<String> exeArgs) {
        this.scripts.add(new Script(exe, exeArgs));
    }

    public void addCommand(String exe, List<String> exeArgs) {
        this.commands.add(new Command(exe, exeArgs));
    }

    public String toString() {
        StringBuilder str = new StringBuilder("RecipeContext:\n");
        str.append("Deployment Properties: ").append(this.getDeploymentProperties()).append("\n");
        str.append("Deploy Files: ").append(this.getDeployFiles()).append("\n");
        str.append("Replacement Vars: ").append(this.getReplacementVariables()).append("\n");
        str.append("Replacement Values: ");
        Configuration values = this.getReplacementVariableValues();
        if (values == null) {
            str.append("<none>");
        } else {
            str.append(values.getProperties());
        }
        str.append("\n");
        str.append("Script Files: ").append(this.getScriptFiles()).append("\n");
        for (Script script : this.scripts) {
            str.append("* ").append(script.getExecutable()).append(" ").append(script.getArguments()).append("\n");
        }
        str.append("Commands: ").append("\n");
        for (Command cmd : this.commands) {
            str.append("* ").append(cmd.getExecutable()).append(" ").append(cmd.getArguments()).append("\n");
        }
        str.append("Recipe Text:\n-----------\n").append(this.getRecipe()).append("\n");
        return str.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class Command {
        private final String exe;
        private final List<String> args;

        public Command(String exe, List<String> args) {
            this.exe = exe;
            this.args = args;
        }

        public String getExecutable() {
            return this.exe;
        }

        public List<String> getArguments() {
            return this.args;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class Script {
        private final String exe;
        private final List<String> args;

        public Script(String exe, List<String> args) {
            this.exe = exe;
            this.args = args;
        }

        public String getExecutable() {
            return this.exe;
        }

        public List<String> getArguments() {
            return this.args;
        }
    }
}

