/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.filetemplate;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.OutputStreamWriter;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.bundle.filetemplate.recipe.RecipeContext;
import org.rhq.bundle.filetemplate.recipe.RecipeParser;
import org.rhq.core.domain.content.PackageVersion;
import org.rhq.core.system.OperatingSystemType;
import org.rhq.core.system.ProcessExecution;
import org.rhq.core.system.ProcessExecutionResults;
import org.rhq.core.system.SystemInfo;
import org.rhq.core.util.file.FileUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProcessingRecipeContext
extends RecipeContext {
    private final Log log = LogFactory.getLog(((Object)((Object)this)).getClass());
    private final SystemInfo systemInfo;
    private String baseWorkingDirectory;

    public ProcessingRecipeContext(String recipe, Map<PackageVersion, File> packageVersionFiles, SystemInfo systemInfo, String baseWorkingDirectory) {
        super(recipe);
        this.systemInfo = systemInfo;
        this.baseWorkingDirectory = baseWorkingDirectory;
    }

    public void addDeployFile(String filename, String directory) {
        super.addDeployFile(filename, directory);
        File existingFile = new File(this.baseWorkingDirectory, filename);
        ProcessExecution pe = this.getUnzipExecution(existingFile, directory);
        if (pe != null) {
            ProcessExecutionResults results = this.systemInfo.executeProcess(pe);
            if (results.getError() != null) {
                throw new RuntimeException("Could not unbundle file [" + pe + "]: " + results, results.getError());
            }
            if (results.getExitCode() == null || results.getExitCode() > 0) {
                throw new RuntimeException("Failed to unbundle file [" + pe + "]: " + results);
            }
            this.log.debug((Object)("bundle deploy: unzipped [" + existingFile + "] to [" + directory + "]"));
        } else {
            File newFile = new File(directory, filename);
            if (!existingFile.renameTo(newFile)) {
                throw new RuntimeException("Failed to move [" + existingFile + "] to [" + newFile + "]");
            }
            this.log.debug((Object)("bundle deploy: renamed [" + existingFile + "] to [" + newFile + "]"));
        }
    }

    public void addFile(String source, String destination) {
        super.addFile(source, destination);
        File sourceFile = new File(this.baseWorkingDirectory, source);
        File destinationFile = new File(destination);
        try {
            destinationFile.getParentFile().mkdirs();
            FileUtil.copyFile((File)sourceFile, (File)destinationFile);
            this.log.debug((Object)("bundle file: copied [" + sourceFile + "] to [" + destinationFile + "]"));
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to copy file [" + sourceFile + "] to [" + destinationFile + "]", e);
        }
    }

    public void addRealizedFile(String file) {
        super.addRealizedFile(file);
        File trueFile = new File(file);
        RecipeParser parser = this.getParser();
        File realizedTmpFile = null;
        OutputStreamWriter realizedTmpFileWriter = null;
        BufferedReader reader = null;
        try {
            realizedTmpFile = File.createTempFile("rhq-realize-", ".tmp", trueFile.getParentFile());
            realizedTmpFileWriter = new FileWriter(realizedTmpFile);
            reader = new BufferedReader(new FileReader(trueFile));
            String line = reader.readLine();
            while (line != null) {
                line = parser.replaceReplacementVariables((RecipeContext)this, line);
                realizedTmpFileWriter.write(line);
                realizedTmpFileWriter.write("\n");
                line = reader.readLine();
            }
            realizedTmpFileWriter.close();
            realizedTmpFileWriter = null;
            reader.close();
            reader = null;
            trueFile.delete();
            if (!realizedTmpFile.renameTo(trueFile)) {
                throw new RuntimeException("Failed to rename realized tmp file [" + realizedTmpFile + "]");
            }
            this.log.debug((Object)("bundle realize file: renamed realized [" + realizedTmpFile + "] to [" + trueFile + "]"));
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot realize file [" + file + "]", e);
        }
        finally {
            if (realizedTmpFileWriter != null) {
                try {
                    realizedTmpFileWriter.close();
                }
                catch (Exception e) {}
            }
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (Exception e) {}
            }
            if (realizedTmpFile != null && realizedTmpFile.exists()) {
                realizedTmpFile.delete();
            }
        }
    }

    public void addReplacementVariables(Set<String> replacementVariables) {
        super.addReplacementVariables(replacementVariables);
    }

    public void addScript(String exe, List<String> exeArgs) {
        super.addScript(exe, exeArgs);
        File scriptFile = new File(this.baseWorkingDirectory, exe);
        this.ensureExecutable(scriptFile);
        ProcessExecution pe = new ProcessExecution(scriptFile.getAbsolutePath());
        pe.setArguments(exeArgs);
        pe.setWaitForCompletion(1800000L);
        pe.setWorkingDirectory(scriptFile.getParent());
        ProcessExecutionResults results = this.systemInfo.executeProcess(pe);
        if (results.getError() != null) {
            throw new RuntimeException("Could not execute script [" + pe + "]: " + results, results.getError());
        }
        this.log.debug((Object)("bundle script: executed script [" + pe + "]"));
    }

    public void addCommand(String exe, List<String> exeArgs) {
        super.addCommand(exe, exeArgs);
        ProcessExecution pe = new ProcessExecution(exe);
        pe.setArguments(exeArgs);
        pe.setWaitForCompletion(1800000L);
        pe.setCheckExecutableExists(false);
        pe.setWorkingDirectory(this.baseWorkingDirectory);
        ProcessExecutionResults results = this.systemInfo.executeProcess(pe);
        if (results.getError() != null) {
            throw new RuntimeException("Could not execute command [" + pe + "]: " + results, results.getError());
        }
        this.log.debug((Object)("bundle command: executed command [" + pe + "]"));
    }

    private void ensureExecutable(File scriptFile) {
        boolean success;
        try {
            Method m = File.class.getMethod("setExecutable", Boolean.TYPE, Boolean.TYPE);
            Boolean r = (Boolean)m.invoke((Object)scriptFile, Boolean.TRUE, Boolean.TRUE);
            success = r;
        }
        catch (Exception e) {
            if (this.systemInfo.getOperatingSystemType() != OperatingSystemType.WINDOWS) {
                ProcessExecution pe = new ProcessExecution("chmod");
                pe.setArguments(new String[]{"u+x", scriptFile.getAbsolutePath()});
                pe.setWaitForCompletion(30000L);
                pe.setCheckExecutableExists(false);
                pe.setWorkingDirectory(scriptFile.getParent());
                ProcessExecutionResults chmodResults = this.systemInfo.executeProcess(pe);
                success = chmodResults.getExitCode() != null && chmodResults.getExitCode() == 0;
            }
            success = true;
        }
        if (!success) {
            throw new RuntimeException("Cannot ensure that script [" + scriptFile + "] is executable");
        }
    }

    private ProcessExecution getUnzipExecution(File file, String directory) {
        String exe;
        ArrayList<String> args = null;
        String filepath = file.getAbsolutePath();
        if (filepath.endsWith(".tar")) {
            exe = "tar";
            args = new ArrayList<String>();
            args.add("xf");
            args.add(filepath);
            args.add("-C");
            args.add(directory);
        } else if (filepath.endsWith(".tar.bz2") || filepath.endsWith(".tbz2") || filepath.endsWith(".tbz")) {
            exe = "tar";
            args = new ArrayList();
            args.add("xfj");
            args.add(filepath);
            args.add("-C");
            args.add(directory);
        } else if (filepath.endsWith(".tar.gz") || filepath.endsWith(".tgz")) {
            exe = "tar";
            args = new ArrayList();
            args.add("xfz");
            args.add(filepath);
            args.add("-C");
            args.add(directory);
        } else if (filepath.endsWith(".zip")) {
            exe = "unzip";
            args = new ArrayList();
            args.add("-o");
            args.add(filepath);
            args.add("-d");
            args.add(directory);
        } else if (filepath.endsWith(".rpm")) {
            exe = "rpm";
            args = new ArrayList();
            args.add("-i");
            args.add(filepath);
            if (directory != null && directory.length() > 0) {
                args.add("--prefix");
                args.add(directory);
            }
        } else {
            return null;
        }
        ProcessExecution pe = new ProcessExecution(exe);
        pe.setArguments(args);
        pe.setWaitForCompletion(1800000L);
        pe.setCheckExecutableExists(false);
        pe.setWorkingDirectory(this.baseWorkingDirectory);
        return pe;
    }
}

