/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.iis;

import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hyperic.sigar.win32.Pdh;
import org.rhq.core.domain.measurement.AvailabilityType;
import org.rhq.core.domain.measurement.DataType;
import org.rhq.core.domain.measurement.MeasurementDataNumeric;
import org.rhq.core.domain.measurement.MeasurementReport;
import org.rhq.core.domain.measurement.MeasurementScheduleRequest;
import org.rhq.core.domain.measurement.calltime.CallTimeData;
import org.rhq.core.pluginapi.inventory.InvalidPluginConfigurationException;
import org.rhq.core.pluginapi.inventory.ResourceComponent;
import org.rhq.core.pluginapi.inventory.ResourceContext;
import org.rhq.core.pluginapi.measurement.MeasurementFacet;
import org.rhq.core.pluginapi.util.ResponseTimeConfiguration;
import org.rhq.plugins.iis.IISResponseTimeDelegate;
import org.rhq.plugins.iis.IISServerComponent;

public class IISVHostComponent
implements ResourceComponent<IISServerComponent<?>>,
MeasurementFacet {
    private ResourceContext<IISServerComponent<?>> resourceContext;
    private IISResponseTimeDelegate responseTimeDelegate;
    private Log log = LogFactory.getLog(IISVHostComponent.class);

    public void start(ResourceContext<IISServerComponent<?>> resourceContext) throws InvalidPluginConfigurationException, Exception {
        this.resourceContext = resourceContext;
        String logDirectory = this.getLogDirectory();
        String logFormat = this.getResponseTimeLogFormat();
        ResponseTimeConfiguration responseTimeConfiguration = this.getResponseTimeConfiguration();
        if (logFormat == null) {
            throw new InvalidPluginConfigurationException("The 'responseTimeLogFormat' property must be specified.");
        }
        this.responseTimeDelegate = new IISResponseTimeDelegate(logDirectory, logFormat, responseTimeConfiguration);
    }

    public void stop() {
    }

    public AvailabilityType getAvailability() {
        return AvailabilityType.UP;
    }

    public String getResponseTimeLogFormat() {
        return this.resourceContext.getPluginConfiguration().getSimpleValue("responseTimeLogFormat", null);
    }

    public String getLogDirectory() {
        return this.resourceContext.getPluginConfiguration().getSimpleValue("logDirectory", null);
    }

    public String getSiteName() {
        return this.resourceContext.getPluginConfiguration().getSimpleValue("siteName", null);
    }

    public ResponseTimeConfiguration getResponseTimeConfiguration() {
        return new ResponseTimeConfiguration(this.resourceContext.getPluginConfiguration());
    }

    public void getValues(MeasurementReport report, Set<MeasurementScheduleRequest> metrics) throws Exception {
        String propertyBase = "\\Web Service(" + this.getSiteName() + ")\\";
        Pdh pdh = new Pdh();
        for (MeasurementScheduleRequest request : metrics) {
            if (request.getDataType() == DataType.CALLTIME) {
                this.log.debug((Object)("Calltime MeasurementScheduleRequest: " + request));
                CallTimeData callTimeData = new CallTimeData(request);
                this.responseTimeDelegate.parseLogs(callTimeData);
                report.addData(callTimeData);
                continue;
            }
            double value = pdh.getRawValue(propertyBase + request.getName());
            report.addData(new MeasurementDataNumeric(request, Double.valueOf(value)));
        }
    }
}

