/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.installer;

import gnu.getopt.Getopt;
import gnu.getopt.LongOpt;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.util.exception.ThrowableUtil;
import org.rhq.enterprise.server.installer.InstallerConfiguration;
import org.rhq.enterprise.server.installer.InstallerService;
import org.rhq.enterprise.server.installer.InstallerServiceImpl;

public class Installer {
    private static final Log LOG = LogFactory.getLog(Installer.class);
    private static final int EXIT_CODE_ALREADY_INSTALLED = 0;
    private static final int EXIT_CODE_INSTALLATION_DONE = 0;
    private static final int EXIT_CODE_AUTOINSTALL_DISABLED = 1;
    private static final int EXIT_CODE_INSTALLATION_ERROR = 2;
    private InstallerConfiguration installerConfig = new InstallerConfiguration();

    public static void main(String[] args) {
        try {
            LOG.info((Object)"Starting installer...");
            Installer installer = new Installer();
            installer.doInstall(args);
        }
        catch (Exception e) {
            LOG.error((Object)"An error occurred", (Throwable)e);
            System.exit(2);
        }
        System.exit(0);
    }

    public InstallerConfiguration getInstallerConfiguration() {
        return this.installerConfig;
    }

    public void doInstall(String[] args) throws Exception {
        WhatToDo[] thingsToDo;
        block19: for (WhatToDo whatToDo : thingsToDo = this.processArguments(args)) {
            switch (whatToDo) {
                case DISPLAY_USAGE: {
                    this.displayUsage();
                    continue block19;
                }
                case LIST_SERVERS: {
                    new InstallerServiceImpl(this.installerConfig).listServers();
                    continue block19;
                }
                case TEST: {
                    try {
                        new InstallerServiceImpl(this.installerConfig).test();
                    }
                    catch (InstallerService.AutoInstallDisabledException e) {
                        LOG.error((Object)e.getMessage());
                        System.exit(1);
                    }
                    catch (InstallerService.AlreadyInstalledException e) {
                        LOG.info((Object)e.getMessage());
                        System.exit(0);
                    }
                    continue block19;
                }
                case SETUPDB: {
                    HashMap<String, String> serverProperties;
                    InstallerServiceImpl installerService;
                    try {
                        installerService = new InstallerServiceImpl(this.installerConfig);
                        serverProperties = installerService.getServerProperties();
                        installerService.prepareDatabase(serverProperties, null, null);
                        LOG.info((Object)"Database setup is complete.");
                    }
                    catch (Exception e) {
                        LOG.error((Object)ThrowableUtil.getAllMessages((Throwable)e));
                        System.exit(2);
                    }
                    continue block19;
                }
                case RECONFIGURE: {
                    HashMap<String, String> serverProperties;
                    InstallerServiceImpl installerService;
                    try {
                        installerService = new InstallerServiceImpl(this.installerConfig);
                        serverProperties = installerService.getServerProperties();
                        boolean reconfigured = installerService.reconfigure(serverProperties);
                        if (!reconfigured) continue block19;
                        LOG.info((Object)"Reconfiguration is complete.");
                    }
                    catch (Exception e) {
                        LOG.error((Object)ThrowableUtil.getAllMessages((Throwable)e));
                        System.exit(2);
                    }
                    continue block19;
                }
                case INSTALL: {
                    HashMap<String, String> serverProperties;
                    InstallerServiceImpl installerService;
                    try {
                        installerService = new InstallerServiceImpl(this.installerConfig);
                        serverProperties = installerService.preInstall();
                        installerService.install(serverProperties, null, null);
                        LOG.info((Object)"Installation is complete. The server should be ready shortly.");
                    }
                    catch (InstallerService.AutoInstallDisabledException e) {
                        LOG.error((Object)e.getMessage());
                        System.exit(1);
                    }
                    catch (InstallerService.AlreadyInstalledException e) {
                        LOG.info((Object)e.getMessage());
                        System.exit(0);
                    }
                    continue block19;
                }
                case DO_NOTHING: {
                    continue block19;
                }
                default: {
                    throw new IllegalStateException("Please report this bug: " + (Object)((Object)whatToDo));
                }
            }
        }
    }

    private void displayUsage() {
        StringBuilder usage = new StringBuilder("RHQ Installer\n");
        usage.append("\t--help, -H: this help text").append("\n");
        usage.append("\t-Dname=value: set system properties for the Installer VM").append("\n");
        usage.append("\t--host=<hostname>, -h: hostname where the app server is running").append("\n");
        usage.append("\t--port=<port>, -p: talk to the app server over this management port").append("\n");
        usage.append("\t--test, -t: test the validity of the server properties (install not performed)").append("\n");
        usage.append("\t--force, -f: force the installer to try to install everything").append("\n");
        usage.append("\t--listservers, -l: show list of known installed servers (install not performed)").append("\n");
        usage.append("\t--setupdb, -b: only perform database schema creation or update").append("\n");
        usage.append("\t--reconfig, -r: resets some configuration settings in an installed server").append("\n");
        usage.append("\t--dbpassword, -d: encodes a DB password for rhq-server.properties (install not performed)").append("\n");
        LOG.info((Object)usage);
    }

    private WhatToDo[] processArguments(String[] args) throws Exception {
        int code;
        String sopts = "-:HD:h:p:d:bflrt";
        LongOpt[] lopts = new LongOpt[]{new LongOpt("help", 0, null, 72), new LongOpt("host", 1, null, 104), new LongOpt("port", 1, null, 112), new LongOpt("dbpassword", 1, null, 100), new LongOpt("setupdb", 0, null, 98), new LongOpt("listservers", 0, null, 108), new LongOpt("reconfig", 0, null, 114), new LongOpt("force", 0, null, 102), new LongOpt("test", 0, null, 116)};
        boolean test = false;
        boolean listservers = false;
        boolean setupdb = false;
        boolean reconfig = false;
        String dbpassword = null;
        Getopt getopt = new Getopt("installer", args, sopts, lopts);
        while ((code = getopt.getopt()) != -1) {
            switch (code) {
                case 58: 
                case 63: {
                    this.displayUsage();
                    throw new IllegalArgumentException();
                }
                case 1: {
                    throw new IllegalArgumentException("Unknown option: " + getopt.getOptarg());
                }
                case 72: {
                    return new WhatToDo[]{WhatToDo.DISPLAY_USAGE};
                }
                case 68: {
                    String value;
                    String name;
                    String sysprop = getopt.getOptarg();
                    int i = sysprop.indexOf("=");
                    if (i == -1) {
                        name = sysprop;
                        value = "true";
                    } else {
                        name = sysprop.substring(0, i);
                        value = sysprop.substring(i + 1, sysprop.length());
                    }
                    System.setProperty(name, value);
                    LOG.info((Object)("System property set: " + name + "=" + value));
                    break;
                }
                case 104: {
                    String hostString = getopt.getOptarg();
                    if (hostString == null) {
                        throw new IllegalArgumentException("Missing host value");
                    }
                    this.installerConfig.setManagementHost(hostString);
                    break;
                }
                case 112: {
                    String portString = getopt.getOptarg();
                    if (portString == null) {
                        throw new IllegalArgumentException("Missing port value");
                    }
                    this.installerConfig.setManagementPort(Integer.parseInt(portString));
                    break;
                }
                case 100: {
                    dbpassword = getopt.getOptarg();
                    if (dbpassword != null) break;
                    throw new IllegalArgumentException("Missing password");
                }
                case 98: {
                    setupdb = true;
                    break;
                }
                case 102: {
                    this.installerConfig.setForceInstall(true);
                    break;
                }
                case 108: {
                    listservers = true;
                    break;
                }
                case 114: {
                    reconfig = true;
                    break;
                }
                case 116: {
                    test = true;
                }
            }
        }
        if (dbpassword != null) {
            String pw = new InstallerServiceImpl(this.installerConfig).obfuscatePassword(dbpassword);
            LOG.info((Object)("*** Encoded Password: " + pw));
            return new WhatToDo[]{WhatToDo.DO_NOTHING};
        }
        if (reconfig) {
            return new WhatToDo[]{WhatToDo.RECONFIGURE};
        }
        if (test || setupdb || listservers) {
            ArrayList<WhatToDo> whatToDo = new ArrayList<WhatToDo>();
            if (test) {
                whatToDo.add(WhatToDo.TEST);
            }
            if (setupdb) {
                whatToDo.add(WhatToDo.SETUPDB);
            }
            if (listservers) {
                whatToDo.add(WhatToDo.LIST_SERVERS);
            }
            return whatToDo.toArray(new WhatToDo[whatToDo.size()]);
        }
        return new WhatToDo[]{WhatToDo.INSTALL};
    }

    private static enum WhatToDo {
        DISPLAY_USAGE,
        DO_NOTHING,
        RECONFIGURE,
        TEST,
        SETUPDB,
        LIST_SERVERS,
        INSTALL;

    }
}

