/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.installer;

import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.as.controller.client.ModelControllerClient;
import org.rhq.common.jbossas.client.controller.CoreJBossASClient;
import org.rhq.common.jbossas.client.controller.DeploymentJBossASClient;
import org.rhq.common.jbossas.client.controller.WebJBossASClient;
import org.rhq.core.db.DatabaseTypeFactory;
import org.rhq.core.util.PropertiesFileUpdate;
import org.rhq.core.util.exception.ThrowableUtil;
import org.rhq.enterprise.server.installer.InstallerConfiguration;
import org.rhq.enterprise.server.installer.InstallerService;
import org.rhq.enterprise.server.installer.ServerDetails;
import org.rhq.enterprise.server.installer.ServerInstallUtil;
import org.rhq.enterprise.server.installer.ServerProperties;

public class InstallerServiceImpl
implements InstallerService {
    private static final String RHQ_EXTENSION_NAME = "org.rhq.rhq-enterprise-server-startup-subsystem";
    private static final String RHQ_SUBSYSTEM_NAME = "rhq-startup";
    private static final String EAR_NAME = "rhq.ear";
    private static final String SYSPROP_PROPFILE = "rhq.server.properties-file";
    private final Log log = LogFactory.getLog(InstallerServiceImpl.class);
    private final InstallerConfiguration installerConfiguration;

    private void log(String s) {
        this.log.info((Object)s);
    }

    private void log(String s, Throwable t) {
        this.log.warn((Object)s, t);
    }

    public InstallerServiceImpl(InstallerConfiguration config) {
        this.installerConfiguration = config;
    }

    @Override
    public String obfuscatePassword(String clearTextPassword) throws Exception {
        String obfuscatedPassword = ServerInstallUtil.obfuscatePassword(clearTextPassword);
        return obfuscatedPassword;
    }

    @Override
    public void listServers() throws Exception {
        String obfuscatedDbPassword;
        String clearTextDbPassword;
        String dbUsername;
        HashMap<String, String> serverProperties = this.getServerProperties();
        String dbUrl = serverProperties.get("rhq.server.database.connection-url");
        ArrayList<ServerDetails> allServerDetails = this.getAllServerDetails(dbUrl, dbUsername = serverProperties.get("rhq.server.database.user-name"), clearTextDbPassword = ServerInstallUtil.deobfuscatePassword(obfuscatedDbPassword = serverProperties.get("rhq.server.database.password")));
        if (allServerDetails == null) {
            this.log.warn((Object)"Cannot get details on all servers");
            return;
        }
        if (allServerDetails.size() == 0) {
            this.log("There are no known servers currently registered");
            return;
        }
        StringBuilder info = new StringBuilder("Details on currently registered servers");
        info.append("\n");
        info.append("Server Name");
        info.append("\t");
        info.append("Public Endpoint Address");
        info.append("\t");
        info.append("Secure Port");
        info.append("\n");
        for (ServerDetails serverDetails : allServerDetails) {
            info.append(serverDetails.getName());
            info.append("\t");
            info.append(serverDetails.getEndpointAddress());
            info.append("\t");
            info.append(serverDetails.getEndpointPortString());
            info.append("\t");
            info.append(serverDetails.getEndpointSecurePortString());
            info.append("\n");
        }
        this.log(info.toString());
    }

    @Override
    public void test() throws InstallerService.AutoInstallDisabledException, InstallerService.AlreadyInstalledException, Exception {
        HashMap<String, String> serverProperties = this.preInstall();
        this.verifyDataFormats(serverProperties);
        String dbUrl = serverProperties.get("rhq.server.database.connection-url");
        String dbUsername = serverProperties.get("rhq.server.database.user-name");
        String obfuscatedDbPassword = serverProperties.get("rhq.server.database.password");
        String clearTextDbPassword = ServerInstallUtil.deobfuscatePassword(obfuscatedDbPassword);
        String dbErrorStr = this.testConnection(dbUrl, dbUsername, clearTextDbPassword);
        if (dbErrorStr != null) {
            throw new Exception(dbErrorStr);
        }
        ServerDetails detailsFromProps = this.getServerDetailsFromPropertiesOnly(serverProperties);
        ServerDetails detailsFromDb = this.getServerDetails(dbUrl, dbUsername, clearTextDbPassword, detailsFromProps.getName());
        ServerInstallUtil.ExistingSchemaOption existingSchemaOption = this.getAutoinstallExistingSchemaOption(serverProperties);
        if (detailsFromDb == null) {
            this.log("This will be considered a new server: " + detailsFromProps);
        } else if (existingSchemaOption == ServerInstallUtil.ExistingSchemaOption.OVERWRITE) {
            this.log("This [" + detailsFromProps + "] will OVERWRITE the existing server [" + detailsFromDb + "] that already exists in the database.");
        } else {
            this.log("This [" + detailsFromProps + "] will be considered a reinstallation of an existing server [" + detailsFromDb + "]");
        }
        if (existingSchemaOption == ServerInstallUtil.ExistingSchemaOption.OVERWRITE) {
            this.log.warn((Object)"The installer has been configured to OVERWRITE any existing data in the database. If you do install with this configuration, realize that all existing data in the database will be lost.");
        }
        String appServerHomeDir = this.getAppServerHomeDir();
        this.log("The app server where the installation will go is found at: " + appServerHomeDir);
        this.log("It looks like everything is OK and you can start the installation.");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public HashMap<String, String> preInstall() throws InstallerService.AutoInstallDisabledException, InstallerService.AlreadyInstalledException, Exception {
        boolean autoInstallMode;
        HashMap<String, String> serverProperties;
        try {
            serverProperties = this.getServerProperties();
            autoInstallMode = ServerInstallUtil.isAutoinstallEnabled(serverProperties);
        }
        catch (Throwable t) {
            throw new Exception("Cannot determine if in auto-install mode", t);
        }
        if (autoInstallMode) {
            this.log("The server is preconfigured and ready for auto-install.");
        } else {
            if (!this.installerConfiguration.isForceInstall()) throw new InstallerService.AutoInstallDisabledException("Auto-installation is disabled. Please fully configure rhq-server.properties");
            this.log("Auto-installation would have been disabled, but installer was asked to force the install... continuing.");
        }
        String asVersion = this.testModelControllerClient(serverProperties);
        this.log("Installing into app server version [" + asVersion + "]");
        String installationResults = this.getInstallationResults();
        if (installationResults == null) return serverProperties;
        if (installationResults.length() == 0) {
            if (!this.installerConfiguration.isForceInstall()) throw new InstallerService.AlreadyInstalledException("The installer has already been told to perform its work. The server should be ready soon.");
            this.log("The installer appears to have already been told to perform its work, but the installer was asked for force the install... continuing.");
            return serverProperties;
        } else {
            if (!this.installerConfiguration.isForceInstall()) throw new Exception("The installer has already attempted to install the server but errors occurred:\n" + installationResults);
            this.log("The installer is going to force another installation attempt, even though a previous attempt encountered errors:\n" + installationResults);
        }
        return serverProperties;
    }

    @Override
    public String getInstallationResults() throws Exception {
        if (this.isEarDeployed()) {
            return "";
        }
        if (this.isExtensionDeployed()) {
            return "";
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void install(HashMap<String, String> serverProperties, ServerDetails serverDetails, String existingSchemaOption) throws InstallerService.AutoInstallDisabledException, InstallerService.AlreadyInstalledException, Exception {
        if (this.isEarDeployed()) {
            if (this.installerConfiguration.isForceInstall()) {
                this.log("It looks like the installation has already been completed, but the installer was asked for force the install... continuing.");
            } else {
                throw new InstallerService.AlreadyInstalledException("It looks like the installation has already been completed - there is nothing for the installer to do.");
            }
        }
        this.prepareDatabase(serverProperties, serverDetails, existingSchemaOption);
        String appServerConfigDir = this.getAppServerConfigDir();
        ServerInstallUtil.createDefaultManagementUser(serverDetails, appServerConfigDir);
        ModelControllerClient mcc = null;
        try {
            mcc = this.getModelControllerClient();
            ServerInstallUtil.setSocketBindings(mcc, serverProperties);
            ServerInstallUtil.configureDeploymentScanner(mcc);
            ServerInstallUtil.configureTransactionManager(mcc);
            ServerInstallUtil.configureLogging(mcc, serverProperties);
            File keystoreFile = ServerInstallUtil.createKeystore(serverDetails, appServerConfigDir);
            ServerInstallUtil.setupWebConnectors(mcc, appServerConfigDir, serverProperties);
        }
        finally {
            InstallerServiceImpl.safeClose(mcc);
        }
        this.deployServices(serverProperties);
        this.deployAppExtension();
        this.reloadConfiguration();
        this.testModelControllerClient(60);
        this.deployAppSubsystem();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void prepareDatabase(HashMap<String, String> serverProperties, ServerDetails serverDetails, String existingSchemaOption) throws Exception {
        ServerInstallUtil.ExistingSchemaOption existingSchemaOptionEnum;
        String clearTextDbPassword;
        String obfuscatedDbPassword;
        this.verifyDataFormats(serverProperties);
        boolean autoInstallMode = ServerInstallUtil.isAutoinstallEnabled(serverProperties);
        if (autoInstallMode) {
            serverDetails = this.getServerDetailsFromPropertiesOnly(serverProperties);
        } else {
            if (serverDetails == null) {
                throw new Exception("Auto-installation is disabled and cannot determine server details");
            }
            if (ServerInstallUtil.isEmpty(serverDetails.getName())) {
                throw new Exception("Please enter a server name");
            }
            if (ServerInstallUtil.isEmpty(serverDetails.getEndpointAddress())) {
                try {
                    serverDetails.setEndpointAddress(InetAddress.getLocalHost().getCanonicalHostName());
                }
                catch (Exception e) {
                    throw new Exception("Could not assign a server public address automatically - please specify one.");
                }
            }
        }
        DatabaseTypeFactory.clearDatabaseTypeCache();
        String databaseType = serverProperties.get("rhq.server.database.type-mapping");
        if (ServerInstallUtil.isEmpty(databaseType)) {
            throw new Exception("Please indicate the type of database to connect to");
        }
        ServerInstallUtil.SupportedDatabaseType supportedDbType = ServerInstallUtil.getSupportedDatabaseType(databaseType);
        if (supportedDbType == null) {
            throw new Exception("Invalid database type: " + databaseType);
        }
        try {
            String url = serverProperties.get("rhq.server.database.connection-url");
            Pattern pattern = null;
            if (supportedDbType == ServerInstallUtil.SupportedDatabaseType.POSTGRES) {
                pattern = Pattern.compile(".*://(.*):([0123456789]+)/(.*)");
            } else if (supportedDbType == ServerInstallUtil.SupportedDatabaseType.ORACLE) {
                // empty if block
            }
            if (pattern != null) {
                Matcher match = pattern.matcher(url);
                if (!match.find() || match.groupCount() != 3) throw new Exception("Cannot get server, port or db name from connection URL: " + url);
                String serverName = match.group(1);
                String port = match.group(2);
                String dbName = match.group(3);
                serverProperties.put("rhq.server.database.server-name", serverName);
                serverProperties.put("rhq.server.database.port", port);
                serverProperties.put("rhq.server.database.db-name", dbName);
            } else {
                serverProperties.put("rhq.server.database.server-name", "");
                serverProperties.put("rhq.server.database.port", "");
                serverProperties.put("rhq.server.database.db-name", "");
            }
        }
        catch (Exception e) {
            throw new Exception("JDBC connection URL seems to be invalid", e);
        }
        try {
            String dialect = null;
            String quartzDriverDelegateClass = "org.quartz.impl.jdbcjobstore.StdJDBCDelegate";
            String quartzSelectWithLockSQL = "SELECT * FROM {0}LOCKS ROWLOCK WHERE LOCK_NAME = ? FOR UPDATE";
            String quartzLockHandlerClass = "org.quartz.impl.jdbcjobstore.StdRowLockSemaphore";
            if (supportedDbType == ServerInstallUtil.SupportedDatabaseType.POSTGRES) {
                dialect = "org.hibernate.dialect.PostgreSQLDialect";
                quartzDriverDelegateClass = "org.quartz.impl.jdbcjobstore.PostgreSQLDelegate";
            } else if (supportedDbType == ServerInstallUtil.SupportedDatabaseType.ORACLE) {
                dialect = "org.hibernate.dialect.Oracle10gDialect";
                quartzDriverDelegateClass = "org.quartz.impl.jdbcjobstore.oracle.OracleDelegate";
            }
            serverProperties.put("hibernate.dialect", dialect);
            serverProperties.put("rhq.server.quartz.driverDelegateClass", quartzDriverDelegateClass);
            serverProperties.put("rhq.server.quartz.selectWithLockSQL", quartzSelectWithLockSQL);
            serverProperties.put("rhq.server.quartz.lockHandlerClass", quartzLockHandlerClass);
        }
        catch (Exception e) {
            throw new Exception("Cannot configure internal database settings", e);
        }
        String dbUrl = serverProperties.get("rhq.server.database.connection-url");
        String dbUsername = serverProperties.get("rhq.server.database.user-name");
        if (autoInstallMode) {
            obfuscatedDbPassword = serverProperties.get("rhq.server.database.password");
            clearTextDbPassword = ServerInstallUtil.deobfuscatePassword(obfuscatedDbPassword);
        } else {
            clearTextDbPassword = serverProperties.get("rhq.server.database.password");
            obfuscatedDbPassword = ServerInstallUtil.obfuscatePassword(clearTextDbPassword);
            serverProperties.put("rhq.server.database.password", obfuscatedDbPassword);
        }
        String testConnectionErrorMessage = this.testConnection(dbUrl, dbUsername, clearTextDbPassword);
        if (testConnectionErrorMessage != null) {
            throw new Exception("Cannot connect to the database: " + testConnectionErrorMessage);
        }
        this.saveServerProperties(serverProperties);
        if (autoInstallMode) {
            existingSchemaOptionEnum = this.getAutoinstallExistingSchemaOption(serverProperties);
        } else {
            if (existingSchemaOption == null) {
                throw new Exception("Don't know what to do with the database schema");
            }
            existingSchemaOptionEnum = ServerInstallUtil.ExistingSchemaOption.valueOf(existingSchemaOption);
        }
        try {
            if (ServerInstallUtil.ExistingSchemaOption.SKIP != existingSchemaOptionEnum) {
                String dbSetupLogDir = this.getDatabaseSetupLogDir();
                if (this.isDatabaseSchemaExist(dbUrl, dbUsername, clearTextDbPassword)) {
                    if (ServerInstallUtil.ExistingSchemaOption.OVERWRITE == existingSchemaOptionEnum) {
                        this.log("Database schema exists but installer was told to overwrite it - a new schema will be created now.");
                        ServerInstallUtil.createNewDatabaseSchema(serverProperties, serverDetails, clearTextDbPassword, dbSetupLogDir);
                    } else {
                        this.log("Database schema exists - it will now be updated.");
                        ServerInstallUtil.upgradeExistingDatabaseSchema(serverProperties, serverDetails, clearTextDbPassword, dbSetupLogDir);
                    }
                } else {
                    this.log("Database schema does not yet exist - it will now be created.");
                    ServerInstallUtil.createNewDatabaseSchema(serverProperties, serverDetails, clearTextDbPassword, dbSetupLogDir);
                }
            } else {
                this.log("Ignoring database schema - installer will assume it exists and is already up-to-date.");
            }
        }
        catch (Exception e) {
            throw new Exception("Could not complete the database schema installation", e);
        }
        ServerInstallUtil.storeServerDetails(serverProperties, clearTextDbPassword, serverDetails);
    }

    @Override
    public ArrayList<String> getServerNames(String connectionUrl, String username, String password) {
        try {
            return ServerInstallUtil.getServerNames(connectionUrl, username, password);
        }
        catch (Exception e) {
            this.log("Could not get the list of registered server names", e);
            return null;
        }
    }

    @Override
    public ArrayList<ServerDetails> getAllServerDetails(String connectionUrl, String username, String password) {
        ArrayList<String> serverNames = this.getServerNames(connectionUrl, username, password);
        if (serverNames == null) {
            return null;
        }
        ArrayList<ServerDetails> serverDetails = new ArrayList<ServerDetails>(serverNames.size());
        for (String serverName : serverNames) {
            ServerDetails currentDetails = this.getServerDetails(connectionUrl, username, password, serverName);
            if (currentDetails == null) {
                return null;
            }
            serverDetails.add(currentDetails);
        }
        return serverDetails;
    }

    @Override
    public ServerDetails getServerDetails(String connectionUrl, String username, String password, String serverName) {
        try {
            ServerDetails sd = ServerInstallUtil.getServerDetails(connectionUrl, username, password, serverName);
            if (sd != null) {
                if (ServerInstallUtil.isEmpty(sd.getName())) {
                    try {
                        sd.setEndpointAddress(InetAddress.getLocalHost().getCanonicalHostName());
                    }
                    catch (Exception ignore) {
                        // empty catch block
                    }
                }
                if (ServerInstallUtil.isEmpty(sd.getEndpointAddress())) {
                    try {
                        sd.setEndpointAddress(InetAddress.getLocalHost().getHostAddress());
                    }
                    catch (Exception ignore) {
                        // empty catch block
                    }
                }
            }
            return sd;
        }
        catch (Exception e) {
            this.log("Could not get server details for [" + serverName + "]", e);
            return null;
        }
    }

    @Override
    public boolean isDatabaseSchemaExist(String connectionUrl, String username, String password) {
        try {
            return ServerInstallUtil.isDatabaseSchemaExist(connectionUrl, username, password);
        }
        catch (Exception e) {
            this.log("Could not determine database existence", e);
            return false;
        }
    }

    @Override
    public String testConnection(String connectionUrl, String username, String password) {
        String results = ServerInstallUtil.testConnection(connectionUrl, username, password);
        return results;
    }

    @Override
    public HashMap<String, String> getServerProperties() throws Exception {
        File serverPropertiesFile = this.getServerPropertiesFile();
        PropertiesFileUpdate propsFile = new PropertiesFileUpdate(serverPropertiesFile.getAbsolutePath());
        Properties props = propsFile.loadExistingProperties();
        boolean isIBM = System.getProperty("java.vendor", "").contains("IBM");
        if (isIBM) {
            for (String algPropName : ServerProperties.IBM_ALGOROTHM_SETTINGS) {
                props.setProperty(algPropName, "IbmX509");
            }
        }
        HashMap<String, String> map = new HashMap<String, String>(props.size());
        for (Object property : props.keySet()) {
            map.put(property.toString(), props.getProperty(property.toString()));
        }
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean reconfigure(HashMap<String, String> serverProperties) throws Exception {
        this.testModelControllerClient(serverProperties, 30);
        if (null == this.getInstallationResults()) {
            this.log("Run the installer on this server.");
            return false;
        }
        String appServerConfigDir = this.getAppServerConfigDir();
        ModelControllerClient mcc = null;
        try {
            mcc = this.getModelControllerClient();
            try {
                if (ServerInstallUtil.isSameDatasourceSecurityDomainExisting(mcc, serverProperties) && ServerInstallUtil.isSameMailServiceExisting(mcc, serverProperties) && ServerInstallUtil.isSameWebConnectorsExisting(mcc, appServerConfigDir, serverProperties) && ServerInstallUtil.isSameLoggingExisting(mcc, serverProperties)) {
                    this.log("Nothing in the configuration changed that requires a reconfig - everything looks OK");
                    boolean bl = true;
                    return bl;
                }
            }
            catch (Exception e) {
                this.log("Cannot determine if the config is the same, will reconfigure just in case", e);
            }
            CoreJBossASClient coreClient = new CoreJBossASClient(mcc);
            coreClient.reload(true);
            this.testModelControllerClient(30);
            mcc = this.getModelControllerClient();
            ServerInstallUtil.createDatasourceSecurityDomain(mcc, serverProperties);
            ServerInstallUtil.setupMailService(mcc, serverProperties);
            ServerInstallUtil.setupWebConnectors(mcc, appServerConfigDir, serverProperties);
            ServerInstallUtil.configureLogging(mcc, serverProperties);
            coreClient = new CoreJBossASClient(mcc);
            coreClient.restart();
        }
        finally {
            InstallerServiceImpl.safeClose(mcc);
        }
        return true;
    }

    private void verifyDataFormats(HashMap<String, String> serverProperties) throws Exception {
        StringBuilder dataErrors = new StringBuilder();
        for (Map.Entry<String, String> entry : serverProperties.entrySet()) {
            String newValue;
            String name = entry.getKey();
            if (ServerProperties.BOOLEAN_PROPERTIES.contains(name)) {
                newValue = entry.getValue();
                if (newValue.equals("true") || newValue.equals("false")) continue;
                dataErrors.append("[" + name + "] must be 'true' or 'false' : [" + newValue + "]\n");
                continue;
            }
            if (!ServerProperties.INTEGER_PROPERTIES.contains(name)) continue;
            newValue = entry.getValue();
            try {
                Integer.parseInt(newValue);
            }
            catch (NumberFormatException e) {
                if (ServerInstallUtil.isEmpty(newValue) && name.equals("rhq.communications.connector.bind-port")) continue;
                dataErrors.append("[" + name + "] must be a number : [" + newValue + "]\n");
            }
        }
        if (dataErrors.length() > 0) {
            throw new Exception("Cannot install due to data errors:\n" + dataErrors.toString());
        }
    }

    private void saveServerProperties(HashMap<String, String> serverProperties) throws Exception {
        File serverPropertiesFile = this.getServerPropertiesFile();
        PropertiesFileUpdate propsFile = new PropertiesFileUpdate(serverPropertiesFile.getAbsolutePath());
        Properties props = new Properties();
        for (Map.Entry<String, String> entry : serverProperties.entrySet()) {
            props.setProperty(entry.getKey(), entry.getValue());
        }
        propsFile.update(props);
        for (Map.Entry<String, String> entry : serverProperties.entrySet()) {
            System.setProperty(entry.getKey(), entry.getValue());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getAppServerVersion() throws Exception {
        ModelControllerClient mcc = null;
        try {
            String version;
            mcc = this.getModelControllerClient();
            CoreJBossASClient client = new CoreJBossASClient(mcc);
            String string = version = client.getAppServerVersion();
            return string;
        }
        finally {
            InstallerServiceImpl.safeClose(mcc);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getOperatingSystem() throws Exception {
        ModelControllerClient mcc = null;
        try {
            String osName;
            mcc = this.getModelControllerClient();
            CoreJBossASClient client = new CoreJBossASClient(mcc);
            String string = osName = client.getOperatingSystem();
            return string;
        }
        finally {
            InstallerServiceImpl.safeClose(mcc);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getAppServerHomeDir() throws Exception {
        ModelControllerClient mcc = null;
        try {
            String dir;
            mcc = this.getModelControllerClient();
            CoreJBossASClient client = new CoreJBossASClient(mcc);
            String string = dir = client.getAppServerHomeDir();
            return string;
        }
        finally {
            InstallerServiceImpl.safeClose(mcc);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getAppServerConfigDir() throws Exception {
        ModelControllerClient mcc = null;
        try {
            String dir;
            mcc = this.getModelControllerClient();
            CoreJBossASClient client = new CoreJBossASClient(mcc);
            String string = dir = client.getAppServerConfigDir();
            return string;
        }
        finally {
            InstallerServiceImpl.safeClose(mcc);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isEarDeployed() throws Exception {
        ModelControllerClient mcc = null;
        try {
            boolean isDeployed;
            mcc = this.getModelControllerClient();
            DeploymentJBossASClient client = new DeploymentJBossASClient(mcc);
            boolean bl = isDeployed = client.isDeployment(EAR_NAME);
            return bl;
        }
        finally {
            InstallerServiceImpl.safeClose(mcc);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isExtensionDeployed() throws Exception {
        ModelControllerClient mcc = null;
        try {
            boolean isDeployed;
            mcc = this.getModelControllerClient();
            CoreJBossASClient client = new CoreJBossASClient(mcc);
            boolean bl = isDeployed = client.isExtension(RHQ_EXTENSION_NAME);
            return bl;
        }
        finally {
            InstallerServiceImpl.safeClose(mcc);
        }
    }

    private String getDatabaseSetupLogDir() throws Exception {
        File logDir;
        String installerLogDirStr = System.getProperty("rhq.server.installer.logdir");
        if (installerLogDirStr != null) {
            logDir = new File(installerLogDirStr);
            logDir.mkdirs();
            if (!logDir.isDirectory()) {
                throw new Exception("Cannot create installer log directory: " + logDir);
            }
        } else {
            File tmpDir = new File(System.getProperty("java.io.tmpdir"));
            if (!tmpDir.isDirectory()) {
                this.log("Missing tmp dir [" + tmpDir + "]; will use current directory to store logs");
                logDir = new File(".");
            } else {
                logDir = new File(tmpDir, "rhq-installer-db");
                logDir.mkdir();
                if (!logDir.isDirectory()) {
                    this.log("Cannot create database setup log directory [" + logDir + "]; will use current directory");
                    logDir = new File(".");
                }
            }
        }
        String logDirPath = logDir.getAbsolutePath();
        this.log("Database setup log file directory: " + logDirPath);
        return logDirPath;
    }

    private File getServerPropertiesFile() throws Exception {
        String sysprop = System.getProperty(SYSPROP_PROPFILE);
        if (sysprop != null) {
            File propFile = new File(sysprop);
            if (propFile.isFile()) {
                return propFile;
            }
            throw new IllegalArgumentException("System property [rhq.server.properties-file] pointing to invalid file: " + propFile);
        }
        File appServerHomeDir = new File(this.getAppServerHomeDir());
        File serverPropertiesFile = new File(appServerHomeDir, "../bin/rhq-server.properties");
        return serverPropertiesFile;
    }

    private ServerInstallUtil.ExistingSchemaOption getAutoinstallExistingSchemaOption(HashMap<String, String> serverProperties) {
        String s = serverProperties.get("rhq.autoinstall.database");
        ServerInstallUtil.ExistingSchemaOption existingSchemaOptionEnum = s == null || s.equalsIgnoreCase("auto") ? ServerInstallUtil.ExistingSchemaOption.KEEP : ServerInstallUtil.ExistingSchemaOption.valueOf(s.toUpperCase());
        return existingSchemaOptionEnum;
    }

    private ServerDetails getServerDetailsFromPropertiesOnly(HashMap<String, String> serverProperties) throws Exception {
        int securePort;
        int port;
        String connectorTransport;
        String highAvailabilityName = serverProperties.get("rhq.server.high-availability.name");
        String publicEndpoint = serverProperties.get("rhq.autoinstall.public-endpoint-address");
        if (ServerInstallUtil.isEmpty(highAvailabilityName)) {
            try {
                highAvailabilityName = InetAddress.getLocalHost().getCanonicalHostName();
            }
            catch (Exception e) {
                this.log("Could not determine default server name: ", e);
                throw new Exception("Server name is not preconfigured and could not be determined automatically");
            }
        }
        if (ServerInstallUtil.isEmpty(publicEndpoint)) {
            String connBindAddress = serverProperties.get("rhq.communications.connector.bind-address");
            if (!ServerInstallUtil.isEmpty(connBindAddress) && !"0.0.0.0".equals(connBindAddress.trim())) {
                publicEndpoint = connBindAddress.trim();
            } else {
                String serverBindAddress = serverProperties.get("jboss.bind.address");
                if (!ServerInstallUtil.isEmpty(serverBindAddress) && !"0.0.0.0".equals(serverBindAddress.trim())) {
                    publicEndpoint = serverBindAddress.trim();
                } else {
                    try {
                        publicEndpoint = InetAddress.getLocalHost().getCanonicalHostName();
                    }
                    catch (Exception e) {
                        this.log("Could not determine default public endpoint address: ", e);
                        throw new Exception("Public endpoint address not preconfigured and could not be determined automatically");
                    }
                }
            }
        }
        if ((connectorTransport = serverProperties.get("rhq.communications.connector.transport")) != null && connectorTransport.contains("socket")) {
            String connectorBindPort = serverProperties.get("rhq.communications.connector.bind-port");
            if (ServerInstallUtil.isEmpty(connectorBindPort) || "0".equals(connectorBindPort.trim())) {
                throw new Exception("Using non-servlet transport [" + connectorTransport + "] but didn't define a port");
            }
            port = Integer.parseInt(connectorBindPort);
            securePort = Integer.parseInt(connectorBindPort);
        } else {
            try {
                port = Integer.parseInt(serverProperties.get("rhq.server.socket.binding.port.http"));
            }
            catch (Exception e) {
                this.log("Could not determine port, will use default: " + e);
                port = 7080;
            }
            try {
                securePort = Integer.parseInt(serverProperties.get("rhq.server.socket.binding.port.https"));
            }
            catch (Exception e) {
                this.log("Could not determine secure port, will use default: " + e);
                securePort = 7443;
            }
        }
        ServerDetails serverDetails = new ServerDetails(highAvailabilityName, publicEndpoint, port, securePort);
        return serverDetails;
    }

    private String testModelControllerClient(HashMap<String, String> fallbackProps, int secsToWait) throws Exception {
        long start = System.currentTimeMillis();
        long end = start + (long)secsToWait * 1000L;
        Exception error = null;
        while (System.currentTimeMillis() < end) {
            try {
                String retVal = this.testModelControllerClient(fallbackProps);
                if (!new WebJBossASClient(this.getModelControllerClient()).isWebSubsystem()) {
                    throw new IllegalStateException("The server does not appear to be fully started yet (the web subsystem did not start)");
                }
                return retVal;
            }
            catch (Exception e) {
                error = e;
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException ignore) {}
            }
        }
        throw new RuntimeException("Timed out before being able to successfully connect to the server", error);
    }

    private String testModelControllerClient(int secsToWait) throws Exception {
        return this.testModelControllerClient(null, secsToWait);
    }

    private String testModelControllerClient(HashMap<String, String> fallbackProps) throws Exception {
        String host = this.installerConfiguration.getManagementHost();
        int port = this.installerConfiguration.getManagementPort();
        ModelControllerClient mcc = null;
        try {
            String asVersion;
            mcc = ModelControllerClient.Factory.create((String)host, (int)port);
            CoreJBossASClient client = new CoreJBossASClient(mcc);
            Properties sysprops = client.getSystemProperties();
            if (!sysprops.containsKey("rhq.server.database.connection-url")) {
                throw new Exception("Not an RHQ Server");
            }
            String string = asVersion = client.getAppServerVersion();
            return string;
        }
        catch (Exception e) {
            String string;
            try {
                mcc.close();
                mcc = null;
            }
            catch (IOException ignore) {
                // empty catch block
            }
            if (fallbackProps == null) {
                throw new Exception("Cannot obtain client connection to the RHQ app server", e);
            }
            try {
                String portStr;
                boolean differentValues = false;
                String hostStr = fallbackProps.get("jboss.bind.address.management");
                if (hostStr != null && !hostStr.equals(host)) {
                    host = hostStr;
                    differentValues = true;
                }
                if ((portStr = fallbackProps.get("jboss.management.native.port")) != null && !portStr.equals(String.valueOf(port))) {
                    port = Integer.parseInt(portStr);
                    differentValues = true;
                }
                if (!differentValues) {
                    throw new Exception("Cannot obtain client connection to the RHQ app server!", e);
                }
                mcc = ModelControllerClient.Factory.create((String)host, (int)port);
                CoreJBossASClient client = new CoreJBossASClient(mcc);
                Properties sysprops = client.getSystemProperties();
                if (!sysprops.containsKey("rhq.server.database.connection-url")) {
                    throw new Exception("Not an RHQ Server");
                }
                String asVersion = client.getAppServerVersion();
                this.installerConfiguration.setManagementHost(host);
                this.installerConfiguration.setManagementPort(port);
                string = asVersion;
            }
            catch (Exception e2) {
                throw new Exception("Cannot obtain client connection to the RHQ app server!!", e);
            }
            InstallerServiceImpl.safeClose(mcc);
            return string;
        }
        finally {
            InstallerServiceImpl.safeClose(mcc);
        }
    }

    private ModelControllerClient getModelControllerClient() {
        ModelControllerClient client;
        try {
            String host = this.installerConfiguration.getManagementHost();
            int port = this.installerConfiguration.getManagementPort();
            client = ModelControllerClient.Factory.create((String)host, (int)port);
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot obtain client connection to the app server", e);
        }
        return client;
    }

    private void deployServices(HashMap<String, String> serverProperties) throws Exception {
        ModelControllerClient mcc = null;
        try {
            mcc = this.getModelControllerClient();
            ServerInstallUtil.createDatasourceSecurityDomain(mcc, serverProperties);
            ServerInstallUtil.createRESTSecurityDomain(mcc, serverProperties);
            ServerInstallUtil.createNewCaches(mcc, serverProperties);
            ServerInstallUtil.createNewJdbcDrivers(mcc, serverProperties);
            ServerInstallUtil.createNewDatasources(mcc, serverProperties);
            ServerInstallUtil.createNewJMSQueues(mcc, serverProperties);
            ServerInstallUtil.setupMailService(mcc, serverProperties);
            new WebJBossASClient(mcc).setEnableWelcomeRoot(false);
        }
        catch (Exception e) {
            this.log("deployServices failed", e);
            throw new Exception("Failed to deploy services: " + ThrowableUtil.getAllMessages((Throwable)e));
        }
        finally {
            InstallerServiceImpl.safeClose(mcc);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deployAppExtension() throws Exception {
        ModelControllerClient mcc = null;
        try {
            mcc = this.getModelControllerClient();
            CoreJBossASClient client = new CoreJBossASClient(mcc);
            boolean isDeployed = client.isExtension(RHQ_EXTENSION_NAME);
            if (!isDeployed) {
                this.log("Installing RHQ EAR startup subsystem extension");
                client.addExtension(RHQ_EXTENSION_NAME);
            } else {
                this.log("RHQ EAR startup subsystem extension is already deployed");
            }
        }
        finally {
            InstallerServiceImpl.safeClose(mcc);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deployAppSubsystem() throws Exception {
        ModelControllerClient mcc = null;
        try {
            mcc = this.getModelControllerClient();
            CoreJBossASClient client = new CoreJBossASClient(mcc);
            boolean isDeployed = client.isSubsystem(RHQ_SUBSYSTEM_NAME);
            if (!isDeployed) {
                this.log("Installing RHQ EAR subsystem");
                client.addSubsystem(RHQ_SUBSYSTEM_NAME);
            } else {
                this.log("RHQ EAR subsystem is already deployed");
            }
        }
        finally {
            InstallerServiceImpl.safeClose(mcc);
        }
    }

    private static void safeClose(ModelControllerClient mcc) {
        if (null != mcc) {
            try {
                mcc.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reloadConfiguration() {
        this.log("Will now ask the app server to reload its configuration");
        ModelControllerClient mcc = null;
        try {
            mcc = this.getModelControllerClient();
            CoreJBossASClient client = new CoreJBossASClient(mcc);
            client.reload();
            this.log("App server has been successfully asked to reload its configuration");
        }
        catch (Exception e) {
            this.log("reloadConfiguration failed - restart the server to complete the installation", e);
        }
        finally {
            InstallerServiceImpl.safeClose(mcc);
        }
    }
}

