/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.installer;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.tools.ant.BuildListener;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.helper.ProjectHelper2;
import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.dmr.ModelNode;
import org.rhq.common.jbossas.client.controller.Address;
import org.rhq.common.jbossas.client.controller.CoreJBossASClient;
import org.rhq.common.jbossas.client.controller.DatasourceJBossASClient;
import org.rhq.common.jbossas.client.controller.FailureException;
import org.rhq.common.jbossas.client.controller.InfinispanJBossASClient;
import org.rhq.common.jbossas.client.controller.JBossASClient;
import org.rhq.common.jbossas.client.controller.LoggingJBossASClient;
import org.rhq.common.jbossas.client.controller.MessagingJBossASClient;
import org.rhq.common.jbossas.client.controller.SecurityDomainJBossASClient;
import org.rhq.common.jbossas.client.controller.SocketBindingJBossASClient;
import org.rhq.common.jbossas.client.controller.TransactionsJBossASClient;
import org.rhq.common.jbossas.client.controller.WebJBossASClient;
import org.rhq.core.db.DatabaseType;
import org.rhq.core.db.DatabaseTypeFactory;
import org.rhq.core.db.DbUtil;
import org.rhq.core.db.OracleDatabaseType;
import org.rhq.core.db.PostgresqlDatabaseType;
import org.rhq.core.db.setup.DBSetup;
import org.rhq.core.util.PropertiesFileUpdate;
import org.rhq.core.util.exception.ThrowableUtil;
import org.rhq.core.util.file.FileUtil;
import org.rhq.core.util.stream.StreamUtil;
import org.rhq.enterprise.communications.util.SecurityUtil;
import org.rhq.enterprise.server.installer.LoggerAntBuildListener;
import org.rhq.enterprise.server.installer.ServerDetails;

public class ServerInstallUtil {
    private static final Log LOG = LogFactory.getLog(ServerInstallUtil.class);
    private static final ArrayList<SocketBindingInfo> defaultSocketBindings = new ArrayList();
    private static final String RHQ_DATASOURCE_NAME_NOTX = "NoTxRHQDS";
    private static final String RHQ_DATASOURCE_NAME_XA = "RHQDS";
    private static final String RHQ_DS_SECURITY_DOMAIN = "RHQDSSecurityDomain";
    private static final String RHQ_REST_SECURITY_DOMAIN = "RHQRESTSecurityDomain";
    private static final String JDBC_DRIVER_POSTGRES = "postgres";
    private static final String JDBC_DRIVER_ORACLE = "oracle";
    private static final String JMS_ALERT_CONDITION_QUEUE = "AlertConditionQueue";
    private static final String JMS_DRIFT_CHANGESET_QUEUE = "DriftChangesetQueue";
    private static final String JMS_DRIFT_FILE_QUEUE = "DriftFileQueue";
    private static final String RHQ_CACHE_CONTAINER = "rhq";
    private static final String RHQ_CACHE = "rhqCache";
    private static final String RHQ_MGMT_USER = "rhqadmin";

    public static void configureLogging(ModelControllerClient mcc, HashMap<String, String> serverProperties) throws Exception {
        LoggingJBossASClient client = new LoggingJBossASClient(mcc);
        String val = ServerInstallUtil.buildExpression("rhq.server.log-level", serverProperties, true);
        client.setLoggerLevel("org.rhq", val);
        LOG.info((Object)("Logging category org.rhq set to [" + val + "]"));
    }

    public static void configureTransactionManager(ModelControllerClient mcc) throws Exception {
        TransactionsJBossASClient client = new TransactionsJBossASClient(mcc);
        client.setDefaultTransactionTimeout(600);
        LOG.info((Object)"Default transaction timeout set to 600 seconds.");
    }

    public static void configureDeploymentScanner(ModelControllerClient mcc) throws Exception {
        CoreJBossASClient client = new CoreJBossASClient(mcc);
        client.setAppServerDefaultDeploymentScanEnabled(false);
        LOG.info((Object)"Deployment scanner turned off.");
    }

    public static void setupMailService(ModelControllerClient mcc, HashMap<String, String> serverProperties) throws Exception {
        String fromAddressExpr = ServerInstallUtil.buildExpression("rhq.server.email.from-address", serverProperties, true);
        String smtpHostExpr = ServerInstallUtil.buildExpression("rhq.server.email.smtp-host", serverProperties, true);
        String smtpPortExpr = ServerInstallUtil.buildExpression("rhq.server.email.smtp-port", serverProperties, true);
        Address addr = Address.root().add(new String[]{"subsystem", "mail", "mail-session", "java:jboss/mail/Default"});
        ModelNode writeFromAddr = JBossASClient.createRequest((String)"write-attribute", (Address)addr);
        writeFromAddr.get("name").set("from");
        writeFromAddr.get("value").setExpression(fromAddressExpr);
        addr = Address.root().add(new String[]{"socket-binding-group", "standard-sockets", "remote-destination-outbound-socket-binding", "mail-smtp"});
        ModelNode writeHost = JBossASClient.createRequest((String)"write-attribute", (Address)addr);
        writeHost.get("name").set("host");
        JBossASClient.setPossibleExpression((ModelNode)writeHost, (String)"value", (String)smtpHostExpr);
        addr = Address.root().add(new String[]{"socket-binding-group", "standard-sockets", "remote-destination-outbound-socket-binding", "mail-smtp"});
        ModelNode writePort = JBossASClient.createRequest((String)"write-attribute", (Address)addr);
        writePort.get("name").set("port");
        JBossASClient.setPossibleExpression((ModelNode)writePort, (String)"value", (String)smtpPortExpr);
        ModelNode batch = JBossASClient.createBatchRequest((ModelNode[])new ModelNode[]{writeFromAddr, writeHost, writePort});
        JBossASClient client = new JBossASClient(mcc);
        ModelNode response = client.execute(batch);
        if (!JBossASClient.isSuccess((ModelNode)response)) {
            throw new FailureException(response, "Failed to setup mail service");
        }
        LOG.info((Object)"Mail service has been configured.");
    }

    public static SupportedDatabaseType getSupportedDatabaseType(HashMap<String, String> serverProperties) {
        return ServerInstallUtil.getSupportedDatabaseType(serverProperties.get("rhq.server.database.type-mapping"));
    }

    public static SupportedDatabaseType getSupportedDatabaseType(String dbType) {
        if (dbType == null) {
            return null;
        }
        if (dbType.toLowerCase().indexOf(JDBC_DRIVER_POSTGRES) > -1) {
            return SupportedDatabaseType.POSTGRES;
        }
        if (dbType.toLowerCase().indexOf(JDBC_DRIVER_ORACLE) > -1) {
            return SupportedDatabaseType.ORACLE;
        }
        return null;
    }

    public static void createDatasourceSecurityDomain(ModelControllerClient mcc, HashMap<String, String> serverProperties) throws Exception {
        String dbUsername = ServerInstallUtil.buildExpression("rhq.server.database.user-name", serverProperties, true);
        String obfuscatedPassword = ServerInstallUtil.buildExpression("rhq.server.database.password", serverProperties, true);
        SecurityDomainJBossASClient client = new SecurityDomainJBossASClient(mcc);
        String securityDomain = RHQ_DS_SECURITY_DOMAIN;
        if (!client.isSecurityDomain(RHQ_DS_SECURITY_DOMAIN)) {
            client.createNewSecureIdentitySecurityDomain72(RHQ_DS_SECURITY_DOMAIN, dbUsername, obfuscatedPassword);
            LOG.info((Object)"Security domain [RHQDSSecurityDomain] created");
        } else {
            LOG.info((Object)"Security domain [RHQDSSecurityDomain] already exists, skipping the creation request");
            client.updateSecureIdentitySecurityDomainCredentials(RHQ_DS_SECURITY_DOMAIN, dbUsername, obfuscatedPassword);
            LOG.info((Object)"Credentials have been updated for security domain [RHQDSSecurityDomain]");
        }
    }

    public static void createNewJMSQueues(ModelControllerClient mcc, HashMap<String, String> serverProperties) throws Exception {
        ModelNode results;
        ModelNode request;
        MessagingJBossASClient client = new MessagingJBossASClient(mcc);
        ArrayList<String> entryNames = new ArrayList<String>();
        String queueName = JMS_ALERT_CONDITION_QUEUE;
        if (!client.isQueue(queueName)) {
            entryNames.clear();
            entryNames.add("queue/" + queueName);
            request = client.createNewQueueRequest(queueName, Boolean.valueOf(true), entryNames);
            results = client.execute(request);
            if (!MessagingJBossASClient.isSuccess((ModelNode)results)) {
                throw new FailureException(results, "Failed to create JMS Queue [" + queueName + "]");
            }
            LOG.info((Object)("JMS queue [" + queueName + "] created"));
        } else {
            LOG.info((Object)("JMS Queue [" + queueName + "] already exists, skipping the creation request"));
        }
        queueName = JMS_DRIFT_CHANGESET_QUEUE;
        if (!client.isQueue(queueName)) {
            entryNames.clear();
            entryNames.add("queue/" + queueName);
            request = client.createNewQueueRequest(queueName, Boolean.valueOf(true), entryNames);
            results = client.execute(request);
            if (!MessagingJBossASClient.isSuccess((ModelNode)results)) {
                throw new FailureException(results, "Failed to create JMS Queue [" + queueName + "]");
            }
            LOG.info((Object)("JMS queue [" + queueName + "] created"));
        } else {
            LOG.info((Object)("JMS Queue [" + queueName + "] already exists, skipping the creation request"));
        }
        queueName = JMS_DRIFT_FILE_QUEUE;
        if (!client.isQueue(queueName)) {
            entryNames.clear();
            entryNames.add("queue/" + queueName);
            request = client.createNewQueueRequest(queueName, Boolean.valueOf(true), entryNames);
            results = client.execute(request);
            if (!MessagingJBossASClient.isSuccess((ModelNode)results)) {
                throw new FailureException(results, "Failed to create JMS Queue [" + queueName + "]");
            }
            LOG.info((Object)("JMS queue [" + queueName + "] created"));
        } else {
            LOG.info((Object)("JMS Queue [" + queueName + "] already exists, skipping the creation request"));
        }
    }

    public static void createRESTSecurityDomain(ModelControllerClient mcc, HashMap<String, String> serverProperties) throws Exception {
        SecurityDomainJBossASClient client = new SecurityDomainJBossASClient(mcc);
        String securityDomain = RHQ_REST_SECURITY_DOMAIN;
        if (!client.isSecurityDomain(RHQ_REST_SECURITY_DOMAIN)) {
            String dsJndiName = "java:jboss/datasources/RHQDS";
            client.createNewDatabaseServerSecurityDomain72(RHQ_REST_SECURITY_DOMAIN, dsJndiName, "SELECT PASSWORD FROM RHQ_PRINCIPAL WHERE principal=?", "SELECT 'all', 'Roles' FROM RHQ_PRINCIPAL WHERE principal=?", null, null);
            LOG.info((Object)"Security domain [RHQRESTSecurityDomain] created");
        } else {
            LOG.info((Object)"Security domain [RHQRESTSecurityDomain] already exists, skipping the creation request");
        }
    }

    public static void createNewCaches(ModelControllerClient mcc, HashMap<String, String> serverProperties) throws Exception {
        ModelNode results;
        ModelNode request;
        InfinispanJBossASClient client = new InfinispanJBossASClient(mcc);
        String cacheContainerName = RHQ_CACHE_CONTAINER;
        String localCacheName = RHQ_CACHE;
        if (!client.isCacheContainer(RHQ_CACHE_CONTAINER)) {
            request = client.createNewCacheContainerRequest(RHQ_CACHE_CONTAINER, RHQ_CACHE);
            results = client.execute(request);
            if (!MessagingJBossASClient.isSuccess((ModelNode)results)) {
                throw new FailureException(results, "Failed to create Cache container [rhq]");
            }
            LOG.info((Object)"Cache container [rhq] created");
        } else {
            LOG.info((Object)"Cache container [rhq] already exists, skipping the creation request");
        }
        if (!client.isLocalCache(RHQ_CACHE_CONTAINER, RHQ_CACHE)) {
            request = client.createNewLocalCacheRequest(RHQ_CACHE_CONTAINER, RHQ_CACHE, null, null, null, null, null);
            results = client.execute(request);
            if (!MessagingJBossASClient.isSuccess((ModelNode)results)) {
                throw new FailureException(results, "Failed to create Local Cache [rhqCache]");
            }
            LOG.info((Object)"Local Cache [rhqCache] created");
        } else {
            LOG.info((Object)"Local Cache [rhqCache] already exists, skipping the creation request");
        }
    }

    public static void createNewJdbcDrivers(ModelControllerClient mcc, HashMap<String, String> serverProperties) throws Exception {
        DatasourceJBossASClient client = new DatasourceJBossASClient(mcc);
        ModelNode postgresDriverRequest = client.createNewJdbcDriverRequest(JDBC_DRIVER_POSTGRES, "org.rhq.postgres", "org.postgresql.xa.PGXADataSource");
        ModelNode oracleDriverRequest = client.createNewJdbcDriverRequest(JDBC_DRIVER_ORACLE, "org.rhq.oracle", "oracle.jdbc.xa.client.OracleXADataSource");
        SupportedDatabaseType supportedDbType = ServerInstallUtil.getSupportedDatabaseType(serverProperties);
        switch (supportedDbType) {
            case POSTGRES: {
                ModelNode results;
                if (client.isJDBCDriver(JDBC_DRIVER_POSTGRES)) {
                    LOG.info((Object)"Postgres JDBC driver is already deployed");
                } else {
                    results = client.execute(postgresDriverRequest);
                    if (!DatasourceJBossASClient.isSuccess((ModelNode)results)) {
                        throw new FailureException(results, "Failed to create postgres database driver");
                    }
                    LOG.info((Object)"Deployed Postgres JDBC driver");
                }
                if (client.isJDBCDriver(JDBC_DRIVER_ORACLE)) {
                    LOG.info((Object)"Oracle JDBC driver is already deployed");
                    break;
                }
                results = client.execute(oracleDriverRequest);
                if (!DatasourceJBossASClient.isSuccess((ModelNode)results)) {
                    LOG.warn((Object)("Could not create Oracle JDBC Driver - you will not be able to switch to an Oracle DB later: " + JBossASClient.getFailureDescription((ModelNode)results)));
                    break;
                }
                LOG.info((Object)"Deployed Oracle JDBC driver for future use");
                break;
            }
            case ORACLE: {
                ModelNode results;
                if (client.isJDBCDriver(JDBC_DRIVER_ORACLE)) {
                    LOG.info((Object)"Oracle JDBC driver is already deployed");
                } else {
                    results = client.execute(oracleDriverRequest);
                    if (!DatasourceJBossASClient.isSuccess((ModelNode)results)) {
                        throw new FailureException(results, "Failed to create oracle database driver");
                    }
                    LOG.info((Object)"Deployed Oracle JDBC driver");
                }
                if (client.isJDBCDriver(JDBC_DRIVER_POSTGRES)) {
                    LOG.info((Object)"Postgres JDBC driver is already deployed");
                    break;
                }
                results = client.execute(postgresDriverRequest);
                if (!DatasourceJBossASClient.isSuccess((ModelNode)results)) {
                    LOG.warn((Object)("Could not create Postgres JDBC Driver - you will not be able to switch to a Postgres DB later: " + JBossASClient.getFailureDescription((ModelNode)results)));
                    break;
                }
                LOG.info((Object)"Deployed Postgres JDBC driver for future use");
                break;
            }
            default: {
                throw new RuntimeException("bad db type");
            }
        }
    }

    public static void createNewDatasources(ModelControllerClient mcc, HashMap<String, String> serverProperties) throws Exception {
        SupportedDatabaseType supportedDbType = ServerInstallUtil.getSupportedDatabaseType(serverProperties);
        switch (supportedDbType) {
            case POSTGRES: {
                ServerInstallUtil.createNewDatasources_Postgres(mcc);
                break;
            }
            case ORACLE: {
                ServerInstallUtil.createNewDatasources_Oracle(mcc);
                break;
            }
            default: {
                throw new RuntimeException("bad db type");
            }
        }
        LOG.info((Object)"Created datasources");
        DatasourceJBossASClient client = new DatasourceJBossASClient(mcc);
        client.enableDatasource(RHQ_DATASOURCE_NAME_NOTX);
        client.enableXADatasource(RHQ_DATASOURCE_NAME_XA);
        LOG.info((Object)"Enabled datasources");
    }

    private static void createNewDatasources_Postgres(ModelControllerClient mcc) throws Exception {
        ModelNode batch;
        ModelNode results;
        HashMap<String, String> props = new HashMap<String, String>(4);
        DatasourceJBossASClient client = new DatasourceJBossASClient(mcc);
        ModelNode noTxDsRequest = null;
        ModelNode xaDsRequest = null;
        if (!client.isDatasource(RHQ_DATASOURCE_NAME_NOTX)) {
            props.put("char.encoding", "UTF-8");
            noTxDsRequest = client.createNewDatasourceRequest(RHQ_DATASOURCE_NAME_NOTX, 30000, "${rhq.server.database.connection-url:jdbc:postgres://127.0.0.1:5432/rhq}", JDBC_DRIVER_POSTGRES, "org.jboss.jca.adapters.jdbc.extensions.postgres.PostgreSQLExceptionSorter", 15, false, 2, 5, 75, RHQ_DS_SECURITY_DOMAIN, "-unused-stale-conn-checker-", "TRANSACTION_READ_COMMITTED", "org.jboss.jca.adapters.jdbc.extensions.postgres.PostgreSQLValidConnectionChecker", props);
            noTxDsRequest.get("steps").get(0).remove("stale-connection-checker-class-name");
        } else {
            LOG.info((Object)"Postgres datasource [NoTxRHQDS] already exists");
        }
        if (!client.isXADatasource(RHQ_DATASOURCE_NAME_XA)) {
            props.clear();
            props.put("ServerName", "${rhq.server.database.server-name:127.0.0.1}");
            props.put("PortNumber", "${rhq.server.database.port:5432}");
            props.put("DatabaseName", "${rhq.server.database.db-name:rhq}");
            xaDsRequest = client.createNewXADatasourceRequest(RHQ_DATASOURCE_NAME_XA, 30000, JDBC_DRIVER_POSTGRES, "org.jboss.jca.adapters.jdbc.extensions.postgres.PostgreSQLExceptionSorter", 15, 5, 50, (Boolean)null, (Boolean)null, 75, (String)null, RHQ_DS_SECURITY_DOMAIN, (String)null, "TRANSACTION_READ_COMMITTED", "org.jboss.jca.adapters.jdbc.extensions.postgres.PostgreSQLValidConnectionChecker", props);
        } else {
            LOG.info((Object)"Postgres XA datasource [RHQDS] already exists");
        }
        if (!(noTxDsRequest == null && xaDsRequest == null || DatasourceJBossASClient.isSuccess((ModelNode)(results = client.execute(batch = DatasourceJBossASClient.createBatchRequest((ModelNode[])new ModelNode[]{noTxDsRequest, xaDsRequest})))))) {
            throw new FailureException(results, "Failed to create Postgres datasources");
        }
    }

    private static void createNewDatasources_Oracle(ModelControllerClient mcc) throws Exception {
        ModelNode batch;
        ModelNode results;
        HashMap<String, String> props = new HashMap<String, String>(2);
        DatasourceJBossASClient client = new DatasourceJBossASClient(mcc);
        ModelNode noTxDsRequest = null;
        ModelNode xaDsRequest = null;
        if (!client.isDatasource(RHQ_DATASOURCE_NAME_NOTX)) {
            props.put("char.encoding", "UTF-8");
            noTxDsRequest = client.createNewDatasourceRequest(RHQ_DATASOURCE_NAME_NOTX, 30000, "${rhq.server.database.connection-url:jdbc:oracle:thin:@127.0.0.1:1521:rhq}", JDBC_DRIVER_ORACLE, "org.jboss.jca.adapters.jdbc.extensions.oracle.OracleExceptionSorter", 15, false, 2, 5, 75, RHQ_DS_SECURITY_DOMAIN, "org.jboss.jca.adapters.jdbc.extensions.oracle.OracleStaleConnectionChecker", "TRANSACTION_READ_COMMITTED", "org.jboss.jca.adapters.jdbc.extensions.oracle.OracleValidConnectionChecker", props);
        } else {
            LOG.info((Object)"Oracle datasource [NoTxRHQDS] already exists");
        }
        if (!client.isDatasource(RHQ_DATASOURCE_NAME_XA)) {
            props.clear();
            props.put("URL", "${rhq.server.database.connection-url:jdbc:oracle:thin:@127.0.0.1:1521:rhq}");
            xaDsRequest = client.createNewXADatasourceRequest(RHQ_DATASOURCE_NAME_XA, 30000, JDBC_DRIVER_ORACLE, "org.jboss.jca.adapters.jdbc.extensions.oracle.OracleExceptionSorter", 15, 5, 50, (Boolean)null, Boolean.TRUE, 75, (String)null, RHQ_DS_SECURITY_DOMAIN, "org.jboss.jca.adapters.jdbc.extensions.oracle.OracleStaleConnectionChecker", "TRANSACTION_READ_COMMITTED", "org.jboss.jca.adapters.jdbc.extensions.oracle.OracleValidConnectionChecker", props);
        } else {
            LOG.info((Object)"Oracle XA datasource [RHQDS] already exists");
        }
        if (!(noTxDsRequest == null && xaDsRequest == null || DatasourceJBossASClient.isSuccess((ModelNode)(results = client.execute(batch = DatasourceJBossASClient.createBatchRequest((ModelNode[])new ModelNode[]{noTxDsRequest, xaDsRequest})))))) {
            throw new FailureException(results, "Failed to create Oracle datasources");
        }
    }

    public static boolean isAutoinstallEnabled(HashMap<String, String> serverProperties) {
        String enableProp = serverProperties.get("rhq.autoinstall.enabled");
        if (enableProp != null) {
            return Boolean.parseBoolean(enableProp);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isDatabaseSchemaExist(String connectionUrl, String username, String password) throws Exception {
        Connection conn = ServerInstallUtil.getDatabaseConnection(connectionUrl, username, password);
        DatabaseType db = DatabaseTypeFactory.getDatabaseType((Connection)conn);
        try {
            boolean bl = db.checkTableExists(conn, "RHQ_PRINCIPAL");
            return bl;
        }
        catch (IllegalStateException e) {
            boolean bl = false;
            return bl;
        }
        finally {
            db.closeConnection(conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ArrayList<String> getServerNames(String connectionUrl, String username, String password) throws Exception {
        DatabaseType db = null;
        Connection conn = null;
        Statement stm = null;
        ResultSet rs = null;
        ArrayList<String> result = new ArrayList<String>();
        try {
            conn = ServerInstallUtil.getDatabaseConnection(connectionUrl, username, password);
            db = DatabaseTypeFactory.getDatabaseType((Connection)conn);
            if (db.checkTableExists(conn, "rhq_server")) {
                stm = conn.createStatement();
                rs = stm.executeQuery("SELECT name FROM rhq_server ORDER BY name asc");
                while (rs.next()) {
                    result.add(rs.getString(1));
                }
            }
            if (null == db) return result;
        }
        catch (IllegalStateException e) {
            if (null == db) return result;
            db.closeJDBCObjects(conn, stm, rs);
            return result;
        }
        catch (SQLException e2) {
            LOG.info((Object)("Unable to fetch existing server info: " + e2.getMessage()));
            if (null == db) return result;
            {
                catch (Throwable throwable) {
                    if (null == db) throw throwable;
                    db.closeJDBCObjects(conn, stm, rs);
                    throw throwable;
                }
            }
            db.closeJDBCObjects(conn, stm, rs);
            return result;
        }
        db.closeJDBCObjects(conn, stm, rs);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ServerDetails getServerDetails(String connectionUrl, String username, String password, String serverName) {
        DatabaseType db = null;
        Connection conn = null;
        ServerDetails result = null;
        try {
            conn = ServerInstallUtil.getDatabaseConnection(connectionUrl, username, password);
            db = DatabaseTypeFactory.getDatabaseType((Connection)conn);
            result = ServerInstallUtil.getServerDetails(db, conn, serverName);
        }
        catch (Exception e) {
            LOG.info((Object)("Unable to get server detail: " + e.getMessage()));
        }
        finally {
            if (null != db) {
                db.closeConnection(conn);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static ServerDetails getServerDetails(DatabaseType db, Connection conn, String serverName) {
        PreparedStatement stm = null;
        ResultSet rs = null;
        ServerDetails result = null;
        if (null == serverName) {
            return result;
        }
        try {
            stm = conn.prepareStatement("SELECT s.address, s.port, s.secure_port   FROM rhq_server s  WHERE s.name = ?");
            stm.setString(1, serverName.trim());
            rs = stm.executeQuery();
            if (rs.next()) {
                result = new ServerDetails(serverName, rs.getString(1), rs.getInt(2), rs.getInt(3));
            }
            if (null == db) return result;
        }
        catch (SQLException e) {
            try {
                LOG.info((Object)("Unable to get server details for server [" + serverName + "]: " + e.getMessage()));
                if (null == db) return result;
            }
            catch (Throwable throwable) {
                if (null == db) throw throwable;
                db.closeResultSet(rs);
                db.closeStatement((Statement)stm);
                throw throwable;
            }
            db.closeResultSet(rs);
            db.closeStatement((Statement)stm);
            return result;
        }
        db.closeResultSet(rs);
        db.closeStatement((Statement)stm);
        return result;
    }

    public static String testConnection(String connectionUrl, String username, String password) {
        DatabaseTypeFactory.clearDatabaseTypeCache();
        try {
            ServerInstallUtil.ensureDatabaseIsSupported(connectionUrl, username, password);
            return null;
        }
        catch (Exception e) {
            LOG.warn((Object)"Installer failed to test connection", (Throwable)e);
            return ThrowableUtil.getAllMessages((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void ensureDatabaseIsSupported(String connectionUrl, String username, String password) throws Exception {
        Connection conn = null;
        DatabaseType db = null;
        try {
            conn = ServerInstallUtil.getDatabaseConnection(connectionUrl, username, password);
            db = DatabaseTypeFactory.getDatabaseType((Connection)conn);
            String version = db.getVersion();
            if (DatabaseTypeFactory.isPostgres((DatabaseType)db)) {
                if (version.startsWith("7") || version.equals("8") || version.startsWith("8.0") || version.startsWith("8.1")) {
                    throw new Exception("Unsupported PostgreSQL [" + db + "]");
                }
            } else if (DatabaseTypeFactory.isOracle((DatabaseType)db)) {
                if (version.startsWith("8") || version.startsWith("9")) {
                    throw new Exception("Unsupported Oracle [" + db + "]");
                }
            } else {
                throw new Exception("Unsupported DB [" + db + "]");
            }
            LOG.info((Object)("Database is supported: " + db));
        }
        finally {
            if (db != null) {
                db.closeConnection(conn);
            }
        }
    }

    public static Connection getDatabaseConnection(String connectionUrl, String userName, String password) throws SQLException {
        return DbUtil.getConnection((String)connectionUrl, (String)userName, (String)password);
    }

    public static String obfuscatePassword(String password) {
        try {
            String className = "org.picketbox.datasource.security.SecureIdentityLoginModule";
            Class<?> clazz = Class.forName(className);
            Object object = clazz.newInstance();
            Method method = clazz.getDeclaredMethod("encode", String.class);
            method.setAccessible(true);
            String result = method.invoke(object, password).toString();
            return result;
        }
        catch (Exception e) {
            throw new RuntimeException("obfuscating db password failed: ", e);
        }
    }

    public static String deobfuscatePassword(String obfuscatedPassword) {
        try {
            String className = "org.picketbox.datasource.security.SecureIdentityLoginModule";
            Class<?> clazz = Class.forName(className);
            Object object = clazz.newInstance();
            Method method = clazz.getDeclaredMethod("decode", String.class);
            method.setAccessible(true);
            char[] result = (char[])method.invoke(object, obfuscatedPassword);
            return new String(result);
        }
        catch (Exception e) {
            throw new RuntimeException("de-obfuscating db password failed: ", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void storeServerDetails(HashMap<String, String> serverProperties, String password, ServerDetails serverDetails) throws Exception {
        DatabaseType db = null;
        Connection conn = null;
        try {
            String dbUrl = serverProperties.get("rhq.server.database.connection-url");
            String userName = serverProperties.get("rhq.server.database.user-name");
            conn = ServerInstallUtil.getDatabaseConnection(dbUrl, userName, password);
            db = DatabaseTypeFactory.getDatabaseType((Connection)conn);
            ServerInstallUtil.updateOrInsertServer(db, conn, serverDetails);
            if (null == db) return;
        }
        catch (SQLException e) {
            try {
                LOG.info((Object)("Unable to store server entry in the database: " + ThrowableUtil.getAllMessages((Throwable)e)));
                if (null == db) return;
            }
            catch (Throwable throwable) {
                if (null == db) throw throwable;
                db.closeConnection(conn);
                throw throwable;
            }
            db.closeConnection(conn);
            return;
        }
        db.closeConnection(conn);
        return;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void updateOrInsertServer(DatabaseType db, Connection conn, ServerDetails serverDetails) {
        PreparedStatement stm = null;
        ResultSet rs = null;
        if (null == serverDetails || ServerInstallUtil.isEmpty(serverDetails.getName())) {
            return;
        }
        try {
            stm = conn.prepareStatement("UPDATE rhq_server SET address=?, port=?, secure_port=? WHERE name=?");
            stm.setString(1, serverDetails.getEndpointAddress());
            stm.setInt(2, serverDetails.getEndpointPort());
            stm.setInt(3, serverDetails.getEndpointSecurePort());
            stm.setString(4, serverDetails.getName());
            if (0 == stm.executeUpdate()) {
                stm.close();
                int i = 1;
                if (!(db instanceof PostgresqlDatabaseType) && !(db instanceof OracleDatabaseType)) {
                    throw new IllegalArgumentException("Unknown database type, can't continue: " + db);
                }
                stm = conn.prepareStatement("INSERT INTO rhq_server  ( id, name, address, port, secure_port, ctime, mtime, operation_mode, compute_power ) VALUES ( ?, ?, ?, ?, ?, ?, ?, 'INSTALLED', 1 )");
                stm.setInt(i++, db.getNextSequenceValue(conn, "rhq_server", "id"));
                stm.setString(i++, serverDetails.getName());
                stm.setString(i++, serverDetails.getEndpointAddress());
                stm.setInt(i++, serverDetails.getEndpointPort());
                stm.setInt(i++, serverDetails.getEndpointSecurePort());
                long now = System.currentTimeMillis();
                stm.setLong(i++, now);
                stm.setLong(i++, now);
                stm.executeUpdate();
            }
        }
        catch (SQLException e) {
            LOG.info((Object)("Unable to put the server details in the database: " + ThrowableUtil.getAllMessages((Throwable)e)));
        }
        finally {
            if (null != db) {
                db.closeResultSet(rs);
                db.closeStatement((Statement)stm);
            }
        }
    }

    public static void createNewDatabaseSchema(HashMap<String, String> props, ServerDetails serverDetails, String password, String logDir) throws Exception {
        String dbUrl = props.get("rhq.server.database.connection-url");
        String userName = props.get("rhq.server.database.user-name");
        try {
            String dbsetupSchemaXmlFile = ServerInstallUtil.extractDatabaseXmlFile("db-schema-combined.xml", props, serverDetails, logDir);
            String dbsetupDataXmlFile = ServerInstallUtil.extractDatabaseXmlFile("db-data-combined.xml", props, serverDetails, logDir);
            DBSetup dbsetup = new DBSetup(dbUrl, userName, password);
            dbsetup.uninstall(dbsetupSchemaXmlFile);
            dbsetup.setup(dbsetupSchemaXmlFile);
            dbsetup.setup(dbsetupDataXmlFile, null, true, false);
        }
        catch (Exception e) {
            LOG.fatal((Object)"Cannot install the database schema - the server will not run properly.", (Throwable)e);
            throw e;
        }
    }

    public static void upgradeExistingDatabaseSchema(HashMap<String, String> props, ServerDetails serverDetails, String password, String logDir) throws Exception {
        String dbUrl = props.get("rhq.server.database.connection-url");
        String userName = props.get("rhq.server.database.user-name");
        File logfile = new File(logDir, "rhq-installer-dbupgrade.log");
        logfile.delete();
        try {
            String dbupgradeXmlFile = ServerInstallUtil.extractDatabaseXmlFile("db-upgrade.xml", props, serverDetails, logDir);
            Properties antProps = new Properties();
            antProps.setProperty("jdbc.url", dbUrl);
            antProps.setProperty("jdbc.user", userName);
            antProps.setProperty("jdbc.password", password);
            antProps.setProperty("target.schema.version", "LATEST");
            ServerInstallUtil.startAnt(new File(dbupgradeXmlFile), "db-ant-tasks.properties", antProps, logfile);
        }
        catch (Exception e) {
            LOG.fatal((Object)"Cannot upgrade the database schema - the server will not run properly.", (Throwable)e);
            throw e;
        }
    }

    public static boolean isEmpty(String s) {
        return s == null || s.trim().length() == 0;
    }

    private static String extractDatabaseXmlFile(String xmlFileName, HashMap<String, String> props, ServerDetails serverDetails, String logDir) throws IOException {
        String publicEndpoint;
        String httpPort;
        InputStream resourceInStream = ServerInstallUtil.class.getClassLoader().getResourceAsStream(xmlFileName);
        ByteArrayOutputStream contentOutStream = new ByteArrayOutputStream();
        StreamUtil.copy((InputStream)resourceInStream, (OutputStream)contentOutStream);
        String emailFromAddress = props.get("rhq.server.email.from-address");
        if (ServerInstallUtil.isEmpty(emailFromAddress)) {
            emailFromAddress = "rhqadmin@localhost";
        }
        if (ServerInstallUtil.isEmpty(httpPort = props.get("rhq.server.socket.binding.port.http"))) {
            httpPort = String.valueOf(7080);
        }
        if (ServerInstallUtil.isEmpty(publicEndpoint = serverDetails.getEndpointAddress())) {
            try {
                publicEndpoint = props.get("jboss.bind.address");
                if (ServerInstallUtil.isEmpty(publicEndpoint) || "0.0.0.0".equals(publicEndpoint)) {
                    publicEndpoint = InetAddress.getLocalHost().getHostAddress();
                }
            }
            catch (Exception e) {
                publicEndpoint = "127.0.0.1";
            }
        }
        String content = contentOutStream.toString();
        content = content.replaceAll("@@@LARGE_TABLESPACE_FOR_DATA@@@", "DEFAULT");
        content = content.replaceAll("@@@LARGE_TABLESPACE_FOR_INDEX@@@", "DEFAULT");
        content = content.replaceAll("@@@ADMINUSERNAME@@@", RHQ_MGMT_USER);
        content = content.replaceAll("@@@ADMINPASSWORD@@@", "x1XwrxKuPvYUILiOnOZTLg==");
        content = content.replaceAll("@@@ADMINEMAIL@@@", emailFromAddress);
        content = content.replaceAll("@@@BASEURL@@@", "http://" + publicEndpoint + ":" + httpPort + "/");
        content = content.replaceAll("@@@JAASPROVIDER@@@", "JDBC");
        content = content.replaceAll("@@@LDAPURL@@@", "ldap://localhost/");
        content = content.replaceAll("@@@LDAPPROTOCOL@@@", "");
        content = content.replaceAll("@@@LDAPLOGINPROP@@@", "cn");
        content = content.replaceAll("@@@LDAPBASEDN@@@", "o=JBoss,c=US");
        content = content.replaceAll("@@@LDAPSEARCHFILTER@@@", "");
        content = content.replaceAll("@@@LDAPBINDDN@@@", "");
        content = content.replaceAll("@@@LDAPBINDPW@@@", "");
        content = content.replaceAll("@@@MULTICAST_ADDR@@@", "");
        content = content.replaceAll("@@@MULTICAST_PORT@@@", "");
        File xmlFile = new File(logDir, xmlFileName);
        FileOutputStream xmlFileOutStream = new FileOutputStream(xmlFile);
        ByteArrayInputStream contentInStream = new ByteArrayInputStream(content.getBytes());
        StreamUtil.copy((InputStream)contentInStream, (OutputStream)xmlFileOutStream);
        return xmlFile.getAbsolutePath();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void startAnt(File buildFile, String customTaskDefs, Properties properties, File logFile) {
        PrintWriter logFileOutput = null;
        try {
            logFileOutput = new PrintWriter(new FileOutputStream(logFile));
            ClassLoader classLoader = ServerInstallUtil.class.getClassLoader();
            Properties taskDefs = new Properties();
            InputStream taskDefsStream = classLoader.getResourceAsStream(customTaskDefs);
            try {
                taskDefs.load(taskDefsStream);
            }
            finally {
                taskDefsStream.close();
            }
            Project project = new Project();
            project.setCoreLoader(classLoader);
            project.init();
            for (Map.Entry<Object, Object> property : properties.entrySet()) {
                project.setProperty(property.getKey().toString(), property.getValue().toString());
            }
            project.addBuildListener((BuildListener)new LoggerAntBuildListener(logFileOutput));
            for (Map.Entry<Object, Object> taskDef : taskDefs.entrySet()) {
                project.addTaskDefinition(taskDef.getKey().toString(), Class.forName(taskDef.getValue().toString(), true, classLoader));
            }
            new ProjectHelper2().parse(project, (Object)buildFile);
            project.executeTarget(project.getDefaultTarget());
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot run ANT on script [" + buildFile + "]. Cause: " + e, e);
        }
        finally {
            if (logFileOutput != null) {
                logFileOutput.close();
            }
        }
    }

    public static void setupWebConnectors(ModelControllerClient mcc, String configDirStr, HashMap<String, String> serverProperties) throws Exception {
        String connectorName = "http";
        String sslConnectorName = "https";
        WebJBossASClient client = new WebJBossASClient(mcc);
        client.removeConnector("https");
        LOG.info((Object)"Creating https connector...");
        WebJBossASClient.ConnectorConfiguration connector = ServerInstallUtil.buildSecureConnectorConfiguration(configDirStr, serverProperties);
        String truststoreFileString = connector.getSslConfiguration().getCaCertificateFile();
        truststoreFileString = ServerInstallUtil.resolveExpression(mcc, truststoreFileString);
        connector.getSslConfiguration().setCaCertificateFile(truststoreFileString);
        String keystoreFileString = connector.getSslConfiguration().getCertificateKeyFile();
        keystoreFileString = ServerInstallUtil.resolveExpression(mcc, keystoreFileString);
        connector.getSslConfiguration().setCertificateKeyFile(keystoreFileString);
        if (truststoreFileString == null) {
            LOG.warn((Object)"Missing a valid truststore location - you must specify a valid truststore location!");
        } else {
            File truststoreFile = new File(truststoreFileString);
            if (!truststoreFile.exists()) {
                File keystoreFile = new File(keystoreFileString);
                if (!keystoreFile.isFile()) {
                    LOG.warn((Object)("Missing both keystore [" + keystoreFile + "] and truststore [" + truststoreFile + "]"));
                } else {
                    LOG.warn((Object)("Missing the truststore [" + truststoreFile + "] - will copy the keystore [" + keystoreFile + "] and make the copy the truststore."));
                    try {
                        FileUtil.copyFile((File)keystoreFile, (File)truststoreFile);
                    }
                    catch (Exception e) {
                        LOG.error((Object)"Failed to copy keystore to make truststore - a truststore still does not exist", (Throwable)e);
                    }
                }
            }
        }
        client.addConnector("https", connector);
        LOG.info((Object)"https connector created.");
        if (client.isConnector("http")) {
            client.changeConnector("http", "max-connections", ServerInstallUtil.buildExpression("rhq.server.startup.web.max-connections", serverProperties, true));
            client.changeConnector("http", "redirect-port", ServerInstallUtil.buildExpression("rhq.server.socket.binding.port.https", serverProperties, true));
        } else {
            LOG.warn((Object)"There doesn't appear to be a http connector configured already - this is strange.");
        }
    }

    private static String resolveExpression(ModelControllerClient mcc, String expression) {
        String resolvedExpression;
        if (expression == null) {
            return null;
        }
        CoreJBossASClient client = new CoreJBossASClient(mcc);
        try {
            resolvedExpression = client.resolveExpression(expression);
            while (resolvedExpression != null && resolvedExpression.contains("${") && !resolvedExpression.equals(expression)) {
                expression = resolvedExpression;
                resolvedExpression = client.resolveExpression(expression);
            }
        }
        catch (Exception e) {
            LOG.warn((Object)("Cannot resolve expression [" + expression + "]; will use it as-is but errors may occur later."));
            resolvedExpression = expression;
        }
        return resolvedExpression;
    }

    private static WebJBossASClient.ConnectorConfiguration buildSecureConnectorConfiguration(String configDirStr, HashMap<String, String> serverProperties) {
        WebJBossASClient.SSLConfiguration ssl = new WebJBossASClient.SSLConfiguration();
        ssl.setCaCertificateFile(ServerInstallUtil.buildExpression("rhq.server.tomcat.security.truststore.file", serverProperties, true));
        ssl.setCaCertificationPassword(ServerInstallUtil.buildExpression("rhq.server.tomcat.security.truststore.password", serverProperties, true));
        ssl.setTruststoreType(ServerInstallUtil.buildExpression("rhq.server.tomcat.security.truststore.type", serverProperties, true));
        ssl.setCertificateKeyFile(ServerInstallUtil.buildExpression("rhq.server.tomcat.security.keystore.file", serverProperties, true));
        ssl.setPassword(ServerInstallUtil.buildExpression("rhq.server.tomcat.security.keystore.password", serverProperties, true));
        ssl.setKeyAlias(ServerInstallUtil.buildExpression("rhq.server.tomcat.security.keystore.alias", serverProperties, true));
        ssl.setKeystoreType(ServerInstallUtil.buildExpression("rhq.server.tomcat.security.keystore.type", serverProperties, true));
        ssl.setProtocol(ServerInstallUtil.buildExpression("rhq.server.tomcat.security.secure-socket-protocol", serverProperties, true));
        ssl.setVerifyClient(ServerInstallUtil.buildExpression("rhq.server.tomcat.security.client-auth-mode", serverProperties, true));
        WebJBossASClient.ConnectorConfiguration connector = new WebJBossASClient.ConnectorConfiguration();
        connector.setMaxConnections(ServerInstallUtil.buildExpression("rhq.server.startup.web.max-connections", serverProperties, true));
        connector.setScheme("https");
        connector.setSocketBinding("https");
        connector.setSslConfiguration(ssl);
        return connector;
    }

    private static String getAbsoluteFileLocation(String propertyName, HashMap<String, String> properties, String defaultRootDir) {
        if (properties == null || !properties.containsKey(propertyName)) {
            return null;
        }
        String propertyValue = properties.get(propertyName);
        File path = new File(propertyValue);
        if (path.isAbsolute()) {
            return path.getAbsolutePath();
        }
        return new File(defaultRootDir, propertyValue).getAbsolutePath();
    }

    private static String buildExpression(String propName, HashMap<String, String> defaultProperties, boolean supportsExpression) {
        if (supportsExpression) {
            if (defaultProperties != null && defaultProperties.containsKey(propName)) {
                return "${" + propName + ":" + defaultProperties.get(propName) + "}";
            }
            return "${" + propName + "}";
        }
        if (defaultProperties != null && defaultProperties.containsKey(propName)) {
            return defaultProperties.get(propName);
        }
        LOG.warn((Object)("There is no known value for property [" + propName + "]"));
        return "";
    }

    public static File createKeystore(ServerDetails serverDetails, String configDirStr) {
        File keystore;
        block4: {
            File confDir = new File(configDirStr);
            keystore = new File(confDir, "rhq.keystore");
            File keystoreBackup = new File(confDir, "rhq.keystore.backup");
            if (keystore.exists()) {
                keystoreBackup.delete();
                if (!keystore.renameTo(keystoreBackup)) {
                    LOG.warn((Object)("Cannot backup existing keystore - cannot generate a new cert with a proper domain name. [" + keystore + "] will be the keystore used by this server"));
                    return keystore;
                }
            }
            try {
                String keystorePassword;
                String keystorePath = keystore.getAbsolutePath();
                String keyAlias = "RHQ";
                String domainName = "CN=" + serverDetails.getEndpointAddress() + ", OU=RHQ, O=rhq-project.org, C=US";
                String keyPassword = keystorePassword = "RHQManagement";
                String keyAlgorithm = "rsa";
                int validity = 7300;
                SecurityUtil.createKeyStore((String)keystorePath, (String)keyAlias, (String)domainName, (String)keystorePassword, (String)keyPassword, (String)keyAlgorithm, (int)validity);
                LOG.info((Object)("New keystore created [" + keystorePath + "] with cert domain name of [" + domainName + "]"));
            }
            catch (Exception e) {
                LOG.warn((Object)"Could not generate a new cert with a proper domain name, will use the original keystore");
                keystore.delete();
                if (keystoreBackup.renameTo(keystore)) break block4;
                LOG.warn((Object)("Failed to restore the original keystore from backup - please rename [" + keystoreBackup + "] to [" + keystore + "]"));
            }
        }
        return keystore;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createDefaultManagementUser(ServerDetails serverDetails, String configDirStr) {
        block7: {
            File mgmtUsers;
            block8: {
                File confDir = new File(configDirStr);
                mgmtUsers = new File(confDir, "mgmt-users.properties");
                if (!mgmtUsers.exists()) break block8;
                try {
                    PropertiesFileUpdate mgmtUsersPropFile = new PropertiesFileUpdate(mgmtUsers.getAbsolutePath());
                    Properties existingUsers = mgmtUsersPropFile.loadExistingProperties();
                    if (existingUsers.containsKey(RHQ_MGMT_USER)) {
                        LOG.info((Object)"There is already a mgmt user named [rhqadmin], will not create another");
                        return;
                    }
                }
                catch (Exception e) {
                    LOG.warn((Object)("Cannot determine if mgmt user exists in [" + mgmtUsers + "]; will try to create it anyway"), (Throwable)e);
                }
                FileOutputStream fos = null;
                try {
                    fos = new FileOutputStream(mgmtUsers, true);
                    fos.write("\nrhqadmin=35c160c1f841a889d4cda53f0bfc94b6\n".getBytes());
                }
                catch (Exception e) {
                    try {
                        LOG.warn((Object)("Could not create default management user in file: [" + mgmtUsers + "] : "), (Throwable)e);
                    }
                    catch (Throwable throwable) {
                        StreamUtil.safeClose(fos);
                        throw throwable;
                    }
                    StreamUtil.safeClose((Closeable)fos);
                    break block7;
                }
                StreamUtil.safeClose((Closeable)fos);
                break block7;
            }
            LOG.warn((Object)("Could not create default management user. Could not find file: [" + mgmtUsers + "]"));
        }
    }

    public static void setSocketBindings(ModelControllerClient mcc, HashMap<String, String> serverProperties) throws Exception {
        SocketBindingJBossASClient client = new SocketBindingJBossASClient(mcc);
        for (SocketBindingInfo binding : defaultSocketBindings) {
            int newPort = binding.port;
            String overrideValue = serverProperties.get(binding.sysprop);
            if (overrideValue != null) {
                try {
                    newPort = Integer.parseInt(overrideValue);
                }
                catch (Exception e) {
                    LOG.warn((Object)("Invalid port in system property [" + binding.sysprop + "]: " + overrideValue));
                }
            }
            LOG.info((Object)String.format("Setting socket binding [%s] to [${%s:%d}]", binding.name, binding.sysprop, newPort));
            try {
                client.setStandardSocketBindingPortExpression(binding.name, binding.sysprop, newPort);
            }
            catch (Exception e) {
                if (binding.required) {
                    throw e;
                }
                LOG.info((Object)String.format("Setting socket binding: [%s] resulted in [%s] -- this is harmless ", binding.name, e.getMessage()));
            }
        }
    }

    static {
        defaultSocketBindings.add(new SocketBindingInfo("ajp", "rhq.server.socket.binding.port.ajp", 7009));
        defaultSocketBindings.add(new SocketBindingInfo("http", "rhq.server.socket.binding.port.http", 7080));
        defaultSocketBindings.add(new SocketBindingInfo("https", "rhq.server.socket.binding.port.https", 7443));
        defaultSocketBindings.add(new SocketBindingInfo("jacorb", "rhq.server.socket.binding.port.jacorb", 2528));
        defaultSocketBindings.add(new SocketBindingInfo("jacorb-ssl", "rhq.server.socket.binding.port.jacorb-ssl", 2529));
        defaultSocketBindings.add(new SocketBindingInfo("messaging", "rhq.server.socket.binding.port.messaging", 4445));
        defaultSocketBindings.add(new SocketBindingInfo("messaging-throughput", "rhq.server.socket.binding.port.messaging-throughput", 4455));
        defaultSocketBindings.add(new SocketBindingInfo("management-http", "jboss.management.http.port", 6990));
        defaultSocketBindings.add(new SocketBindingInfo("management-https", "jboss.management.https.port", 6443));
        defaultSocketBindings.add(new SocketBindingInfo("management-native", "jboss.management.native.port", 6999));
        defaultSocketBindings.add(new SocketBindingInfo("osgi-http", "rhq.server.socket.binding.port.osgi-http", 7090, false));
        defaultSocketBindings.add(new SocketBindingInfo("remoting", "rhq.server.socket.binding.port.remoting", 3447));
        defaultSocketBindings.add(new SocketBindingInfo("txn-recovery-environment", "rhq.server.socket.binding.port.txn-recovery-environment", 3712));
        defaultSocketBindings.add(new SocketBindingInfo("txn-status-manager", "rhq.server.socket.binding.port.txn-status-manager", 3713));
    }

    private static class SocketBindingInfo {
        public String name;
        public String sysprop;
        public int port;
        public boolean required = true;

        public SocketBindingInfo(String n, String s, int p) {
            this.name = n;
            this.sysprop = s;
            this.port = p;
        }

        public SocketBindingInfo(String name, String sysprop, int port, boolean required) {
            this.name = name;
            this.port = port;
            this.required = required;
            this.sysprop = sysprop;
        }
    }

    public static enum SupportedDatabaseType {
        POSTGRES,
        ORACLE;

    }

    public static enum ExistingSchemaOption {
        OVERWRITE,
        KEEP,
        SKIP;

    }
}

