/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.installer;

import java.util.Properties;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import org.rhq.enterprise.installer.ConfigurationBean;
import org.rhq.enterprise.installer.ServerInformation;
import org.rhq.enterprise.installer.StartPageResults;

public class AutoInstallServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;

    public void init() throws ServletException {
        ServerInformation serverInfo = new ServerInformation();
        Properties serverProperties = serverInfo.getServerProperties();
        String enabledString = serverProperties.getProperty("rhq.autoinstall.enabled");
        boolean enabled = Boolean.parseBoolean(enabledString);
        if (enabled) {
            this.log("Server is preconfigured - performing auto-install immediately...");
            try {
                ConfigurationBean configBean = new ConfigurationBean();
                configBean.setHaServerFromPropertiesOnly();
                StartPageResults results = configBean.save();
                if (results != StartPageResults.SUCCESS) {
                    throw new Exception("Save failed - check logs for error messages");
                }
            }
            catch (Throwable t) {
                this.log("The server was preconfigured but it failed to auto-install!", t);
                throw new ServletException(t);
            }
            this.log("Server has been auto-installed and should be ready shortly.");
        } else {
            this.log("Server is not preconfigured - will not perform auto-install. Please perform a manual install.");
        }
    }
}

