/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.installer;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.management.MBeanServer;
import javax.management.MBeanServerInvocationHandler;
import javax.management.ObjectName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.tools.ant.BuildListener;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.helper.ProjectHelper2;
import org.jboss.mx.util.MBeanServerLocator;
import org.jboss.mx.util.ObjectNameFactory;
import org.jboss.security.auth.login.XMLLoginConfigMBean;
import org.jboss.system.server.ServerConfig;
import org.rhq.core.db.DatabaseType;
import org.rhq.core.db.DatabaseTypeFactory;
import org.rhq.core.db.DbUtil;
import org.rhq.core.db.H2DatabaseType;
import org.rhq.core.db.OracleDatabaseType;
import org.rhq.core.db.PostgresqlDatabaseType;
import org.rhq.core.db.SQLServerDatabaseType;
import org.rhq.core.db.setup.DBSetup;
import org.rhq.core.util.PropertiesFileUpdate;
import org.rhq.core.util.jdbc.JDBCUtil;
import org.rhq.enterprise.communications.util.SecurityUtil;
import org.rhq.enterprise.installer.LoggerAntBuildListener;
import org.rhq.enterprise.installer.ServerInformation;
import org.rhq.enterprise.installer.ServerProperties;

/*
 * Exception performing whole class analysis ignored.
 */
public class ServerInformation {
    private static final Log LOG = LogFactory.getLog(ServerInformation.class);
    private static final String DEPLOYED_EAR_FILENAME = "rhq.ear";
    private static final String UNDEPLOYED_EAR_FILENAME = "rhq.ear.rej";
    private static final String DEPLOYED_DS_FILENAME = "rhq-ds.xml";
    private static final String UNDEPLOYED_POSTGRES_DS_FILENAME = "rhq-ds.xml.postgres.rej";
    private static final String UNDEPLOYED_ORACLE_DS_FILENAME = "rhq-ds.xml.oracle.rej";
    private static final String UNDEPLOYED_H2_DS_FILENAME = "rhq-ds.xml.h2.rej";
    private static final String UNDEPLOYED_SQLSERVER_DS_FILENAME = "rhq-ds.xml.sqlserver.rej";
    private static final String DEPLOYED_EMBEDDED_AGENT_FILENAME = "rhq-agent.sar";
    private static final String UNDEPLOYED_EMBEDDED_AGENT_FILENAME = "rhq-agent.sar.rej";
    private static final String DEPLOYED_MAIL_SERVICE_FILENAME = "mail-service.xml";
    private static final String UNDEPLOYED_MAIL_SERVICE_FILENAME = "mail-service.xml.rej";
    private static final String DEPLOYED_ALERT_CACHE_SERVICE_FILENAME = "alert-cache-service.xml";
    private static final String UNDEPLOYED_ALERT_CACHE_SERVICE_FILENAME = "alert-cache-service.xml.rej";
    private static final String DEPLOYED_JMS_FILENAME = "jms";
    private static final String UNDEPLOYED_POSTGRES_JMS_FILENAME = "jms-postgres.rej";
    private static final String UNDEPLOYED_ORACLE_JMS_FILENAME = "jms-oracle.rej";
    private static final String UNDEPLOYED_H2_JMS_FILENAME = "jms-h2.rej";
    private static final String UNDEPLOYED_SQLSERVER_JMS_FILENAME = "jms-sqlserver.rej";
    private static final String SERVER_PROPERTIES_FILENAME = "rhq-server.properties";
    private MBeanServer mbeanServer = null;
    private File deployDirectory = null;
    private File binDirectory = null;
    private File logDirectory = null;
    private File dataDirectory = null;
    private File confDirectory = null;

    public boolean isDatabaseConnectionValid(Properties props) {
        if (props == null) {
            props = this.getServerProperties();
        }
        String jdbcUrl = props.getProperty("rhq.server.database.connection-url", "-unknown-");
        String userName = props.getProperty("rhq.server.database.user-name", "-unknown-");
        String password = props.getProperty("rhq.server.database.password", "-unknown-");
        return DbUtil.ping((String)jdbcUrl, (String)userName, (String)password);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void ensureDatabaseIsSupported(Properties props) throws Exception {
        Connection conn = null;
        DatabaseType db = null;
        try {
            conn = this.getDatabaseConnection(props);
            db = DatabaseTypeFactory.getDatabaseType((Connection)conn);
            String version = db.getVersion();
            if (DatabaseTypeFactory.isPostgres((DatabaseType)db)) {
                if (version.startsWith("7") || version.equals("8") || version.startsWith("8.0") || version.startsWith("8.1")) {
                    throw new Exception("Unsupported PostgreSQL [" + db + "]");
                }
            } else if (DatabaseTypeFactory.isOracle((DatabaseType)db)) {
                if (version.startsWith("8") || version.startsWith("9")) {
                    throw new Exception("Unsupported Oracle [" + db + "]");
                }
            } else if (DatabaseTypeFactory.isH2((DatabaseType)db)) {
                if (version.startsWith("1.0")) {
                    throw new Exception("Unsupported H2 [" + db + "]");
                }
            } else if (DatabaseTypeFactory.isSQLServer((DatabaseType)db)) {
                if (version.startsWith("2000")) {
                    throw new Exception("Unsupported SQL Server [" + db + "]");
                }
            } else {
                throw new Exception("Unsupported DB [" + db + "]");
            }
            LOG.info((Object)("Database is supported: " + db));
        }
        finally {
            if (db != null) {
                db.closeConnection(conn);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isDatabaseSchemaExist(Properties props) throws Exception {
        Connection conn = this.getDatabaseConnection(props);
        DatabaseType db = DatabaseTypeFactory.getDatabaseType((Connection)conn);
        try {
            boolean bl = db.checkTableExists(conn, "RHQ_PRINCIPAL");
            return bl;
        }
        finally {
            db.closeConnection(conn);
        }
    }

    public void createNewDatabaseSchema(Properties props) throws Exception {
        if (props == null) {
            props = this.getServerProperties();
        }
        String jdbcUrl = props.getProperty("rhq.server.database.connection-url", "-unknown-");
        String userName = props.getProperty("rhq.server.database.user-name", "-unknown-");
        String password = props.getProperty("rhq.server.database.password", "-unknown-");
        try {
            String dbsetupSchemaXmlFile = this.extractDatabaseXmlFile("db-schema-combined.xml", props);
            String dbsetupDataXmlFile = this.extractDatabaseXmlFile("db-data-combined.xml", props);
            DBSetup dbsetup = new DBSetup(jdbcUrl, userName, password);
            dbsetup.uninstall(dbsetupSchemaXmlFile);
            dbsetup.setup(dbsetupSchemaXmlFile);
            dbsetup.setup(dbsetupDataXmlFile, null, true, false);
        }
        catch (Exception e) {
            LOG.fatal((Object)"Cannot install the database schema - RHQ Server will not run properly", (Throwable)e);
            throw e;
        }
    }

    public void upgradeExistingDatabaseSchema(Properties props) throws Exception {
        if (props == null) {
            props = this.getServerProperties();
        }
        String jdbcUrl = props.getProperty("rhq.server.database.connection-url", "-unknown-");
        String userName = props.getProperty("rhq.server.database.user-name", "-unknown-");
        String password = props.getProperty("rhq.server.database.password", "-unknown-");
        File logfile = new File(this.getLogDirectory(), "rhq-installer-dbupgrade.log");
        logfile.delete();
        try {
            String dbupgradeXmlFile = this.extractDatabaseXmlFile("db-upgrade.xml", props);
            Properties antProps = new Properties();
            antProps.setProperty("jdbc.url", jdbcUrl);
            antProps.setProperty("jdbc.user", userName);
            antProps.setProperty("jdbc.password", password);
            antProps.setProperty("target.schema.version", "LATEST");
            this.startAnt(new File(dbupgradeXmlFile), "db-ant-tasks.properties", antProps, logfile);
        }
        catch (Exception e) {
            LOG.fatal((Object)"Cannot upgrade the database schema - RHQ Server will not run properly", (Throwable)e);
            throw e;
        }
    }

    public Properties getServerProperties() {
        Properties properties;
        File file = this.getServerPropertiesFile();
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(file);
            Properties props = new Properties();
            props.load(fis);
            properties = props;
        }
        catch (Exception e) {
            try {
                throw new RuntimeException("Cannot load configuration from [" + file + "]. Cause:" + e, e);
            }
            catch (Throwable throwable) {
                JDBCUtil.safeClose(fis);
                throw throwable;
            }
        }
        JDBCUtil.safeClose((InputStream)fis);
        return properties;
    }

    public void setServerProperties(Properties props) {
        this.clearNullProperties(props);
        File file = this.getServerPropertiesFile();
        try {
            PropertiesFileUpdate updater = new PropertiesFileUpdate(file.getAbsolutePath());
            updater.update(props);
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot store configuration to [" + file + "]. Cause:" + e, e);
        }
        for (Map.Entry<Object, Object> entry : props.entrySet()) {
            System.setProperty(entry.getKey().toString(), entry.getValue().toString());
        }
    }

    public void moveDeploymentArtifacts(boolean deploy) {
        try {
            File mail = this.getMailServiceFile(!deploy);
            File mailRenameTo = this.getMailServiceFile(deploy);
            if (!mailRenameTo.exists()) {
                mail.renameTo(mailRenameTo);
            }
            File agent = this.getEmbeddedAgentFile(!deploy);
            File agentRenameTo = this.getEmbeddedAgentFile(deploy);
            if (!agentRenameTo.exists()) {
                agent.renameTo(agentRenameTo);
            }
            File ds = this.getDataSourceFile(true);
            if (deploy) {
                File undeployedDataSource = this.getDataSourceFile(false);
                this.copySingleFile(undeployedDataSource, ds);
            } else {
                this.deleteFile(ds);
            }
            File jms = this.getJmsFile(true);
            if (deploy) {
                File undeployedJms = this.getJmsFile(false);
                this.copyDirectory(undeployedJms, jms);
            } else {
                this.deleteFile(jms);
            }
            File alertCache = this.getAlertCacheServiceFile(!deploy);
            File alertCacheRenameTo = this.getAlertCacheServiceFile(deploy);
            if (!alertCacheRenameTo.exists()) {
                alertCache.renameTo(alertCacheRenameTo);
            }
            File ear = this.getEarFile(!deploy);
            File earRenameTo = this.getEarFile(deploy);
            if (!earRenameTo.exists()) {
                ear.renameTo(earRenameTo);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to move deployment artifacts. Cause: " + e, e);
        }
    }

    public boolean isFullyDeployed() {
        File ear = this.getEarFile(true);
        File agent = this.getEmbeddedAgentFile(true);
        File jms = this.getJmsFile(true);
        File ds = this.getDataSourceFile(true);
        File mail = this.getMailServiceFile(true);
        File alert = this.getAlertCacheServiceFile(true);
        return ds.exists() && jms.exists() && ear.exists() && agent.exists() && mail.exists() && alert.exists();
    }

    private File getEarFile(boolean deployed) {
        File deployDir = this.getDeployDirectory();
        File file = new File(deployDir, deployed ? "rhq.ear" : "rhq.ear.rej");
        return file;
    }

    private File getMailServiceFile(boolean deployed) {
        File deployDir = this.getDeployDirectory();
        File file = new File(deployDir, deployed ? "mail-service.xml" : "mail-service.xml.rej");
        return file;
    }

    private File getAlertCacheServiceFile(boolean deployed) {
        File deployDir = this.getDeployDirectory();
        File file = new File(deployDir, deployed ? "alert-cache-service.xml" : "alert-cache-service.xml.rej");
        return file;
    }

    private File getEmbeddedAgentFile(boolean deployed) {
        File deployDir = this.getDeployDirectory();
        File file = new File(deployDir, deployed ? "rhq-agent.sar" : "rhq-agent.sar.rej");
        return file;
    }

    private File getDataSourceFile(boolean deployed) {
        File file;
        File deployDir = this.getDeployDirectory();
        if (deployed) {
            file = new File(deployDir, "rhq-ds.xml");
        } else {
            String db = this.getServerProperties().getProperty("rhq.server.database.type-mapping");
            if (db.toLowerCase().indexOf("postgres") > -1) {
                file = new File(deployDir, "rhq-ds.xml.postgres.rej");
            } else if (db.toLowerCase().indexOf("oracle") > -1) {
                file = new File(deployDir, "rhq-ds.xml.oracle.rej");
            } else if (db.toLowerCase().indexOf("h2") > -1) {
                file = new File(deployDir, "rhq-ds.xml.h2.rej");
            } else if (db.toLowerCase().indexOf("sqlserver") > -1) {
                file = new File(deployDir, "rhq-ds.xml.sqlserver.rej");
            } else {
                throw new RuntimeException("Unsupported database: " + db);
            }
        }
        return file;
    }

    private File getJmsFile(boolean deployed) {
        File file;
        File deployDir = this.getDeployDirectory();
        if (deployed) {
            file = new File(deployDir, "jms");
        } else {
            String db = this.getServerProperties().getProperty("rhq.server.database.type-mapping");
            if (db.toLowerCase().indexOf("postgres") > -1) {
                file = new File(deployDir, "jms-postgres.rej");
            } else if (db.toLowerCase().indexOf("oracle") > -1) {
                file = new File(deployDir, "jms-oracle.rej");
            } else if (db.toLowerCase().indexOf("h2") > -1) {
                file = new File(deployDir, "jms-h2.rej");
            } else if (db.toLowerCase().indexOf("sqlserver") > -1) {
                file = new File(deployDir, "jms-sqlserver.rej");
            } else {
                throw new RuntimeException("Unsupported database: " + db);
            }
        }
        return file;
    }

    private void clearNullProperties(Properties props) {
        String bindAddr = props.getProperty("jboss.bind.address");
        if (bindAddr != null && bindAddr.trim().length() == 0) {
            props.remove("jboss.bind.address");
        }
    }

    private File getServerPropertiesFile() {
        File binDir = this.getBinDirectory();
        File file = new File(binDir, "rhq-server.properties");
        return file;
    }

    private File getDeployDirectory() {
        if (this.deployDirectory == null) {
            MBeanServer mbs = this.getMBeanServer();
            ObjectName name = ObjectNameFactory.create((String)"jboss.system:type=ServerConfig");
            ServerConfig mbean = MBeanServerInvocationHandler.newProxyInstance(mbs, name, ServerConfig.class, false);
            this.deployDirectory = new File(mbean.getServerHomeDir(), "deploy");
        }
        return this.deployDirectory;
    }

    private File getBinDirectory() {
        if (this.binDirectory == null) {
            MBeanServer mbs = this.getMBeanServer();
            ObjectName name = ObjectNameFactory.create((String)"jboss.system:type=ServerConfig");
            ServerConfig mbean = MBeanServerInvocationHandler.newProxyInstance(mbs, name, ServerConfig.class, false);
            File homeDir = mbean.getHomeDir();
            this.binDirectory = new File(homeDir.getParentFile(), "bin");
        }
        return this.binDirectory;
    }

    File getLogDirectory() {
        if (this.logDirectory == null) {
            MBeanServer mbs = this.getMBeanServer();
            ObjectName name = ObjectNameFactory.create((String)"jboss.system:type=ServerConfig");
            ServerConfig mbean = MBeanServerInvocationHandler.newProxyInstance(mbs, name, ServerConfig.class, false);
            File homeDir = mbean.getHomeDir();
            this.logDirectory = new File(homeDir.getParentFile(), "logs");
            this.logDirectory.mkdirs();
        }
        return this.logDirectory;
    }

    void setLogDirectory(File dir) {
        this.logDirectory = dir;
    }

    public File getDataDirectory() {
        if (this.dataDirectory == null) {
            MBeanServer mbs = this.getMBeanServer();
            ObjectName name = ObjectNameFactory.create((String)"jboss.system:type=ServerConfig");
            ServerConfig mbean = MBeanServerInvocationHandler.newProxyInstance(mbs, name, ServerConfig.class, false);
            this.dataDirectory = new File(mbean.getServerHomeDir(), "data");
            this.dataDirectory.mkdirs();
        }
        return this.dataDirectory;
    }

    private File getConfDirectory() {
        if (this.confDirectory == null) {
            MBeanServer mbs = this.getMBeanServer();
            ObjectName name = ObjectNameFactory.create((String)"jboss.system:type=ServerConfig");
            ServerConfig mbean = MBeanServerInvocationHandler.newProxyInstance(mbs, name, ServerConfig.class, false);
            this.confDirectory = new File(mbean.getServerHomeDir(), "conf");
        }
        return this.confDirectory;
    }

    private MBeanServer getMBeanServer() {
        if (this.mbeanServer == null) {
            this.mbeanServer = MBeanServerLocator.locateJBoss();
        }
        return this.mbeanServer;
    }

    private void deleteFile(File file) {
        if (file != null) {
            if (file.isDirectory()) {
                File[] doomedFiles = file.listFiles();
                if (doomedFiles != null) {
                    for (File doomedFile : doomedFiles) {
                        this.deleteFile(doomedFile);
                    }
                }
            } else {
                file.delete();
            }
        }
    }

    private void copyDirectory(File from, File to) throws Exception {
        File[] children;
        to.mkdirs();
        for (File fromChild : children = from.listFiles()) {
            File toChild = new File(to, fromChild.getName());
            if (fromChild.isDirectory()) {
                this.copyDirectory(fromChild, toChild);
                continue;
            }
            this.copySingleFile(fromChild, toChild);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copySingleFile(File from, File to) throws Exception {
        FileInputStream fis = new FileInputStream(from);
        FileOutputStream fos = new FileOutputStream(to);
        try {
            byte[] buf = new byte[1024];
            int i = 0;
            while ((i = fis.read(buf)) != -1) {
                fos.write(buf, 0, i);
            }
        }
        finally {
            JDBCUtil.safeClose((InputStream)fis);
            JDBCUtil.safeClose((OutputStream)fos);
        }
    }

    public Connection getDatabaseConnection(Properties props) throws SQLException {
        if (props == null) {
            props = this.getServerProperties();
        }
        String jdbcUrl = props.getProperty("rhq.server.database.connection-url", "-unknown-");
        String userName = props.getProperty("rhq.server.database.user-name", "-unknown-");
        String password = props.getProperty("rhq.server.database.password", "-unknown-");
        return DbUtil.getConnection((String)jdbcUrl, (String)userName, (String)password);
    }

    private String extractDatabaseXmlFile(String xmlFileName, Properties props) throws IOException {
        InputStream resourceInStream = this.getClass().getClassLoader().getResourceAsStream(xmlFileName);
        ByteArrayOutputStream contentOutStream = new ByteArrayOutputStream();
        this.copyStreamData(resourceInStream, (OutputStream)contentOutStream);
        String content = contentOutStream.toString();
        content = content.replaceAll("@@@LARGE_TABLESPACE_FOR_DATA@@@", "DEFAULT");
        content = content.replaceAll("@@@LARGE_TABLESPACE_FOR_INDEX@@@", "DEFAULT");
        content = content.replaceAll("@@@ADMINUSERNAME@@@", "rhqadmin");
        content = content.replaceAll("@@@ADMINPASSWORD@@@", "x1XwrxKuPvYUILiOnOZTLg==");
        content = content.replaceAll("@@@ADMINEMAIL@@@", props.getProperty("rhq.server.email.from-address"));
        content = content.replaceAll("@@@BASEURL@@@", "http://" + ServerProperties.getValidServerBindAddress((Properties)props) + ":" + ServerProperties.getHttpPort((Properties)props) + "/");
        content = content.replaceAll("@@@JAASPROVIDER@@@", "JDBC");
        content = content.replaceAll("@@@LDAPURL@@@", "ldap://localhost/");
        content = content.replaceAll("@@@LDAPPROTOCOL@@@", "");
        content = content.replaceAll("@@@LDAPLOGINPROP@@@", "cn");
        content = content.replaceAll("@@@LDAPBASEDN@@@", "o=JBoss,c=US");
        content = content.replaceAll("@@@LDAPSEARCHFILTER@@@", "");
        content = content.replaceAll("@@@LDAPBINDDN@@@", "");
        content = content.replaceAll("@@@LDAPBINDPW@@@", "");
        content = content.replaceAll("@@@MULTICAST_ADDR@@@", "");
        content = content.replaceAll("@@@MULTICAST_PORT@@@", "");
        File xmlFile = new File(this.getLogDirectory(), xmlFileName);
        FileOutputStream xmlFileOutStream = new FileOutputStream(xmlFile);
        ByteArrayInputStream contentInStream = new ByteArrayInputStream(content.getBytes());
        this.copyStreamData((InputStream)contentInStream, (OutputStream)xmlFileOutStream);
        return xmlFile.getAbsolutePath();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyStreamData(InputStream input, OutputStream output) throws IOException {
        int bufferSize = 32768;
        try {
            input = new BufferedInputStream(input, bufferSize);
            byte[] buffer = new byte[bufferSize];
            int bytesRead = input.read(buffer);
            while (bytesRead != -1) {
                output.write(buffer, 0, bytesRead);
                bytesRead = input.read(buffer);
            }
            output.flush();
        }
        finally {
            JDBCUtil.safeClose((OutputStream)output);
            JDBCUtil.safeClose((InputStream)input);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startAnt(File buildFile, String customTaskDefs, Properties properties, File logFile) {
        PrintWriter logFileOutput = null;
        try {
            logFileOutput = new PrintWriter(new FileOutputStream(logFile));
            ClassLoader classLoader = this.getClass().getClassLoader();
            Properties taskDefs = new Properties();
            InputStream taskDefsStream = classLoader.getResourceAsStream(customTaskDefs);
            try {
                taskDefs.load(taskDefsStream);
            }
            finally {
                taskDefsStream.close();
            }
            Project project = new Project();
            project.setCoreLoader(classLoader);
            project.init();
            for (Map.Entry<Object, Object> property : properties.entrySet()) {
                project.setProperty(property.getKey().toString(), property.getValue().toString());
            }
            project.addBuildListener((BuildListener)new LoggerAntBuildListener(logFileOutput));
            for (Map.Entry<Object, Object> taskDef : taskDefs.entrySet()) {
                project.addTaskDefinition(taskDef.getKey().toString(), Class.forName(taskDef.getValue().toString(), true, classLoader));
            }
            new ProjectHelper2().parse(project, (Object)buildFile);
            project.executeTarget(project.getDefaultTarget());
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot run ANT on script [" + buildFile + "]. Cause: " + e, e);
        }
        finally {
            if (logFileOutput != null) {
                logFileOutput.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanJmsTables(Properties props) {
        Connection conn = null;
        Statement stm = null;
        try {
            conn = this.getDatabaseConnection(props);
            stm = conn.createStatement();
            stm.executeUpdate("DELETE FROM JMS_MESSAGES");
        }
        catch (SQLException e) {
            LOG.info((Object)("Was not able to delete existing JMS messages: " + e.getMessage()));
        }
        finally {
            try {
                if (null != stm) {
                    stm.close();
                }
            }
            catch (Exception e) {}
            try {
                if (null != conn) {
                    conn.close();
                }
            }
            catch (Exception e) {}
        }
    }

    public void restartLoginConfig() throws Exception {
        XMLLoginConfigMBean mbean;
        MBeanServer mbs = this.getMBeanServer();
        ObjectName name = ObjectNameFactory.create((String)"jboss.security:service=XMLLoginConfig");
        XMLLoginConfigMBean conf = mbean = MBeanServerInvocationHandler.newProxyInstance(mbs, name, XMLLoginConfigMBean.class, false);
        conf.stop();
        conf.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public List<String> getServerNames(Properties props) throws Exception {
        DatabaseType db = null;
        Connection conn = null;
        Statement stm = null;
        ResultSet rs = null;
        ArrayList<String> result = new ArrayList<String>();
        try {
            conn = this.getDatabaseConnection(props);
            db = DatabaseTypeFactory.getDatabaseType((Connection)conn);
            if (db.checkTableExists(conn, "rhq_server")) {
                stm = conn.createStatement();
                rs = stm.executeQuery("SELECT name FROM rhq_server ORDER BY name asc");
                while (rs.next()) {
                    result.add(rs.getString(1));
                }
            }
            if (null == db) return result;
        }
        catch (SQLException e) {
            try {
                LOG.info((Object)("Unable to fetch existing server info: " + e.getMessage()));
                if (null == db) return result;
            }
            catch (Throwable throwable) {
                if (null == db) throw throwable;
                db.closeJDBCObjects(conn, stm, rs);
                throw throwable;
            }
            db.closeJDBCObjects(conn, stm, rs);
            return result;
        }
        db.closeJDBCObjects(conn, stm, rs);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private int getAffinityGroupId(DatabaseType db, Connection conn, String affinityGroup) {
        PreparedStatement stm = null;
        ResultSet rs = null;
        int result = -1;
        if (null == affinityGroup || "".equals(affinityGroup)) {
            return result;
        }
        try {
            stm = conn.prepareStatement("SELECT id FROM rhq_affinity_group WHERE name = ?");
            stm.setString(1, affinityGroup.trim());
            rs = stm.executeQuery();
            if (rs.next()) {
                result = rs.getInt(1);
            }
            if (null == db) return result;
        }
        catch (SQLException e) {
            try {
                LOG.info((Object)("Unable to get affinity group id: " + e.getMessage()));
                if (null == db) return result;
            }
            catch (Throwable throwable) {
                if (null == db) throw throwable;
                db.closeResultSet(rs);
                db.closeStatement((Statement)stm);
                throw throwable;
            }
            db.closeResultSet(rs);
            db.closeStatement((Statement)stm);
            return result;
        }
        db.closeResultSet(rs);
        db.closeStatement((Statement)stm);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String getAffinityGroup(DatabaseType db, Connection conn, String serverName) {
        PreparedStatement stm = null;
        ResultSet rs = null;
        String result = null;
        if (null == serverName) {
            return result;
        }
        try {
            stm = conn.prepareStatement("SELECT ag.name FROM rhq_affinity_group ag JOIN rhq_server s ON ag.id = s.affinity_group_id WHERE s.name = ?");
            stm.setString(1, serverName.trim());
            rs = stm.executeQuery();
            if (rs.next()) {
                result = rs.getString(1);
            }
            if (null == db) return result;
        }
        catch (SQLException e) {
            try {
                LOG.info((Object)("Unable to get affinity group name for server: " + e.getMessage()));
                if (null == db) return result;
            }
            catch (Throwable throwable) {
                if (null == db) throw throwable;
                db.closeResultSet(rs);
                db.closeStatement((Statement)stm);
                throw throwable;
            }
            db.closeResultSet(rs);
            db.closeStatement((Statement)stm);
            return result;
        }
        db.closeResultSet(rs);
        db.closeStatement((Statement)stm);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getAffinityGroupForServer(Properties props, String serverName) {
        DatabaseType db = null;
        Connection conn = null;
        String result = null;
        try {
            conn = this.getDatabaseConnection(props);
            db = DatabaseTypeFactory.getDatabaseType((Connection)conn);
            result = this.getAffinityGroup(db, conn, serverName);
        }
        catch (Exception e) {
            LOG.info((Object)("Unable to get affinity group for server: " + e.getMessage()));
        }
        finally {
            if (null != db) {
                db.closeConnection(conn);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void insertAffinityGroup(DatabaseType db, Connection conn, String affinityGroup) {
        PreparedStatement stm = null;
        ResultSet rs = null;
        if (null == affinityGroup) {
            return;
        }
        if ("".equals(affinityGroup = affinityGroup.trim())) {
            return;
        }
        try {
            int i = 1;
            if (db instanceof SQLServerDatabaseType) {
                stm = conn.prepareStatement("INSERT INTO rhq_affinity_group ( name ) VALUES ( ? )");
            } else if (db instanceof PostgresqlDatabaseType || db instanceof OracleDatabaseType || db instanceof H2DatabaseType) {
                stm = conn.prepareStatement("INSERT INTO rhq_affinity_group ( id, name ) VALUES ( ?, ? )");
                stm.setInt(i++, db.getNextSequenceValue(conn, "rhq_affinity_group", "id"));
            } else {
                throw new IllegalArgumentException("Unknown database type, can't continue: " + db);
            }
            stm.setString(i++, affinityGroup);
            stm.executeUpdate();
        }
        catch (SQLException e) {
            LOG.info((Object)("Unable to insert affinity group: " + e.getMessage()));
        }
        finally {
            if (null != db) {
                db.closeResultSet(rs);
                db.closeStatement((Statement)stm);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Server getServer(DatabaseType db, Connection conn, String serverName) {
        PreparedStatement stm = null;
        ResultSet rs = null;
        Server result = null;
        if (null == serverName) {
            return result;
        }
        try {
            stm = conn.prepareStatement("SELECT s.address, s.port, s.secure_port, ag.name FROM rhq_server s LEFT JOIN rhq_affinity_group ag ON ag.id = s.affinity_group_id WHERE s.name = ?");
            stm.setString(1, serverName.trim());
            rs = stm.executeQuery();
            if (rs.next()) {
                result = new Server(serverName, rs.getString(1), rs.getInt(2), rs.getInt(3), rs.getString(4));
            }
            if (null == db) return result;
        }
        catch (SQLException e) {
            try {
                LOG.info((Object)("Unable to get affinity group name for server: " + e.getMessage()));
                if (null == db) return result;
            }
            catch (Throwable throwable) {
                if (null == db) throw throwable;
                db.closeResultSet(rs);
                db.closeStatement((Statement)stm);
                throw throwable;
            }
            db.closeResultSet(rs);
            db.closeStatement((Statement)stm);
            return result;
        }
        db.closeResultSet(rs);
        db.closeStatement((Statement)stm);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Server getServerDetail(Properties props, String serverName) {
        DatabaseType db = null;
        Connection conn = null;
        Server result = null;
        try {
            conn = this.getDatabaseConnection(props);
            db = DatabaseTypeFactory.getDatabaseType((Connection)conn);
            result = this.getServer(db, conn, serverName);
        }
        catch (Exception e) {
            LOG.info((Object)("Unable to get server detail: " + e.getMessage()));
        }
        finally {
            if (null != db) {
                db.closeConnection(conn);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateServerAffinityGroup(DatabaseType db, Connection conn, String serverName, int affinityGroupId) {
        PreparedStatement stm = null;
        ResultSet rs = null;
        if (affinityGroupId < 0 || null == serverName) {
            return;
        }
        try {
            stm = conn.prepareStatement("UPDATE rhq_server SET affinity_group_id = ? WHERE name = ?");
            stm.setInt(1, affinityGroupId);
            stm.setString(2, serverName);
            stm.executeUpdate();
        }
        catch (SQLException e) {
            LOG.info((Object)("Unable to set server affinity group id: " + e.getMessage()));
        }
        finally {
            if (null != db) {
                db.closeResultSet(rs);
                db.closeStatement((Statement)stm);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateOrInsertServer(DatabaseType db, Connection conn, Server server) {
        PreparedStatement stm = null;
        ResultSet rs = null;
        if (null == server || null == Server.access$100((Server)server)) {
            return;
        }
        if ("".equals(Server.access$100((Server)server).trim())) {
            return;
        }
        try {
            int affinityGroupId;
            stm = conn.prepareStatement("UPDATE rhq_server SET address=?, port=?, secure_port=? WHERE name=?");
            stm.setString(1, Server.access$200((Server)server));
            stm.setInt(2, Server.access$300((Server)server));
            stm.setInt(3, Server.access$400((Server)server));
            stm.setString(4, Server.access$100((Server)server));
            if (0 == stm.executeUpdate()) {
                stm.close();
                int i = 1;
                if (db instanceof SQLServerDatabaseType) {
                    stm = conn.prepareStatement("INSERT INTO rhq_server  ( name, address, port, secure_port, ctime, mtime, operation_mode, compute_power ) VALUES ( ?, ?, ?, ?, ?, ?, 'INSTALLED', 1 )");
                } else if (db instanceof PostgresqlDatabaseType || db instanceof OracleDatabaseType || db instanceof H2DatabaseType) {
                    stm = conn.prepareStatement("INSERT INTO rhq_server  ( id, name, address, port, secure_port, ctime, mtime, operation_mode, compute_power ) VALUES ( ?, ?, ?, ?, ?, ?, ?, 'INSTALLED', 1 )");
                    stm.setInt(i++, db.getNextSequenceValue(conn, "rhq_server", "id"));
                } else {
                    throw new IllegalArgumentException("Unknown database type, can't continue: " + db);
                }
                stm.setString(i++, Server.access$100((Server)server));
                stm.setString(i++, Server.access$200((Server)server));
                stm.setInt(i++, Server.access$300((Server)server));
                stm.setInt(i++, Server.access$400((Server)server));
                long now = System.currentTimeMillis();
                stm.setLong(i++, now);
                stm.setLong(i++, now);
                stm.executeUpdate();
            }
            if ((affinityGroupId = this.getAffinityGroupId(db, conn, server.getAffinityGroup())) < 0) {
                this.insertAffinityGroup(db, conn, Server.access$500((Server)server));
                affinityGroupId = this.getAffinityGroupId(db, conn, Server.access$500((Server)server));
            }
            if (affinityGroupId > 0) {
                this.updateServerAffinityGroup(db, conn, Server.access$100((Server)server), affinityGroupId);
            }
        }
        catch (SQLException e) {
            LOG.info((Object)("Unable to insert server: " + e.getMessage()));
        }
        finally {
            if (null != db) {
                db.closeResultSet(rs);
                db.closeStatement((Statement)stm);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void storeServer(Properties props, Server server) throws Exception {
        DatabaseType db = null;
        Connection conn = null;
        try {
            conn = this.getDatabaseConnection(props);
            db = DatabaseTypeFactory.getDatabaseType((Connection)conn);
            this.updateOrInsertServer(db, conn, server);
        }
        catch (SQLException e) {
            LOG.info((Object)("Unable to create server entry: " + e.getMessage()));
        }
        finally {
            if (null != db) {
                db.closeConnection(conn);
            }
        }
    }

    public void createKeystore(Server haServer) {
        block4: {
            File confDir = this.getConfDirectory();
            File keystore = new File(confDir, "rhq.keystore");
            File keystoreBackup = new File(confDir, "rhq.keystore.backup");
            if (keystore.exists()) {
                keystoreBackup.delete();
                if (!keystore.renameTo(keystoreBackup)) {
                    LOG.warn((Object)("Cannot backup existing keystore - cannot generate a new cert with a proper domain name. [" + keystore + "] will be the keystore used by this server"));
                    return;
                }
            }
            try {
                String keystorePassword;
                String keystorePath = keystore.getAbsolutePath();
                String keyAlias = "RHQ";
                String domainName = "CN=" + Server.access$200((Server)haServer) + ", OU=RHQ, O=rhq-project.org, C=US";
                String keyPassword = keystorePassword = "RHQManagement";
                String keyAlgorithm = "rsa";
                int validity = 7300;
                SecurityUtil.createKeyStore((String)keystorePath, (String)keyAlias, (String)domainName, (String)keystorePassword, (String)keyPassword, (String)keyAlgorithm, (int)validity);
                LOG.info((Object)("New keystore created [" + keystorePath + "] with cert domain name of [" + domainName + "]"));
            }
            catch (Exception e) {
                LOG.warn((Object)"Could not generate a new cert with a proper domain name, will use the original keystore");
                keystore.delete();
                if (keystoreBackup.renameTo(keystore)) break block4;
                LOG.warn((Object)("Failed to restore the original keystore from backup - please rename [" + keystoreBackup + "] to [" + keystore + "]"));
            }
        }
    }

    static /* synthetic */ Log access$000() {
        return LOG;
    }
}

