/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.installer;

import java.lang.reflect.Method;
import java.net.InetAddress;
import java.sql.Connection;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.faces.context.FacesContext;
import javax.faces.model.SelectItem;
import mazz.i18n.Msg;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.resource.security.SecureIdentityLoginModule;
import org.rhq.core.db.DatabaseTypeFactory;
import org.rhq.core.util.exception.ThrowableUtil;
import org.rhq.enterprise.installer.ConfigurationBean;
import org.rhq.enterprise.installer.PropertyItem;
import org.rhq.enterprise.installer.PropertyItemWithValue;
import org.rhq.enterprise.installer.ServerInformation;
import org.rhq.enterprise.installer.ServerProperties;
import org.rhq.enterprise.installer.StartPageResults;
import org.rhq.enterprise.installer.i18n.InstallerI18NResourceKeys;

public class ConfigurationBean {
    private static final Log LOG = LogFactory.getLog(ConfigurationBean.class);
    private static Set<String> JON_SUPPORTED_DATABASE_TYPES = new HashSet(2);
    private Msg I18Nmsg;
    private List<SelectItem> existingSchemaOptions;
    private ServerInformation serverInfo;
    private Boolean showAdvancedSettings;
    private List<PropertyItemWithValue> configuration;
    private String lastError;
    private String lastTest;
    private String lastCreate;
    private String existingSchemaOption;
    private String adminConnectionUrl;
    private String adminUsername;
    private String adminPassword;
    private ServerInformation.Server haServer;
    private String haServerName;
    private String selectedRegisteredServerName;

    public ConfigurationBean() {
        FacesContext currentInstance = FacesContext.getCurrentInstance();
        this.I18Nmsg = currentInstance != null ? new Msg(InstallerI18NResourceKeys.BUNDLE_BASE_NAME, currentInstance.getViewRoot().getLocale()) : new Msg(InstallerI18NResourceKeys.BUNDLE_BASE_NAME, Locale.getDefault());
        this.serverInfo = new ServerInformation();
        this.showAdvancedSettings = Boolean.FALSE;
        this.existingSchemaOption = ExistingSchemaOption.KEEP.name();
        this.initConfiguration();
        if (!this.isAutoinstallEnabled()) {
            this.setHaServerName(this.getDefaultServerName());
        }
    }

    private String getDefaultServerName() {
        String defaultServerName = "";
        try {
            defaultServerName = InetAddress.getLocalHost().getCanonicalHostName();
        }
        catch (Exception e) {
            LOG.info((Object)"Could not determine default server name: ", (Throwable)e);
        }
        return defaultServerName;
    }

    public PropertyItemWithValue getConfigurationProperty(String propertyName) {
        return this.getConfigurationProperty(this.getConfiguration(), propertyName);
    }

    private PropertyItemWithValue getConfigurationPropertyFromAll(String propertyName) {
        return this.getConfigurationProperty(this.configuration, propertyName);
    }

    private PropertyItemWithValue getConfigurationProperty(List<PropertyItemWithValue> config, String propertyName) {
        PropertyItemWithValue result = null;
        for (PropertyItemWithValue item : config) {
            if (!item.getItemDefinition().getPropertyName().equalsIgnoreCase(propertyName)) continue;
            result = item;
            break;
        }
        return result;
    }

    public void initConfiguration() {
        if (this.configuration == null) {
            Properties properties = this.serverInfo.getServerProperties();
            List itemDefs = new ServerProperties().getPropertyItems();
            if (this.serverInfo.getProduct() == ServerInformation.Product.JON && !this.serverInfo.isUnsupportedJonFeaturesEnabled()) {
                LOG.debug((Object)"Hiding the embedded agent props and the unsupported DB types...");
                for (PropertyItem itemDef : itemDefs) {
                    if (itemDef.getPropertyName().startsWith("rhq.server.embedded-agent.")) {
                        itemDef.setHidden(true);
                    }
                    if (!itemDef.getPropertyName().equals("rhq.server.database.type-mapping")) continue;
                    List options = itemDef.getOptions();
                    Iterator iterator = options.iterator();
                    while (iterator.hasNext()) {
                        SelectItem option = (SelectItem)iterator.next();
                        String databaseType = (String)option.getValue();
                        if (JON_SUPPORTED_DATABASE_TYPES.contains(databaseType)) continue;
                        iterator.remove();
                    }
                }
            }
            this.configuration = new ArrayList();
            for (PropertyItem itemDef : itemDefs) {
                String property = properties.getProperty(itemDef.getPropertyName());
                PropertyItemWithValue value = new PropertyItemWithValue(itemDef, property);
                this.configuration.add(value);
            }
            boolean isIBM = System.getProperty("java.vendor", "").contains("IBM");
            if (isIBM) {
                String[] algPropNames;
                for (String algPropName : algPropNames = new String[]{"rhq.server.tomcat.security.algorithm", "rhq.server.client.security.keystore.algorithm", "rhq.server.client.security.truststore.algorithm", "rhq.communications.connector.security.keystore.algorithm", "rhq.communications.connector.security.truststore.algorithm"}) {
                    PropertyItemWithValue prop = this.getConfigurationProperty(this.configuration, algPropName);
                    if (prop == null) continue;
                    prop.setValue("IbmX509");
                }
            }
        }
    }

    public List<PropertyItemWithValue> getConfiguration() {
        ArrayList<PropertyItemWithValue> retConfig;
        if (this.showAdvancedSettings.booleanValue()) {
            retConfig = this.configuration;
        } else {
            retConfig = new ArrayList<PropertyItemWithValue>();
            for (PropertyItemWithValue item : this.configuration) {
                if (item.getItemDefinition().isAdvanced()) continue;
                retConfig.add(item);
            }
        }
        return retConfig;
    }

    public List<PropertyItemWithValue> getNonDatabaseConfiguration() {
        List allConfig = this.getConfiguration();
        ArrayList<PropertyItemWithValue> retConfig = new ArrayList<PropertyItemWithValue>();
        for (PropertyItemWithValue item : allConfig) {
            if (item.getItemDefinition().getPropertyName().startsWith("rhq.server.database.") || item.getItemDefinition().isHidden()) continue;
            retConfig.add(item);
        }
        return retConfig;
    }

    public List<PropertyItemWithValue> getDatabaseConfiguration() {
        List allConfig = this.getConfiguration();
        ArrayList<PropertyItemWithValue> retConfig = new ArrayList<PropertyItemWithValue>();
        for (PropertyItemWithValue item : allConfig) {
            if (!item.getItemDefinition().getPropertyName().startsWith("rhq.server.database.") || item.getItemDefinition().isHidden()) continue;
            retConfig.add(item);
        }
        return retConfig;
    }

    public boolean isAutoinstallEnabled() {
        PropertyItemWithValue enableProp = this.getConfigurationPropertyFromAll("rhq.autoinstall.enabled");
        if (enableProp != null) {
            return Boolean.parseBoolean(enableProp.getValue());
        }
        return false;
    }

    public void setConfiguration(List<PropertyItemWithValue> newConfig) {
        for (PropertyItemWithValue newValue : newConfig) {
            PropertyItemWithValue oldValue = this.findPropertyItemWithValue(newValue.getItemDefinition().getPropertyName());
            oldValue.setValue(newValue.getValue());
        }
    }

    public Boolean isShowAdvancedSettings() {
        return this.showAdvancedSettings;
    }

    public Boolean getShowAdvancedSettings() {
        return this.showAdvancedSettings;
    }

    public void setShowAdvancedSettings(Boolean showAdvancedSettings) {
        if (showAdvancedSettings == null) {
            showAdvancedSettings = Boolean.FALSE;
        }
        this.showAdvancedSettings = showAdvancedSettings;
    }

    public String getLastError() {
        return this.lastError != null ? this.lastError.replaceAll("'", "\\\\'") : null;
    }

    public String getLastTest() {
        return this.lastTest != null ? this.lastTest.replaceAll("'", "\\\\'") : null;
    }

    public String getLastCreate() {
        return this.lastCreate != null ? this.lastCreate.replaceAll("'", "\\\\'") : null;
    }

    public String getAdminConnectionUrl() {
        if (this.adminConnectionUrl == null) {
            this.adminConnectionUrl = this.getConfigurationAsProperties(this.configuration).getProperty("rhq.server.database.connection-url");
        }
        return this.adminConnectionUrl;
    }

    public void setAdminConnectionUrl(String adminUrl) {
        this.adminConnectionUrl = adminUrl;
    }

    public String getAdminUsername() {
        Properties config;
        String dbtype;
        if (this.adminUsername == null && (dbtype = (config = this.getConfigurationAsProperties(this.configuration)).getProperty("rhq.server.database.type-mapping")) != null) {
            if (dbtype.toLowerCase().indexOf("oracle") > -1) {
                this.adminUsername = "sys";
            } else if (dbtype.toLowerCase().indexOf("postgres") > -1) {
                this.adminUsername = "postgres";
            } else if (dbtype.toLowerCase().indexOf("h2") > -1) {
                this.adminUsername = "sa";
            } else if (dbtype.toLowerCase().indexOf("sqlserver") > -1) {
                this.adminUsername = "sa";
            } else if (dbtype.toLowerCase().indexOf("mysql") > -1) {
                this.adminUsername = "mysqladmin";
            }
        }
        return this.adminUsername;
    }

    public void setAdminUsername(String adminUsername) {
        this.adminUsername = adminUsername;
    }

    public String getAdminPassword() {
        return this.adminPassword;
    }

    public void setAdminPassword(String adminPassword) {
        this.adminPassword = adminPassword;
    }

    public StartPageResults testConnection() {
        Properties configurationAsProperties = this.getConfigurationAsProperties(this.configuration);
        DatabaseTypeFactory.clearDatabaseTypeCache();
        try {
            this.serverInfo.ensureDatabaseIsSupported(configurationAsProperties);
            this.lastTest = "OK";
        }
        catch (Exception e) {
            LOG.warn((Object)"Installer failed to test connection", (Throwable)e);
            this.lastTest = e.toString();
        }
        return StartPageResults.STAY;
    }

    public StartPageResults showCreateDatabasePage() {
        this.adminConnectionUrl = null;
        this.adminUsername = null;
        this.adminPassword = null;
        return StartPageResults.CREATEDB;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StartPageResults createDatabase() {
        Properties config = this.getConfigurationAsProperties(this.configuration);
        String dbType = config.getProperty("rhq.server.database.type-mapping", "-unknown-");
        Properties adminConfig = new Properties();
        adminConfig.put("rhq.server.database.connection-url", this.adminConnectionUrl);
        adminConfig.put("rhq.server.database.user-name", this.adminUsername);
        adminConfig.put("rhq.server.database.password", this.adminPassword);
        Connection conn = null;
        Statement stmt = null;
        PropertyItemWithValue propertyItemUsername = null;
        PropertyItemWithValue propertyItemPassword = null;
        PropertyItemWithValue propertyItemUrl = null;
        for (PropertyItemWithValue item : this.configuration) {
            String propName = item.getItemDefinition().getPropertyName();
            if (propName.equals("rhq.server.database.user-name")) {
                propertyItemUsername = item;
                continue;
            }
            if (propName.equals("rhq.server.database.password")) {
                propertyItemPassword = item;
                continue;
            }
            if (!propName.equals("rhq.server.database.connection-url")) continue;
            propertyItemUrl = item;
        }
        if (propertyItemUsername == null || propertyItemPassword == null || propertyItemUrl == null) {
            throw new NullPointerException("Missing a property item - this is a bug please report it");
        }
        LOG.info((Object)("Will attempt to create user/database 'rhqadmin' using URL [" + this.getAdminConnectionUrl() + "] and admin user [" + this.getAdminUsername() + "]. Admin password was" + (this.getAdminPassword().length() > 0 ? " not " : " ") + "empty"));
        try {
            String sql2;
            String sql1;
            conn = this.serverInfo.getDatabaseConnection(adminConfig);
            conn.setAutoCommit(true);
            stmt = conn.createStatement();
            if (dbType.equalsIgnoreCase("postgresql")) {
                sql1 = "CREATE ROLE rhqadmin LOGIN ENCRYPTED PASSWORD 'rhqadmin' NOSUPERUSER NOINHERIT CREATEDB NOCREATEROLE";
                sql2 = "CREATE DATABASE rhq WITH OWNER = rhqadmin ENCODING = 'SQL_ASCII' TABLESPACE = pg_default";
            } else if (dbType.equalsIgnoreCase("oracle10g")) {
                sql1 = "CREATE USER rhqadmin IDENTIFIED BY rhqadmin";
                sql2 = "GRANT connect, resource TO rhqadmin";
            } else if (dbType.equalsIgnoreCase("h2")) {
                sql1 = "CREATE USER rhqadmin IDENTIFIED BY rhqadmin";
                sql2 = "GRANT connect, resource TO rhqadmin";
            } else if (dbType.equalsIgnoreCase("sqlserver")) {
                sql1 = "CREATE USER rhqadmin IDENTIFIED BY rhqadmin";
                sql2 = "GRANT connect, resource TO rhqadmin";
            } else {
                throw new Exception("Unknown database type: " + dbType);
            }
            stmt.addBatch(sql1);
            stmt.addBatch(sql2);
            int[] results = stmt.executeBatch();
            if (results[0] == -3) {
                throw new Exception("Failed to execute: " + sql1);
            }
            if (results[1] == -3) {
                throw new Exception("Failed to execute: " + sql2);
            }
            propertyItemUsername.setValue("rhqadmin");
            propertyItemPassword.setValue("rhqadmin");
            if ((dbType.equalsIgnoreCase("postgresql") || dbType.equalsIgnoreCase("mysql")) && !propertyItemUrl.getValue().endsWith("/rhq")) {
                propertyItemUrl.setValue(propertyItemUrl.getValue() + "/rhq");
            }
            this.testConnection();
            this.lastCreate = "OK";
        }
        catch (Exception e) {
            LOG.warn((Object)"Installer failed to create database", (Throwable)e);
            this.lastCreate = ThrowableUtil.getAllMessages((Throwable)e);
        }
        finally {
            this.adminConnectionUrl = null;
            this.adminUsername = null;
            this.adminPassword = null;
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (Exception e) {}
            }
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (Exception e) {}
            }
        }
        return StartPageResults.STAY;
    }

    public String getDataDirectory() {
        try {
            String path = this.serverInfo.getDataDirectory().getCanonicalPath();
            path = path.replace('\\', '/');
            return path;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public boolean isDatabaseSchemaExist() {
        try {
            Properties configurationAsProperties = this.getConfigurationAsProperties(this.configuration);
            return this.serverInfo.isDatabaseSchemaExist(configurationAsProperties);
        }
        catch (Exception e) {
            LOG.info((Object)("Could not determine database existence: " + e));
            return false;
        }
    }

    public String getExistingSchemaOption() {
        return this.existingSchemaOption;
    }

    public void setExistingSchemaOption(String existingSchemaOption) {
        this.existingSchemaOption = existingSchemaOption;
    }

    public boolean isKeepExistingSchema() {
        return ExistingSchemaOption.KEEP.name().equals(this.existingSchemaOption) || ExistingSchemaOption.SKIP.name().equals(this.existingSchemaOption);
    }

    public StartPageResults saveEmbeddedMode() {
        PropertyItemWithValue prop = this.getConfigurationPropertyFromAll("rhq.server.embedded-agent.enabled");
        prop.setValue(Boolean.TRUE.toString());
        ArrayList<PropertyItemWithValue> newConfig = new ArrayList<PropertyItemWithValue>(1);
        newConfig.add(prop);
        this.setConfiguration(newConfig);
        List dbConfig = this.getDatabaseConfiguration();
        for (PropertyItemWithValue dbProp : dbConfig) {
            if (dbProp.getItemDefinition().getPropertyName().equals("rhq.server.database.connection-url")) {
                dbProp.setValue("jdbc:h2:" + this.getDataDirectory() + "/rhq;MVCC=TRUE;DB_CLOSE_ON_EXIT=FALSE;LOG=2");
                continue;
            }
            if (dbProp.getItemDefinition().getPropertyName().equals("rhq.server.database.type-mapping")) {
                dbProp.setValue("H2");
                continue;
            }
            if (dbProp.getItemDefinition().getPropertyName().equals("rhq.server.database.driver-class")) {
                dbProp.setValue("org.h2.Driver");
                continue;
            }
            if (dbProp.getItemDefinition().getPropertyName().equals("rhq.server.database.xa-datasource-class")) {
                dbProp.setValue("org.h2.jdbcx.JdbcDataSource");
                continue;
            }
            if (dbProp.getItemDefinition().getPropertyName().equals("rhq.server.database.user-name")) {
                dbProp.setValue("rhqadmin");
                continue;
            }
            if (!dbProp.getItemDefinition().getPropertyName().equals("rhq.server.database.password")) continue;
            dbProp.setValue("rhqadmin");
        }
        this.setExistingSchemaOption(ExistingSchemaOption.OVERWRITE.name());
        return this.save();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public StartPageResults save() {
        String pass;
        Properties props = this.getConfigurationAsProperties(this.configuration);
        props.remove("rhq.server.database.password");
        LOG.info((Object)("Installer: raw values (these may be updated by the installer, see submitted values below): " + props));
        if (this.isAutoinstallEnabled()) {
            try {
                PropertyItemWithValue prop = this.getConfigurationPropertyFromAll("rhq.server.database.password");
                pass = prop.getValue();
                pass = this.decodePassword(pass);
                prop.setValue(pass);
                LOG.trace((Object)(">" + pass));
            }
            catch (Exception e) {
                LOG.fatal((Object)"Could not decrypt the password for some reason - auto-installation failed", (Throwable)e);
                this.lastError = this.I18Nmsg.getMsg("saveError", new Object[]{ThrowableUtil.getAllMessages((Throwable)e)});
                return StartPageResults.ERROR;
            }
        }
        DatabaseTypeFactory.clearDatabaseTypeCache();
        try {
            this.getConfigurationPropertyFromAll("rhq.server.high-availability.name").setValue(this.getHaServer().getName());
            this.getConfigurationPropertyFromAll("rhq.server.startup.web.http.port").setValue(this.getHaServer().getEndpointPortString());
            this.getConfigurationPropertyFromAll("rhq.server.startup.web.https.port").setValue(this.getHaServer().getEndpointSecurePortString());
            PropertyItemWithValue portConfig = this.getConfigurationPropertyFromAll("rhq.communications.connector.bind-port");
            if ("0".equals(portConfig.getValue())) {
                portConfig.setRawValue("");
            }
        }
        catch (Exception e) {
            LOG.fatal((Object)"Could not save the settings for some reason", (Throwable)e);
            this.lastError = this.I18Nmsg.getMsg("saveError", new Object[]{ThrowableUtil.getAllMessages((Throwable)e)});
            return StartPageResults.ERROR;
        }
        try {
            String url = this.getConfigurationPropertyFromAll("rhq.server.database.connection-url").getValue();
            String db = this.getConfigurationPropertyFromAll("rhq.server.database.type-mapping").getValue();
            Pattern pattern = null;
            if (db.toLowerCase().indexOf("postgres") > -1) {
                pattern = Pattern.compile(".*://(.*):([0123456789]+)/(.*)");
            } else if (db.toLowerCase().indexOf("oracle") > -1) {
                LOG.info((Object)"Oracle does not need to have server-name, port and db-name individually set, skipping");
            } else if (db.toLowerCase().indexOf("h2") > -1) {
                LOG.info((Object)"H2 does not need to have server-name, port and db-name individually set, skipping");
            } else if (db.toLowerCase().indexOf("sqlserver") > -1) {
                pattern = Pattern.compile("(?i).*://(.*):([0123456789]+).*databaseName=([^;]*)");
            } else {
                LOG.info((Object)"Unknown database type - will not set server-name, port and db-name");
            }
            if (pattern != null) {
                Matcher match = pattern.matcher(url);
                if (!match.find() || match.groupCount() != 3) throw new Exception("Cannot get server, port or db name from connection URL: " + url);
                String serverName = match.group(1);
                String port = match.group(2);
                String dbName = match.group(3);
                this.getConfigurationPropertyFromAll("rhq.server.database.server-name").setValue(serverName);
                this.getConfigurationPropertyFromAll("rhq.server.database.port").setValue(port);
                this.getConfigurationPropertyFromAll("rhq.server.database.db-name").setValue(dbName);
            } else {
                this.getConfigurationPropertyFromAll("rhq.server.database.server-name").setValue("");
                this.getConfigurationPropertyFromAll("rhq.server.database.port").setValue("");
                this.getConfigurationPropertyFromAll("rhq.server.database.db-name").setValue("");
            }
        }
        catch (Exception e) {
            LOG.fatal((Object)"JDBC connection URL seems to be invalid", (Throwable)e);
            this.lastError = this.I18Nmsg.getMsg("saveError", new Object[]{ThrowableUtil.getAllMessages((Throwable)e)});
            return StartPageResults.ERROR;
        }
        try {
            String dialect;
            String db = this.getConfigurationPropertyFromAll("rhq.server.database.type-mapping").getValue();
            String quartzDriverDelegateClass = "org.quartz.impl.jdbcjobstore.StdJDBCDelegate";
            String quartzSelectWithLockSQL = "SELECT * FROM {0}LOCKS ROWLOCK WHERE LOCK_NAME = ? FOR UPDATE";
            String quartzLockHandlerClass = "org.quartz.impl.jdbcjobstore.StdRowLockSemaphore";
            if (db.toLowerCase().indexOf("postgres") > -1) {
                dialect = "org.hibernate.dialect.PostgreSQLDialect";
                quartzDriverDelegateClass = "org.quartz.impl.jdbcjobstore.PostgreSQLDelegate";
            } else if (db.toLowerCase().indexOf("oracle") > -1) {
                dialect = "org.hibernate.dialect.Oracle10gDialect";
                quartzDriverDelegateClass = "org.quartz.impl.jdbcjobstore.oracle.OracleDelegate";
            } else if (db.toLowerCase().indexOf("h2") > -1) {
                dialect = "org.rhq.core.domain.server.H2CustomDialect";
            } else if (db.toLowerCase().indexOf("sqlserver") > -1) {
                dialect = "org.hibernate.dialect.SQLServerDialect";
                quartzDriverDelegateClass = "org.quartz.impl.jdbcjobstore.MSSQLDelegate";
                quartzSelectWithLockSQL = "SELECT * FROM {0}LOCKS ROWLOCK WITH (HOLDLOCK,XLOCK) WHERE LOCK_NAME = ?";
                quartzLockHandlerClass = "org.quartz.impl.jdbcjobstore.UpdateLockRowSemaphore";
            } else {
                if (db.toLowerCase().indexOf("mysql") <= -1) throw new Exception("Unknown db type: " + db);
                dialect = "org.hibernate.dialect.MySQL5InnoDBDialect";
                quartzDriverDelegateClass = "org.quartz.impl.jdbcjobstore.PostgreSQLDelegate";
            }
            this.getConfigurationPropertyFromAll("hibernate.dialect").setValue(dialect);
            this.getConfigurationPropertyFromAll("rhq.server.quartz.driverDelegateClass").setValue(quartzDriverDelegateClass);
            this.getConfigurationPropertyFromAll("rhq.server.quartz.selectWithLockSQL").setValue(quartzSelectWithLockSQL);
            this.getConfigurationPropertyFromAll("rhq.server.quartz.lockHandlerClass").setValue(quartzLockHandlerClass);
        }
        catch (Exception e) {
            LOG.fatal((Object)"Invalid database type", (Throwable)e);
            this.lastError = this.I18Nmsg.getMsg("saveError", new Object[]{ThrowableUtil.getAllMessages((Throwable)e)});
            return StartPageResults.ERROR;
        }
        Properties configurationAsProperties = this.getConfigurationAsProperties(this.configuration);
        this.testConnection();
        if (this.lastTest == null || !this.lastTest.equals("OK")) {
            this.lastError = this.lastTest;
            return StartPageResults.ERROR;
        }
        if (null == this.haServer || null == this.haServer.getName() || "".equals(this.haServer.getName().trim())) {
            this.lastError = this.I18Nmsg.getMsg("invalidString", new Object[]{this.I18Nmsg.getMsg("propertyHighAvailabilityName", new Object[0])});
            return StartPageResults.ERROR;
        }
        for (PropertyItemWithValue newValue : this.configuration) {
            if (Integer.class.isAssignableFrom(newValue.getItemDefinition().getPropertyType())) {
                try {
                    Integer.parseInt(newValue.getValue());
                    continue;
                }
                catch (Exception e) {
                    if (newValue.getItemDefinition().getPropertyName().equals("rhq.communications.connector.bind-port") && newValue.getValue().length() == 0) continue;
                    this.lastError = this.I18Nmsg.getMsg("invalidNumber", new Object[]{newValue.getItemDefinition().getPropertyLabel(), newValue.getValue()});
                    return StartPageResults.ERROR;
                }
            }
            if (!Boolean.class.isAssignableFrom(newValue.getItemDefinition().getPropertyType())) continue;
            try {
                if (newValue.getValue() == null) {
                    newValue.setValue(Boolean.FALSE.toString());
                }
                Boolean.parseBoolean(newValue.getValue());
            }
            catch (Exception e) {
                this.lastError = this.I18Nmsg.getMsg("invalidBoolean", new Object[]{newValue.getItemDefinition().getPropertyLabel(), newValue.getValue()});
                return StartPageResults.ERROR;
            }
        }
        try {
            this.lastError = null;
            this.serverInfo.setServerProperties(configurationAsProperties);
            if (!ExistingSchemaOption.SKIP.name().equals(this.existingSchemaOption)) {
                if (this.serverInfo.isDatabaseSchemaExist(configurationAsProperties)) {
                    if (this.existingSchemaOption == null && !this.isAutoinstallEnabled()) {
                        return StartPageResults.STAY;
                    }
                    if (ExistingSchemaOption.OVERWRITE.name().equals(this.existingSchemaOption)) {
                        this.serverInfo.createNewDatabaseSchema(configurationAsProperties);
                    } else {
                        this.serverInfo.upgradeExistingDatabaseSchema(configurationAsProperties);
                    }
                } else {
                    this.serverInfo.createNewDatabaseSchema(configurationAsProperties);
                }
            }
            this.serverInfo.storeServer(configurationAsProperties, this.haServer);
            pass = configurationAsProperties.getProperty("rhq.server.database.password");
            pass = this.encryptPassword(pass);
            configurationAsProperties.setProperty("rhq.server.database.password", pass);
            this.serverInfo.setServerProperties(configurationAsProperties);
            this.serverInfo.restartLoginConfig();
            this.serverInfo.createKeystore(this.haServer);
            this.serverInfo.moveDeploymentArtifacts(true);
        }
        catch (Exception e) {
            LOG.fatal((Object)("Failed to update properties and fully deploy - " + this.serverInfo.getProduct() + " Server will not function properly."), (Throwable)e);
            this.lastError = this.I18Nmsg.getMsg("saveFailure", new Object[]{ThrowableUtil.getAllMessages((Throwable)e)});
            return StartPageResults.ERROR;
        }
        LOG.info((Object)("Installer: final submitted values: " + configurationAsProperties));
        return StartPageResults.SUCCESS;
    }

    private String encryptPassword(String password) throws Exception {
        try {
            SecureIdentityLoginModule lm = new SecureIdentityLoginModule();
            Class<SecureIdentityLoginModule> clazz = SecureIdentityLoginModule.class;
            Method m = clazz.getDeclaredMethod("encode", String.class);
            m.setAccessible(true);
            String res = (String)m.invoke((Object)lm, password);
            return res;
        }
        catch (Exception e) {
            throw new Exception("Encoding db password failed: ", e);
        }
    }

    private String decodePassword(String encrypedPassword) throws Exception {
        try {
            SecureIdentityLoginModule lm = new SecureIdentityLoginModule();
            Class<SecureIdentityLoginModule> clazz = SecureIdentityLoginModule.class;
            Method m = clazz.getDeclaredMethod("decode", String.class);
            m.setAccessible(true);
            char[] res = (char[])m.invoke((Object)lm, encrypedPassword);
            return new String(res);
        }
        catch (Exception e) {
            throw new Exception("Decoding db password failed: ", e);
        }
    }

    private Properties getConfigurationAsProperties(List<PropertyItemWithValue> config) {
        Properties props = new Properties();
        for (PropertyItemWithValue itemWithValue : config) {
            props.setProperty(itemWithValue.getItemDefinition().getPropertyName(), itemWithValue.getValue());
        }
        return props;
    }

    private PropertyItemWithValue findPropertyItemWithValue(String propertyName) {
        for (PropertyItemWithValue value : this.configuration) {
            if (!value.getItemDefinition().getPropertyName().equals(propertyName)) continue;
            return value;
        }
        return null;
    }

    public List<SelectItem> getExistingSchemaOptions() {
        if (this.existingSchemaOptions == null) {
            this.existingSchemaOptions = new ArrayList();
            this.existingSchemaOptions.add(new SelectItem((Object)ExistingSchemaOption.OVERWRITE.name(), this.I18Nmsg.getMsg("existingSchemaAnswerOverwrite", new Object[0])));
            this.existingSchemaOptions.add(new SelectItem((Object)ExistingSchemaOption.KEEP.name(), this.I18Nmsg.getMsg("existingSchemaAnswerUpgrade", new Object[0])));
            this.existingSchemaOptions.add(new SelectItem((Object)ExistingSchemaOption.SKIP.name(), this.I18Nmsg.getMsg("existingSchemaAnswerSkip", new Object[0])));
        }
        return this.existingSchemaOptions;
    }

    public PropertyItemWithValue getPropHaServerName() {
        return this.getConfigurationPropertyFromAll("rhq.server.high-availability.name");
    }

    public PropertyItemWithValue getPropHaEndpointPort() {
        return this.getConfigurationPropertyFromAll("rhq.server.startup.web.http.port");
    }

    public PropertyItemWithValue getPropHaEndpointSecurePort() {
        return this.getConfigurationPropertyFromAll("rhq.server.startup.web.https.port");
    }

    public boolean isRegisteredServers() {
        if (!this.isKeepExistingSchema()) {
            return false;
        }
        List registeredServerNames = this.getRegisteredServerNames();
        return null != registeredServerNames && !registeredServerNames.isEmpty();
    }

    public boolean isInstallationSettingsConfigurable() {
        String selectedServer = this.getSelectedRegisteredServerName();
        return selectedServer == null || selectedServer.isEmpty() || selectedServer.equals(this.I18Nmsg.getMsg("newServerSelectItem", new Object[0]));
    }

    public List<SelectItem> getRegisteredServerNames() {
        ArrayList<SelectItem> result = new ArrayList<SelectItem>(0);
        if (!this.isDatabaseSchemaExist()) {
            return result;
        }
        try {
            Properties configurationAsProperties = this.getConfigurationAsProperties(this.configuration);
            for (String serverName : this.serverInfo.getServerNames(configurationAsProperties)) {
                result.add(new SelectItem((Object)serverName));
            }
            if (!result.isEmpty()) {
                result.add(0, new SelectItem((Object)this.I18Nmsg.getMsg("newServerSelectItem", new Object[0])));
            }
        }
        catch (Exception e) {
            LOG.warn((Object)"Unexpected Exception getting registered server info: ", (Throwable)e);
        }
        return result;
    }

    public String getSelectedRegisteredServerName() {
        return this.selectedRegisteredServerName;
    }

    public void setSelectedRegisteredServerName(String selectedRegisteredServerName) {
        this.selectedRegisteredServerName = selectedRegisteredServerName;
        this.setHaServerName(selectedRegisteredServerName);
    }

    public String getHaServerName() {
        return this.haServerName;
    }

    public void setHaServerName(String serverName) {
        if (this.I18Nmsg.getMsg("newServerSelectItem", new Object[0]).equals(serverName)) {
            serverName = this.getDefaultServerName();
        }
        this.haServerName = serverName;
        if (this.isRegisteredServers()) {
            Properties configurationAsProperties = this.getConfigurationAsProperties(this.configuration);
            this.setHaServer(this.serverInfo.getServerDetail(configurationAsProperties, serverName));
        }
        if (null == this.getHaServer()) {
            String endpointAddress = "";
            try {
                endpointAddress = InetAddress.getLocalHost().getCanonicalHostName();
            }
            catch (Exception e) {
                LOG.info((Object)"Could not determine default server address: ", (Throwable)e);
            }
            this.setHaServer(new ServerInformation.Server(serverName, endpointAddress, 7080, 7443, ""));
            try {
                this.getHaServer().setEndpointPortString(this.getConfigurationPropertyFromAll("rhq.server.startup.web.http.port").getValue());
            }
            catch (Exception e) {
                LOG.debug((Object)"Could not determine default port: ", (Throwable)e);
            }
            try {
                this.getHaServer().setEndpointSecurePortString(this.getConfigurationPropertyFromAll("rhq.server.startup.web.https.port").getValue());
            }
            catch (Exception e) {
                LOG.debug((Object)"Could not determine default secure port: ", (Throwable)e);
            }
        } else {
            this.getHaServer().setName(serverName);
        }
    }

    public void setHaServerFromPropertiesOnly() throws Exception {
        PropertyItemWithValue serverBindAddress;
        PropertyItemWithValue connBindAddress;
        PropertyItemWithValue preconfigAddr;
        PropertyItemWithValue preconfigDb = this.getConfigurationPropertyFromAll("rhq.autoinstall.database");
        if (preconfigDb != null && preconfigDb.getValue() != null) {
            if ("overwrite".equals(preconfigDb.getValue().toLowerCase())) {
                this.setExistingSchemaOption(ExistingSchemaOption.OVERWRITE.name());
            } else if ("skip".equals(preconfigDb.getValue().toLowerCase())) {
                this.setExistingSchemaOption(ExistingSchemaOption.SKIP.name());
            } else if ("auto".equals(preconfigDb.getValue().toLowerCase())) {
                this.setExistingSchemaOption(null);
            } else {
                LOG.warn((Object)("An invalid setting for [rhq.autoinstall.database] was provided: [" + preconfigDb.getValue() + "]. Valid values are 'auto', 'overwrite' or 'skip'. Defaulting to 'auto'"));
                preconfigDb.setRawValue("auto");
                this.setExistingSchemaOption(null);
            }
        } else {
            LOG.debug((Object)"[rhq.autoinstall.database] was not provided. Defaulting to 'auto'");
            this.setExistingSchemaOption(null);
        }
        ServerInformation.Server preconfiguredHaServer = new ServerInformation.Server("", "", 7080, 7443, "");
        PropertyItemWithValue haNameProp = this.getPropHaServerName();
        if (haNameProp != null) {
            preconfiguredHaServer.setName(haNameProp.getValue());
        }
        if (preconfiguredHaServer.getName().equals("")) {
            String serverName = this.getDefaultServerName();
            if (serverName == null || "".equals(serverName)) {
                throw new Exception("Server name is not preconfigured and could not be determined automatically");
            }
            preconfiguredHaServer.setName(serverName);
        }
        String publicEndpointAddress = (preconfigAddr = this.getConfigurationPropertyFromAll("rhq.autoinstall.public-endpoint-address")) != null && preconfigAddr.getValue() != null && !"".equals(preconfigAddr.getValue().trim()) ? preconfigAddr.getValue().trim() : ((connBindAddress = this.getConfigurationPropertyFromAll("rhq.communications.connector.bind-address")) != null && connBindAddress.getValue() != null && !"".equals(connBindAddress.getValue().trim()) && !"0.0.0.0".equals(connBindAddress.getValue().trim()) ? connBindAddress.getValue().trim() : ((serverBindAddress = this.getConfigurationPropertyFromAll("jboss.bind.address")) != null && serverBindAddress.getValue() != null && !"".equals(serverBindAddress.getValue().trim()) && !"0.0.0.0".equals(serverBindAddress.getValue().trim()) ? serverBindAddress.getValue().trim() : InetAddress.getLocalHost().getCanonicalHostName()));
        preconfiguredHaServer.setEndpointAddress(publicEndpointAddress);
        PropertyItemWithValue connectorTransport = this.getConfigurationPropertyFromAll("rhq.communications.connector.transport");
        if (connectorTransport != null && connectorTransport.getValue() != null && connectorTransport.getValue().contains("socket")) {
            PropertyItemWithValue connectorBindPort = this.getConfigurationPropertyFromAll("rhq.communications.connector.bind-port");
            if (connectorBindPort == null || connectorBindPort.getValue() == null || "".equals(connectorBindPort.getValue().trim()) || "0".equals(connectorBindPort.getValue().trim())) {
                throw new Exception("Using non-servlet transport [" + connectorTransport + "] but didn't define a port");
            }
            preconfiguredHaServer.setEndpointPort(Integer.parseInt(connectorBindPort.getValue()));
            preconfiguredHaServer.setEndpointSecurePort(Integer.parseInt(connectorBindPort.getValue()));
        } else {
            try {
                PropertyItemWithValue httpPort = this.getPropHaEndpointPort();
                preconfiguredHaServer.setEndpointPortString(httpPort.getValue());
            }
            catch (Exception e) {
                LOG.warn((Object)("Could not determine port, will use default: " + e));
            }
            try {
                PropertyItemWithValue httpsPort = this.getPropHaEndpointSecurePort();
                preconfiguredHaServer.setEndpointSecurePortString(httpsPort.getValue());
            }
            catch (Exception e) {
                LOG.warn((Object)("Could not determine secure port, will use default: " + e));
            }
        }
        this.setHaServer(preconfiguredHaServer);
        this.haServerName = preconfiguredHaServer.getName();
    }

    public ServerInformation.Server getHaServer() {
        return this.haServer;
    }

    public void setHaServer(ServerInformation.Server haServer) {
        this.haServer = haServer;
    }

    static {
        JON_SUPPORTED_DATABASE_TYPES.add("PostgreSQL");
        JON_SUPPORTED_DATABASE_TYPES.add("Oracle");
    }
}

