/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.installer;

import java.net.InetAddress;
import java.util.List;
import java.util.Locale;
import javax.faces.context.FacesContext;
import javax.faces.model.SelectItem;
import mazz.i18n.Msg;
import org.rhq.enterprise.installer.i18n.InstallerI18NResourceKeys;

public class PropertyItem {
    private String propertyName;
    private Class<?> propertyType;
    private int fieldSize;
    private boolean requiresRestart;
    private boolean secret;
    private boolean advanced;
    private boolean hidden;
    private List<SelectItem> options;
    private String propertyLabelResourceBundleKey;
    private String helpResourceBundleKey;
    private Msg i18nMsg;

    public PropertyItem(String name, Class<?> type, String labelBundleKey, String helpBundleKey, boolean requiresRestart, boolean secret, boolean advanced, boolean hidden) {
        this.setPropertyName(name);
        this.setPropertyType(type);
        this.setPropertyLabelResourceBundleKey(labelBundleKey);
        this.setHelpResourceBundleKey(helpBundleKey);
        this.setRequiresRestart(requiresRestart);
        this.setSecret(secret);
        this.setAdvanced(advanced);
        this.setHidden(hidden);
        if (Number.class.isAssignableFrom(type)) {
            this.setFieldSize(6);
        } else if (Boolean.class.isAssignableFrom(type)) {
            this.setFieldSize(6);
        } else if (InetAddress.class.isAssignableFrom(type)) {
            this.setFieldSize(40);
        } else {
            this.setFieldSize(60);
        }
    }

    public PropertyItem(String name, Class<?> type, String labelBundleKey, String helpBundleKey, boolean requiresRestart, boolean secret, boolean advanced) {
        this(name, type, labelBundleKey, helpBundleKey, requiresRestart, secret, advanced, false);
    }

    public PropertyItem(String name, Class<?> type, String labelBundleKey, String helpBundleKey, boolean requiresRestart, boolean secret, boolean advanced, List<SelectItem> options) {
        this(name, type, labelBundleKey, helpBundleKey, requiresRestart, secret, advanced, false);
        this.setOptions(options);
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    public void setPropertyName(String propertyName) {
        this.propertyName = propertyName;
    }

    public Class<?> getPropertyType() {
        return this.propertyType;
    }

    public void setPropertyType(Class<?> propertyType) {
        this.propertyType = propertyType;
    }

    public int getFieldSize() {
        return this.fieldSize;
    }

    public void setFieldSize(int fieldSize) {
        this.fieldSize = fieldSize;
    }

    public boolean isRequiresRestart() {
        return this.requiresRestart;
    }

    public void setRequiresRestart(boolean requiresRestart) {
        this.requiresRestart = requiresRestart;
    }

    public boolean isSecret() {
        return this.secret;
    }

    public void setSecret(boolean secret) {
        this.secret = secret;
    }

    public boolean isAdvanced() {
        return this.advanced;
    }

    public List<SelectItem> getOptions() {
        return this.options;
    }

    public void setOptions(List<SelectItem> options) {
        this.options = options;
    }

    public void setAdvanced(boolean hidden) {
        this.advanced = hidden;
    }

    public boolean isHidden() {
        return this.hidden;
    }

    public void setHidden(boolean hidden) {
        this.hidden = hidden;
    }

    public String getPropertyLabelResourceBundleKey() {
        return this.propertyLabelResourceBundleKey;
    }

    public void setPropertyLabelResourceBundleKey(String propertyLabelResourceBundleKey) {
        this.propertyLabelResourceBundleKey = propertyLabelResourceBundleKey;
    }

    public String getHelpResourceBundleKey() {
        return this.helpResourceBundleKey;
    }

    public void setHelpResourceBundleKey(String helpResourceBundleKey) {
        this.helpResourceBundleKey = helpResourceBundleKey;
    }

    public String getPropertyLabel() {
        return this.getI18nMsg().getMsg(this.getPropertyLabelResourceBundleKey(), new Object[0]);
    }

    public String getHelp() {
        return this.getI18nMsg().getMsg(this.getHelpResourceBundleKey(), new Object[0]);
    }

    private Msg getI18nMsg() {
        if (this.i18nMsg == null) {
            this.i18nMsg = new Msg(InstallerI18NResourceKeys.BUNDLE_BASE_NAME, this.getLocale());
        }
        return this.i18nMsg;
    }

    private Locale getLocale() {
        return FacesContext.getCurrentInstance().getViewRoot().getLocale();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PropertyItem that = (PropertyItem)o;
        return !(this.propertyName != null ? !this.propertyName.equals(that.propertyName) : that.propertyName != null);
    }

    public int hashCode() {
        return this.propertyName != null ? this.propertyName.hashCode() : 0;
    }
}

