/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.irc;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jibble.pircbot.PircBot;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.Property;
import org.rhq.core.domain.configuration.PropertyList;
import org.rhq.core.domain.configuration.PropertyMap;
import org.rhq.core.domain.configuration.PropertySimple;
import org.rhq.core.domain.measurement.AvailabilityType;
import org.rhq.core.pluginapi.inventory.InvalidPluginConfigurationException;
import org.rhq.core.pluginapi.inventory.ResourceComponent;
import org.rhq.core.pluginapi.inventory.ResourceContext;
import org.rhq.core.pluginapi.operation.OperationFacet;
import org.rhq.core.pluginapi.operation.OperationResult;
import org.rhq.plugins.irc.IRCChannelComponent;

public class IRCServerComponent
implements ResourceComponent,
OperationFacet {
    private final Log log = LogFactory.getLog(this.getClass());
    private Bot bot;
    private Map<String, IRCChannelComponent> channels = new HashMap<String, IRCChannelComponent>();
    private String host;
    private String port;
    private String nick;
    private List<String> activeChannels;
    private Map<String, ChannelInfo> info = new HashMap<String, ChannelInfo>();

    public AvailabilityType getAvailability() {
        if (!this.bot.isConnected()) {
            try {
                this.bot.connect(this.host);
            }
            catch (Exception e) {
                this.log.warn((Object)("Failure to connect to IRC server " + this.host + " reason: " + e.getMessage()));
            }
        }
        this.activeChannels = Arrays.asList(this.bot.getChannels());
        return this.bot.isConnected() ? AvailabilityType.UP : AvailabilityType.DOWN;
    }

    public void start(ResourceContext context) throws InvalidPluginConfigurationException, Exception {
        Configuration conf = context.getPluginConfiguration();
        this.host = conf.getSimple("host").getStringValue();
        this.port = conf.getSimple("port").getStringValue();
        this.nick = conf.getSimple("botNick").getStringValue();
        this.bot = new Bot(this.nick);
        this.bot.setAutoNickChange(true);
        this.bot.connect(this.host);
    }

    public void registerChannel(IRCChannelComponent channelComponent) {
        this.channels.put(channelComponent.getChannel(), channelComponent);
        this.bot.joinChannel(channelComponent.getChannel());
        this.updateChannels();
    }

    public void unregisterChannel(IRCChannelComponent channelComponent) {
        this.bot.partChannel(channelComponent.getChannel());
        this.channels.remove(channelComponent.getChannel());
    }

    public boolean isInChannel(String channel) {
        return this.activeChannels.contains(channel);
    }

    public void sendMessage(String channel, String message) {
        this.bot.sendMessage(channel, message);
    }

    public OperationResult invokeOperation(String name, Configuration parameters) throws InterruptedException, Exception {
        if (name.equals("listChannels")) {
            OperationResult result = new OperationResult();
            Configuration resultConfig = result.getComplexResults();
            PropertyList channelList = new PropertyList("channelList");
            this.bot.listChannels();
            Thread.sleep(5000L);
            for (ChannelInfo channelInfo : this.info.values()) {
                PropertyMap channelMap = new PropertyMap("channelMap");
                channelMap.put((Property)new PropertySimple("channel", (Object)channelInfo.channel));
                channelMap.put((Property)new PropertySimple("userCount", (Object)channelInfo.userCount));
                channelMap.put((Property)new PropertySimple("topic", (Object)channelInfo.topic));
                channelList.add((Property)channelMap);
            }
            resultConfig.put((Property)channelList);
            return result;
        }
        return null;
    }

    public int getUserCount(String channel) {
        return this.bot.getUsers(channel).length;
    }

    public void stop() {
        this.bot.disconnect();
    }

    private void updateChannels() {
        this.activeChannels = Arrays.asList(this.bot.getChannels());
    }

    public class Bot
    extends PircBot {
        public Bot(String nick) {
            this.setName(nick);
        }

        protected void onChannelInfo(String channel, int userCount, String topic) {
            IRCServerComponent.this.info.put(channel, new ChannelInfo(channel, userCount, topic));
        }

        public void onMessage(String channel, String sender, String login, String hostname, String message) {
            IRCChannelComponent component = (IRCChannelComponent)IRCServerComponent.this.channels.get(channel);
            if (component != null) {
                component.acceptMessage(sender, login, hostname, message);
            }
            if (message.contains(this.getName()) && sender.contains("ghinkle")) {
                this.sendMessage(channel, "monitoring " + IRCServerComponent.this.channels.size() + " channels");
            }
        }
    }

    public static class ChannelInfo {
        String channel;
        int userCount;
        String topic;

        public ChannelInfo(String channel, int userCount, String topic) {
            this.channel = channel;
            this.userCount = userCount;
            this.topic = topic;
        }
    }
}

