/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.modules.plugins.jbossas7.jmx;

import java.io.File;
import java.util.Collections;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mc4j.ems.connection.ConnectionFactory;
import org.mc4j.ems.connection.EmsConnection;
import org.mc4j.ems.connection.settings.ConnectionSettings;
import org.mc4j.ems.connection.support.ConnectionProvider;
import org.mc4j.ems.connection.support.metadata.ConnectionTypeDescriptor;
import org.mc4j.ems.connection.support.metadata.JSR160ConnectionTypeDescriptor;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.PropertySimple;
import org.rhq.core.pluginapi.inventory.DiscoveredResourceDetails;
import org.rhq.core.pluginapi.inventory.ResourceDiscoveryComponent;
import org.rhq.core.pluginapi.inventory.ResourceDiscoveryContext;
import org.rhq.modules.plugins.jbossas7.BaseComponent;
import org.rhq.modules.plugins.jbossas7.BaseServerComponent;
import org.rhq.modules.plugins.jbossas7.ManagedASComponent;
import org.rhq.modules.plugins.jbossas7.StandaloneASComponent;
import org.rhq.modules.plugins.jbossas7.helper.ServerPluginConfiguration;

public class ApplicationMBeansDiscoveryComponent
implements ResourceDiscoveryComponent<BaseComponent<?>> {
    private static final Log LOG = LogFactory.getLog(ApplicationMBeansDiscoveryComponent.class);
    private static final String HOSTNAME = "hostname";
    private static final String PORT = "port";
    private static final String USERNAME = "username";
    private static final String PASSWORD = "password";
    private static final String CLIENT_JAR_LOCATION = "clientJarLocation";
    private static final int STANDALONE_REMOTING_PORT_OFFSET = 9;
    private static final int DOMAIN_REMOTING_PORT_DEFAULT = 4447;
    private static final String MANAGED_SERVER_PORT_OFFSET_PROPERTY_NAME = "socket-binding-port-offset";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<DiscoveredResourceDetails> discoverResources(ResourceDiscoveryContext<BaseComponent<?>> context) throws Exception {
        String password;
        String username;
        int port;
        BaseComponent parentComponent = (BaseComponent)context.getParentResourceComponent();
        BaseServerComponent baseServerComponent = parentComponent.getServerComponent();
        ServerPluginConfiguration serverPluginConfiguration = baseServerComponent.getServerPluginConfiguration();
        Configuration pluginConfig = context.getDefaultPluginConfiguration();
        pluginConfig.setSimpleValue(HOSTNAME, serverPluginConfiguration.getHostname());
        if (parentComponent instanceof ManagedASComponent) {
            ManagedASComponent managedASComponent = (ManagedASComponent)parentComponent;
            Configuration managedASConfig = managedASComponent.loadResourceConfiguration();
            PropertySimple offsetProp = managedASConfig.getSimple(MANAGED_SERVER_PORT_OFFSET_PROPERTY_NAME);
            if (offsetProp == null) {
                LOG.warn((Object)"Could not find Managed Server socket binding offset, skipping discovery");
                return Collections.emptySet();
            }
            port = offsetProp.getIntegerValue() + 4447;
            String[] credentials = this.getCredentialsForManagedAS();
            username = credentials[0];
            password = credentials[1];
        } else if (parentComponent instanceof StandaloneASComponent) {
            port = serverPluginConfiguration.getPort() + 9;
            username = serverPluginConfiguration.getUser();
            password = serverPluginConfiguration.getPassword();
        } else {
            LOG.warn((Object)(parentComponent + " is not a supported parent component"));
            return Collections.emptySet();
        }
        pluginConfig.setSimpleValue(PORT, String.valueOf(port));
        pluginConfig.setSimpleValue(USERNAME, username);
        pluginConfig.setSimpleValue(PASSWORD, password);
        File clientJarFile = new File(serverPluginConfiguration.getHomeDir(), "bin" + File.separator + "client" + File.separator + "jboss-client.jar");
        if (!clientJarFile.isFile()) {
            LOG.warn((Object)(clientJarFile + " does not exist."));
            return Collections.emptySet();
        }
        pluginConfig.setSimpleValue(CLIENT_JAR_LOCATION, clientJarFile.getAbsolutePath());
        EmsConnection emsConnection = null;
        try {
            Set<Object> set;
            emsConnection = ApplicationMBeansDiscoveryComponent.loadEmsConnection(pluginConfig);
            if (emsConnection == null) {
                set = Collections.emptySet();
                return set;
            }
            if (!this.hasApplicationMBeans(pluginConfig, emsConnection)) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"No application MBeans found");
                }
                set = Collections.emptySet();
                return set;
            }
            set = Collections.singleton(new DiscoveredResourceDetails(context.getResourceType(), this.getNewResourceKey(pluginConfig), this.getNewResourceName(pluginConfig), this.getNewResourceVersion(pluginConfig), this.getNewResourceDescription(pluginConfig), pluginConfig, null));
            return set;
        }
        finally {
            if (emsConnection != null) {
                emsConnection.close();
            }
        }
    }

    protected boolean hasApplicationMBeans(Configuration pluginConfig, EmsConnection emsConnection) {
        String beansQueryString = this.getBeansQueryString(pluginConfig);
        if (emsConnection.queryBeans(beansQueryString).isEmpty()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Found no MBeans with query '" + beansQueryString + "'"));
            }
            return false;
        }
        return true;
    }

    protected String[] getCredentialsForManagedAS() {
        return new String[]{"rhqadmin", "rhqadmin"};
    }

    protected String getBeansQueryString(Configuration pluginConfig) {
        return pluginConfig.getSimpleValue("beansQueryString");
    }

    protected String getNewResourceKey(Configuration pluginConfig) {
        return pluginConfig.getSimpleValue("newResourceKey");
    }

    protected String getNewResourceName(Configuration pluginConfig) {
        return pluginConfig.getSimpleValue("newResourceName");
    }

    protected String getNewResourceDescription(Configuration pluginConfig) {
        return pluginConfig.getSimpleValue("newResourceDescription");
    }

    protected String getNewResourceVersion(Configuration pluginConfig) {
        return pluginConfig.getSimpleValue("newResourceVersion");
    }

    public static EmsConnection loadEmsConnection(Configuration pluginConfig) {
        Object emsConnection = null;
        try {
            File clientJarFile = new File(pluginConfig.getSimpleValue(CLIENT_JAR_LOCATION));
            ConnectionSettings connectionSettings = new ConnectionSettings();
            connectionSettings.initializeConnectionType((ConnectionTypeDescriptor)new A7ConnectionTypeDescriptor(clientJarFile));
            connectionSettings.setLibraryURI(clientJarFile.getParent());
            connectionSettings.setServerUrl("service:jmx:remoting-jmx://" + pluginConfig.getSimpleValue(HOSTNAME) + ":" + pluginConfig.getSimpleValue(PORT));
            connectionSettings.setPrincipal(pluginConfig.getSimpleValue(USERNAME));
            connectionSettings.setCredentials(pluginConfig.getSimpleValue(PASSWORD));
            ConnectionFactory connectionFactory = new ConnectionFactory();
            connectionFactory.discoverServerClasses(connectionSettings);
            ConnectionProvider connectionProvider = connectionFactory.getConnectionProvider(connectionSettings);
            return connectionProvider.connect();
        }
        catch (Exception e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Could not create EmsConnection", (Throwable)e);
            }
            if (emsConnection != null) {
                emsConnection.close();
            }
            return null;
        }
    }

    private static class A7ConnectionTypeDescriptor
    extends JSR160ConnectionTypeDescriptor {
        private final File clientJarFile;

        public A7ConnectionTypeDescriptor(File clientJarFile) {
            this.clientJarFile = clientJarFile;
        }

        public String[] getConnectionClasspathEntries() {
            return new String[]{this.clientJarFile.getName()};
        }
    }

    public static final class PluginConfigProps {
        public static final String BEANS_QUERY_STRING = "beansQueryString";
        public static final String NEW_RESOURCE_KEY = "newResourceKey";
        public static final String NEW_RESOURCE_NAME = "newResourceName";
        public static final String NEW_RESOURCE_DESCRIPTION = "newResourceDescription";
        public static final String NEW_RESOURCE_VERSION = "newResourceVersion";

        private PluginConfigProps() {
        }
    }
}

