/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.modules.plugins.jbossas7.jmx;

import java.io.File;
import java.util.Collections;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mc4j.ems.connection.ConnectionFactory;
import org.mc4j.ems.connection.EmsConnection;
import org.mc4j.ems.connection.settings.ConnectionSettings;
import org.mc4j.ems.connection.support.ConnectionProvider;
import org.mc4j.ems.connection.support.metadata.ConnectionTypeDescriptor;
import org.mc4j.ems.connection.support.metadata.JSR160ConnectionTypeDescriptor;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.PropertySimple;
import org.rhq.core.pluginapi.inventory.DiscoveredResourceDetails;
import org.rhq.core.pluginapi.inventory.ResourceDiscoveryComponent;
import org.rhq.core.pluginapi.inventory.ResourceDiscoveryContext;
import org.rhq.modules.plugins.jbossas7.BaseComponent;
import org.rhq.modules.plugins.jbossas7.BaseServerComponent;
import org.rhq.modules.plugins.jbossas7.JBossProductType;
import org.rhq.modules.plugins.jbossas7.ManagedASComponent;
import org.rhq.modules.plugins.jbossas7.StandaloneASComponent;
import org.rhq.modules.plugins.jbossas7.helper.ServerPluginConfiguration;

public class ApplicationMBeansDiscoveryComponent
implements ResourceDiscoveryComponent<BaseComponent<?>> {
    private static final Log LOG = LogFactory.getLog(ApplicationMBeansDiscoveryComponent.class);
    private static final String HOSTNAME = "hostname";
    private static final String PORT = "port";
    private static final String USERNAME = "username";
    private static final String PASSWORD = "password";
    private static final String CLIENT_JAR_LOCATION = "clientJarLocation";
    private static final String PROTOCOL = "protocol";
    private static final int STANDALONE_REMOTING_PORT_OFFSET = 9;
    private static final int DOMAIN_REMOTING_PORT_DEFAULT = 4447;
    private static final String MANAGED_SERVER_PORT_OFFSET_PROPERTY_NAME = "socket-binding-port-offset";
    private static final int HTTP_PORT_DEFAULT = 8080;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<DiscoveredResourceDetails> discoverResources(ResourceDiscoveryContext<BaseComponent<?>> context) throws Exception {
        String password;
        String username;
        int port;
        BaseComponent parentComponent = (BaseComponent)context.getParentResourceComponent();
        BaseServerComponent baseServerComponent = parentComponent.getServerComponent();
        ServerPluginConfiguration serverPluginConfiguration = baseServerComponent.getServerPluginConfiguration();
        JBossProductType productType = serverPluginConfiguration.getProductType();
        Configuration pluginConfig = context.getDefaultPluginConfiguration();
        if (parentComponent instanceof ManagedASComponent) {
            ManagedASComponent managedASComponent = (ManagedASComponent)parentComponent;
            Configuration managedASConfig = managedASComponent.loadResourceConfiguration();
            PropertySimple offsetProp = managedASConfig.getSimple(MANAGED_SERVER_PORT_OFFSET_PROPERTY_NAME);
            if (offsetProp == null) {
                LOG.warn((Object)"Could not find Managed Server socket binding offset, skipping discovery");
                return Collections.emptySet();
            }
            port = productType != JBossProductType.WILDFLY8 ? 4447 : 8080;
            port += offsetProp.getIntegerValue().intValue();
            String[] credentials = this.getCredentialsForManagedAS();
            username = credentials[0];
            password = credentials[1];
        } else if (parentComponent instanceof StandaloneASComponent) {
            port = serverPluginConfiguration.getPort();
            if (productType != JBossProductType.WILDFLY8) {
                port += 9;
            }
            username = serverPluginConfiguration.getUser();
            password = serverPluginConfiguration.getPassword();
        } else {
            LOG.warn((Object)(parentComponent + " is not a supported parent component"));
            return Collections.emptySet();
        }
        String clientJarPath = "bin" + File.separator + "client" + File.separator + "jboss-client.jar";
        File clientJarFile = new File(serverPluginConfiguration.getHomeDir(), clientJarPath);
        if (!clientJarFile.isFile()) {
            LOG.warn((Object)(clientJarFile + " does not exist."));
            return Collections.emptySet();
        }
        pluginConfig.setSimpleValue(HOSTNAME, serverPluginConfiguration.getHostname());
        pluginConfig.setSimpleValue(PORT, String.valueOf(port));
        pluginConfig.setSimpleValue(USERNAME, username);
        pluginConfig.setSimpleValue(PASSWORD, password);
        pluginConfig.setSimpleValue(CLIENT_JAR_LOCATION, clientJarFile.getAbsolutePath());
        pluginConfig.setSimpleValue(PROTOCOL, productType == JBossProductType.WILDFLY8 ? "http-remoting-jmx" : "remoting-jmx");
        EmsConnection emsConnection = null;
        try {
            Set<Object> set;
            emsConnection = ApplicationMBeansDiscoveryComponent.loadEmsConnection(pluginConfig, context.getParentResourceContext().getTemporaryDirectory());
            if (emsConnection == null) {
                set = Collections.emptySet();
                return set;
            }
            if (!this.hasApplicationMBeans(pluginConfig, emsConnection)) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"No application MBeans found");
                }
                set = Collections.emptySet();
                return set;
            }
            set = Collections.singleton(new DiscoveredResourceDetails(context.getResourceType(), this.getNewResourceKey(pluginConfig), this.getNewResourceName(pluginConfig), this.getNewResourceVersion(pluginConfig), this.getNewResourceDescription(pluginConfig), pluginConfig, null));
            return set;
        }
        finally {
            if (emsConnection != null) {
                emsConnection.close();
            }
        }
    }

    protected boolean hasApplicationMBeans(Configuration pluginConfig, EmsConnection emsConnection) {
        String beansQueryString = this.getBeansQueryString(pluginConfig);
        if (emsConnection.queryBeans(beansQueryString).isEmpty()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Found no MBeans with query '" + beansQueryString + "'"));
            }
            return false;
        }
        return true;
    }

    protected String[] getCredentialsForManagedAS() {
        return new String[]{"rhqadmin", "rhqadmin"};
    }

    protected String getBeansQueryString(Configuration pluginConfig) {
        return pluginConfig.getSimpleValue("beansQueryString");
    }

    protected String getNewResourceKey(Configuration pluginConfig) {
        return pluginConfig.getSimpleValue("newResourceKey");
    }

    protected String getNewResourceName(Configuration pluginConfig) {
        return pluginConfig.getSimpleValue("newResourceName");
    }

    protected String getNewResourceDescription(Configuration pluginConfig) {
        return pluginConfig.getSimpleValue("newResourceDescription");
    }

    protected String getNewResourceVersion(Configuration pluginConfig) {
        return pluginConfig.getSimpleValue("newResourceVersion");
    }

    @Deprecated
    public static EmsConnection loadEmsConnection(Configuration pluginConfig) {
        return ApplicationMBeansDiscoveryComponent.loadEmsConnection(pluginConfig, new File(System.getProperty("java.io.tmpdir")));
    }

    public static EmsConnection loadEmsConnection(Configuration pluginConfig, File jarTempDir) {
        Object emsConnection = null;
        try {
            File clientJarFile = new File(pluginConfig.getSimpleValue(CLIENT_JAR_LOCATION));
            ConnectionSettings connectionSettings = new ConnectionSettings();
            connectionSettings.initializeConnectionType((ConnectionTypeDescriptor)new A7ConnectionTypeDescriptor(clientJarFile));
            connectionSettings.setLibraryURI(clientJarFile.getParent());
            String serverUrl = "service:jmx:" + pluginConfig.getSimpleValue(PROTOCOL) + "://" + pluginConfig.getSimpleValue(HOSTNAME) + ":" + pluginConfig.getSimpleValue(PORT);
            connectionSettings.setServerUrl(serverUrl);
            connectionSettings.setPrincipal(pluginConfig.getSimpleValue(USERNAME));
            connectionSettings.setCredentials(pluginConfig.getSimpleValue(PASSWORD));
            if (connectionSettings.getControlProperties() == null) {
                connectionSettings.setControlProperties(new Properties());
            }
            connectionSettings.getControlProperties().setProperty("mc4j.ems.CopyJarsToTemp", String.valueOf(Boolean.TRUE));
            connectionSettings.getControlProperties().setProperty("mc4j.ems.JarTempDir", jarTempDir.getAbsolutePath());
            if (connectionSettings.getAdvancedProperties() == null) {
                connectionSettings.setAdvancedProperties(new Properties());
            }
            connectionSettings.getAdvancedProperties().setProperty("mc4j.ems.UseContextClassLoader", String.valueOf(Boolean.FALSE));
            ConnectionFactory connectionFactory = new ConnectionFactory();
            connectionFactory.discoverServerClasses(connectionSettings);
            ConnectionProvider connectionProvider = connectionFactory.getConnectionProvider(connectionSettings);
            return connectionProvider.connect();
        }
        catch (Exception e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Could not create EmsConnection", (Throwable)e);
            }
            if (emsConnection != null) {
                emsConnection.close();
            }
            return null;
        }
    }

    private static class A7ConnectionTypeDescriptor
    extends JSR160ConnectionTypeDescriptor {
        private final File clientJarFile;

        public A7ConnectionTypeDescriptor(File clientJarFile) {
            this.clientJarFile = clientJarFile;
        }

        public String[] getConnectionClasspathEntries() {
            return new String[]{this.clientJarFile.getName()};
        }

        public boolean isUseChildFirstClassLoader() {
            return true;
        }
    }

    public static final class PluginConfigProps {
        public static final String BEANS_QUERY_STRING = "beansQueryString";
        public static final String NEW_RESOURCE_KEY = "newResourceKey";
        public static final String NEW_RESOURCE_NAME = "newResourceName";
        public static final String NEW_RESOURCE_DESCRIPTION = "newResourceDescription";
        public static final String NEW_RESOURCE_VERSION = "newResourceVersion";

        private PluginConfigProps() {
        }
    }
}

